#ifndef _VCMAIN_H_
#define _VCMAIN_H_

#include <windows.h>
#include <d3drmwin.h>
#include "vcerror.h"

#ifdef __cplusplus
extern "C" {
#endif

#define VEGCLI_DISPMODE_WINDOWED	1
#define VEGCLI_DISPMODE_EXCLUSIVE	2

// Macros
#undef  ATTEMPT
#define ATTEMPT(x)			{ if (FAILED(x)) goto generic_error; }
#undef  RELEASE
#define RELEASE(x)			{ if (x != NULL) {x->Release(); x = NULL;} }

#define IID_VEGDDRAW				IID_IDirectDraw
#define IID_VEG						IID_IDirect3DRM3
#define IID_VEGFRAME				IID_IDirect3DRMFrame3
#define IID_VEGMESHBUILDER			IID_IDirect3DRMMeshBuilder3
#define IID_VEGVISUAL				IID_IDirect3DRMVisual

typedef LPDIRECT3DRM3				LPVEG;
typedef LPDIRECT3DRMDEVICE3			LPVEGDEVICE;
typedef LPDIRECT3DRMFRAME3			LPVEGFRAME;
typedef LPDIRECT3DRMMESHBUILDER3	LPVEGMESHBUILDER;
typedef LPDIRECT3DRMVIEWPORT2		LPVEGVIEWPORT;
typedef LPDIRECT3DRMANIMATION2		LPVEGANIMATION;
typedef LPDIRECT3DRMANIMATIONSET2	LPVEGANIMATIONSET;
typedef LPDIRECT3DRMTEXTURE3		LPVEGTEXTURE;
typedef LPDIRECT3DRMVISUAL			LPVEGVISUAL;

typedef LPDIRECTDRAW				LPVEGDDRAW;
typedef LPDIRECTDRAWCLIPPER			LPVEGDDRAWCLIPPER;
typedef LPDIRECTDRAWPALETTE			LPVEGDDRAWPALETTE;
typedef LPDIRECTDRAWSURFACE			LPVEGDDRAWSURFACE;


typedef struct _VEGCLI3DINFO
{
	HWND						hwnd;			// µ 
	int							vegDispMode;	//  , ȭ  
	BOOL						bDispFPS;		// FPS  ΰ?
	POINT						ptFPS;			// FPS µ ġ
	DWORD						dwLastTime;		// FPS   
	DWORD						dwCurTime;
	DWORD						dwFpsTime;
	DWORD						dwDeltaTime;
	DWORD						dwFramesRendered;
	DWORD						dwFps;
	char						lpszTexturePath[128];
	char						lpszAppPath[128];	// Application  path  Ѵ.

	LPVEG						lpD3DRM;		// Direct3DRM ü
	LPVEGDEVICE					device;			// ¿ ̽ ü
	LPVEGFRAME					scene;			//   
	LPVEGFRAME					camera;			// ī޶ 
	LPVEGVIEWPORT				view;			// Ʈ
	LPVEGANIMATION				animation;		//   
	LPVEGANIMATIONSET			animationSet;	// ϸ̼ Ͱ ִ  о鿴
												// , ϸ̼ Ͱ  ü 
												//    Ѿ ȴ.
	D3DRMCOLORMODEL				colormodel;		// ÷, RGB(true color) or MONO(256 color)

	LPVEGDDRAW					lpDD;			// DirectDraw ü
	LPVEGDDRAWCLIPPER			lpDDClipper;	// Ŭ ü
	LPVEGDDRAWSURFACE			lpDDSPrimary;   //  ǥ
	LPVEGDDRAWSURFACE			lpDDSBack;		//  ǥ
	LPDIRECTDRAWPALETTE			lpDDPal;		// ķƮ ü
} VEGCLI3DINFO, *PVEGCLI3DINFO, far *LPVEGCLI3DINFO;

//////////////////////////////////////////////////////////////////////////////////////////////
//
// VEG Client 3Dƾ ʱȭ
//
//////////////////////////////////////////////////////////////////////////////////////////////

LPVEGCLI3DINFO
vegcli3DCreate( HWND hwnd, int nDispMode, int cx, int cy, int bpp );

void
vegcli3DDestroy( LPVEGCLI3DINFO lpInfo );

//////////////////////////////////////////////////////////////////////////////////////////////
//
// FPS( Frame Per Second )
// FPS ȭ鿡 ǥϱ   Լ......
//
//////////////////////////////////////////////////////////////////////////////////////////////

void
vegcli3DFPSDisplay( LPVEGCLI3DINFO lpInfo, BOOL b );

void
vegcli3DFPSSetPos( LPVEGCLI3DINFO lpInfo, LPPOINT pt );

void
vegcli3DFPSOut( LPVEGCLI3DINFO lpInfo );

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Frame Create
//     Լ 
//
//////////////////////////////////////////////////////////////////////////////////////////////

LPVEGFRAME
vegcli3DLightCreate( LPVEGCLI3DINFO lpInfo,
		 		     LPVEGFRAME lpParent,
				     LPVEGFRAME lpRef,
				     D3DRMLIGHTTYPE lt, 
				     D3DVECTOR* rgb, 
				     D3DVECTOR* pos, 
				     D3DVECTOR* d, 
				     D3DVECTOR* u );

LPVEGMESHBUILDER
vegcli3DMeshCreateFromFile( LPVEGCLI3DINFO lpInfo, LPCTSTR filename );

LPVEGMESHBUILDER
vegcli3DMeshCreateFromRes( LPVEGCLI3DINFO lpInfo, LPD3DRMLOADRESOURCE res );

LPVEGFRAME
vegcli3DFrameCreateFromMeshFile( LPVEGCLI3DINFO lpInfo,
						     LPVEGFRAME lpParent,
						     LPVEGFRAME lpRef,
						     D3DVECTOR* pos, 
						     D3DVECTOR* d, 
						     D3DVECTOR* u,
						     LPCTSTR filename );

LPVEGFRAME
vegcli3DFrameCreateFromMeshRes( LPVEGCLI3DINFO lpInfo,
						    LPVEGFRAME lpParent,
						    LPVEGFRAME lpRef,
						    D3DVECTOR* pos, 
						    D3DVECTOR* d, 
						    D3DVECTOR* u,
						    LPD3DRMLOADRESOURCE res );

LPVEGFRAME
vegcli3DFrameCreateFromMesh( LPVEGCLI3DINFO lpInfo,
						     LPVEGFRAME lpParent,
						     LPVEGFRAME lpRef,
						     D3DVECTOR* pos, 
						     D3DVECTOR* d, 
						     D3DVECTOR* u,
						     LPVEGMESHBUILDER builder );

LPVEGFRAME
vegcli3DFrameHierCreateFromAnimeFile( LPVEGCLI3DINFO lpInfo, 
									  LPVEGFRAME lpParent, 
									  LPCTSTR filename );

LPVEGFRAME
vegcli3DFrameHierCreateFromAnimeRes( LPVEGCLI3DINFO lpInfo, 
									 LPVEGFRAME lpParent, 
									 LPD3DRMLOADRESOURCE lpRes );

LPVEGFRAME
vegcli3DFrameHierCreateFromFrameFile( LPVEGCLI3DINFO lpInfo, 
									  LPVEGFRAME lpParent, 
									  LPCTSTR filename );

LPVEGFRAME
vegcli3DFrameHierCreateFromFrameRes( LPVEGCLI3DINFO lpInfo, 
									 LPVEGFRAME lpParent, 
									 LPD3DRMLOADRESOURCE lpRes );

LPVEGFRAME
vegcli3DFrameCreateFromFrame( LPVEGCLI3DINFO lpInfo, 
							  LPVEGFRAME lpParent, 
							  LPCTSTR filename );

LPVEGFRAME
vegcli3DFrameCreate( LPVEGCLI3DINFO lpInfo, LPVEGFRAME lpParent );

BOOL
vegcli3DFrameDestroy( LPVEGFRAME lpFrame );

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Frame Set
// Position, Orientation, Rotation, Velocity 
//
//////////////////////////////////////////////////////////////////////////////////////////////
BOOL
vegcli3DFrameSetPos( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *pos );

BOOL
vegcli3DFrameGetPos( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *pos );

BOOL
vegcli3DFrameSetOrg( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *d, D3DVECTOR *u );

BOOL
vegcli3DFrameGetOrg( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *d, D3DVECTOR *u );

BOOL
vegcli3DFrameSetRotation( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *rot, D3DVALUE theta );

BOOL
vegcli3DFrameAddRotation( LPVEGFRAME lpFrame, D3DRMCOMBINETYPE rctCombine, D3DVECTOR *rot, D3DVALUE theta );

BOOL
vegcli3DFrameGetRotation( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *rot, D3DVALUE *theta );

BOOL
vegcli3DFrameSetVelocity( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *vel, BOOL fRotVel );

BOOL
vegcli3DFrameGetVelocity( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *vel, BOOL fRotVel );

BOOL
vegcli3DFrameSetScale( LPVEGFRAME lpFrame, D3DVALUE x, D3DVALUE y, D3DVALUE z );

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Frame
//  ̵
//
//////////////////////////////////////////////////////////////////////////////////////////////

//   thetaŭ front ̵
BOOL
vegcli3DFrameMoveFront( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ back ̵
BOOL
vegcli3DFrameMoveBack( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ up ̵
BOOL
vegcli3DFrameMoveUp( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ down ̵
BOOL
vegcli3DFrameMoveDown( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ left ̵
BOOL
vegcli3DFrameMoveLeft( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ right ̵
BOOL
vegcli3DFrameMoveRight( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ left ȸ
BOOL
vegcli3DFrameTurnLeft( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ right ȸ
BOOL
vegcli3DFrameTurnRight( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ up ȸ
BOOL
vegcli3DFrameTurnUp( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ down ȸ
BOOL
vegcli3DFrameTurnDown( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ left (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DFrameRollLeft( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//   thetaŭ right (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DFrameRollRight( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta );

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Walk thru == Navigate
//
//////////////////////////////////////////////////////////////////////////////////////////////

// ī޶ thetaŭ front ̵
BOOL
vegcli3DNaviMoveFront( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ back ̵
BOOL
vegcli3DNaviMoveBack( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ up ̵
BOOL
vegcli3DNaviMoveUp( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ down ̵
BOOL
vegcli3DNaviMoveDown( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ left ̵
BOOL
vegcli3DNaviMoveLeft( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ right ̵
BOOL
vegcli3DNaviMoveRight( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ left ȸ
BOOL
vegcli3DNaviTurnLeft( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ right ȸ
BOOL
vegcli3DNaviTurnRight( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ up ȸ
BOOL
vegcli3DNaviTurnUp( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ down ȸ
BOOL
vegcli3DNaviTurnDown( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ left (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DNaviRollLeft( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

// ī޶ thetaŭ right (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DNaviRollRight( LPVEGCLI3DINFO lpInfo, D3DVALUE theta );

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Render
// ȭ ͸Ͽ viewport Ѵ.
// Ȥ ۿ Ͽ FlipѴ.
//
//////////////////////////////////////////////////////////////////////////////////////////////

BOOL 
vegcli3DRender( LPVEGCLI3DINFO lpInfo ) ;

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Rendering quality
//
//////////////////////////////////////////////////////////////////////////////////////////////

/* quality =
 * D3DRMRENDER_WIREFRAME   (D3DRMSHADE_FLAT+D3DRMLIGHT_OFF+D3DRMFILL_WIREFRAME)
 * D3DRMRENDER_UNLITFLAT   (D3DRMSHADE_FLAT+D3DRMLIGHT_OFF+D3DRMFILL_SOLID)
 * D3DRMRENDER_FLAT        (D3DRMSHADE_FLAT+D3DRMLIGHT_ON+D3DRMFILL_SOLID)
 * D3DRMRENDER_GOURAUD     (D3DRMSHADE_GOURAUD+D3DRMLIGHT_ON+D3DRMFILL_SOLID)
 * D3DRMRENDER_PHONG       (D3DRMSHADE_PHONG+D3DRMLIGHT_ON+D3DRMFILL_SOLID)
 */
BOOL
vegcli3DQualitySet( LPVEGCLI3DINFO lpInfo, D3DRMRENDERQUALITY quality );

D3DRMRENDERQUALITY
vegcli3DQualityGet( LPVEGCLI3DINFO lpInfo );

/* lm =
 * D3DRMLIGHT_OFF	Lighting is off. 
 * D3DRMLIGHT_ON	Lighting is on. 
 * D3DRMLIGHT_MASK	Lighting uses a mask. 
 * D3DRMLIGHT_MAX	Maximum lighting mode. 
 */
BOOL
vegcli3DQualitySetLight( LPVEGCLI3DINFO lpInfo, D3DRMLIGHTMODE lm );

/* fm = 
 * D3DRMFILL_POINTS		Fills points only; minimum fill mode. 
 * D3DRMFILL_WIREFRAME	Fill wireframes. 
 * D3DRMFILL_SOLID		Fill solid objects. 
 * D3DRMFILL_MASK		Fill using a mask. 
 * D3DRMFILL_MAX		Maximum value for fill mode. 
 */
BOOL
vegcli3DQualitySetFill( LPVEGCLI3DINFO lpInfo, D3DRMFILLMODE fm );

/* sm = 
 * D3DRMSHADE_FLAT
 * D3DRMSHADE_GOURAUD
 * D3DRMSHADE_PHONG
 * D3DRMSHADE_MASK
 * D3DRMSHADE_MAX
 */
BOOL
vegcli3DQualitySetShade( LPVEGCLI3DINFO lpInfo, D3DRMSHADEMODE sm );

/* tq = 
 * D3DRMTEXTURE_NEAREST				Choose the nearest pixel in the texture. 
 * D3DRMTEXTURE_LINEAR				Linearly interpolate the four nearest pixels. 
 * D3DRMTEXTURE_MIPNEAREST			Similar to D3DRMTEXTURE_NEAREST, but uses the appropriate mipmap instead of the texture. 
 * D3DRMTEXTURE_MIPLINEAR			Similar to D3DRMTEXTURE_LINEAR, but uses the appropriate mipmap instead of the texture. 
 * D3DRMTEXTURE_LINEARMIPNEAREST	Similar to D3DRMTEXTURE_MIPNEAREST, but interpolates between the two nearest mipmaps. 
 * D3DRMTEXTURE_LINEARMIPLINEAR		Similar to D3DRMTEXTURE_MIPLINEAR, but interpolates between the two nearest mipmaps. 
 */

/* flag = TRUE or FALSE
 *
 */
BOOL
vegcli3DQualitySetDither( LPVEGCLI3DINFO lpInfo, BOOL flag );

/* cm = 
 * D3DCOLOR_MONO	Use a monochromatic model (or ramp model). In this model, the blue component of a vertex color is used to define the brightness of a lit vertex. 
 * D3DCOLOR_RGB		Use a full RGB model. 
 */
BOOL
vegcli3DQualitySetColormodel( LPVEGCLI3DINFO lpInfo, D3DRMCOLORMODEL cm );

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  ̽ ̳, Ʈ  low level API
//
//////////////////////////////////////////////////////////////////////////////////////////////

// viewer.cpp ҽ ״  ִ.
LPGUID
vegcli3DFindDevice( LPVEGCLI3DINFO lpInfo, D3DCOLORMODEL cm );

// viewer.cpp ҽ ణ Ͽ ״  ִ.
BOOL 
vegcli3DCreateDevice( LPVEGCLI3DINFO lpInfo, int cx, int cy, int bpp );

// viewer.cpp ҽ ణ Ͽ ״  ִ.
BOOL 
vegcli3DRebuildDevice( LPVEGCLI3DINFO lpInfo, int width, int height );

// viewer.cpp ҽ ణ Ͽ ״  ִ.
BOOL 
vegcli3DResizeViewport( LPVEGCLI3DINFO lpInfo, int width, int height);

#ifdef __cplusplus
};
#endif

#endif // _VCMAIN_H_