#include <math.h>
#include <d3drmwin.h>
#include "vcmain.h"
#include "vcselect.h"
#include "vcerror.h"

static	int						showBoxes = FALSE;
static	LPVEGFRAME				sFrame = NULL;
static	LPVEGMESHBUILDER		sVisual = NULL;
static	LPDIRECT3DRMLIGHT		sLight = NULL;
static	LPDIRECT3DRMMESH		selectionBox = NULL;

		LPVEGFRAME				clipboardFrame = NULL;
		LPVEGVISUAL				clipboardVisual = NULL;

static  void	AddRod(LPVEGMESHBUILDER mesh, D3DVALUE radius, D3DVECTOR a, D3DVECTOR b);
static	void	AddCone(LPVEGMESHBUILDER mesh, D3DVALUE radius, D3DVECTOR a, D3DVECTOR b);

// ϴ  ã  recursion ϰ ִ.
//  hierarchy ʹ  ʱ⸸ ...
// ׸  ̸ name Ķ  
// name ̱ Ȱ   Ѵ.
LPVEGFRAME
vegcli3DSelSearchFrameByName( LPVEGFRAME lpParent, LPCTSTR name )
{
	// recursion ؾ Ѵ.
	DWORD					i;
	DWORD					index;
	DWORD					dwSize = 0;
	LPSTR					tmp = NULL;
	LPDIRECT3DRMFRAMEARRAY	lpFrameArray = NULL;
	LPDIRECT3DRMFRAME		lpFrame1 = NULL;
	LPVEGFRAME				lpFrameVeg = NULL;
	HRESULT					rval;

	ATTEMPT( rval = lpParent->GetName( &dwSize, NULL ) );
	if( dwSize != 0 )
	{
		tmp = (LPSTR)malloc( dwSize );
		ATTEMPT( rval = lpParent->GetName( &dwSize, (LPSTR)tmp ) );

		if( !lstrcmp( (LPCTSTR)name, (LPCTSTR)tmp ) )
		{
			free( tmp );
			return lpParent;
		}
		free( tmp );
	}

	ATTEMPT( rval = lpParent->GetChildren( &lpFrameArray ) );
	index = lpFrameArray->GetSize();
	if( index == 0 ) return NULL;

	for( i = 0 ; i < index ; i++ )
	{
		ATTEMPT( rval = lpFrameArray->GetElement( i, &lpFrame1 ) );
		ATTEMPT( rval = lpFrame1->QueryInterface( IID_VEGFRAME, (LPVOID *)&lpFrameVeg ) );
		RELEASE( lpFrame1 );
		ATTEMPT( rval = lpFrameVeg->GetName( &dwSize, NULL ) );
		if( dwSize != 0 )
		{
			tmp = (LPSTR)malloc( dwSize );
			ATTEMPT( rval = lpFrameVeg->GetName( &dwSize, (LPSTR)tmp ) );

//			if( !lstrcmp( (LPCTSTR)name, (LPCTSTR)tmp ) )
			if( CompareString( LOCALE_SYSTEM_DEFAULT, 0, name, strlen( name ), tmp, strlen( name ) ) == 2 )
			{
				free( tmp );
				RELEASE( lpFrameArray );
				return lpFrameVeg;
			}
			else
			{
				free( tmp );
				lpFrameVeg = vegcli3DSelSearchFrameByName( lpFrameVeg, name );
				if( lpFrameVeg != NULL ) return lpFrameVeg;
			}
		}
	}

	return NULL;

generic_error:
	vegMsg( "Error in vegcli3DSelSearchFrameByName()\n%s", DXErrorToString( rval ) );
	RELEASE( lpFrameArray );
	RELEASE( lpFrameVeg );
	free( tmp );
	return NULL;
}

//  select visual ܰ ó ұ? ?
// ⺻ FALSE,  ó ʴ´.
static
void
ShowBoxes( LPVEGCLI3DINFO lpInfo, int show )
{
    showBoxes = show;
    vegcli3DSelSelectVisual( lpInfo, sVisual, sFrame );
}

int
vegcli3DSelToggleBoxes( LPVEGCLI3DINFO lpInfo )
{
    ShowBoxes( lpInfo, !showBoxes );
    return showBoxes;
}

// select  viewport 콺  ʰ, Ƿ   ִ.
// 
void
vegcli3DSelSetFrame( LPVEGFRAME frame )
{
    sFrame = frame;
}

// select   ̾?
LPVEGFRAME
vegcli3DSelGetFrame( void )
{
    return sFrame;
}

void
vegcli3DSelSetVisual( LPVEGMESHBUILDER visual )
{
    sVisual = visual;
}

// select   ̾?
// ⼭ ! ϰ LPDIRECT3DRMVISUAL ƴϴ! 
// LPDIRECT3DRMMESHBUILDER .
LPVEGMESHBUILDER
vegcli3DSelGetVisual( void )
{
    return sVisual;
}

LPDIRECT3DRMLIGHT
vegcli3DSelGetLight( void )
{
    return sLight;
}

//  Լ θ  ?
void
vegcli3DSelDeselectVisual( void )
{
    if (sFrame && selectionBox)
        sFrame->DeleteVisual(selectionBox);
    sFrame = NULL;
    sVisual = NULL;
    selectionBox = NULL;
}

void
vegcli3DSelSelectVisual( LPVEGCLI3DINFO lpInfo, LPVEGMESHBUILDER visual, LPVEGFRAME frame )
{
    vegcli3DSelDeselectVisual();
    sVisual = visual;
    sFrame = frame;

    if( sVisual )
    {   LPDIRECT3DRMLIGHTARRAY lights;

        sLight = 0;
        sFrame->GetLights( &lights );
        if( lights )
        {   if ( lights->GetSize() )
            {   lights->GetElement( 0, &sLight );
                sLight->Release(); /* reinstate reference count */
            }
            lights->Release();
        }

        if( showBoxes && visual )
        {   D3DRMBOX box;
            LPVEGMESHBUILDER builder;

            sVisual->GetBox( &box );
            builder = vegcli3DSelMakeBox( lpInfo, &box );
            builder->CreateMesh( &selectionBox );
            sFrame->AddVisual( selectionBox );
			sFrame->Release();
            selectionBox->Release();
        }
    }
}

//  Լ    ̴.
// 콺 Ʈ  ϸ  Լ ؾ!
void
vegcli3DSelFindVisual( LPVEGCLI3DINFO lpInfo, int x, int y )
{
    LPDIRECT3DRMVISUAL			visual;
    LPDIRECT3DRMPICKEDARRAY		picked;
    LPDIRECT3DRMFRAMEARRAY		frames;
	LPDIRECT3DRMFRAME			frame1;
    LPVEGFRAME					frame;
    LPVEGMESHBUILDER			mesh;

    /*
     * Make sure we don't try to select the selection box of the current
     * selection.
     */
    vegcli3DSelDeselectVisual();

    lpInfo->view->Pick(x, y, &picked);
    if (picked)
    {   if (picked->GetSize())
        {
            picked->GetPick(0, &visual, &frames, 0);
            frames->GetElement(frames->GetSize() - 1, &frame1);
			if( SUCCEEDED( frame1->QueryInterface( IID_VEGFRAME, (LPVOID *) &frame ) ) )
			{
				RELEASE( frame1 );
				if( SUCCEEDED(visual->QueryInterface(IID_VEGMESHBUILDER, (void **) &mesh)) )
				{   vegcli3DSelSelectVisual(lpInfo, mesh, frame);
					mesh->Release();
				}
			}

            frame->Release();
            frames->Release();
            visual->Release();
        }
        picked->Release();
    }
}


void 
vegcli3DSelCutVisual( void )
{
    LPVEGFRAME frame;

    if (clipboardFrame)
        clipboardFrame->Release();

    if (sFrame) 
	{
        clipboardFrame = sFrame;
        clipboardVisual = sVisual;

        vegcli3DSelDeselectVisual();

        clipboardFrame->AddRef();
        clipboardFrame->GetParent(&frame);
        if (frame) 
		{
            frame->DeleteChild(clipboardFrame);
            frame->Release();
        }
    }
}

void 
vegcli3DSelCopyVisual( void )
{
    LPVEGFRAME frame;

    if (clipboardFrame)
        clipboardFrame->Release();

    if (sFrame) {
        sFrame->Clone(0, IID_VEGFRAME, (void **) &clipboardFrame);
        sVisual->Clone(0, IID_VEGVISUAL, (void **) &clipboardVisual);

        clipboardFrame->AddVisual(clipboardVisual);
		clipboardFrame->Release();
        clipboardVisual->Release();

        clipboardFrame->GetParent(&frame);
        if (frame) {
            frame->DeleteChild(clipboardFrame);
            frame->Release();
        }
    }
}

void
vegcli3DSelPasteVisual( LPVEGFRAME scene )
{
    if (clipboardFrame)
    {
        LPVEGFRAME frame;
        LPVEGVISUAL visual;

        clipboardFrame->Clone(0, IID_VEGFRAME, (void **) &frame);
        clipboardVisual->Clone(0, IID_VEGVISUAL, (void **) &visual);

        frame->AddVisual(visual);
        frame->Release();
        scene->AddChild(frame);
        visual->Release();
    }
}

void
vegcli3DSelDeleteVisual( void )
{
    if (sFrame)
    {
        LPVEGFRAME parent, frame = sFrame;

        vegcli3DSelDeselectVisual();
        frame->GetParent(&parent);
        parent->DeleteChild(frame);
        parent->Release();
    }
}

void
vegcli3DSelDeleteFrame( void )
{
    if (sFrame)
    {
        LPVEGFRAME parent, frame = sFrame;

        vegcli3DSelDeselectVisual();
        frame->GetParent(&parent);
        parent->DeleteChild(frame);
        parent->Release();
    }
}

void
vegcli3DSelClearClipboard( void )
{
    if (clipboardFrame)
        clipboardFrame->Release();
}

LPVEGMESHBUILDER
vegcli3DSelMakeBox( LPVEGCLI3DINFO lpInfo, D3DRMBOX* box )
{
    static	
			D3DVECTOR zero = {D3DVAL(0.0), D3DVAL(0.0), D3DVAL(0.0)};
    static	
			D3DVECTOR dir = {D3DVAL(0.0), D3DVAL(0.0), D3DVAL(0.0)};
	LPVEG				lpD3DRM = lpInfo->lpD3DRM;
	LPVEGMESHBUILDER	mesh;
    D3DVECTOR			a, b;
	HRESULT				rval;

    rval = lpD3DRM->CreateMeshBuilder(&mesh);
	if( rval != D3DRM_OK )
	{
		vegMsg( "Error![ vegcli3DSelMakeBox() ]\n%s", DXErrorToString( rval ) );
		return NULL;
	}

    dir.z = box->max.z + D3DVAL(1.0);
    AddRod(mesh, D3DVAL(0.05), zero, dir);
    a = dir;
    a.z += D3DVAL(0.6);
    AddCone(mesh, D3DVAL(0.2), dir, a);
    a = box->min;
    b = a;
    b.y = box->max.y;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.x = box->max.x;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.y = box->min.y;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.x = box->min.x;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.z = box->max.z;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.x = box->max.x;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.y = box->max.y;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.x = box->min.x;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b; b.y = box->min.y;
    AddRod(mesh, D3DVAL(0.05), a, b);
    b.y = box->max.y; a = b; b.z = box->min.z;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a = b = box->max; b.z = box->min.z;
    AddRod(mesh, D3DVAL(0.05), a, b);
    a.y = box->min.y; b = a; b.z = box->min.z;
    AddRod(mesh, D3DVAL(0.05), a, b);

    mesh->SetColor(D3DRMCreateColorRGB(D3DVAL(1.0), D3DVAL(1.0), D3DVAL(1.0)));
    return mesh;
}

////////////////////////////////////////////////////////////////////////////////////////
//
// Rod & Cone
//
////////////////////////////////////////////////////////////////////////////////////////

static unsigned long rod_faces[] =
{   8, 7, 7, 6, 6, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0, 0, /* end 1 */
    4, 0, 0, 1, 1, 9, 1, 8, 0,  /* side 0 */
    4, 1, 1, 2, 2, 10, 2, 9, 1, /* side 1 */
    4, 2, 2, 3, 3, 11, 3, 10, 2, /* side 2 */
    4, 3, 3, 4, 4, 12, 4, 11, 3, /* side 3 */
    4, 4, 4, 5, 5, 13, 5, 12, 4, /* side 4 */
    4, 5, 5, 6, 6, 14, 6, 13, 5, /* side 5 */
    4, 6, 6, 7, 7, 15, 7, 14, 6, /* side 6 */
    4, 7, 7, 0, 0, 8, 0, 15, 7,         /* side 7 */
    8, 8, 0, 9, 1, 10, 2, 11, 3, 12, 4, 13, 5, 14, 6, 15, 7, /* end 2 */
    0,
};

static
void
AddRod(LPVEGMESHBUILDER mesh, D3DVALUE radius, D3DVECTOR a, D3DVECTOR b)
{
    D3DVECTOR d, u, r;
    D3DVECTOR v[16];
    D3DVECTOR n[8];
    D3DVALUE f;
    int i;

    /*
     * Find the unit vector along the rod.
     */
    d.x = b.x - a.x;
    d.y = b.y - a.y;
    d.z = b.z - a.z;
    D3DRMVectorNormalise(&d);

    /*
     * Pick a vector normal to d
     */
    if (d.y != D3DVAL(0.0) || d.z != D3DVAL(0.0))
    {   u.x = D3DVAL(0.0);
        if (d.y == D3DVAL(0.0))
        {   u.y = D3DVAL(1.0);
            u.z = D3DVAL(0.0);
        } else
        {   D3DVALUE n_fix =
                D3DVAL(1.0)
            +   D3DDivide(D3DMultiply(d.z, d.z), D3DMultiply(d.y, d.y));
#ifdef FIXED_POINT_API
            double un_val = (double)n_fix / (double)(1<<16);
            u.z = D3DVAL(sqrt(1/un_val));
#else
            u.z = D3DVAL(sqrt(D3DDivide(D3DVAL(1.0), D3DVAL(n_fix))));
#endif
            u.y = -D3DMultiply(u.z, D3DDivide(d.z, d.y));
        }
    } else
    {   u.x = D3DVAL(0.0);
        u.y = D3DVAL(0.0);
        u.z = D3DVAL(1.0);
    }

    /*
     * Now find a vector normal to them both, to give us a coordinate
     * system in the plane normal to the rod.
     */
    D3DRMVectorCrossProduct(&r, &d, &u);

    /*
     * Scale down the coordinates to the radius of the rod.
     */
    u.x = D3DMultiply(u.x, radius);
    u.y = D3DMultiply(u.y, radius);
    u.z = D3DMultiply(u.z, radius);
    r.x = D3DMultiply(r.x, radius);
    r.y = D3DMultiply(r.y, radius);
    r.z = D3DMultiply(r.z, radius);

    /*
     * Calculate the corners of an octagon.
     */
    f = D3DVAL((float)sqrt(2.0) / (2 * (1 + (float)sqrt(2.0) / 2)));
    v[0].x = u.x + D3DMultiply(r.x, f);
    v[0].y = u.y + D3DMultiply(r.y, f);
    v[0].z = u.z + D3DMultiply(r.z, f);

    v[1].x = D3DMultiply(u.x, f) + r.x;
    v[1].y = D3DMultiply(u.y, f) + r.y;
    v[1].z = D3DMultiply(u.z, f) + r.z;

    v[2].x = D3DMultiply(-u.x, f) + r.x;
    v[2].y = D3DMultiply(-u.y, f) + r.y;
    v[2].z = D3DMultiply(-u.z, f) + r.z;

    v[3].x = -u.x + D3DMultiply(r.x, f);
    v[3].y = -u.y + D3DMultiply(r.y, f);
    v[3].z = -u.z + D3DMultiply(r.z, f);

    v[4].x = -u.x - D3DMultiply(r.x, f);
    v[4].y = -u.y - D3DMultiply(r.y, f);
    v[4].z = -u.z - D3DMultiply(r.z, f);

    v[5].x = D3DMultiply(-u.x, f) - r.x;
    v[5].y = D3DMultiply(-u.y, f) - r.y;
    v[5].z = D3DMultiply(-u.z, f) - r.z;

    v[6].x = D3DMultiply(u.x, f) - r.x;
    v[6].y = D3DMultiply(u.y, f) - r.y;
    v[6].z = D3DMultiply(u.z, f) - r.z;

    v[7].x = u.x - D3DMultiply(r.x, f);
    v[7].y = u.y - D3DMultiply(r.y, f);
    v[7].z = u.z - D3DMultiply(r.z, f);

    /*
     * Add the rod endpoints and calculate the vertex normals.
     */
    for (i = 0; i < 8; i++)
    {   n[i] = v[i];
        D3DRMVectorNormalise(&n[i]);
        v[i + 8].x = v[i].x + b.x;
        v[i + 8].y = v[i].y + b.y;
        v[i + 8].z = v[i].z + b.z;
        v[i].x += a.x;
        v[i].y += a.y;
        v[i].z += a.z;
    }

    /*
     * Now add the faces.
     */
    mesh->AddFaces(16, v, 8, n, rod_faces, NULL);
}

static unsigned long cone_faces[] =
{   8, 7, 7, 6, 6, 5, 5, 4, 4, 3, 3, 2, 2, 1, 1, 0, 0, /* end 1 */
    3, 0, 0, 1, 1, 8, 1,        /* side 0 */
    3, 1, 1, 2, 2, 8, 1,        /* side 1 */
    3, 2, 2, 3, 3, 8, 1, /* side 2 */
    3, 3, 3, 4, 4, 8, 1, /* side 3 */
    3, 4, 4, 5, 5, 8, 1, /* side 4 */
    3, 5, 5, 6, 6, 8, 1, /* side 5 */
    3, 6, 6, 7, 7, 8, 1, /* side 6 */
    3, 7, 7, 0, 0, 8, 1,                /* side 7 */
    0,
};

static
void
AddCone(LPVEGMESHBUILDER mesh, D3DVALUE radius, D3DVECTOR a, D3DVECTOR b)
{
    D3DVECTOR d, u, r;
    D3DVECTOR v[16];
    D3DVECTOR n[8];
    D3DVALUE f;
    int i;

    /*
     * Find the unit vector along the rod.
     */
    d.x = b.x - a.x;
    d.y = b.y - a.y;
    d.z = b.z - a.z;
    D3DRMVectorNormalise(&d);

    /*
     * Pick a vector normal to d
     */
    if (d.y != D3DVAL(0.0) || d.z != D3DVAL(0.0))
    {   u.x = D3DVAL(0.0);
        if (d.y == D3DVAL(0.0))
        {   u.y = D3DVAL(1.0);
            u.z = D3DVAL(0.0);
        } else
        {   D3DVALUE n_fix =
                D3DVAL(1.0)
            +   D3DDivide(D3DMultiply(d.z, d.z), D3DMultiply(d.y, d.y));
#ifdef FIXED_POINT_API
            double un_val = (double)n_fix / (double)(1<<16);
            u.z = D3DVAL(sqrt(1 / un_val));
#else
            u.z = D3DVAL(sqrt(D3DVAL(1.0) / D3DVAL(n_fix)));
#endif
            u.y = - D3DDivide(D3DMultiply(u.z, d.z), d.y);
        }
    } else
    {   u.x = D3DVAL(0.0);
        u.y = D3DVAL(0.0);
        u.z = D3DVAL(1.0);
    }

    /*
     * Now find a vector normal to them both, to give us a coordinate
     * system in the plane normal to the rod.
     */
    D3DRMVectorCrossProduct(&r, &d, &u);

    /*
     * Scale down the coordinates to the radius of the rod.
     */
    u.x = D3DMultiply(u.x, radius);
    u.y = D3DMultiply(u.y, radius);
    u.z = D3DMultiply(u.z, radius);
    r.x = D3DMultiply(r.x, radius);
    r.y = D3DMultiply(r.y, radius);
    r.z = D3DMultiply(r.z, radius);

    /*
     * Calculate the corners of an octagon.
     */
    f = D3DVAL((float)sqrt(2.0) / (2 * (1 + (float)sqrt(2.0) / 2)));
    v[0].x = u.x + D3DMultiply(r.x, f);
    v[0].y = u.y + D3DMultiply(r.y, f);
    v[0].z = u.z + D3DMultiply(r.z, f);

    v[1].x = D3DMultiply(u.x, f) + r.x;
    v[1].y = D3DMultiply(u.y, f) + r.y;
    v[1].z = D3DMultiply(u.z, f) + r.z;

    v[2].x = D3DMultiply(-u.x, f) + r.x;
    v[2].y = D3DMultiply(-u.y, f) + r.y;
    v[2].z = D3DMultiply(-u.z, f) + r.z;

    v[3].x = -u.x + D3DMultiply(r.x, f);
    v[3].y = -u.y + D3DMultiply(r.y, f);
    v[3].z = -u.z + D3DMultiply(r.z, f);

    v[4].x = -u.x - D3DMultiply(r.x, f);
    v[4].y = -u.y - D3DMultiply(r.y, f);
    v[4].z = -u.z - D3DMultiply(r.z, f);

    v[5].x = D3DMultiply(-u.x, f) - r.x;
    v[5].y = D3DMultiply(-u.y, f) - r.y;
    v[5].z = D3DMultiply(-u.z, f) - r.z;

    v[6].x = D3DMultiply(u.x, f) - r.x;
    v[6].y = D3DMultiply(u.y, f) - r.y;
    v[6].z = D3DMultiply(u.z, f) - r.z;

    v[7].x = u.x - D3DMultiply(r.x, f);
    v[7].y = u.y - D3DMultiply(r.y, f);
    v[7].z = u.z - D3DMultiply(r.z, f);

    v[8] = b;

    /*
     * Calculate the vertex normals.
     */
    for (i = 0; i < 8; i++)
    {   n[i] = v[i];
        D3DRMVectorNormalise(&n[0]);
        v[i].x += a.x;
        v[i].y += a.y;
        v[i].z += a.z;
    }

    /*
     * Now add the faces.
     */
    mesh->AddFaces(9, v, 8, n, cone_faces, NULL);
}
