#include "ZTypes.h"
#include "vcmain.h"
#include "anime.h"

static	ZTANIMEARGS			animeargs[MAX_CHARACTER+1];
static	ZTGESTURE			gesturestate[MAX_CHARACTER+1];
static	LPVEGFRAME			lpCharFrame[MAX_CHARACTER+1];

ZTGESTURESTATE gstTrans[][2] =
{
	GST_BODY_WALK,		GST_BODY_WALK,
	GST_BODY_STANCE,	GST_BODY_STANCE,
	GST_BODY_SLICE,		GST_BODY_STANCE,
	GST_BODY_MAGIC,		GST_BODY_STANCE,
};


ZTGESTURESTATE gst[] = 
{
	GST_BODY_WALK,
	GST_BODY_STANCE,
	GST_BODY_SLICE,
	GST_BODY_MAGIC
};

D3DVALUE gstCnt[] = 
{
	GST_BODY_CNT_WALK,
	GST_BODY_CNT_STANCE,
	GST_BODY_CNT_SLICE,
	GST_BODY_CNT_MAGIC
};

D3DVALUE gstStart[] =
{
	GST_BODY_START_WALK,
	GST_BODY_START_STANCE,
	GST_BODY_START_SLICE,
	GST_BODY_START_MAGIC
};

D3DVALUE gstTime[] =
{
	GST_BODY_TIME_WALK,
	GST_BODY_TIME_STANCE,
	GST_BODY_TIME_SLICE,
	GST_BODY_TIME_MAGIC
};

D3DVALUE gstDelta[] =
{
	GST_BODY_DELTA_WALK,
	GST_BODY_DELTA_STANCE,
	GST_BODY_DELTA_SLICE,
	GST_BODY_DELTA_MAGIC
};

void
CreateAnimeSet( void )
{
	for( int i = 0 ; i <= MAX_CHARACTER ; i++ )
	{
		animeargs[i].lpAnimeSetBody    = NULL;
		animeargs[i].timeBody    = D3DVAL( 0.0 );
//		ʳ Ȯ 
//		gesturestate[i].face   = GST_FACE_NORMAL;
		gesturestate[i].body   = GST_BODY_STANCE;
		lpCharFrame[i] = NULL;
	}
}

void
DestroyAnimeSet( int index )
{
	RELEASE( animeargs[index].lpAnimeSetBody    );
	animeargs[index].timeBody    = D3DVAL( 0.0 );
}

void
SetAnimeArgs( int index, LPZTANIMEARGS lpArgs )
{
	animeargs[index].lpAnimeSetBody    = lpArgs->lpAnimeSetBody   ;
	animeargs[index].timeBody          = lpArgs->timeBody   ;
}

void
SetGestureState( int index, LPZTGESTURE lpGesture )
{
	gesturestate[index].body   = lpGesture->body;

	animeargs[index].timeBody = gstStart[lpGesture->body];
}

ZTGESTURESTATE
GetGestureState( int index )
{
	return gesturestate[index].body;
}

void
SetCharFrame( int index, LPVEGFRAME lpFrame )
{
	lpCharFrame[index] = lpFrame;
}

int
SearchCharFrame( LPVEGFRAME lpFrame )
{
	for( int i = 0 ; i <= MAX_CHARACTER ; i++ )
		if( lpFrame == lpCharFrame[i] ) return i;

	return -1;
}

void
AnimateBody( int i, void* arg, D3DVALUE delta )
{
    D3DVALUE	timeBody;
	int			gst;

	gst = (int)gesturestate[i].body;
	timeBody = animeargs[i].timeBody;

    if( !animeargs[i].lpAnimeSetBody ) return;

	animeargs[i].lpAnimeSetBody->SetTime( timeBody );
	timeBody += ( gstDelta[gst] * delta );
	if( timeBody > gstStart[gst] + gstCnt[gst] )
	{
		gesturestate[i].body = gstTrans[gst][1];
		timeBody = gstStart[ gstTrans[gst][1] ];
	}

	animeargs[i].timeBody = timeBody;
}

void
CDECL
CallbackCharAnime( LPVEGFRAME obj, void* arg, D3DVALUE delta )
{
	int			i;
	
	i = SearchCharFrame( obj );
	if( i == -1 ) return;

	AnimateBody( i, arg, delta );
//	AnimateFace( i, arg, delta );
}

