#include <windows.h>
#include <windowsx.h>
#include <math.h>
#include "vcmain.h"
#include "vcselect.h"
#include "ztypes.h"
#include "anime.h"

#define SIGN_EXTEND(w)    ((((int)(w)) << 16) >> 16)

#define XFILE_HERO			"hero.x"
#define XFILE_SWORD			"sword.x"
#define XFILE_FIELD			"field.x"
#define XFILE_TUBE			"tube.x"

#define PI					3.141592

LONG FAR PASCAL WindowProc(HWND win, UINT msg, WPARAM wparam, LPARAM lparam);

void OnSize(HWND hwnd, UINT state, int cx, int cy);
void OnKeyDown(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
void OnActivate(HWND hwnd, UINT state, HWND hwndActDeact, BOOL fMinimized);
void OnPaint(HWND hwnd);
BOOL OnEraseBkgnd(HWND hwnd, HDC hdc);
void OnLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
void OnLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
void OnRButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
void OnRButtonUp(HWND hwnd, int x, int y, UINT flags);
void OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags);

static char			acAppName[32] = "TestApp";
LPVEGCLI3DINFO		lpInfo;
BOOL				left_drag, right_drag;
int					last_x, last_y;
LPVEGFRAME			sFrame = NULL;
LPVEGFRAME			lpSword = NULL;
LPVEGFRAME			lpHero = NULL;
ZTGESTURE			gst;

void LoadData( void )
{
	ZTANIMEARGS			args;
	D3DVECTOR			pos;

	pos.x = D3DVAL( 0 );
	pos.y = D3DVAL( 0 );
	pos.z = D3DVAL( 0 );

	// HERO.X  а ִϸ̼ غѴ.
	lpHero = vegcli3DFrameHierCreateFromAnimeFile( lpInfo, 
												   lpInfo->scene, 
												   XFILE_HERO );
	args.lpAnimeSetBody = lpInfo->animationSet;
	args.timeBody = D3DVAL( 0 );
	SetAnimeArgs( 0, &args );
	SetCharFrame( 0, lpHero );
	gst.body = GST_BODY_WALK;
	SetGestureState( 0, &gst );
	lpHero->AddMoveCallback( CallbackCharAnime, NULL, D3DRMCALLBACK_PREORDER  );

	// ٴ   а, 
	pos.x = D3DVAL( 1 );
	pos.y = D3DVAL( -149 );
	pos.z = D3DVAL( 300 );
	vegcli3DFrameCreateFromMeshFile( lpInfo, lpInfo->scene, lpInfo->camera, &pos, NULL, NULL, XFILE_FIELD );
/*
	// Į о ̱ Ͽ    ã´.
	lpFrame = vegcli3DSelSearchFrameByName( lpFrame, MONTAGE_BODYPART_RFIST );
	if( lpFrame )
	{
		pos.x = D3DVAL( 0 );
		pos.y = D3DVAL( 0 );
		pos.z = D3DVAL( 0 );
		// Į   ڽ  о δ.
		lpFrame = vegcli3DFrameCreateFromMeshFile( lpInfo, lpFrame, lpFrame, &pos, NULL, NULL, XFILE_SWORD );
		pos.x = D3DVAL( 1 );
		pos.y = D3DVAL( 0 );
		pos.z = D3DVAL( 0 );
		// Į ȸ ġ  Ѵ.
		vegcli3DFrameAddRotation( lpFrame, D3DRMCOMBINE_BEFORE, &pos, D3DVAL( -PI / 2 ) );
	}
*/
}

BOOL DoInit( HWND hwnd )
{
	D3DVECTOR	pos, rgb;
	D3DVECTOR	d, u;

	d.x = D3DVAL( -1 );
	d.y = D3DVAL( -1 );
	d.z = D3DVAL( 1 );

	u.x = D3DVAL( 0 );
	u.y = D3DVAL( 1 );
	u.z = D3DVAL( 0 );

	lpInfo = vegcli3DCreate( hwnd, VEGCLI_DISPMODE_EXCLUSIVE, 640, 480, 16 );
	if( !lpInfo ) return FALSE;

    pos.x = D3DVAL(0.0);
    pos.y = D3DVAL(150.0);
    pos.z = D3DVAL(-240.0);
	vegcli3DFrameSetPos( lpInfo->camera, lpInfo->scene, &pos );

	//  GOURAUD ̵ 
	vegcli3DQualitySet( lpInfo, D3DRMRENDER_GOURAUD );
	vegcli3DQualitySetColormodel( lpInfo, D3DCOLOR_RGB );
	vegcli3DFPSDisplay( lpInfo, TRUE );

	//    
	rgb.x = D3DVAL( .5 );
	rgb.y = D3DVAL( .5 );
	rgb.z = D3DVAL( .5 );
    //  ġ
	pos.x = D3DVAL(0.0);
    pos.y = D3DVAL(200.0);
    pos.z = D3DVAL(200.0);
	//  
	vegcli3DLightCreate( lpInfo, lpInfo->scene, lpInfo->scene, D3DRMLIGHT_AMBIENT, &rgb, &pos, NULL, NULL );
	vegcli3DLightCreate( lpInfo, lpInfo->scene, lpInfo->scene, D3DRMLIGHT_PARALLELPOINT, &rgb, &pos, NULL, NULL );
	pos.x = D3DVAL(0.0);
    pos.y = D3DVAL(50.0);
    pos.z = D3DVAL(-100.0);
	vegcli3DLightCreate( lpInfo, lpInfo->scene, lpInfo->scene, D3DRMLIGHT_POINT, &rgb, &pos, NULL, NULL );

	LoadData();

	return TRUE;
}

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR cmdline, int cmdshow )
{
    MSG			msg;
    WNDCLASS	wc;
    HWND		hwnd;
	RECT		r;

    wc.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = sizeof(DWORD);
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = NULL;
    wc.lpszClassName = acAppName;
    RegisterClass(&wc);

    hwnd =
	CreateWindow
	(   acAppName,				/* class */
	    acAppName,				/* caption */
	    WS_POPUP,	/* style */
	    CW_USEDEFAULT,			/* init. x pos */
	    CW_USEDEFAULT,			/* init. y pos */
	    640,					/* init. x size */
	    480,					/* init. y size */
	    NULL,					/* parent window */
	    NULL,					/* menu handle */
	    hInstance,				/* program handle */
	    NULL					/* create parms */
	);


    if ( !hwnd ) return 1;

    ShowWindow( hwnd, cmdshow );
    UpdateWindow( hwnd );

	if( !DoInit( hwnd ) ) return 1;

    while ( TRUE )
	{
		GetClientRect( hwnd, &r );

		while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
			{
				goto out;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		if ( r.right && r.bottom )
		{
			if (!vegcli3DRender( lpInfo ))
			{
				vegMsg("Rendering failed.\n");
				break;
			}	
		}
		else
		{
			WaitMessage();
		}
    }

out:
    DestroyWindow(hwnd);
	vegcli3DDestroy( lpInfo );
    return msg.wParam;
}

LONG FAR PASCAL WindowProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch( msg )
	{
		HANDLE_MSG( hwnd, WM_SIZE, OnSize );
		HANDLE_MSG( hwnd, WM_KEYDOWN, OnKeyDown );
		HANDLE_MSG( hwnd, WM_LBUTTONDOWN, OnLButtonDown );
		HANDLE_MSG( hwnd, WM_LBUTTONUP, OnLButtonUp );
		HANDLE_MSG( hwnd, WM_RBUTTONDOWN, OnRButtonDown );
		HANDLE_MSG( hwnd, WM_RBUTTONUP, OnRButtonUp );
		HANDLE_MSG( hwnd, WM_MOUSEMOVE, OnMouseMove );
		HANDLE_MSG( hwnd, WM_ACTIVATE, OnActivate );
		HANDLE_MSG( hwnd, WM_PAINT, OnPaint );
		HANDLE_MSG( hwnd, WM_ERASEBKGND, OnEraseBkgnd );
		default : 
			return DefWindowProc(hwnd, msg, wParam, lParam);
	}
}

void OnSize(HWND hwnd, UINT state, int cx, int cy)
{
	if( cx && cy )
		vegcli3DResizeViewport( lpInfo, cx, cy );
}

#define WALKTHRU_KEY_FRONT		VK_UP
#define WALKTHRU_KEY_BACK		VK_DOWN
#define WALKTHRU_KEY_LEFT		VK_LEFT
#define WALKTHRU_KEY_RIGHT		VK_RIGHT
#define WALKTHRU_KEY_UP			VK_PRIOR
#define WALKTHRU_KEY_DOWN		VK_NEXT
#define MOVE_GAP	20
#define TURN_GAP	0.08

void OnKeyDown(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags)
{
	if( vk == VK_ESCAPE )
		PostQuitMessage( 0 );

	if( vk == WALKTHRU_KEY_FRONT )
		vegcli3DNaviMoveFront( lpInfo, D3DVAL( MOVE_GAP ) );
	else
	if( vk == WALKTHRU_KEY_BACK )
		vegcli3DNaviMoveBack( lpInfo, D3DVAL( MOVE_GAP ) );
	else
	if( vk == WALKTHRU_KEY_LEFT && GetKeyState( VK_CONTROL ) < 0 )
		vegcli3DNaviMoveLeft( lpInfo, D3DVAL( MOVE_GAP ) );
	else
	if( vk == WALKTHRU_KEY_RIGHT && GetKeyState( VK_CONTROL ) < 0 )
		vegcli3DNaviMoveRight( lpInfo, D3DVAL( MOVE_GAP ) );
	else
	if( vk == WALKTHRU_KEY_LEFT )
		vegcli3DNaviTurnLeft( lpInfo, D3DVAL( TURN_GAP ) );
	else
	if( vk == WALKTHRU_KEY_RIGHT )
		vegcli3DNaviTurnRight( lpInfo, D3DVAL( TURN_GAP ) );
	else
	if( vk == WALKTHRU_KEY_UP && GetKeyState( VK_CONTROL ) < 0 )
		vegcli3DNaviMoveUp( lpInfo, D3DVAL( MOVE_GAP ) );
	else
	if( vk == WALKTHRU_KEY_DOWN && GetKeyState( VK_CONTROL ) < 0 )
		vegcli3DNaviMoveDown( lpInfo, D3DVAL( MOVE_GAP ) );
	else
	if( vk == WALKTHRU_KEY_UP )
		vegcli3DNaviTurnUp( lpInfo, D3DVAL( TURN_GAP ) );
	else
	if( vk == WALKTHRU_KEY_DOWN )
		vegcli3DNaviTurnDown( lpInfo, D3DVAL( TURN_GAP ) );

	if( vk == '1' )
	{
		gst.body = GST_BODY_WALK;
		SetGestureState( 0, &gst );
	}
	if( vk == '2' )
	{
		gst.body = GST_BODY_STANCE;
		SetGestureState( 0, &gst );
	}
	if( vk == '3' )
	{
		gst.body = GST_BODY_SLICE;
		SetGestureState( 0, &gst );
	}
	if( vk == '4' )
	{
		gst.body = GST_BODY_MAGIC;
		SetGestureState( 0, &gst );
	}
	if( vk == '5' )		// Į ǥѴ.
	{
		if( !lpSword )
		{
			LPVEGFRAME	lpFrame;
			D3DVECTOR	pos;

			// Į о ̱ Ͽ  ָ  ã´.
			lpFrame = vegcli3DSelSearchFrameByName( lpHero, MONTAGE_BODYPART_RFIST );
			if( lpFrame )
			{
				pos.x = D3DVAL( 0 );
				pos.y = D3DVAL( 0 );
				pos.z = D3DVAL( 0 );
				// Į  ָ ڽ  о δ.
				lpSword = vegcli3DFrameCreateFromMeshFile( lpInfo, lpFrame, lpFrame, &pos, NULL, NULL, XFILE_SWORD );
				pos.x = D3DVAL( 1 );
				pos.y = D3DVAL( 0 );
				pos.z = D3DVAL( 0 );
				// Į ȸ ġ  Ѵ.
				vegcli3DFrameAddRotation( lpSword, D3DRMCOMBINE_BEFORE, &pos, D3DVAL( -PI / 2 ) );
			}
		}
	}
	if( vk == '6' )		// Į .
	{
		if( lpSword )
		{
			vegcli3DFrameDestroy( lpSword );
			lpSword = NULL;
		}
	}
}

void OnActivate(HWND hwnd, UINT state, HWND hwndActDeact, BOOL fMinimized)
{
	WPARAM	wParam = (WPARAM)( WORD(  fMinimized || (state>>8) ) );
	
	LPDIRECT3DRMWINDEVICE windev;
	if (!lpInfo || !lpInfo->device) return;
	if (SUCCEEDED(lpInfo->device->QueryInterface(IID_IDirect3DRMWinDevice, (void **) &windev)))
	{
		if (FAILED(windev->HandleActivate(wParam)))
			vegMsg("Failed to handle WM_ACTIVATE.\n");
		windev->Release();
	}
	else
	{
		vegMsg("Failed to create Windows device to handle WM_ACTIVATE.\n");
	}
}

void OnPaint(HWND hwnd)
{
	if (lpInfo)
	{
		RECT r;
	    PAINTSTRUCT ps;
	    LPDIRECT3DRMWINDEVICE windev;

		if (!lpInfo || !lpInfo->device) return;
	    if (GetUpdateRect(hwnd, &r, FALSE))
	    {
			BeginPaint(hwnd, &ps);
    		if (SUCCEEDED(lpInfo->device->QueryInterface(IID_IDirect3DRMWinDevice, (void **) &windev)))
			{
				if (FAILED(windev->HandlePaint(ps.hdc)))
					vegMsg("Failed to handle WM_PAINT.\n");
				windev->Release();
			}
			else
			{
				vegMsg("Failed to create Windows device to handle WM_PAINT.\n");
			}
		
			EndPaint(hwnd, &ps);
	    }
	}
}

BOOL OnEraseBkgnd(HWND hwnd, HDC hdc)
{
	return TRUE;
}

void OnLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags)
{
	last_x = x;
	last_y = y;
	vegcli3DSelFindVisual( lpInfo, x, y );
	left_drag = TRUE;
	SetCapture( hwnd );
}

void OnLButtonUp(HWND hwnd, int x, int y, UINT keyFlags)
{
	ReleaseCapture();
	left_drag = FALSE;
}

void OnRButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags)
{
	last_x = x;
	last_y = y;
	vegcli3DSelFindVisual( lpInfo, x, y );
	right_drag = TRUE;
	SetCapture( hwnd );
}

void OnRButtonUp(HWND hwnd, int x, int y, UINT flags)
{
	ReleaseCapture();
	right_drag = FALSE;
}

void OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags)
{
	sFrame = vegcli3DSelGetFrame();

	if ((keyFlags & MK_LBUTTON) && sFrame && left_drag)
	{   
		double delta_x, delta_y;
	    delta_x = SIGN_EXTEND( x ) - last_x;
	    delta_y = -SIGN_EXTEND( y  - last_y );
	    last_x = SIGN_EXTEND( x );
	    last_y = SIGN_EXTEND( y );
	    {
		double delta_r = sqrt(delta_x * delta_x + delta_y * delta_y);
		double radius = 50;
		double denom;

		denom = sqrt(radius * radius + delta_r * delta_r);

		if (delta_r == 0 || denom == 0) return;
		sFrame->AddRotation
		(	D3DRMCOMBINE_BEFORE, //lpInfo->camera,
		    D3DDivide(D3DVAL((float) delta_y), D3DVAL((float) delta_r)),
		    D3DDivide(D3DVAL((float) -delta_x), D3DVAL((float) delta_r)),
		    D3DVAL(0.0),
		    D3DDivide(D3DVAL((float) delta_r), D3DVAL((float) denom))
		);
	    }
	}
	else 
	if ((keyFlags & MK_RBUTTON) && sFrame && right_drag)
	{   
		double delta_x, delta_y;
	    D3DVECTOR p1;
	    D3DRMVECTOR4D p2;

	    delta_x = SIGN_EXTEND( x ) - last_x;
	    delta_y = SIGN_EXTEND( y ) - last_y;
	    last_x = SIGN_EXTEND( x );
	    last_y = SIGN_EXTEND( y );
	    sFrame->GetPosition(lpInfo->scene, &p1);
	    lpInfo->view->Transform(&p2, &p1);
	    p2.x += D3DMultiply(D3DVAL((float)delta_x), p2.w);
	    p2.y += D3DMultiply(D3DVAL((float)delta_y), p2.w);
	    lpInfo->view->InverseTransform(&p1, &p2);
	    sFrame->SetPosition(lpInfo->scene, p1.x, p1.y, p1.z);
	}
}

