//
// ZTypes.h
// 
// Global typing definitions 1.0
// 
// (c)copyleft by newtype
//

#ifndef _ZTYPES_H_
#define _ZTYPES_H_

#include "vcmain.h"

#define MAX_CHARACTER		2

#define MONTAGE_FACEPART_HEAD		"x3ds_head"
#define MONTAGE_FACEPART_HAIR		"x3ds_hair"
#define MONTAGE_BODYPART_NECK		"x3ds_neck"
#define MONTAGE_BODYPART_CHEST		"x3ds_chest"
#define MONTAGE_BODYPART_HIP 		"x3ds_hip"
#define MONTAGE_BODYPART_LDARM		"x3ds_dlarml"
#define MONTAGE_BODYPART_RDARM		"x3ds_drarmr"
#define MONTAGE_BODYPART_LUARM		"x3ds_ularml"
#define MONTAGE_BODYPART_RUARM		"x3ds_urarmr"
#define MONTAGE_BODYPART_LFIST		"x3ds_lfist"
#define MONTAGE_BODYPART_RFIST		"x3ds_rfist"
#define MONTAGE_BODYPART_LDLEG		"x3ds_dlleg"
#define MONTAGE_BODYPART_RDLEG		"x3ds_drleg"
#define MONTAGE_BODYPART_LULEG		"x3ds_ulleg"
#define MONTAGE_BODYPART_RULEG		"x3ds_urleg"
#define MONTAGE_BODYPART_LFOOT		"x3ds_lfoot"
#define MONTAGE_BODYPART_RFOOT		"x3ds_lfoot"

#define GST_BODY_WALK				0
#define GST_BODY_STANCE				1
#define GST_BODY_SLICE				2
#define GST_BODY_MAGIC				3

#define GST_BODY_CNT_WALK			D3DVAL( 119 )
#define GST_BODY_CNT_STANCE			D3DVAL( 29 )
#define GST_BODY_CNT_SLICE			D3DVAL( 59 )
#define GST_BODY_CNT_MAGIC			D3DVAL( 59 )

#define GST_BODY_START_WALK			D3DVAL( 0 )
#define GST_BODY_START_STANCE		D3DVAL( 120 )
#define GST_BODY_START_SLICE		D3DVAL( 150 )
#define GST_BODY_START_MAGIC		D3DVAL( 210 )

//  1000 1
#define GST_BODY_TIME_WALK			D3DVAL( 2000 )		// 2
#define GST_BODY_TIME_STANCE		D3DVAL( 1000 )		// 1
#define GST_BODY_TIME_SLICE			D3DVAL( 2000 )		// 2
#define GST_BODY_TIME_MAGIC			D3DVAL( 3000 )		// 3

#define GST_BODY_DELTA_WALK			D3DVAL( GST_BODY_CNT_WALK   / GST_BODY_TIME_WALK )
#define GST_BODY_DELTA_STANCE		D3DVAL( GST_BODY_CNT_STANCE / GST_BODY_TIME_STANCE )
#define GST_BODY_DELTA_SLICE		D3DVAL( GST_BODY_CNT_SLICE	/ GST_BODY_TIME_SLICE )
#define GST_BODY_DELTA_MAGIC		D3DVAL( GST_BODY_CNT_MAGIC	/ GST_BODY_TIME_MAGIC )

typedef int ZTGESTURESTATE;

typedef struct tagZTGESTURE
{
//	ZTGESTURESTATE	face;
	ZTGESTURESTATE	body;
} ZTGESTURE, *PZTGESTURE, *LPZTGESTURE;

typedef struct tagZTANIMEARGS
{
    LPVEGANIMATIONSET			lpAnimeSetBody;
    D3DVALUE                    timeBody;
} ZTANIMEARGS, *PZTANIMEARGS, *LPZTANIMEARGS;

#endif //_ZTYPES_H_
