///////////////////////////////////////////////////////////////
// MAPEDIT.CPP                                KYONGEUN		 //
// *************************************************		 //
// ***** MAPEDIT Utility Programe Version 1.1  *****		 //
// ***** [ KyongEun-Seo ] 1998 . 4             *****		 //
// *************************************************		 //
//															 //
// USAGE : MAPEDIT filename.(PCX, BMP)                       //
//															 //
//  EX) MAPEDIT test.bmp      ==>   test.map 				 //
//      MAPEDIT test.pcx      ==>   test.map    			 //
//															 //
// Thank You !   											 //
//															 //
///////////////////////////////////////////////////////////////

#include "mapedit.h"



BOOL InitMain(LPSTR fn)
{
    page0  = CreateMemory(640*480);
    page1  = CreateMemory(640*480);
  


	int fc  = 0;
	BOOL filecheck = FALSE;

	// ӵ  ȭ ̸  ȭ ̸ .
	for(int i=0; i<20; i++)                       
	{
		tempfn[fc++] = *(fn++);              // ó ѹھ filename Ѵ. 
		if( *fn == ' ' )                     // ' '(space)  ...
		{
			tempfn[fc] = '\0';               // 迭  '\0' Ѵ. 
			fc = 0;
			break;
		}

	}



    if( !strstr(tempfn, ".") )
	{
		sprintf(M_SAVEMESSAGE, "ȭ ̸ Ȯ Էϼ...^^;");
		return FALSE;
	}



	if( LoadPcx(page0, tempfn, Pal) != FALSE )
	{
		filecheck = TRUE;
	}
	
	if( LoadBmp(page0, tempfn, Pal) != FALSE )
	{
		filecheck = TRUE;
	}


	if(filecheck == FALSE)
	{
		wsprintf(M_SAVEMESSAGE, "%s ׷ ȭ ƴմϴ.", tempfn);
		return FALSE;
	}



	return TRUE;   

}




void CloseMain(void)
{
	FreeMemory(page0);
	FreeMemory(page1);


	if(M_MAPNUM != 0)
	{
		for(int i=0; i<20; i++)
		{
			filename[i] = tempfn[i];
			if(tempfn[i] == '.')
			{
				filename[i] = '\0';
				break;
			}
		}

		strcat(filename, ".MAP");

		if( (fp=fopen(filename, "wb")) == NULL)
		{
			wsprintf(M_SAVEMESSAGE, "%s ȭ   ϴ.", filename);
			MessageBox(NULL, M_SAVEMESSAGE, "(FALE)", MB_OK);
			PostQuitMessage(0);
		}	

	
		fwrite(MapID, 30, 1, fp);


		for(int ii=0; ii<M_MAPNUM; ii++)
		{
			fwrite(&MAPID[ii].num,  4, 1, fp);           //  ȭ Ϳ  ȣ .
			fwrite(&MAPID[ii].sx,   4, 1, fp);           //   ǥ .
			fwrite(&MAPID[ii].sy,   4, 1, fp);          
			fwrite(&MAPID[ii].ex,   4, 1, fp);           //   ǥ .          
			fwrite(&MAPID[ii].ey,   4, 1, fp);          
			fwrite(&MAPID[ii].att,  4, 1, fp);           //  Ӽ .
		}

		fwrite(&M_MAPNUM, 4, 1, fp);				   	 // ȭ  ü   .
		fclose(fp);									     // ȭ ݴ´.
	
		wsprintf(M_SAVEMESSAGE, "%s ȭ ϴ...^^;", filename);
	}
	else 
	{
		sprintf(M_SAVEMESSAGE, "(*.MAP) ȭ  ʾҽϴ...^^;");
	} 


	MessageBox(NULL, M_SAVEMESSAGE, " ȭ(RESULT)", MB_OK);

}




void DrawCross(void)
{
	PutWLine(M_XPOS-20, M_YPOS, 41, M_COLORNUM);
	PutHLine(M_XPOS, M_YPOS-20, 41, M_COLORNUM);
}



void DrawBox(void)
{
	int M_IMAGEMODE;						            // ڽ ׸   

	M_WIDTH  = M_XPOS - M_XSTART;                         //  ׸  ̸ Ѵ.
	M_HEIGHT = M_YPOS - M_YSTART;

	if(M_WIDTH>0 && M_HEIGHT>0) { M_IMAGEMODE = 1; }    // ׸ »󿡼 Ϸ 
	if(M_WIDTH<0 && M_HEIGHT<0) { M_IMAGEMODE = 2; }    // ׸ Ͽ » 
	if(M_WIDTH<0 && M_HEIGHT>0) { M_IMAGEMODE = 3; }    // ׸ Ͽ  
	if(M_WIDTH>0 && M_HEIGHT<0) { M_IMAGEMODE = 4; }    // ׸ 󿡼 Ϸ 

	if(M_WIDTH <0) M_WIDTH  =  -M_WIDTH;        // ũⰡ ̸  .
	if(M_HEIGHT<0) M_HEIGHT =  -M_HEIGHT;

	M_WIDTH++;
	M_HEIGHT++;
  
	if(M_IMAGEMODE == 1) { PutBox(M_XSTART, M_YSTART, M_WIDTH, M_HEIGHT, M_COLORNUM); }
	if(M_IMAGEMODE == 2) { PutBox(M_XPOS, M_YPOS, M_WIDTH, M_HEIGHT, M_COLORNUM); }
	if(M_IMAGEMODE == 3) { PutBox(M_XPOS, M_YSTART, M_WIDTH, M_HEIGHT, M_COLORNUM); }
	if(M_IMAGEMODE == 4) { PutBox(M_XSTART, M_YPOS, M_WIDTH, M_HEIGHT, M_COLORNUM); }
}



void DrawSaveBox(void)
{
	int w, h;
	for(int i=0; i<M_MAPNUM; i++)
	{
		w = MAPID[i].ex - MAPID[i].sx;
		h = MAPID[i].ey - MAPID[i].sy;
		PutBox(MAPID[i].sx, MAPID[i].sy, w+1, h+1, M_COLORNUM); 
	}


}


void SaveMap(void)                //  ǥ ȭϿ Ѵ.
{
	int value;
	int temp;

	if(M_XSTART > M_XEND) 
	{
		temp = M_XSTART;
		M_XSTART = M_XEND;
		M_XEND = temp;
	}
	if(M_YSTART > M_YEND) 
	{
		temp = M_YSTART;
		M_YSTART = M_YEND;
		M_YEND = temp;
	}

	wsprintf(M_SAVEMESSAGE, 
		      "    ȣ : %d \n ǥ : (%d, %d)\n    ǥ : (%d, %d)\n ũ : %d\n ũ : %d\n\n    : %d\n\nϽðڽϱ ?",
			  M_MAPNUM, M_XSTART, M_YSTART, M_XEND, M_YEND, M_WIDTH, M_HEIGHT, M_ATT);

	value = MessageBox(NULL, M_SAVEMESSAGE, "(SAVE)", MB_YESNO);
 
	if(value == IDYES)
	{
		MAPID[M_MAPNUM].num = M_MAPNUM;
		MAPID[M_MAPNUM].sx  = M_XSTART;
		MAPID[M_MAPNUM].sy  = M_YSTART;
		MAPID[M_MAPNUM].ex  = M_XEND;
		MAPID[M_MAPNUM].ey  = M_YEND;
		MAPID[M_MAPNUM].att = M_ATT;
 
		M_MAPNUM++;
	}
 
	M_DRAWMODE = FALSE;
}




void DelMap(void)    // Ʈ ϳ Ѵ.
{
	M_MAPNUM--;

	MAPID[M_MAPNUM].num = M_MAPNUM;
	MAPID[M_MAPNUM].sx  = 0;
	MAPID[M_MAPNUM].sy  = 0;
	MAPID[M_MAPNUM].ex  = 0;
	MAPID[M_MAPNUM].ey  = 0;
	MAPID[M_MAPNUM].att = ID_ATT;

	M_DEL = FALSE;
}




void PutMessage(void)
{
 char i[10];

 itoa(M_MAPNUM, i, 10);      
 PutFont(15, 460, "Map Number : ", M_COLORNUM);
 PutFont(120, 460, i, M_COLORNUM);

 itoa(M_ATT, i, 10);      
 PutFont(190, 460, "Map Att : ", M_COLORNUM);
 PutFont(270, 460, i, M_COLORNUM);

 switch(M_ENTER)
 {
 case FALSE:
	  itoa(M_XPOS, i, 10);
	  PutFont(350, 460, "X-POS : ", M_COLORNUM);
	  PutFont(410, 460, i, M_COLORNUM);

      itoa(M_YPOS, i, 10);
	  PutFont(520, 460, "Y-POS : ", M_COLORNUM);
	  PutFont(580, 460, i, M_COLORNUM);
	  break;

 case TRUE:
	 itoa(M_WIDTH, i, 10);
     PutFont(350, 460, "X-SIZE : ", M_COLORNUM);
     PutFont(410, 460, i, M_COLORNUM);

     itoa(M_HEIGHT, i, 10);
     PutFont(520, 460, "Y-SIZE : ", M_COLORNUM);
     PutFont(580, 460, i, M_COLORNUM);
  }

}



///////////////////
// ۾ ƾ...
///////////////////
void Main( void )
{
    page1 = BBPointer();
	ActivePage(page1);
	ClearPage(0);
	CopyPage(page0, page1);

	// ۾ .........

	//  ڽ ׸
	DrawSaveBox();

	// ڽ ׸
    if(M_ENTER == TRUE) DrawBox();

	//  Ÿ  
    if(M_DRAWMODE == TRUE && M_ENTER == FALSE) SaveMap();

	//  Ÿ  
	if(M_DEL == TRUE) DelMap();

	//  
	PutMessage();

	//  ׸ 
	DrawCross();

	ViewScreen();

}




int     ActiveFlag = TRUE;

LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{

    switch(message)
    {
		case WM_CREATE:
			if(!InitMain(FN))
//			{
//				MessageBox(NULL, M_SAVEMESSAGE, "ȭ ġ(MERGE)", MB_OK);
//				PostQuitMessage(0);
//			}
//			else
			{
				MessageBox(NULL, M_SAVEMESSAGE, "(FALSE)", MB_OK);
				PostQuitMessage(0);
			}
			break;

        case WM_DESTROY :
            PostQuitMessage(0);
			break;

        case WM_ACTIVATEAPP :
            ActiveFlag = wParam;
            SetCursor(NULL);
            break;

		case WM_KEYDOWN:
			switch(wParam)
			{
 			case VK_ESCAPE:
				int value;
				value = MessageBox(NULL, "α׷ Ͻðڽϱ ?", "(QUIT)", MB_YESNO);
                if(value == IDYES) PostQuitMessage(0);
				  else break;
                break;
			case VK_F1:
				wsprintf(M_SAVEMESSAGE, 
					     "    %d Դϴ.\n\n%d ~ %d...", 
						 M_MAPNUM, 0, M_MAPNUM-1);
				MessageBox(NULL, M_SAVEMESSAGE, " (SAVE INFO)", MB_OK);
				break;
            // ڽ  
			case VK_SPACE:
				M_COLORNUM++;
				if(M_COLORNUM > 15) M_COLORNUM = 0;
				break;
			//  Ӽ  
			case VK_CONTROL:
				M_ATT++;
				if(M_ATT > 9) M_ATT = 0;
				break;
			// ڽ  
			case VK_SHIFT:
				M_DRAWMODE = FALSE;
				M_ENTER = FALSE;
				break;
				
			case VK_UP:
				M_YPOS--;
				if(M_YPOS < 0) M_YPOS = 0;
				break;
			case VK_DOWN:
				M_YPOS++;
				if(M_YPOS > ID_WINKSIZEY-1) M_YPOS = ID_WINKSIZEY-1; 
				break;
			case VK_RIGHT:
				M_XPOS++;
				if(M_XPOS > ID_WINKSIZEX-1) M_XPOS = ID_WINKSIZEX-1; 
				break;
			case VK_LEFT:
				M_XPOS--;
				if(M_XPOS < 0) M_XPOS = 0;
				break;

			case VK_RETURN:
				if(M_DRAWMODE == FALSE)
				{
					M_XSTART = M_XPOS;
					M_YSTART = M_YPOS;
				}
				M_ENTER = !M_ENTER;
				M_DRAWMODE = TRUE;
				break;

			}
			break;

        case WM_MOUSEMOVE:
			M_XPOS = LOWORD(lParam);
			M_YPOS = HIWORD(lParam);
			break;

		case WM_LBUTTONDOWN:
			if(M_DRAWMODE == FALSE)
			{
				M_XSTART = M_XPOS;
				M_YSTART = M_YPOS;
			}
			if(M_ENTER == TRUE)
			{
				M_XEND = M_XPOS;
				M_YEND = M_YPOS;
			}
			M_ENTER = !M_ENTER;
			M_DRAWMODE = TRUE;
            break;

		case WM_RBUTTONDOWN:
			if(M_MAPNUM > 0) 
			{
				int value;

				wsprintf(M_SAVEMESSAGE, 
				" ȣ : %d \n\n\nϽðڽϱ ?",
				M_MAPNUM-1);
				value = MessageBox(NULL, M_SAVEMESSAGE, "(DELETE)", MB_YESNO);
				if(value == IDYES) M_DEL = TRUE;
			}
			else 
			{
			    MessageBox(NULL, "  ϴ...^^;", "(DELETE)", MB_OK);
			    break;    
			}
            break;
    }

    return  DefWindowProc(hwnd, message, wParam, lParam);
}




int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	FN = lpCmdLine;

    MSG         msg;
    HWND	    hwnd; 
	WNDCLASS    wc;

	wc.lpszClassName = "MAPEDIT";
	wc.hInstance     = hInstance;
	wc.lpfnWndProc   = WindowProc;
    wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.cbClsExtra    = 0; 
	wc.cbWndExtra    = 0; 
	wc.hIcon         = NULL; 
	wc.hCursor       = NULL; 
	wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
	
    RegisterClass(&wc);

    hwnd = CreateWindow( "MAPEDIT",
		                 "MAPEDIT",
						 WS_POPUP,
						 0,
						 0,
				         GetSystemMetrics(SM_CXSCREEN), 
						 GetSystemMetrics(SM_CYSCREEN),  
						 NULL, 
						 NULL, 
						 hInstance, 
						 NULL );

    ShowWindow(hwnd,nCmdShow);
    UpdateWindow(hwnd);


//    M_FULLSCREEN = FALSE;
	InitWinKGL( hwnd );

	LoadFont("han.fnt", "eng.fnt");
	
	SetPalette(Pal);

    int     done = 1;

    while(done) 
	{
        while( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) !=0 ) 
		{
            if( GetMessage( &msg, NULL, 0, 0) == 0 )   done = 0;
                
			TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        
		if (ActiveFlag == TRUE)   
		{
			if(FrameSkip(0, 30)) Main();
		}
    }


	CloseMain();

	CloseWinKGL();


	return msg.wParam;
}
