//////////////////////////////////////////////////////////////
// PCX2SPR.CPP                                KYONGEUN		//
//															//
//  *************************************************		//
//  ***** PCX2SPR Utility Programe Version 1.1  *****		//
//  ***** [ KyongEun-Seo ] 1997.7   ~   1998.4  *****		//
//  ***** [ Only 640 x 480 x 256 Color Image ]  *****		//
//  *************************************************		//
//															//
//  USAGE : PCX2SPR filename[.PCX] filename[.SPR]			//
//															//
//    EX) pcx2spr test.pcx test.dog ( Create test.dog file) //
//    EX) pcx2spr test test.cat     ( Create test.cat file) //
//    EX) pcx2spr test.pcx test     ( Create test.spr file) //
//    EX) pcx2spr test test         ( Create test.spr file) //
//    EX) pcx2spr test              ( Create     .spr file) //
//															//		
//  Thank You !												//
//////////////////////////////////////////////////////////////

#include "pcx2spr.h"



void PutCross(int x, int y)         // ǥ ڸ ׸.
{
  PutWLine(Xpos-20, Ypos, 41, colornum);
  PutHLine(Xpos, Ypos-20, 41, colornum);
}


void DrawBox()                     // ȭ鿡 ڸ ׸.
{
 xwidth  = Xpos - Xold;            //  ׸  ̸ Ѵ.
 yheight = Ypos - Yold;

 if(xwidth>0 && yheight>0) { imagemodesw = 1; }    // ׸ »󿡼 Ϸ 
 if(xwidth<0 && yheight<0) { imagemodesw = 2; }    // ׸ Ͽ » 
 if(xwidth<0 && yheight>0) { imagemodesw = 3; }    // ׸ Ͽ  
 if(xwidth>0 && yheight<0) { imagemodesw = 4; }    // ׸ 󿡼 Ϸ 

 if(xwidth <0) xwidth  =  -xwidth;        // ũⰡ ̸  .
 if(yheight<0) yheight = -yheight;

 xwidth++;
 yheight++;
  
 if(imagemodesw == 1) { PutBox(Xold, Yold, xwidth, yheight, colornum); }
 if(imagemodesw == 2) { PutBox(Xpos, Ypos, xwidth, yheight, colornum); }
 if(imagemodesw == 3) { PutBox(Xpos, Yold, xwidth, yheight, colornum); }
 if(imagemodesw == 4) { PutBox(Xold, Ypos, xwidth, yheight, colornum); }
}


void SaveSpr(void)                //  ׸ ȭϿ Ѵ.
{
 int value;
 wsprintf(M_SAVEMESSAGE, 
	      "Ʈ ȣ : %d \n\n ũ : %d\n ũ : %d\n\nϽðڽϱ ?",
	      sprnum, xwidth, yheight);

 value = MessageBox(NULL, M_SAVEMESSAGE, "(SAVE)", MB_YESNO);
 
 if(value == IDYES)
 {
  SD[sprnum].num = sprnum;
  SD[sprnum].xs  = xwidth;
  SD[sprnum].ys  = yheight;
  SD[sprnum].img = CreateMemory(SD[sprnum].xs*SD[sprnum].ys);   // ׸  ޸𸮸 ȮѴ.
 
  if(imagemodesw == 1) GetImage(page0, Xold, Yold, SD[sprnum].xs, SD[sprnum].ys, SD[sprnum].img);
  if(imagemodesw == 2) GetImage(page0, Xpos, Ypos, SD[sprnum].xs, SD[sprnum].ys, SD[sprnum].img);
  if(imagemodesw == 3) GetImage(page0, Xpos, Yold, SD[sprnum].xs, SD[sprnum].ys, SD[sprnum].img);
  if(imagemodesw == 4) GetImage(page0, Xold, Ypos, SD[sprnum].xs, SD[sprnum].ys, SD[sprnum].img);
  // ׸ ִ ޸𸮿 ׸ о´. 

  sprnum++;
 }
 
 drawmodesw = 0;
}



void DelSpr(void)    // Ʈ ϳ Ѵ.
{
 sprnum--;

 SD[sprnum].num = 0;
 SD[sprnum].xs  = 0;
 SD[sprnum].ys  = 0;
 FreeMemory(SD[sprnum].img);

 delsw = 0;
}




void PutMessage(void)
{
 char i[10];

 itoa(sprnum, i, 10);                 //  Ÿ sprnum  Ÿ i ȯѴ.
 PutFont(50, 460, "Sprite Number : ", colornum);
 PutFont(178, 460, i, colornum);

 if(entersw == 0)
 {
  itoa(Xpos, i, 10);
  PutFont(276, 460, "X-Pos : ", colornum);
  PutFont(340, 460, i, colornum);

  itoa(Ypos, i, 10);
  PutFont(478, 460, "Y-Pos : ", colornum);
  PutFont(542, 460, i, colornum);
  }

 if(entersw == 1)
 {
  itoa(xwidth, i, 10);
  PutFont(276, 460, "X-Size : ", colornum);
  PutFont(348, 460, i, colornum);

  itoa(yheight, i, 10);
  PutFont(478, 460, "Y-Size : ", colornum);
  PutFont(550, 460, i, colornum);
  }

}



void ProcessPart(HWND hwnd)     
{
  page1 = BBPointer();

  ActivePage(page1);
  ClearPage(0);
  CopyPage(page0, page1);

  if(entersw == 1) DrawBox();

  if(drawmodesw == 1 && entersw == 0) SaveSpr();

  if(delsw == 1) DelSpr();

  PutMessage();

  PutCross(Xpos, Ypos);

  ViewScreen();
  
}


void InitMain(LPSTR twofilename)     // Ҷ ڸ о´.
{
 int fsw = 0;
 int fc  = 0;

 // ӵ ΰ ȭ ̸  ȭ ̸ .
 for(int i=0; i<50; i++)                       
 {
	if(fsw == 0) 
	{
		filename1[fc++] = *(twofilename++); // ó ѹھ filename1 Ѵ. 
		if(*twofilename == ' ')             // ' '(space)  ...
		{
			fsw = 1;						 
			filename1[fc] = '\0';           // 迭  '\0' Ѵ. 
			fc = 0;
		}
	}

	if(fsw == 1) 
	{
		filename2[fc++] = *(++twofilename); // filename2 ѹھ Ѵ.  
		if(*(twofilename+1) == '\0') 
		{
			filename2[fc] = '\0';
			goto end;
		}
	}

 }

 end:
 ;


 page0 = CreateMemory(640*480);     // page0 ޸ Ȯ.
 page1 = CreateMemory(640*480);     // page1 ޸ Ȯ.

 strcpy(filename, filename1);       //  ȭ ȭϸ filename Ѵ.
 if(!strstr(filename, ".")) strcat(filename, ".PCX");  // PCX Է ȭϿ Ȯڰ 
                                                       // Ȯڸ δ.
 if( !LoadPcx(page0, filename, pal) )                  // pcxȭ д´.
 {
	MessageBox(NULL, M_SAVEMESSAGE, "(FALE)", MB_OK);
	PostQuitMessage(0);
 }

 SetPalette(pal);

}



void CloseMain()
{

 strcpy(filename, filename2);         //  ȭ ȭϸ filename Ѵ.
 if(!strstr(filename, ".")) strcat(filename, ".SPR"); //  ȭϿ Ȯڰ 
                                                      // Ȯڸ δ.
 if(sprnum != 0)
 {
  if((fp = fopen(filename, "wb")) == NULL)        //  ȭ .
  {
	sprintf(M_SAVEMESSAGE, ".SPR ȭ   ϴ...^^");
	MessageBox(NULL, M_SAVEMESSAGE, "(FALE)", MB_OK);
	PostQuitMessage(0);
  }
  
  fwrite(SpriteID, 33, 1, fp); // ȭ (fp) 33Ʈŭ Ѵ.(SpriteID write)
  fwrite(pal, 768, 1, fp);     // ȭ (fp) 768Ʈŭ Ѵ.(Palette write)

  for(int i=0; i<sprnum; i++)
  {
   fwrite(&SD[i].num, 4, 1, fp);           //  ȭ Ϳ Ʈ ȣ .
   fwrite(&SD[i].xs,  4, 1, fp);           // ׸  .
   fwrite(&SD[i].ys,  4, 1, fp);           // ׸ ̸ .
   fwrite(SD[i].img, SD[i].xs*SD[i].ys, 1, fp);  // ׸ Ÿ .
   FreeMemory(SD[i].img);                   // ޸ 
  }

  fwrite(&sprnum, 4, 1, fp);  // ȭ  ü Ʈ  .
  fclose(fp);                         // ȭ ݴ´.
 }

 
FreeMemory(page0);
FreeMemory(page1);


 if(sprnum != 0)
 {
	 wsprintf(M_SAVEMESSAGE, "%s ȭ ϴ...^^;", filename);
 }
 else 
 {
	 sprintf(M_SAVEMESSAGE, "Ʈ(Sprite) ȭ  ʾҽϴ...^^;");
 }

 MessageBox(NULL, M_SAVEMESSAGE, " ȭ(RESULT)", MB_OK);

}






int     ActiveSW = TRUE;

long FAR PASCAL WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{

    switch(message)
    {
        case WM_ACTIVATEAPP :
            ActiveSW = wParam;
            SetCursor(NULL);
            break;

        case WM_DESTROY :
            PostQuitMessage(0);
            break;

		case WM_KEYDOWN:
			switch(wParam)
			{
 			case VK_ESCAPE:
				int value;
				value = MessageBox(NULL, "α׷ Ͻðڽϱ ?", "(QUIT)", MB_YESNO);
                if(value == IDYES) PostQuitMessage(0);
				  else break;
                break;

			case VK_F1:
				wsprintf(M_SAVEMESSAGE, 
					     "  Ʈ %d Դϴ.\n\n%d ~ %d...", 
						 sprnum, 0, sprnum-1);
				MessageBox(NULL, M_SAVEMESSAGE, " (SAVE INFO)", MB_OK);
				break;

			case VK_UP:
				if(Ypos > 0) Ypos--;
				break;
			case VK_DOWN:
				if(Ypos < 479) Ypos++;
				break;
			case VK_RIGHT:
				if(Xpos < 639) Xpos++;
				break;
			case VK_LEFT:
				if(Xpos > 0) Xpos--;
				break;

			case VK_RETURN:
				if(drawmodesw == 0)
				{
					Xold = Xpos;
					Yold = Ypos;
				}
				entersw = !entersw;
				drawmodesw = 1;
				break;

			case VK_SPACE:
				colornum++;
				if(colornum > 15) colornum = 0;
				break;

			}
			break;

        case WM_MOUSEMOVE:
			Xpos = LOWORD(lParam);
			Ypos = HIWORD(lParam);
			break;

		case WM_LBUTTONDOWN:
			if(drawmodesw == 0)
			{
				Xold = Xpos;
				Yold = Ypos;
			}
			entersw = !entersw;
			drawmodesw = 1;
            break;

		case WM_RBUTTONDOWN:
			if(sprnum > 0) 
			{
				int value;
				wsprintf(M_SAVEMESSAGE, 
				"Ʈ ȣ : %d \n\n\nϽðڽϱ ?",
				sprnum-1);
				value = MessageBox(NULL, M_SAVEMESSAGE, "(DELETE)", MB_YESNO);
				if(value == IDYES) delsw = 1;
			}
			else 
			{
			    MessageBox(NULL, " Ʈ ϴ...^^;", "(DELETE)", MB_OK);
			    break;    
			}
            break;

		case WM_ERASEBKGND:
			return TRUE;
    
    }

    return  DefWindowProc(hwnd, message, wParam, lParam);
}




int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HWND	    hwnd; 
	WNDCLASS    wc;

	wc.lpszClassName = "PCX2SPR";
	wc.hInstance     = hInstance;
	wc.lpfnWndProc   = WindowProc;
    wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.cbClsExtra    = 0; 
	wc.cbWndExtra    = 0; 
	wc.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor       = NULL; 
	wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
	
    RegisterClass(&wc);

    hwnd = CreateWindow( "PCX2SPR",
		                 "PCX2SPR",
						 WS_POPUP,
						 0,
						 0,
				         GetSystemMetrics(SM_CXSCREEN), //  640,
						 GetSystemMetrics(SM_CYSCREEN), //  480 , 
						 NULL, 
						 NULL, 
						 hInstance, 
						 NULL );

    ShowWindow(hwnd,nCmdShow);
    UpdateWindow(hwnd);


	InitWinKGL( hwnd );   // WinKGL ʱȭ

	LoadFont("han.fnt", "eng.fnt");

	InitMain(lpCmdLine);           

	int loop = 1;
	
    while(loop) 
	{
        while( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) !=0 ) 
		{
            if( GetMessage( &msg, NULL, 0, 0) == 0 )   loop = 0;
                
			TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        
		if (ActiveSW == TRUE)   
		{
			ProcessPart( hwnd );
		}
    }

    
	CloseMain();

	CloseWinKGL();     // WinKGL 

    return msg.wParam;
}
