
#include    "snake.h"


//////////////////////////////////////
// μ  ڵ ʿϴ..
//////////////////////////////////////

void InitSnake(HWND hwnd)
{
	M_FULLSCREEN = FALSE;
	InitWinKGL( hwnd );    // ʱȭ 


	page0 = CreateMemory(640*480);   // ۾ ޸ 


	// ⺻ Ʈ ε
	wallsprnum = LoadSpr(Wall, "wall.spr", Pal);
	eatsprnum  = LoadSpr( Eat,  "eat.spr", Pal);
	headsprnum = LoadSpr(Head, "head.spr", Pal);
	tailsprnum = LoadSpr(Tail, "tail.spr", Pal);
	itemsprnum = LoadSpr(Item, "item.spr", Pal);

	menusprnum = LoadSpr(Menu, "menu.spr", Pal);
	
	// ȷƮ 
	SetPalette(Pal);

	// Ʈ ε
	LoadFont("han.fnt", "eng.fnt");
	

	ID_CHECKSTAGE = ID_TOPMENU;    //  
	ID_COUNTSTART = FALSE;         // ð īƮ  


}

	




void CloseSnake(void)
{

	FreeMemory(page0);

    FreeSpr(Wall, wallsprnum);
    FreeSpr( Eat, eatsprnum);
    FreeSpr(Head, headsprnum);
    FreeSpr(Tail, tailsprnum);
    FreeSpr(Item, itemsprnum);

	FreeSpr(Menu, menusprnum);

	CloseWinKGL();

}



//  ޴ 
void TopMenu(void)
{
	static int tempstage;
	static int colorsw = 255;

    page0 = BBPointer();         // ۾  
	ActivePage(page0);           // Ȱ ޸   
	ClearPage(0);                // ޸ Ŭ 

	PutSpr(150, 100, &Menu[0], ID_N);

	for(int i=0; i<3; i++)
	{
		PutFont(260, i*70 + 170, TopMenuText[i], 0);
	}

	PutSpr(200, ID_TOPMENUSW*70 + 150, &Menu[1], ID_S);

	PutFont(260, ID_TOPMENUSW*70 + 170, TopMenuText[ID_TOPMENUSW], colorsw);

	if(FrameSkip(100, 16))
	{
		colorsw++;
		if(colorsw > 127) colorsw = 112;
	}


	if(ID_TOPMENUSW == 0) tempstage = ID_SINGLEGAME;
	if(ID_TOPMENUSW == 1) tempstage = ID_DOUBLEGAME;
	if(ID_TOPMENUSW == 2) tempstage = ID_ENDGAME;


	if(ID_RETURN == TRUE)
	{
		// ȭ ο
		ID_SCREENFADE = ID_FADEOUT;
		if(ID_SCREENFADE == ID_FADEOUT) 
		{
			if(ScreenFadeOut()) 
			{
				ID_SCREENFADE = ID_FADENOR;
				ID_CHECKSTAGE = tempstage;
				ID_RETURN = FALSE;
				ID_FADESW = FALSE;
				ID_NEWGAME = TRUE;
				ID_TOPMENUSW = 0;
				ID_SUBMENU = TRUE;
				ID_STAGERUN = FALSE;
			}
		}
	}


	// ȭ 
	if(ID_FADESW == FALSE)
	{
		ID_SCREENFADE = ID_FADEIN;
		if(ID_SCREENFADE == ID_FADEIN)
		{
			if(ScreenFadeIn()) 
			{
				ID_SCREENFADE = ID_FADENOR;
				ID_FADESW = TRUE;
			}
		}
	}


	
	
	ViewScreen();

}



void SubMenu(void)
{
	static int key;
	static int colorsw = 255;

	if(ID_KEYSW == ID_UP)   key = 0;
	if(ID_KEYSW == ID_DOWN) key = 1;

	PutSpr(280, key*50 + 170, &Menu[1], ID_S);

	PutFont(340, key*50 + 190, SubMenuText[key], colorsw);

	if(FrameSkip(100, 16))
	{
		colorsw++;
		if(colorsw > 127) colorsw = 112;
	}

	if(ID_RETURN == TRUE)
	{
		if(key == 0) 
		{
			ID_STAGERUN = TRUE;
			ID_COUNTSTART = TRUE;
		}
		if(key == 1) 
		{
			ID_SCREENFADE = ID_FADEOUT;
			ID_NEXTSTAGE = ID_TOPMENU;
		}
		
		ID_RETURN = FALSE;
		ID_SUBMENU = FALSE;
	}

}



//   Ʈ 
void ItemDraw(void)
{
	PutSpr(10, 10, &Item[0], ID_N);
}



//    
void TextDraw(void)
{
	for(int i=0; i<3; i++)
	{
		PutFont(40, i*70 + 100, ItemText[i], 0);  // ', ð,..'  
	}

	for(int j=0; j<3; j++)
	{
		PutFont(110, j*70 + 130, ItemText[j+3], 0);  // ', ,..'  
	}

}



// ð, ,  Ǽ 
void CountDraw(void)
{
	char i[10];

	//  
	itoa(ID_SCORE, i, 10);
	PutFont(70, 130, i, 2);

	// ð 
	itoa(ID_TIMECOUNT, i, 10);
	PutFont(70, 200, i, 1);

	//  Ǽ 
	itoa(ID_SNAKENUM, i, 10);
	PutFont(80, 270, i, 4);


}




//  Ʈ ⷰ
void WallDraw(void)
{

	for(int i=0; i<MAXWALL; i++)
	{
		PutSpr(WallInfo[i].ID_X, WallInfo[i].ID_Y, &Wall[0], ID_N); // up   wall
	}


	// ȭ鿡  Ʈ ׸(, ð...)
	ItemDraw();

	// ð, ... ۾ 
	TextDraw();

	// ð, ... 
	CountDraw();

}




BOOL SnakeEat(void)
{
	EatInfo.ID_X = rand()%450 + 170;
	EatInfo.ID_Y = rand()%450 +  10;

	// 2ο 
	if(ID_CHECKSTAGE == ID_DOUBLEGAME)
	{
		// ̿    üũ 
		for(int i=0; i<ID_DTAILNUM; i++)
		{
			if( (EatInfo.ID_X < DarkTail[i].ID_X+10) && (DarkTail[i].ID_X < EatInfo.ID_X+10)
			 && (EatInfo.ID_Y < DarkTail[i].ID_Y+10) && (DarkTail[i].ID_Y < EatInfo.ID_Y+10) )
			{
				ID_EATSW = FALSE;
		 	 
				return FALSE;
			}
		}

	}



	// ̿   üũ 
	for(int i=0; i<ID_TAILNUM; i++)
	{
		if( (EatInfo.ID_X < TailInfo[i].ID_X+10) && (TailInfo[i].ID_X < EatInfo.ID_X+10)
         && (EatInfo.ID_Y < TailInfo[i].ID_Y+10) && (TailInfo[i].ID_Y < EatInfo.ID_Y+10) )
		{
			ID_EATSW = FALSE;
		 	 
			return FALSE;
		}
	}

	// ̿  üũ 
	for(int j=0; j<MAXWALL; j++)
	{
		if( (EatInfo.ID_X < WallInfo[j].ID_X+10) && (WallInfo[j].ID_X < EatInfo.ID_X+10)
			&& (EatInfo.ID_Y < WallInfo[j].ID_Y+10) && (WallInfo[j].ID_Y < EatInfo.ID_Y+10) )
		{
			ID_EATSW = FALSE;

			return FALSE;
		}
	}


	ID_EATSW = TRUE;

	return TRUE;
}




void SnakeMove(int key)
{
	for(int i=1; i<ID_TAILNUM; i++)
	{
		TailInfo[ID_TAILNUM-i].ID_X = TailInfo[ID_TAILNUM-(i+1)].ID_X;
		TailInfo[ID_TAILNUM-i].ID_Y = TailInfo[ID_TAILNUM-(i+1)].ID_Y;
		TailInfo[ID_TAILNUM-i].ID_DIRECTION = 
			                  TailInfo[ID_TAILNUM-(i+1)].ID_DIRECTION;
	}

	TailInfo[0].ID_X = HeadInfo.ID_X;
	TailInfo[0].ID_Y = HeadInfo.ID_Y;
	TailInfo[0].ID_DIRECTION = HeadInfo.ID_DIRECTION;

	
	switch(key)
	{
	case ID_UP:
			
		HeadInfo.ID_X = HeadInfo.ID_X;
		HeadInfo.ID_Y = HeadInfo.ID_Y - 10;
		HeadInfo.ID_DIRECTION = ID_UP;

		break;

	case ID_DOWN:
				
		HeadInfo.ID_X = HeadInfo.ID_X;
		HeadInfo.ID_Y = HeadInfo.ID_Y + 10;
		HeadInfo.ID_DIRECTION = ID_DOWN;

		break;

	case ID_RIGHT:
				
		HeadInfo.ID_X = HeadInfo.ID_X + 10;
		HeadInfo.ID_Y = HeadInfo.ID_Y;
		HeadInfo.ID_DIRECTION = ID_RIGHT;

		break;

	case ID_LEFT:
				
		HeadInfo.ID_X = HeadInfo.ID_X - 10;
		HeadInfo.ID_Y = HeadInfo.ID_Y;
		HeadInfo.ID_DIRECTION = ID_LEFT;

		break;

	}

}




BOOL SnakeCheck(void)
{
	if(ID_CHECKSTAGE == ID_DOUBLEGAME)
	{
		// Ӹ    üũ 
		for(int m=0; m<ID_TAILNUM; m++)
		{
			if( (HeadInfo.ID_X < DarkTail[m].ID_X+10) && (DarkTail[m].ID_X < HeadInfo.ID_X+10)
			 && (HeadInfo.ID_Y < DarkTail[m].ID_Y+10) && (DarkTail[m].ID_Y < HeadInfo.ID_Y+10) )
			{
				ID_SCORE -= 100;
	//			ID_SNAKENUM--;

				return FALSE;
			}
		}
	}


	// Ӹ  üũ 
	for(int j=0; j<MAXWALL; j++)
	{
		if( (HeadInfo.ID_X < WallInfo[j].ID_X+10) && (WallInfo[j].ID_X < HeadInfo.ID_X+10)
			&& (HeadInfo.ID_Y < WallInfo[j].ID_Y+10) && (WallInfo[j].ID_Y < HeadInfo.ID_Y+10) )
		{ 
			ID_SCORE -= 100;
//			ID_SNAKENUM--;

			return FALSE;
		}
	}


	// Ӹ   üũ 
	for(int i=0; i<ID_TAILNUM; i++)
	{
		if( (HeadInfo.ID_X < TailInfo[i].ID_X+10) && (TailInfo[i].ID_X < HeadInfo.ID_X+10)
         && (HeadInfo.ID_Y < TailInfo[i].ID_Y+10) && (TailInfo[i].ID_Y < HeadInfo.ID_Y+10) )
		{
			ID_SCORE -= 100;
			ID_SNAKENUM--;

			return FALSE;
		}
	}


	// Ӹ  üũ 
	if( (HeadInfo.ID_X < EatInfo.ID_X+10) && (EatInfo.ID_X < HeadInfo.ID_X+10)
        && (HeadInfo.ID_Y < EatInfo.ID_Y+10) && (EatInfo.ID_Y < HeadInfo.ID_Y+10) )
	{
		ID_EATSW = FALSE;
		ID_TAILNUM += 5;
		ID_SCORE += 50;

		return TRUE;
	}

	//  Ӹ Ӹ üũ 
	if( (HeadInfo.ID_X < DarkHead.ID_X+10) && (DarkHead.ID_X < HeadInfo.ID_X+10)
        && (HeadInfo.ID_Y < DarkHead.ID_Y+10) && (DarkHead.ID_Y < HeadInfo.ID_Y+10) )
	{
		//
		// º....
		//

		return TRUE;
	}

	

	return TRUE;
}



void InitDSnake(void)
{
	ID_DTAILNUM = 10;            // ⺻  
	ID_DSCORE = 0;		         //  
	ID_DSNAKENUM = 2;		     //   
	ID_DKEYSW = ID_RIGHT;        // ⺻  

	// Ӹ ʱȭ 
	DarkHead.ID_X = 320;
	DarkHead.ID_Y = 70;
	DarkHead.ID_DIRECTION = ID_RIGHT;

	for(int a=0; a<ID_DTAILNUM; a++)
	{
		DarkTail[a].ID_X = 310 - a*10;
		DarkTail[a].ID_Y = 70;
		DarkTail[a].ID_DIRECTION = ID_RIGHT;
	}

	//  迭  κ '0' ʱȭ
	for(int b=ID_DTAILNUM; b<MAXTAIL-ID_DTAILNUM; b++)
	{
		DarkTail[b].ID_X = 0;
		DarkTail[b].ID_Y = 0;
		DarkTail[b].ID_DIRECTION = 0;
	}

}





void DSnakeMove(int key)
{
	for(int i=1; i<ID_DTAILNUM; i++)
	{
		DarkTail[ID_DTAILNUM-i].ID_X = DarkTail[ID_DTAILNUM-(i+1)].ID_X;
		DarkTail[ID_DTAILNUM-i].ID_Y = DarkTail[ID_DTAILNUM-(i+1)].ID_Y;
		DarkTail[ID_DTAILNUM-i].ID_DIRECTION = 
			                  DarkTail[ID_DTAILNUM-(i+1)].ID_DIRECTION;
	}

	DarkTail[0].ID_X = DarkHead.ID_X;
	DarkTail[0].ID_Y = DarkHead.ID_Y;
	DarkTail[0].ID_DIRECTION = DarkHead.ID_DIRECTION;

	
	switch(key)
	{
	case ID_UP:
			
		DarkHead.ID_X = DarkHead.ID_X;
		DarkHead.ID_Y = DarkHead.ID_Y - 10;
		DarkHead.ID_DIRECTION = ID_UP;

		break;

	case ID_DOWN:
				
		DarkHead.ID_X = DarkHead.ID_X;
		DarkHead.ID_Y = DarkHead.ID_Y + 10;
		DarkHead.ID_DIRECTION = ID_DOWN;

		break;

	case ID_RIGHT:
				
		DarkHead.ID_X = DarkHead.ID_X + 10;
		DarkHead.ID_Y = DarkHead.ID_Y;
		DarkHead.ID_DIRECTION = ID_RIGHT;

		break;

	case ID_LEFT:
				
		DarkHead.ID_X = DarkHead.ID_X - 10;
		DarkHead.ID_Y = DarkHead.ID_Y;
		DarkHead.ID_DIRECTION = ID_LEFT;

		break;

	}
}




BOOL DSnakeCheck(void)
{
	// Ӹ  üũ 
	for(int j=0; j<MAXWALL; j++)
	{
		if( (DarkHead.ID_X < WallInfo[j].ID_X+10) && (WallInfo[j].ID_X < DarkHead.ID_X+10)
			&& (DarkHead.ID_Y < WallInfo[j].ID_Y+10) && (WallInfo[j].ID_Y < DarkHead.ID_Y+10) )
		{ 
//			ID_SCORE -= 100;
//			ID_SNAKENUM--;

			return FALSE;
		}
	}

	//  Ӹ   üũ 
	for(int k=0; k<ID_TAILNUM; k++)
	{
		if( (DarkHead.ID_X < TailInfo[k].ID_X+10) && (TailInfo[k].ID_X < DarkHead.ID_X+10)
         && (DarkHead.ID_Y < TailInfo[k].ID_Y+10) && (TailInfo[k].ID_Y < DarkHead.ID_Y+10) )
		{
//			ID_SCORE -= 100;
//			ID_SNAKENUM--;

			return FALSE;
		}
	}


	//  Ӹ    üũ 
	for(int i=0; i<ID_DTAILNUM; i++)
	{
		if( (DarkHead.ID_X < DarkTail[i].ID_X+10) && (DarkTail[i].ID_X < DarkHead.ID_X+10)
         && (DarkHead.ID_Y < DarkTail[i].ID_Y+10) && (DarkTail[i].ID_Y < DarkHead.ID_Y+10) )
		{
//			ID_SCORE -= 100;
//			ID_SNAKENUM--;

			return FALSE;
		}
	}


	// Ӹ  üũ 
	if( (DarkHead.ID_X < EatInfo.ID_X+10) && (EatInfo.ID_X < DarkHead.ID_X+10)
        && (DarkHead.ID_Y < EatInfo.ID_Y+10) && (EatInfo.ID_Y < DarkHead.ID_Y+10) )
	{
		ID_EATSW = FALSE;
		ID_DTAILNUM += 5;
//		ID_SCORE += 50;

		return TRUE;
	}
	     
	
	return TRUE;
}




// 01 ʱȭ 
void InitStage01(void)
{	

	if(ID_NEWGAME == TRUE)
	{
		ID_SCORE = 0;		         //  
		ID_TIMECOUNT = 0;			 // ð 
		ID_SNAKENUM = 2;		     //   
		ID_SCREENFADE = ID_FADEIN;	 // ȭ ̵  
		ID_RETURN = FALSE;			 //   
	}

	ID_KEYSW = ID_LEFT;          // ⺻  
	ID_TAILNUM = 10;             // ⺻  
	ID_SPEED = 10;               //  ӵ 


	// Ӹ ʱȭ 
	HeadInfo.ID_X = 470;
	HeadInfo.ID_Y = 400;
	HeadInfo.ID_DIRECTION = ID_LEFT;

	//  ʱȭ 
	for(int i=0; i<ID_TAILNUM; i++)
	{
		TailInfo[i].ID_X = 480 + i*10;
		TailInfo[i].ID_Y = 400;
		TailInfo[i].ID_DIRECTION = ID_LEFT;
	}

	//  迭  κ '0' ʱȭ
	for(int k=ID_TAILNUM; k<MAXTAIL-ID_TAILNUM; k++)
	{
		TailInfo[k].ID_X = 0;
		TailInfo[k].ID_Y = 0;
		TailInfo[k].ID_DIRECTION = 0;
	}


	//  ʱȭ 
//	ID_EATSW = FALSE;


	//  ʱȭ 
	for(int m=0; m<WALLUP; m++)  
	{
		WallInfo[m].ID_X = m*10 + 170; 
		WallInfo[m].ID_Y =   10; 
	}

	for(int n=0; n<WALLRIGHT; n++)  
	{
		WallInfo[WALLUP+n].ID_X =  620; 
		WallInfo[WALLUP+n].ID_Y = n*10 + 10; 
	}

	for(int a=0; a<WALLDOWN; a++)  
	{
		WallInfo[WALLUP+WALLRIGHT+a].ID_X = a*10 + 180; 
		WallInfo[WALLUP+WALLRIGHT+a].ID_Y = 460; 
	}

	for(int b=0; b<WALLLEFT; b++)  
	{
		WallInfo[WALLUP+WALLRIGHT+WALLDOWN+b].ID_X =  170; 
		WallInfo[WALLUP+WALLRIGHT+WALLDOWN+b].ID_Y = b*10 + 20; 
	}
	

}





///////////////////
//  01
///////////////////
void Stage01( void )
{
	// 01 ʱȭ 
	if(ID_NEWGAME == TRUE) 
	{ 
		InitStage01(); 
		ID_NEWGAME = FALSE; 

		// 2ο 
		InitDSnake();
	}

    LPBYTE page0 = BBPointer();  // ۾  
	ActivePage(page0);           // Ȱ ޸   
	ClearPage(0);                // ޸ Ŭ 


	//  Ʈ 
    WallDraw();      

	//  ޴
	if(ID_SUBMENU == TRUE) 
	{
		SubMenu();
	}
	

	//    ʴ´.
	if(ID_SNAKENUM >= 0 && ID_STAGERUN == TRUE) 
	{
		// 2ο üũ 
		if(ID_CHECKSTAGE == ID_DOUBLEGAME)
		{
			// 浹 üũ
			if( DSnakeCheck() ) DSnakeMove(ID_DKEYSW);   
				else InitDSnake();

			//   Ʈ 
			for(int i=0; i<ID_DTAILNUM; i++)
			{
				PutSpr(DarkTail[i].ID_X, DarkTail[i].ID_Y, 
					                &Tail[DarkTail[i].ID_DIRECTION+4], ID_S);
			}

			//  Ӹ Ʈ 
			PutSpr(DarkHead.ID_X, DarkHead.ID_Y, &Head[DarkHead.ID_DIRECTION+4], ID_S);
		}
	


		// 浹 üũ
		if( SnakeCheck() ) SnakeMove(ID_KEYSW);   
			else InitStage01();

		//  
		if(ID_EATSW == FALSE) SnakeEat();
	  
		//  Ʈ 
		if(ID_EATSW == TRUE) PutSpr(EatInfo.ID_X, EatInfo.ID_Y, &Eat[0], ID_S);

		//   Ʈ 
		for(int i=0; i<ID_TAILNUM; i++)
		{
			PutSpr(TailInfo[i].ID_X, TailInfo[i].ID_Y, 
				                &Tail[TailInfo[i].ID_DIRECTION], ID_S);
		}

		//  Ӹ Ʈ 
		PutSpr(HeadInfo.ID_X, HeadInfo.ID_Y, &Head[HeadInfo.ID_DIRECTION], ID_S);


	} // for.... 
	

	// ȭ ο
	if(ID_SCREENFADE == ID_FADEOUT) 
	{
		if(ScreenFadeOut()) 
		{
			ID_SCREENFADE = ID_FADENOR;
			ID_CHECKSTAGE = ID_NEXTSTAGE;
			ID_FADESW = FALSE;
		}
	}


	// ȭ 
	if(ID_FADESW == FALSE)
	{
		ID_SCREENFADE = ID_FADEIN;
		if(ID_SCREENFADE == ID_FADEIN)
		{
			if(ScreenFadeIn()) 
			{
				ID_SCREENFADE = ID_FADENOR;
				ID_FADESW = TRUE;
			}
		}
	}


	//   üũ
	if(ID_SNAKENUM < 0) 
	{
		ID_SCREENFADE = ID_FADEOUT;
		ID_NEXTSTAGE = ID_ENDSTAGE;
	}


	// ȭ鿡 ش
	ViewScreen();   


}



void StageEnding(void)
{
	ID_SNAKENUM = 0;

	ID_COUNTSTART = FALSE;

    LPBYTE page0 = BBPointer();  // ۾  
	ActivePage(page0);           // Ȱ ޸   
	ClearPage(0);                // ޸ Ŭ 


	//  Ʈ 
    WallDraw();      


	for(int i=0; i<7; i++)
	{
		PutFont(200, i*50 + 100, EndingText[i], 15);
	}


	
	// ȭ ο
	if(ID_RETURN == TRUE)
	{
		ID_SCREENFADE = ID_FADEOUT;
		if(ID_SCREENFADE == ID_FADEOUT) 
		{
			if(ScreenFadeOut()) 
			{
				ID_SCREENFADE = ID_FADENOR;
				ID_CHECKSTAGE = ID_TOPMENU;
				ID_RETURN = FALSE;
				ID_FADESW = FALSE;
			}
		}
	}


	// ȭ 
	if(ID_FADESW == FALSE)
	{
		ID_SCREENFADE = ID_FADEIN;
		if(ID_SCREENFADE == ID_FADEIN)
		{
			if(ScreenFadeIn()) 
			{
				ID_SCREENFADE = ID_FADENOR;
				ID_FADESW = TRUE;
			}
		}
	}




	// ȭ鿡 ش
	ViewScreen();   


}



int     ActiveFlag = TRUE;

LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{

    switch(message)
    {
		case WM_CREATE:
			//  ġ ȭ
			MoveWindow(hwnd, 100, 100, 645, 505, TRUE); 
			break;

		case WM_ACTIVATEAPP :
            ActiveFlag = wParam;
            SetCursor(NULL);
            break;

        case WM_DESTROY :
            PostQuitMessage(0);
            break;

		case WM_KEYDOWN:
			switch(ID_CHECKSTAGE)
			{
			case ID_TOPMENU:
				switch(wParam)
				{
				case VK_UP:
					if(ID_TOPMENUSW == 0) ID_TOPMENUSW = 2;
						else ID_TOPMENUSW--;
					break;

				case VK_DOWN:
					if(ID_TOPMENUSW == 2) ID_TOPMENUSW = 0;
						else ID_TOPMENUSW++;
					break;

				case VK_RETURN:
					ID_RETURN = TRUE;
					break;

				}
				break;

			case ID_ENDSTAGE:
				switch(wParam)
				{
				case VK_RETURN:
					ID_RETURN = TRUE;
					break;
				}

				break;

			default:
				switch(wParam)
				{
				case VK_RETURN:
					if(ID_SUBMENU == TRUE) ID_RETURN = TRUE;
					break;

 				case VK_ESCAPE:
			        PostQuitMessage(0);
				    break;

				case VK_UP:
					if(HeadInfo.ID_DIRECTION == ID_DOWN) break; 
					ID_KEYSW = ID_UP;
					break;

				case VK_DOWN:
					if(HeadInfo.ID_DIRECTION == ID_UP) break; 
					ID_KEYSW = ID_DOWN;
					break;

				case VK_RIGHT:
					if(HeadInfo.ID_DIRECTION == ID_LEFT) break; 
					ID_KEYSW = ID_RIGHT;
					break;

				case VK_LEFT:
					if(HeadInfo.ID_DIRECTION == ID_RIGHT) break; 
					ID_KEYSW = ID_LEFT;
					break;

				// 2ο Ű 
				case VK_W:
					if(DarkHead.ID_DIRECTION == ID_DOWN) break; 
					ID_DKEYSW = ID_UP;
					break;

				case VK_S:
					if(DarkHead.ID_DIRECTION == ID_UP) break; 
					ID_DKEYSW = ID_DOWN;
					break;

				case VK_D:
					if(DarkHead.ID_DIRECTION == ID_LEFT) break; 
					ID_DKEYSW = ID_RIGHT;
					break;

				case VK_A:
					if(DarkHead.ID_DIRECTION == ID_RIGHT) break; 
					ID_DKEYSW = ID_LEFT;
					break;
				}
				break;

			}
			break;

			
		case WM_RBUTTONDOWN:
			PostQuitMessage(0);
            break;

    }

    return  DefWindowProc(hwnd, message, wParam, lParam);
}




int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HWND	    hwnd; 
	WNDCLASS    wc;

	wc.lpszClassName = "Snake Game v1.0";
	wc.hInstance     = hInstance;
	wc.lpfnWndProc   = WindowProc;
    wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.cbClsExtra    = 0; 
	wc.cbWndExtra    = 0; 
	wc.hIcon         = LoadIcon(hInstance, "SnakeIcon"); // NULL; 
	wc.hCursor       = LoadCursor(NULL, IDC_CROSS); // NULL; 
	wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
	
    RegisterClass(&wc);

    hwnd = CreateWindow( "Snake Game v1.0",
		                 "Green Snake !",
						 WS_SYSMENU, // WS_POPUP,
						 0,
						 0,
				         645, // GetSystemMetrics(SM_CXSCREEN), 
						 505, // GetSystemMetrics(SM_CYSCREEN),  
						 NULL, 
						 NULL, 
						 hInstance, 
						 NULL );

    ShowWindow(hwnd,nCmdShow);
    UpdateWindow(hwnd);


	InitSnake(hwnd); //  ʱȭ 


    int     done = 1;

    while(done) 
	{
        while( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) !=0 ) 
		{
            if( GetMessage( &msg, NULL, 0, 0) == 0 )   done = 0;
                
			TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        
		if (ActiveFlag == TRUE)   
		{
			// ð īƮ 
			if(ID_COUNTSTART == TRUE) if(FrameSkip(99, 1)) ID_TIMECOUNT++;
		
			//  
			switch(ID_CHECKSTAGE)
			{
			case ID_TOPMENU:
				TopMenu();
				break;

			case ID_DOUBLEGAME:
			case ID_SINGLEGAME:
			case ID_STAGE01:
				if(FrameSkip(0, ID_SPEED)) Stage01();
				break;

			case ID_ENDSTAGE:
				StageEnding();
				break;

			case ID_ENDGAME:
				PostMessage(hwnd, WM_DESTROY, 0, 0);
				break;

			}
		}

    }


	CloseSnake(); //  


	return msg.wParam;
}
