#include "test.h"



/////////////////////////////////////
////////////////////////////////////////////////////
void InitTest(HWND hwnd)
{
     M_FULLSCREEN = FALSE;
	InitWinKGL( hwnd );

	sprnum = LoadSpr(Test, "data\\test.spr", Pal);

   	LoadFont("data\\han.fnt", "data\\eng.fnt");

	SetPalette(Pal);

}



void CloseTest(void)
{
	FreeSpr(Test, sprnum);

	CloseWinKGL();

}



void TextDraw(void)
{
	char i[10];

	for(int t=0; t<7; t++)
	{
		PutFont(0, t*20, Text[t], 15);
	}


	itoa(ID_TIMEFRAME, i, 10);
	PutFont(200, 100, i, 12);

	itoa(ID_SCREENFRAMECOUNT, i, 10);
	PutFont(200, 120, i, 12);

}


//////////////////////////////////////
// μ  ڵ ʿϴ..
//////////////////////////////////////
void Main( HWND hwnd )
{
	static int num;

	ActivePage(page0);
	ClearPage(ID_BKCOLORNUM);

	// ۾ .........

	TextDraw();


	if(ID_COORCHECK == ID_UP)    ID_Y-=3;
	if(ID_Y < 0) ID_Y = 0;

	if(ID_COORCHECK == ID_DOWN)  ID_Y+=3;
	if(ID_Y > 280) ID_Y = 280;
	
	if(ID_COORCHECK == ID_RIGHT) ID_X+=3;
	if(ID_X > 360) ID_X = 360;

	if(ID_COORCHECK == ID_LEFT)  ID_X-=3;
	if(ID_X < 0) ID_X = 0;
	

	for(int i=0; i<4; i++)
	{
		for(int j=0; j<4; j++)
		{
			PutSpr(i*70 + ID_X, j*50 + ID_Y, &Test[num], ID_S);
		}
	}


	if(FrameSkip(1, ID_TIMEFRAME)) num++;

	if(num > 11) num = 0;
	

	ViewScreen();


	static int old;
	old++;
	if(FrameSkip(99, 1)) 
	{
		ID_SCREENFRAMECOUNT = old;
		old = 0;
	}

}




int     ActiveFlag = TRUE;

LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch(message)
    {
		case WM_ACTIVATEAPP :
            ActiveFlag = wParam;
            SetCursor(NULL);
            break;

        case WM_DESTROY :
            PostQuitMessage(0);
            break;

		case WM_KEYDOWN:
			switch(wParam)
			{
			case VK_SPACE:
				ID_TIMEFRAME++;
				if(ID_TIMEFRAME > ID_SCREENFRAMECOUNT) ID_TIMEFRAME = 1;
				break;

			case VK_RETURN:
				ID_BKCOLORNUM++;
				if(ID_BKCOLORNUM > 15) ID_BKCOLORNUM = 0;

				break;

 			case VK_ESCAPE:
                PostQuitMessage(0);
                break;
				
			case VK_UP:
				ID_COORCHECK = ID_UP;
				break;
			case VK_DOWN:
				ID_COORCHECK = ID_DOWN;
				break;
			case VK_RIGHT:
				ID_COORCHECK = ID_RIGHT;
				break;
			case VK_LEFT:
				ID_COORCHECK = ID_LEFT;
				break;
			}
			break;

		case WM_ERASEBKGND:
			return TRUE;

    }

    return  DefWindowProc(hwnd, message, wParam, lParam);
}




int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HWND	    hwnd; 
	WNDCLASS    wc;

	wc.lpszClassName = "TEST";
	wc.hInstance     = hInstance;
	wc.lpfnWndProc   = WindowProc;
    wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.cbClsExtra    = 0; 
	wc.cbWndExtra    = 0; 
	wc.hIcon         = NULL; 
	wc.hCursor       = NULL; 
	wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
	
    RegisterClass(&wc);

    hwnd = CreateWindow( "TEST",
		                 "TEST",
						 WS_SYSMENU, 
						 0,
						 0,
				         645, //GetSystemMetrics(SM_CXSCREEN), 
						 505, //GetSystemMetrics(SM_CYSCREEN),  
						 NULL, 
						 NULL, 
						 hInstance, 
						 NULL );

    ShowWindow(hwnd,nCmdShow);
    UpdateWindow(hwnd);



	InitTest(hwnd);


    int     done = 1;

    while(done) 
	{
        while( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) !=0 ) 
		{
            if( GetMessage( &msg, NULL, 0, 0) == 0 )   done = 0;
                
			TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        
		if (ActiveFlag == TRUE)   
		{
			if(FrameSkip(0, 30)) Main( M_WINKHWND );
		}
    }


	CloseTest();


	return msg.wParam;
}

