/////////////////////////////////////////////////////////////////////////
// WINKGL.H                               KYONGEUN...
/////////////////////////////////////////////////////////////////////////

#ifndef _WINKGL_HEADER
#define _WINKGL_HEADER

//#include <afxwin.h>
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <imm.h>

// Sprite Draw mode 
#define ID_N   11			  // Normal Move
#define ID_S   22			  // Sprite Move
#define ID_BN  33             // Background Normal Move
#define ID_RS  44             // left-right change sprite out  

// Screen Size
#define ID_WINKSIZEX 640      // Screen X size
#define ID_WINKSIZEY 480      // Screen Y size 


// ۿ ޸𸮰 Ҵ Ǿִ ˻Ѵ.
#define  IsBBuff()        (BOOL)(BBuffer != NULL)	
// Ҵ  ͸ ´.
#define  BBPointer()      (LPBYTE)(BBuffer + BBImage)
//  α̸ ´.
#define  BBufferWidth()   (long)(((BITMAPINFOHEADER*) BBuffer)->biWidth)
//  α̸ ´.
#define  BBufferHeight()  (long)(-((BITMAPINFOHEADER*) BBuffer)->biHeight) 
// ÷ Ʈ ´.( )
#define  BBufferBPC()     (DWORD)(((BITMAPINFOHEADER*) BBuffer)->biBitCount)
//  ǰ ִ ȷ ּҸ ´.
#define  BBufferPalette() (PALETTEENTRY*)((LPBYTE)BBuffer + sizeof(BITMAPINFOHEADER))


////////////////////
// ⺻  Լ //
////////////////////
// ̹ ¿ ־  Ѵ.
#define SetTransColor(color)  ( M_TRANSCOLOR = (color) )

// ȭ   Ѵ.
#define  OffSet(sx, sy)       (int)( ((sy)<<8)+((sy)<<8)+((sy)<<6)+((sy)<<6)+(sx) )
// x, y Ŭ üũ Ѵ.
//  : TRUE
//  : FALSE
#define  ClipCheck(x, y) (BOOL)( ((x >= M_CLIPWINDOW.sx) && (x <= M_CLIPWINDOW.ex) && (y >= M_CLIPWINDOW.sy) && (y <= M_CLIPWINDOW.ey)) ? TRUE : FALSE )



//////////////////////
// Page  Լ //
//////////////////////
//   ۾  .
#define  ClearPage(color)  ( memset(M_SCREENPAGE, (color), ID_WINKSIZEX*ID_WINKSIZEY) )
// ۾  Ѵ.
#define  CopyPage(spage, tpage) ( memcpy(tpage, spage, ID_WINKSIZEX*ID_WINKSIZEY) )


///////////////////////////
// ⺻ ׷  Լ //
///////////////////////////
// ۾    ׸.
#define  PutPixel(x, y, color) (BOOL)( (ClipCheck(x, y)) ? *(M_SCREENPAGE + OffSet(x, y)) = (color) : FALSE )  
// ۾    ´.
#define  GetPixel(page, x, y)  (BYTE)( (ClipCheck(x, y)) ? *(page + OffSet(x, y)) : FALSE )



//////////////////////////////
// MAP ȭ ü
//////////////////////////////
typedef struct {  
    int       num;   // ȣ 
    int    sx, sy;   //  ǥ    
    int    ex, ey;   //  ǥ    
	int       att;   // Ӽ 
} MAP;

////////////////////////////
// Ʈ ü
////////////////////////////
typedef struct 
{    
   int    num;   
   int     xs;    
   int     ys;
   LPBYTE img;
}  SPRITE;

//////////////////////////////
//  ü(Clipping)
//////////////////////////////
typedef struct { 
    int sx;      
    int sy;      
    int ex;
    int ey;
    } SCREENVIEW;

extern	 LPSTR SpriteID;					   	    // .spr ȭ 
extern	 LPSTR PaletteID;					   	    // .pal ȭ 
extern	 LPSTR MapID;		    			   	    // .map ȭ 

extern   HWND			M_WINKHWND;
extern   HDC			M_WINKHDC;
extern	 HINSTANCE		M_WINKINST;

extern	 PALETTEENTRY   *M_SCREENPAL;			    //  ȷƮ
extern	 SCREENVIEW		M_CLIPWINDOW;		        //  Ŭ ü
extern   char			M_SAVEMESSAGE[80];		    //  ޼  迭 
extern   POINT			M_OLDIMMPOS;			    // / ڰ  ִ ġ

extern	 LPBYTE			M_SCREENPAGE;               //  ޸() 
extern	 BYTE			M_TRANSCOLOR;               // Ʈ   
extern	 int			M_OLDSCREENWIDTH;
extern	 int			M_OLDSCREENHEIGHT;
extern   BYTE           M_WINKDEFAULTPAL[768];		// ⺻ ȷƮ 迭 


/*********************************************************************************************/
//////////////////////
// ʱȭ  Լ //
//////////////////////

extern LPBYTE   BBuffer;           // ⺻ ۷ Ѵ.
extern DWORD    BBImage;		   // Ÿ  ̹ ũ⸦ Ÿ. 
extern DWORD    BBDataSize;        // ü Ÿ ũ⸦ Ÿ.
extern HPALETTE BBPalette;         // ⺻ ȷƮ ü ȴ. 

extern BOOL     M_FULLSCREEN;

BOOL InitWinKGL( HWND hwnd );   
///////////////////////////////////////////////
// ۾ ϱ ؼ  ʱȭ Ѵ.
// ޸ Ȯ  ȭ  ...
///////////////////////////////////////////////

void CloseWinKGL( void );
////////////////////////////////////
// ۾  ؼ Ѵ.
// ޸    ȯ...
////////////////////////////////////

void ViewScreen( HDC hdc = GetDC(M_WINKHWND) );
///////////////////////////////////////////
// ۿ ׷ ̹ ȭ鿡 ش.
///////////////////////////////////////////


BOOL ChangeDispMode(int ScreenWidth, int ScreenHeight);
////////////////////////////////////////////
// ȭ Display Mode  ٲپ ش.
// ScreenWidth  : ٲ ȭ  ũ 
// ScreenHeight : ٲ ȭ  ũ
//  : TRUE
//  : FALSE
////////////////////////////////////////////


void GetRealDispMode(void);
//////////////////////////////////////////////
//   ׷   ´.
//////////////////////////////////////////////




/*********************************************************************************************/
////////////////////
// ⺻  Լ //
////////////////////


void HideImmBox(void);
////////////////////////////////////////
// ȭ鿡 / ȯ ڸ .
////////////////////////////////////////

void ShowImmBox(void);
////////////////////////////////////////
// ȭ鿡 / ȯ ڸ δ.
////////////////////////////////////////



/*********************************************************************************************/
//////////////////////
// Ŭ  Լ //
//////////////////////

void SetClip(int sx, int sy, int ex, int ey);
////////////////////////////////////////////////////
// screen view size setting
////////////////////////////////////////////////////


/*********************************************************************************************/
//////////////////////
// Page  Լ //
//////////////////////

LPBYTE CreateMemory(int size);
////////////////////////////////////////////////////////////////////////////////////////////
//   ִ  ޸𸮸 .
//
// size :  ޸ ũ
//
// * ݵ ޸𸮸  ؾ Ѵ.( ex: GloablFreePtr(LPBYTE); Ǵ FreeMemory(LPBYTE);)
////////////////////////////////////////////////////////////////////////////////////////////


void FreeMemory(LPBYTE page);
///////////////////////////////////
// Ǿ ޸𸮸 Ѵ.
///////////////////////////////////

void ActivePage(LPBYTE page);
///////////////////////////////////
// ۾ ޸𸮷 Ȱȭ Ų.
///////////////////////////////////

/*********************************************************************************************/
////////////////////////
// pcx, bmp  Լ //
////////////////////////

BOOL LoadPcx(LPBYTE page, LPSTR filename, LPBYTE pal);
////////////////////////////////////////////////////////////////////
// pcx file оδ.
//
// filename : о ȭϸ.
// pal      : ȭϷκ о ȷƮ .
// page     : ۾ (page) .
// Return Value :  ==> TRUE
//                 ==> FALSE
////////////////////////////////////////////////////////////////////


BOOL LoadBmp(LPBYTE page, LPSTR filename, LPBYTE pal);
////////////////////////////////////////////////////////////////////
// bmp file оδ.
//
// filename : о ȭϸ.
// pal      : ȭϷκ о ȷƮ .
// page     : ۾ (page) .
// Return Value :  ==> TRUE
//                 ==> FALSE
////////////////////////////////////////////////////////////////////


/*********************************************************************************************/
//////////////////////
// Sprite  Լ //
//////////////////////


int LoadSpr(SPRITE *spr, LPSTR filename, LPBYTE pal);
////////////////////////////////////////////////////
// Ʈ ȭ ε Ѵ.
//
// spr    : Ʈ ü ǵ ü 
// return : Ʈ  ǵ.    
//
// * ݵ FreeLoadSpr(), FreeSpr()Լ Ἥ
//   ޸𸮸 ־ Ѵ.
////////////////////////////////////////////////////

void PutSpr(int x, int y, SPRITE *spr, int mode);
/////////////////////////////////////////////////
// Ʈ ȭ鿡 Ѵ.
//
// x, y : Ʈ µ ȭ  
// mode : PutImage()Լ mode 
// * spr   Ʈ 迭ü
//    Ѵ.
//
// ex) PutSpr(100, 200, &Spr[0], S);
/////////////////////////////////////////////////

void FreeLoadSpr(int sn, int en, SPRITE *spr);
///////////////////////////////////////////
// ε Ʈ ޸𸮸 Ѵ.
//
// sn :  Ʈ ȣ
// en :  Ʈ ȣ
///////////////////////////////////////////

void FreeSpr(SPRITE *spr, int num);
///////////////////////////////////////////
// ε Ʈ ޸𸮸 Ѵ.
//
// num : ü Ʈ 
///////////////////////////////////////////


/*********************************************************************************************/

BOOL LoadPal(LPBYTE pal, LPSTR filename);
//////////////////////////////////////////
// ȷƮ ȭϿ о´.
// 
//  pal : о  ȷƮ  
//////////////////////////////////////////


/*********************************************************************************************/

int LoadMap(MAP *map, LPSTR filename);
//////////////////////////////////////////
// ȷƮ ȭϿ о´.
// 
// map :  ü  
//////////////////////////////////////////


/*********************************************************************************************/
///////////////////////////
// ⺻ ׷  Լ //
///////////////////////////


void PutWLine(int x, int y, int w, BYTE color);
///////////////////////////////////////////////
//   ׸.
// x, y :  .
// w    :  .
///////////////////////////////////////////////

void PutHLine(int x, int y, int h, BYTE color);
///////////////////////////////////////////////
//   ׸
///////////////////////////////////////////////

void PutBox(int x, int y, int w, int h, BYTE color);
//////////////////////////////////
//  ׸
// w :  
// h :  
//////////////////////////////////


void GetImage(LPBYTE page, int x, int y, int w, int h, LPBYTE image);
/////////////////////////////////////////////////////////////////////////
// page  : ۾  ޸.
// x, y  :  ̹  .
// w, h  :  ̹ ũ(, )
// image : ̹  ޸( CreateMemory() ޸𸮸 ȮѴ.)
/////////////////////////////////////////////////////////////////////////

void PutImage(int x, int y, int w, int h, LPBYTE image, int mode);
////////////////////////////////////////////////////////////////////
//  ۾ ؿ ̹ ׸.
// x, y  : ̹ ׷   .
// w, h  : ̹ ,  ũ.
// image : ̹ ִ ޸.
// mode  : ID_N  ==> ̹  ó ʰ ׳ ׸.
//         ID_S  ==> ̹  óϿ Ʈ Ѵ.
//         ID_BN ==> ̹  ȭϰ ޷θ  ѹ ȭⷰѴ.
//         ID_RS ==> ̹ ¿ ٲپ Ʈ Ѵ.
////////////////////////////////////////////////////////////////////





/*********************************************************************************************/
//////////////////////
// ȷƮ  Լ //
//////////////////////

BOOL SetPalette( LPRGBQUAD rq );
BOOL SetPalette( PALETTEENTRY* pe );
BOOL SetPalette( LPBYTE palette );
////////////////////////////////////////////////
//   Լ ȷƮ ϴ Լ ε, 
// ޵Ǵ ڿ  Լ õǾ 
// ȴ.
////////////////////////////////////////////////

HPALETTE Create256Palette( PALETTEENTRY *Palentry );
/////////////////////////////////////////////
// ȷƮ ϵ Ѵ.
/////////////////////////////////////////////


BOOL FreePalette(void);
////////////////////////////////////////////
//  ȷƮ ý ȷƮ ǵ.
////////////////////////////////////////////


/*********************************************************************************************/
////////////////////
// ȿ  Լ //
////////////////////

static BOOL M_FADEIN;
static BOOL M_FADEOUT;
static  int M_FADEPER;

BOOL ScreenBright(int per);
///////////////////////////////////
// ȭ ⸦ Ѵ.
// per : ȭ  (0 ~ 100).
///////////////////////////////////

BOOL ScreenGray(int per = 100);


BOOL ScreenFadeIn(int step = 10);
/////////////////////////////////
// ȭ  Ӱ Ѵ.
// step :  ӵ(1 ~ 30)
// * ó  TRUE  
//   ߿ FALSE ǵ.
/////////////////////////////////

BOOL ScreenFadeOut(int step = 10);


/*********************************************************************************************/
//////////////////////
// Ÿ̸  Լ //
//////////////////////

#define		MAX_TIME_COUNT		100 

static long M_THISTIME[MAX_TIME_COUNT];   //  ð Ѵ.
static long M_OLDTIME[MAX_TIME_COUNT];    //   µ ð Ѵ.
static long M_FRAMEPERSEC = 0;            // ʴ   Ѵ.

long GetCurTime();
////////////////////////////
//  ð ǵ.
////////////////////////////

BOOL FrameSkip(int tm = 0, long frame = 30);
///////////////////////////////////////
//   ɶ ٸ.
// tm    : Ÿ̸ ȣ
// frame : ʴ ߻  
///////////////////////////////////////




/*********************************************************************************************/
////////////////////
// Ʈ  Լ // 
////////////////////

// ۾   
#define NOR 100   // 빮 
#define SHL 200   // ܰ 
#define CON 300   //  
#define SDW 400   // ׸ 


const BYTE TABLE[3][32] = {
    { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,    // ʼ Ʈ  ̺
     10,11,12,13,14,15,16,17,18,19, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0},

    { 0, 0, 0, 1, 2, 3, 4, 5, 0, 0, 6,    // ߼ Ʈ  ̺
      7, 8, 9,10,11, 0, 0,12,13,14,15,
     16,17, 0, 0,18,19,20,21, 0, 0},

    { 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,    //  Ʈ  ̺
     10,11,12,13,14,15,16, 0,17,18,19,
     20,21,22,23,24,25,26,27, 0, 0}
};

const BYTE FIRST_TABLE[2][20] = {
    {0, 0, 1, 1, 1, 1, 1, 1, 1, 1,      //    ,
     1, 1, 1, 1, 1, 1, 0, 1, 1, 1},     // ʼ  ߼ Ʈ 

    {0, 2, 3, 3, 3, 3, 3, 3, 3, 3,      //  Ҷ,
     3, 3, 3, 3, 3, 3, 2, 3, 3, 3}      // ʼ  ߼ Ʈ 
};

const BYTE MIDDLE_TABLE[3][22] = {
    {0, 0, 2, 0, 2, 1, 2, 1, 2, 3, 0,   // ߼   Ʈ 
     2, 1, 3, 3, 1, 2, 1, 3, 3, 1, 1},

    {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3,   //    ,
     3, 3, 1, 2, 4, 4, 4, 2, 1, 3, 0},  // ߼  ʼƮ 

    {0, 5, 5, 5, 5, 5, 5, 5, 5, 6, 7,   //  Ҷ,
     7, 7, 6, 6, 7, 7, 7, 6, 6, 7, 5}   // ߼  ʼƮ 
};


extern BYTE H_FONT1[8][20][32];    // ʼ 8 Ʈ б  迭
extern BYTE H_FONT2[4][22][32];    // ߼ 4 Ʈ б  迭
extern BYTE H_FONT3[4][28][32];    //  4 Ʈ б  迭

extern BYTE E_FONT[256][16];       //  256 Ʈ б  迭

extern BYTE HangulImage[32];       // ѱ Ʈ ¿ 迭(Ʈ Ͽ )
extern BYTE EnglishImage[16];      //  Ʈ ¿ 迭(Ʈ Ͽ )



void LoadFont(LPSTR hname, LPSTR ename);
/////////////////////////////
// ⺻ Ʈ оδ. //
/////////////////////////////

void PutFont(int x, int y, LPSTR str, int color, int mode = NOR);
/////////////////////////////
// ۾ ȭ鿡 Ѵ. //
/////////////////////////////


/*********************************************************************************************/




#endif






