///////////////////////////////////////////////////////
// VIEWSPR.CPP                              KYONGEUN //
//													 //
// ************************************************* //
// ***** VIEWSPR Utility Programe Version 0.9  ***** //
// ***** [ KyongEun-Seo ] 1997.7  ~  1998.4    ***** //
// ************************************************* //
//													 //		
// US AGE : VIEWSPR filename[.SPR]                   // 
//													 //		
//   EX) viewspr test.exm ( view to test.exm)        //
//   EX) viewspr test     ( view to test.spr)        //
//                                                   //
// Thank You !                                       //
//													 //	
///////////////////////////////////////////////////////
#include "viewspr.h"


void PutMessage(void)
{
 char i[10];

 itoa(SW, i, 10);                 //  Ÿ sprnum  Ÿ i ȯѴ.
 PutFont(50, 460, "Sprite Number : ", colornum);
 PutFont(178, 460, i, colornum);

 itoa(Spr[SW].xs, i, 10);
 PutFont(276, 460, "X-Size : ", colornum);
 PutFont(348, 460, i, colornum);

 itoa(Spr[SW].ys, i, 10);
 PutFont(478, 460, "Y-Size : ", colornum);
 PutFont(550, 460, i, colornum);

}




void Compute(void)                  // ȭ鿡 ׸ ׸ ǥ
{
 Xpos = (640-Spr[SW].xs)/2;
 Ypos = (480-Spr[SW].ys)/2;
}


void ProcessPart(HWND hwnd)
{
  ActivePage(page0);

  ClearPage(backcolor);

  if(shiftkey == TRUE) Compute();
	else Xpos = Ypos = 0;

  PutBox(0, 0, 640, 480, 15);

  PutSpr(Xpos, Ypos, &Spr[SW], spritesw);

  PutMessage();


  ViewScreen();

}


void InitMain(LPSTR onefilename)      // Ҷ ڸ о´.
{

 for(int i=0; i<50; i++)                       
 {
	filename[i] = *(onefilename++);    // ó ѹھ filename Ѵ. 
	if(*onefilename == ' ')            // ' '(space)  ...
	{
		filename[i+1] = '\0';          // 迭  '\0' Ѵ. 
		goto end;
	}
 }
 end:
 ;


 if(!strstr(filename, ".")) strcat(filename, ".spr");  //  ȭϿ Ȯڰ 
                                                       // Ȯڸ δ.

 page0 = CreateMemory(640*480);     // page0 ޸ Ȯ.


 if(!(sprnum = LoadSpr(Spr, filename, pal)) )   // Ʈ ȭ о´.
 {
	 MessageBox(NULL,  M_SAVEMESSAGE, "(FALSE)", MB_OK);
	 PostQuitMessage(0);
 }


 SetPalette(pal);
 
}



void CloseMain(void)
{
	FreeSpr(Spr, sprnum);		  // Ʈ ޸ 
	FreeMemory(page0);   		  // ޸ 
}


int     ActiveSW = TRUE;

long FAR PASCAL WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{

    switch(message)
    {
        case WM_ACTIVATEAPP :
            ActiveSW = wParam;
            SetCursor(NULL);
            break;

        case WM_DESTROY :
            PostQuitMessage(0);
            break;

		case WM_KEYDOWN:
			switch(wParam)
			{
 			case VK_ESCAPE:
				int value;
				value = MessageBox(NULL, "α׷ Ͻðڽϱ ?", "(QUIT)", MB_YESNO);
                if(value == IDYES) PostQuitMessage(0);
				  else break;
                break;

			case VK_F1:
				wsprintf(M_SAVEMESSAGE, 
				" %d Ʈ Ǿ ֽϴ.\n\nƮ ȣ : %d\n\n ũ : %d\n ũ : %d",
				sprnum, Spr[SW].num, Spr[SW].xs, Spr[SW].ys);
				MessageBox(NULL, M_SAVEMESSAGE, "Ʈ (SPRITE INFO)", MB_OK);
				break;
			
			case VK_UP:
			case VK_RIGHT:
				SW++;
				if(SW == sprnum) SW = 0;
				break;
			
			case VK_DOWN:
			case VK_LEFT:
				SW--;
				if(SW < 0) SW = sprnum-1;
				break;

			case VK_CONTROL:
				backcolor++;
				if(backcolor > 15) backcolor = 0;
				break;

			case VK_SPACE:
				colornum++;
				if(colornum > 15) colornum = 0;
				break;

			case VK_SHIFT:
				shiftkey = !shiftkey;
				break;

			case VK_RETURN:
				returnkey = !returnkey;
				if(returnkey == TRUE) spritesw = ID_S;
					else spritesw = ID_N;
				break;
			}
			break;

        case WM_MOUSEMOVE:
			break;

		case WM_LBUTTONDOWN:
			SW++;
			if(SW == sprnum) SW = 0;
            break;

		case WM_RBUTTONDOWN:
			wsprintf(M_SAVEMESSAGE, 
			" %d Ʈ Ǿ ֽϴ.\n\nƮ ȣ : %d\n\n ũ : %d\n ũ : %d",
			sprnum, Spr[SW].num, Spr[SW].xs, Spr[SW].ys);
			MessageBox(NULL, M_SAVEMESSAGE, "Ʈ (SPRITE INFO)", MB_OK);
            break;
    
    }

    return  DefWindowProc(hwnd, message, wParam, lParam);
}




int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HWND	    hwnd; 
	WNDCLASS    wc;

	wc.lpszClassName = "VIEWSPR";
	wc.hInstance     = hInstance;
	wc.lpfnWndProc   = WindowProc;
    wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.cbClsExtra    = 0; 
	wc.cbWndExtra    = 0; 
	wc.hIcon         = NULL;
	wc.hCursor       = NULL; 
	wc.hbrBackground = NULL;
    wc.lpszMenuName  = NULL;
	
    RegisterClass(&wc);

    hwnd = CreateWindow( "VIEWSPR",
		                 "VIEWSPR",
						 WS_POPUP,
						 0,
						 0,
				         GetSystemMetrics(SM_CXSCREEN), //  640,
						 GetSystemMetrics(SM_CYSCREEN), //  480 , 
						 NULL, 
						 NULL, 
						 hInstance, 
						 NULL );

    ShowWindow(hwnd,nCmdShow);
    UpdateWindow(hwnd);

	InitWinKGL( hwnd );   // WinKGL ʱȭ

	LoadFont("han.fnt", "eng.fnt");

	InitMain(lpCmdLine);

	int loop = 1;
	
    while(loop) 
	{
        while( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) !=0 ) 
		{
            if( GetMessage( &msg, NULL, 0, 0) == 0 )   loop = 0;
                
			TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        
		if (ActiveSW == TRUE)   
		{
			ProcessPart( hwnd );
		}
    }

    
	CloseMain();

	CloseWinKGL();     // WinKGL 

    return msg.wParam;
}
