#include    "winkml.h"


LRESULT CALLBACK WindowProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch(message)
    {
		case WM_DESTROY :
            PostQuitMessage(0);
            break;

		case WM_KEYDOWN:
			switch(wParam)
			{
 			case VK_ESCAPE:
                PostQuitMessage(0);
                break;

			case VK_SPACE:
				StartAvi(0);
				break;

			case VK_F1:
				PlayAvi(hwnd, 0, "test0.avi");
				break;

			case VK_F5:
				PlayCD();
				break;
			case VK_F6:
				NextCD();
				break;
			case VK_F7:
				PreCD();
				break;
			case VK_F8:
				StopCD();
				break;

			case VK_UP:
				SetVolume(ID_CD_VOLUME, ID_ADD_VOLUME);
				break;
			case VK_DOWN:
				SetVolume(ID_CD_VOLUME, ID_SUB_VOLUME);
				break;
			case VK_RIGHT:
			case VK_LEFT:
				MuteVolume(ID_CD_VOLUME);
				break;
			}
			break;
	}

    return  DefWindowProc(hwnd, message, wParam, lParam);
}




int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HWND	    hwnd; 
	WNDCLASS    wc;

	wc.lpszClassName = "WINKML";
	wc.hInstance     = hInstance;
	wc.lpfnWndProc   = WindowProc;
    wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.cbClsExtra    = 0; 
	wc.cbWndExtra    = 0; 
	wc.hIcon         = NULL; 
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW); 
	wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName  = NULL;
	
    RegisterClass(&wc);

    hwnd = CreateWindowEx(WS_EX_TOPMOST, 
						  "WINKML",
		                  "WINKML",
						  WS_OVERLAPPEDWINDOW, //WS_SYSMENU,
						  0,
						  0,
				          645, //GetSystemMetrics(SM_CXSCREEN), 
						  505, //GetSystemMetrics(SM_CYSCREEN), 
						  NULL, 
						  NULL, 
						  hInstance, 
						  NULL );

    ShowWindow(hwnd,nCmdShow);
    UpdateWindow(hwnd);


	InitAvi();

	InitCDAudio();

       while( GetMessage( &msg, NULL, 0, 0) )
	   {
			TranslateMessage(&msg);
            DispatchMessage(&msg);
       }
    
	CloseCDAudio();
    	   
	CloseAvi();	
	   
	return msg.wParam;
}
