///////////////////////////////////////////////////////////////////
// WINKML.CPP ( TO LIBRARY )                      KYONGEUN
///////////////////////////////////////////////////////////////////

#include "winkml.h"
//////////////////////////
// winkml.cpp header file
//////////////////////////


/////////////////////////////////////
// AVI
/////////////////////////////////////
void InitAvi(void)
{
	for(int i=0; i<MAXID; i++)
	{
		MciAnimOpenParms[i].lpstrDeviceType = "AVIVideo";
	}
}                  


void CloseAvi(void)
{
	for(int i=0; i<MAXID; i++)
	{
		//mci  ݴ´.
		mciSendCommand(AviDeviceID[i],MCI_CLOSE,0,NULL);
	}
}


BOOL PlayAvi(HWND hwnd, int idnum, LPSTR filename, int xs, int ys)
{	
	StartAvi(idnum);

    AddAviIDNum(idnum);

    MciWindowParms.hWnd = hwnd; // NULL;

    MciAnimOpenParms[idnum].lpstrElementName = filename;

    mciSendCommand(0, MCI_OPEN, MCI_OPEN_ELEMENT, (DWORD)(LPVOID)&MciAnimOpenParms[idnum]);					

    AviDeviceID[idnum] = MciAnimOpenParms[idnum].wDeviceID;

    MciRectParms.rc.top    =  0;
    MciRectParms.rc.left   =  0;
    MciRectParms.rc.right  = xs;					
    MciRectParms.rc.bottom = ys;
    //ġ Ѵ.	
    mciSendCommand(AviDeviceID[idnum],MCI_PUT,MCI_ANIM_PUT_DESTINATION | MCI_ANIM_RECT,
				 (DWORD) (LPVOID) &MciRectParms);

    mciSendCommand(AviDeviceID[idnum],MCI_WINDOW,MCI_ANIM_WINDOW_HWND,
						 (DWORD)(LPVOID) &MciWindowParms);

    //ȭ ÷ Ѵ.
    mciSendCommand(AviDeviceID[idnum],MCI_PLAY,MCI_NOTIFY,(DWORD)(LPVOID)&MciAviPlayParms[idnum]);	
    //avi̱  ȷƮ ٽ Ȱȭ ش.
   
    mciSendCommand(AviDeviceID[idnum],MCI_REALIZE,MCI_ANIM_REALIZE_NORM,NULL);

	return TRUE;						
}				


void StopAvi(int idnum)
{
	//Ͻ 
	mciSendCommand(AviDeviceID[idnum],MCI_PAUSE,MCI_NOTIFY,
		(DWORD)(LPVOID) &MciAviPlayParms[idnum]);
}


BOOL StartAvi(int idnum)
{
	//ó .
	mciSendCommand (AviDeviceID[idnum], MCI_SEEK, MCI_SEEK_TO_START, (DWORD) (LPVOID) NULL);
	return TRUE;
}

BOOL EndAvi (int idnum)
{
	// .
	mciSendCommand (AviDeviceID[idnum], MCI_SEEK, MCI_SEEK_TO_END, (DWORD) (LPVOID) NULL);
	return TRUE;
}

void AddAviIDNum(int num)
{
	if(AviIDNum < num) AviIDNum = num;
}





/////////////////////////////////////
// CD AUDIO
/////////////////////////////////////

// CD ʱȭ 
BOOL InitCDAudio(void)
{
	MCI_PLAYANDPAUSE_SW = FALSE;

    MCI_OPEN_PARMS mciOpenParms;

    mciOpenParms.lpstrDeviceType = "cdaudio";

    MCI_CD_ERROR = mciSendCommand(NULL, MCI_OPEN, MCI_OPEN_TYPE, (DWORD)&mciOpenParms);

    if(MCI_CD_ERROR) return FALSE;
    
	MCI_CD_DEVICEID = mciOpenParms.wDeviceID;

	if(SetCDFormat()) return TRUE;

	return FALSE;
}


// CD ݴ´.
BOOL CloseCDAudio(void)
{
	if(!StopCD()) return FALSE;

    MCI_GENERIC_PARMS mciGenericParms;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_CLOSE, MCI_WAIT, (DWORD)&mciGenericParms);

    if(MCI_CD_ERROR) return FALSE;

	return TRUE;
}


// CD  Ѵ.
BOOL SetCDFormat(void)
{
    MCI_SET_PARMS mciSetParms;

    mciSetParms.dwTimeFormat = MCI_FORMAT_TMSF;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_SET, MCI_SET_TIME_FORMAT, (DWORD)&mciSetParms);

    if(MCI_CD_ERROR) return FALSE;

	return TRUE;
}


// CD 
BOOL PlayCD(void)
{
	MCI_PLAYANDPAUSE_SW = !MCI_PLAYANDPAUSE_SW;

	switch(MCI_PLAYANDPAUSE_SW)
	{
	case TRUE:
		MCI_PLAY_PARMS mciPlayParms;
	    mciPlayParms.dwCallback = NULL;  //(DWORD)hwnd;
    	MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_PLAY, MCI_NOTIFY, (DWORD)&mciPlayParms);
	    if(MCI_CD_ERROR) return FALSE;
		return TRUE;

	case FALSE:
		if(PauseCD()) return TRUE;
		return FALSE;
	}

	return TRUE;
}



//  ߰ ó ư.
BOOL StopCD(void)
{
    MCI_GENERIC_PARMS mciGenericParms;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_STOP, MCI_WAIT, (DWORD)&mciGenericParms);

    if(MCI_CD_ERROR) return FALSE;

	if(StartCD()) return TRUE;

	return FALSE;
}



//  .
BOOL PauseCD(void)
{
	MCI_PLAYANDPAUSE_SW = FALSE;

    MCI_GENERIC_PARMS mciGenericParms;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_PAUSE, MCI_WAIT, (DWORD)&mciGenericParms);

    if(MCI_CD_ERROR) return FALSE;

	if(SetCurrentCD(CurrentCD())) return TRUE;

	return FALSE;
}



// CD ó .
BOOL StartCD(void)
{
	MCI_PLAYANDPAUSE_SW = FALSE;

    MCI_SEEK_PARMS mciSeekParms;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_SEEK, MCI_SEEK_TO_START, (DWORD)&mciSeekParms);
    
	if(MCI_CD_ERROR) return FALSE;

	return TRUE;
}




// Ʈ ġ Ѵ.
BOOL SetCurrentCD(DWORD dwPos)
{
    MCI_STATUS_PARMS mciStatusParms;
    MCI_SEEK_PARMS mciSeekParms;

    mciSeekParms.dwTo = dwPos;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_SEEK, MCI_TO, (DWORD)&mciSeekParms);

    if(MCI_CD_ERROR)
    {
        mciStatusParms.dwItem = MCI_STATUS_CURRENT_TRACK;
        MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&mciStatusParms);
        if(MCI_CD_ERROR) return FALSE;
    }

	return TRUE;
}


// Ʈ 簪 ǵ.
DWORD CurrentCD(void)
{
    MCI_STATUS_PARMS mciStatusParms;

    mciStatusParms.dwItem = MCI_STATUS_POSITION;
    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&mciStatusParms);

    if(MCI_CD_ERROR) return FALSE;

    return mciStatusParms.dwReturn;
}


//  Ʈ ̵Ѵ.
DWORD NextCD(void)
{
	if(!PauseCD()) return FALSE;

    MCI_STATUS_PARMS mciStatusParms;

    mciStatusParms.dwItem = MCI_STATUS_CURRENT_TRACK;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&mciStatusParms);
    
	if(MCI_CD_ERROR) return FALSE;

    if(!SetCurrentCD(++mciStatusParms.dwReturn)) return FALSE;

	if(PlayCD()) return TRUE;

	return FALSE;
}



//  Ʈ ̵Ѵ.
DWORD PreCD(void)
{
	if(!PauseCD()) return FALSE;

    MCI_STATUS_PARMS mciStatusParms;

    mciStatusParms.dwItem = MCI_STATUS_CURRENT_TRACK;

    MCI_CD_ERROR = mciSendCommand(MCI_CD_DEVICEID, MCI_STATUS, MCI_STATUS_ITEM, (DWORD)&mciStatusParms);

    if(MCI_CD_ERROR) return FALSE;

    if(!SetCurrentCD(--mciStatusParms.dwReturn)) return FALSE;

	if(PlayCD()) return TRUE;

	return FALSE;
}





//////////////////////////////////////////
// Auxiliary Output Control
//////////////////////////////////////////
//  ̽  
void	GetVolume(int DeviceID)
{
	auxGetVolume(DeviceID, &M_AUX_VOLUME);

	M_LEFT_VOLUME  = LOWORD(M_AUX_VOLUME);
	M_RIGHT_VOLUME = HIWORD(M_AUX_VOLUME);
}


//  
void	SetVolume(int DeviceID, int mode)
{
	M_MUTE_SWITCH = FALSE;

	GetVolume(DeviceID);

	switch(mode)
	{
	case ID_ADD_VOLUME:
		M_LEFT_VOLUME  += 0x1000;
		M_RIGHT_VOLUME += 0x1000;
		break;

	case ID_SUB_VOLUME:
		M_LEFT_VOLUME  -= 0x1000;
		M_RIGHT_VOLUME -= 0x1000;
		break;
	}

	if(M_LEFT_VOLUME  < 0x1fff) M_LEFT_VOLUME  = 0x1fff;	
	if(M_LEFT_VOLUME  > 0xffff) M_LEFT_VOLUME  = 0xffff;	
	if(M_RIGHT_VOLUME < 0x1fff) M_RIGHT_VOLUME = 0x1fff;	
	if(M_RIGHT_VOLUME > 0xffff) M_RIGHT_VOLUME = 0xffff;	

	M_AUX_VOLUME = M_RIGHT_VOLUME;
	M_AUX_VOLUME = M_AUX_VOLUME << 16;
	M_AUX_VOLUME = M_AUX_VOLUME + M_LEFT_VOLUME;

	auxSetVolume(DeviceID, M_AUX_VOLUME);
}


// Ҹ ON/OFF
void MuteVolume(int DeviceID)
{
	M_MUTE_SWITCH = !M_MUTE_SWITCH;

	switch(M_MUTE_SWITCH)
	{
	case TRUE:
		GetVolume(DeviceID);
		auxSetVolume(DeviceID, 0x1fff1fff);	
		break;
	case FALSE:
		M_AUX_VOLUME = M_RIGHT_VOLUME;
		M_AUX_VOLUME = M_AUX_VOLUME << 16;
		M_AUX_VOLUME = M_AUX_VOLUME + M_LEFT_VOLUME;
		auxSetVolume(DeviceID, M_AUX_VOLUME);	
		break;
	}
}






