#ifndef _SNAKE_CPP
#define _SNAKE_CPP

#include    "snake.h"



//////////////////////////////////////
// μ  ڵ ʿϴ..
//////////////////////////////////////

void Mini_InitSnake(void)
{
	///////////// ⺻ Ʈ ε
	wallsprnum = LoadSpr(WALL, "mini1\\data1\\wall.spr", Pal);
	eatsprnum  = LoadSpr( EAT, "mini1\\data1\\eat.spr",  Pal);
	headsprnum = LoadSpr(HEAD, "mini1\\data1\\head.spr", Pal);
	tailsprnum = LoadSpr(TAIL, "mini1\\data1\\tail.spr", Pal);
	
	///////////// ȷƮ 
	SetPalette(Pal);


	/////////////  ȭ ε 
	mini_backmapnum = LoadMap(MINI_BACKMAP, "mini1\\data2\\back.map");


	M_KEYSW    = ID_LEFT;       // ⺻  
	M_TAILNUM  = 10;            // ⺻  
	M_SPEED    = 10;            //  ӵ 


	// Ӹ ʱȭ 
	COOR_HEAD.sx   = 320;
	COOR_HEAD.sy   = 200;
	COOR_HEAD.ex   = COOR_HEAD.sx + ID_HEAD_XSIZE;
	COOR_HEAD.ey   = COOR_HEAD.sy + ID_HEAD_YSIZE;
	COOR_HEAD.coor = ID_LEFT;
	COOR_HEAD.sn   = ID_LEFT_SPRNUM;
	COOR_HEAD.life = TRUE;

	//  ʱȭ 
	for(int i=0; i<M_TAILNUM; i++)
	{
		COOR_TAIL[i].sx   = COOR_HEAD.sx+ID_HEAD_XSIZE + i*ID_TAIL_XSIZE;
		COOR_TAIL[i].sy   = COOR_HEAD.sy;
		COOR_TAIL[i].ex   = COOR_TAIL[i].sx + ID_TAIL_XSIZE;
		COOR_TAIL[i].ey   = COOR_TAIL[i].sy + ID_TAIL_YSIZE;
		COOR_TAIL[i].coor = ID_LEFT;
		COOR_TAIL[i].sn   = ID_LEFT_SPRNUM;
	}

	//  迭  κ '0' ʱȭ
	for(int k=M_TAILNUM; k<MAXTAIL-M_TAILNUM; k++)
	{
		COOR_TAIL[k].sx   = 640;
		COOR_TAIL[k].sy   = 480;
		COOR_TAIL[k].ex   = COOR_TAIL[k].sx + ID_TAIL_XSIZE;
		COOR_TAIL[k].ey   = COOR_TAIL[k].sy + ID_TAIL_YSIZE;
		COOR_TAIL[k].coor = 0;
		COOR_TAIL[k].sn   = 0;
	}


	//  ʱȭ 
//	M_EATSW = FALSE;


	M_CHECK_MINIGAME = ID_MINI_PLAY;

	M_SCREEN_FADE	 = ID_FADE_IN;
}

	



//  ...
void Mini_CloseSnake(void)
{
    FreeSpr(WALL, wallsprnum);
    FreeSpr( EAT, eatsprnum);
    FreeSpr(HEAD, headsprnum);
    FreeSpr(TAIL, tailsprnum);



	M_CHECK_GAME = ID_MAIN_GAME;
}









//  浹 ˻ ...
BOOL Mini_CheckEat(void)
{
	COOR_EAT.sx = rand()%640;
	COOR_EAT.sy = rand()%480;
	COOR_EAT.ex = COOR_EAT.sx + ID_EAT_XSIZE;
	COOR_EAT.ey = COOR_EAT.sy + ID_EAT_YSIZE;

	// ̿   üũ 
	for(int i=0; i<M_TAILNUM; i++)
	{
		if( (COOR_EAT.sx < COOR_TAIL[i].ex) && (COOR_TAIL[i].sx < COOR_EAT.ex)
         && (COOR_EAT.sy < COOR_TAIL[i].ey) && (COOR_TAIL[i].sy < COOR_EAT.ey) )
		{
			M_EATSW = FALSE;
			return FALSE;
		}
	}

	//  ˻ 
	for(int j=0; j<mini_backmapnum; j++)
	{
		if( (COOR_EAT.sx < MINI_BACKMAP[j].ex) && (MINI_BACKMAP[j].sx < COOR_EAT.ex)
			&&(COOR_EAT.sy < MINI_BACKMAP[j].ey) && (MINI_BACKMAP[j].sy < COOR_EAT.ey) )
		{
			if(MINI_BACKMAP[j].att == ID_MAP_WALL)
			{
				M_EATSW = FALSE;
				return FALSE;
			}
		}
	}


	M_EATSW = TRUE;

	return TRUE;
}




//   ...
void Mini_SnakeMove(void)
{
	for(int i=1; i<M_TAILNUM; i++)
	{
		COOR_TAIL[M_TAILNUM-i].sx   = COOR_TAIL[M_TAILNUM-(i+1)].sx;
		COOR_TAIL[M_TAILNUM-i].sy   = COOR_TAIL[M_TAILNUM-(i+1)].sy;
		COOR_TAIL[M_TAILNUM-i].ex   = COOR_TAIL[M_TAILNUM-i].sx + ID_TAIL_XSIZE;
		COOR_TAIL[M_TAILNUM-i].ey   = COOR_TAIL[M_TAILNUM-i].sy + ID_TAIL_YSIZE;
		COOR_TAIL[M_TAILNUM-i].coor = COOR_TAIL[M_TAILNUM-(i+1)].coor;
		COOR_TAIL[M_TAILNUM-i].sn   = COOR_TAIL[M_TAILNUM-(i+1)].sn;
	}

	COOR_TAIL[0].sx   = COOR_HEAD.sx;
	COOR_TAIL[0].sy   = COOR_HEAD.sy;
	COOR_TAIL[0].ex   = COOR_TAIL[0].sx + ID_TAIL_XSIZE;
	COOR_TAIL[0].ey   = COOR_TAIL[0].sy + ID_TAIL_YSIZE;
	COOR_TAIL[0].coor = COOR_HEAD.coor;
	COOR_TAIL[0].sn   = COOR_HEAD.sn;

	
	switch(M_KEYSW)
	{
	case ID_UP:
		COOR_HEAD.sx   = COOR_HEAD.sx;
		COOR_HEAD.sy   = COOR_HEAD.sy - ID_SNAKE_MOVE;
		COOR_HEAD.coor = ID_UP;
		COOR_HEAD.sn   = ID_UP_SPRNUM;
		break;

	case ID_DOWN:
		COOR_HEAD.sx   = COOR_HEAD.sx;
		COOR_HEAD.sy   = COOR_HEAD.sy + ID_SNAKE_MOVE;
		COOR_HEAD.coor = ID_DOWN;
		COOR_HEAD.sn   = ID_DOWN_SPRNUM;
		break;

	case ID_RIGHT:
		COOR_HEAD.sx   = COOR_HEAD.sx + ID_SNAKE_MOVE;
		COOR_HEAD.sy   = COOR_HEAD.sy;
		COOR_HEAD.coor = ID_RIGHT;
		COOR_HEAD.sn   = ID_RIGHT_SPRNUM;
		break;

	case ID_LEFT:
		COOR_HEAD.sx   = COOR_HEAD.sx - ID_SNAKE_MOVE;
		COOR_HEAD.sy   = COOR_HEAD.sy;
		COOR_HEAD.coor = ID_LEFT;
		COOR_HEAD.sn   = ID_LEFT_SPRNUM;
		break;
	}

	COOR_HEAD.ex   = COOR_HEAD.sx + ID_HEAD_XSIZE;
	COOR_HEAD.ey   = COOR_HEAD.sy + ID_HEAD_YSIZE;


}




//  浹 ˻...
BOOL Mini_CheckSnake(void)
{
	//  ˻ 
	for(int j=0; j<mini_backmapnum; j++)
	{
		if( (COOR_HEAD.sx < MINI_BACKMAP[j].ex) && (MINI_BACKMAP[j].sx < COOR_HEAD.ex)
			&&(COOR_HEAD.sy < MINI_BACKMAP[j].ey) && (MINI_BACKMAP[j].sy < COOR_HEAD.ey) )
		{
			if(MINI_BACKMAP[j].att == ID_MAP_WALL)
			{
				COOR_HEAD.life = FALSE;
				return FALSE;
			}
		}
	}


	// Ӹ   üũ 
	for(int i=0; i<M_TAILNUM; i++)
	{
		if( (COOR_HEAD.sx < COOR_TAIL[i].ex) && (COOR_TAIL[i].sx < COOR_HEAD.ex)
		&& (COOR_HEAD.sy < COOR_TAIL[i].ey) && (COOR_TAIL[i].sy < COOR_HEAD.ey) )
		{
			COOR_HEAD.life = FALSE;

			return FALSE;
		}
	}


	// Ӹ  üũ 
	if( (COOR_HEAD.sx < COOR_EAT.ex) && (COOR_EAT.sx < COOR_HEAD.ex)
        && (COOR_HEAD.sy < COOR_EAT.ey) && (COOR_EAT.sy < COOR_HEAD.ey) )
	{
		M_EATSW = FALSE;
		M_TAILNUM += 5;

		return TRUE;
	}


	return TRUE;
}







///////////////////
//   
///////////////////
void Mini_PlaySnake( void )
{
	int i;


	ActivePage(page0);           // Ȱ ޸   
	ClearPage(0);                // ޸ Ŭ 


	/////////////////    ʴ´.
	switch(COOR_HEAD.life) 
	{
	case TRUE:
		////////////  浹 ˻ 
		if( Mini_CheckSnake() ) Mini_SnakeMove();   

		////////////  
		if(M_EATSW == FALSE) Mini_CheckEat();
	  
		/////////////  Ʈ 
		if(M_EATSW == TRUE) PutSpr(COOR_EAT.sx, COOR_EAT.sy, &EAT[0], ID_S);

		/////////////   Ʈ 
		for(i=0; i<M_TAILNUM; i++)
		{
			PutSpr(COOR_TAIL[i].sx, COOR_TAIL[i].sy, &TAIL[COOR_TAIL[i].sn], ID_S);
		}


		//////////////  Ӹ Ʈ 
		PutSpr(COOR_HEAD.sx, COOR_HEAD.sy, &HEAD[COOR_HEAD.sn], ID_S);

		break;

	case FALSE:
		M_SCREEN_FADE = ID_FADE_OUT;
		break;

	} // switch.... 
	



	switch(M_SCREEN_FADE)
	{
	case ID_FADE_OUT:			// ȭ ο
		if(ScreenFadeOut()) 
		{
			M_SCREEN_FADE = ID_FADE_IN;

			switch(COOR_HEAD.life)
			{
			case TRUE:
				break;

			case FALSE:
				M_CHECK_GAME = ID_MAIN_GAME;
				M_KEYSW      = ID_STOP;
				break;
			}
		}
		break;

	case ID_FADE_IN:			// ȭ 
		if(ScreenFadeIn()) 
		{
			M_SCREEN_FADE = ID_FADE_NOR;
		}
		break;
	}



	// ȭ鿡 ش
	ViewScreen();   

}






#endif