#ifndef _STAGEGAME_CPP
#define _STAGEGAME_CPP

#include "stagegame.h"



void Stage_InitGame(void)
{

	/////////////////////// Ʈ ε
	noasprnum   = LoadSpr(NOA,   "data1\\noa.spr",   Pal);

	mon01sprnum = LoadSpr(MON01, "data1\\mon01.spr", Pal);
	mon02sprnum = LoadSpr(MON02, "data1\\mon02.spr", Pal);
	mon03sprnum = LoadSpr(MON03, "data1\\mon03.spr", Pal);
	mon04sprnum = LoadSpr(MON04, "data1\\mon04.spr", Pal);
	mon06sprnum = LoadSpr(MON06, "data1\\mon06.spr", Pal);

	firesprnum  = LoadSpr(FIRE,  "data1\\fire.spr",  Pal);
	
	finalsprnum = LoadSpr(FINAL, "data1\\final.spr", Pal);

	itemsprnum  = LoadSpr(ITEM,  "data1\\item.spr",  Pal);

	holesprnum  = LoadSpr(HOLE,  "data1\\hole.spr",  Pal);

	numbersprnum = LoadSpr(NUMBER, "data1\\number.spr", Pal);

	noadiesprnum = LoadSpr(NOADIE, "data1\\noadie.spr", Pal);

	backsprnum  = LoadSpr(BACK,  ID_BACKSPR_FILENAME[M_STAGE_NUM],  Pal);

	SetPalette(Pal);
    



	///////////////////////  ε 
	backmapnum  = LoadMap(BACKMAP,  ID_BACKMAP_FILENAME[M_STAGE_NUM]);   //  
	loadmapnum  = LoadMap(LOADMAP,  ID_LOADMAP_FILENAME[M_STAGE_NUM]);   //  ̵ 
	soundmapnum = LoadMap(SOUNDMAP, "data2\\sound.map");                 // Ҹ  
    
	


	////////////////////////  ǥ ʱȭ 
	COOR_NOA.sx    = ID_NOA_DATA[M_STAGE_NUM][0];
	COOR_NOA.sy    = ID_NOA_DATA[M_STAGE_NUM][1];
	COOR_NOA.att   = ID_NOA_DATA[M_STAGE_NUM][2];
	COOR_NOA.ex    = COOR_NOA.sx + ID_NOA_XSIZE;
	COOR_NOA.ey    = COOR_NOA.sy + ID_NOA_YSIZE;
	COOR_NOA.sn    =                       0;
	COOR_NOA.clipx =                    TRUE;
	COOR_NOA.clipy =                    TRUE;
	COOR_NOA.coor  =                ID_RIGHT;
	COOR_NOA.move  =				   FALSE;
	COOR_NOA.life  =				    TRUE;
	COOR_NOA.step  =				       4;
	COOR_NOA.hole  =				   FALSE;



	///////////////////////// 01 ʱȭ(巳)
	for(int n=0; n<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; n++)
	{
		COOR_MON01[n].sx		= ID_MON01_DATA[M_STAGE_NUM][n][0];
		COOR_MON01[n].sy		= ID_MON01_DATA[M_STAGE_NUM][n][1];
        COOR_MON01[n].att		= ID_MON01_DATA[M_STAGE_NUM][n][2];
		COOR_MON01[n].coor		= ID_MON01_DATA[M_STAGE_NUM][n][3];	                
		COOR_MON01[n].firenum   = ID_MON01_DATA[M_STAGE_NUM][n][4];	                
		COOR_MON01[n].firecount = COOR_MON01[n].firenum;
		COOR_MON01[n].ex		= COOR_MON01[n].sx + ID_MON01_XSIZE;
		COOR_MON01[n].ey		= COOR_MON01[n].sy + ID_MON01_YSIZE;
		COOR_MON01[n].sn		=	  						  n*2;		//   ٸ Ѵ.
		COOR_MON01[n].life		= 							 TRUE;
		COOR_MON01[n].move		=							FALSE;
		COOR_MON01[n].time		=			            7 - (n+1);
		COOR_MON01[n].time2		=			                    5;
		COOR_MON01[n].count		=			                    0;
		COOR_MON01[n].count2	=			                    0;
	}


	////////////////////////  01(巳)  (̻^^;) ʱȭ 
	for(int a=0; a<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; a++)	//  01   Ѵ
	{
		for(int aa=0; aa<COOR_MON01[a].firenum; aa++)               //  Ϳ     
		{
			switch(COOR_MON01[a].coor)
			{
			case ID_RIGHT:
				COOR_FIRE[a][aa].sx    = COOR_MON01[a].sx + ID_FIRE_XSIZE;
				COOR_FIRE[a][aa].sy    = COOR_MON01[a].sy + ID_MON01_YSIZE/2;
				COOR_FIRE[a][aa].att   = IDM01_RFIRE0_SPRNUM;
				COOR_FIRE[a][aa].step  = 6; //a+1;
				break;
			case ID_LEFT:
				COOR_FIRE[a][aa].sx    = COOR_MON01[a].sx;
				COOR_FIRE[a][aa].sy    = COOR_MON01[a].sy + ID_MON01_YSIZE/2;
				COOR_FIRE[a][aa].att   = IDM01_LFIRE0_SPRNUM;
				COOR_FIRE[a][aa].step  = -6; //-(a+1);
				break;
			}

				COOR_FIRE[a][aa].ex	   = COOR_FIRE[a][aa].sx + ID_FIRE_XSIZE;
				COOR_FIRE[a][aa].ey	   = COOR_FIRE[a][aa].sy + ID_FIRE_YSIZE;
				COOR_FIRE[a][aa].life  = FALSE;
				COOR_FIRE[a][aa].coor  = COOR_MON01[a].coor;
		}

	}



	///////////////////////// 02 ʱȭ(ǳŰ) 
	for(int q=0; q<ID_STAGE_DATA[M_STAGE_NUM][ID_MON02_NUM]; q++)
	{
		COOR_MON02[q].sx    = ID_MON02_DATA[M_STAGE_NUM][q][0];
		COOR_MON02[q].sy    = ID_MON02_DATA[M_STAGE_NUM][q][1];
        COOR_MON02[q].att   = ID_MON02_DATA[M_STAGE_NUM][q][2];
		COOR_MON02[q].coor  = ID_MON02_DATA[M_STAGE_NUM][q][3];	                
		COOR_MON02[q].ex    = COOR_MON02[q].sx + ID_MON02_XSIZE;
		COOR_MON02[q].ey    = COOR_MON02[q].sy + ID_MON02_YSIZE;
		COOR_MON02[q].sn    =	  						  n*2;		//   ٸ Ѵ.
		COOR_MON02[q].life  = 							 TRUE;
		COOR_MON02[q].move  =							 TRUE;
		COOR_MON02[q].time  =                    10 - (q*2+2);
		COOR_MON02[q].step  =                             q+3;
	}



	///////////////////////// 03 ʱȭ() 
	for(int m=0; m<ID_STAGE_DATA[M_STAGE_NUM][ID_MON03_NUM]; m++)
	{
		COOR_MON03[m].sx    = ID_MON03_DATA[M_STAGE_NUM][m][0];
		COOR_MON03[m].sy    = ID_MON03_DATA[M_STAGE_NUM][m][1];
        COOR_MON03[m].att   = ID_MON03_DATA[M_STAGE_NUM][m][2];
		COOR_MON03[m].coor  = ID_MON03_DATA[M_STAGE_NUM][m][3];	                
		COOR_MON03[m].ex    = COOR_MON03[m].sx + ID_MON03_XSIZE;
		COOR_MON03[m].ey    = COOR_MON03[m].sy + ID_MON03_YSIZE;
		COOR_MON03[m].sn    =	  						  m*2;		//   ٸ Ѵ.
		COOR_MON03[m].life  = 							 TRUE;
		COOR_MON03[m].move  =							 TRUE;
		COOR_MON03[m].time  =                    10 - (m*2+2);
		COOR_MON03[m].step  =                             m+2;
	}




	///////////////////////// 04 ʱȭ() 
	for(int i=0; i<ID_STAGE_DATA[M_STAGE_NUM][ID_MON04_NUM]; i++)
	{
		COOR_MON04[i].sx    = ID_MON04_DATA[M_STAGE_NUM][i][0];
		COOR_MON04[i].sy    = ID_MON04_DATA[M_STAGE_NUM][i][1];
        COOR_MON04[i].att   = ID_MON04_DATA[M_STAGE_NUM][i][2];
		COOR_MON04[i].coor  = ID_MON04_DATA[M_STAGE_NUM][i][3];	                
		COOR_MON04[i].ex    = COOR_MON04[i].sx + ID_MON04_XSIZE;
		COOR_MON04[i].ey    = COOR_MON04[i].sy + ID_MON04_YSIZE;
		COOR_MON04[i].sn    =	  						  i*2;		//   ٸ Ѵ.
		COOR_MON04[i].life  = 							 TRUE;
		COOR_MON04[i].move  =							 TRUE;
		COOR_MON04[i].time  =                    10 - (i*2+2);
		COOR_MON04[i].step  =                             i+1;
	}




	///////////////////////// 06 ʱȭ(ĵ)
	for(int p=0; p<ID_STAGE_DATA[M_STAGE_NUM][ID_MON06_NUM]; p++)
	{
		COOR_MON06[p].sx		= ID_MON06_DATA[M_STAGE_NUM][p][0];
		COOR_MON06[p].sy		= ID_MON06_DATA[M_STAGE_NUM][p][1];
        COOR_MON06[p].att		= ID_MON06_DATA[M_STAGE_NUM][p][2];
		COOR_MON06[p].coor		= ID_MON06_DATA[M_STAGE_NUM][p][3];	                
		COOR_MON06[p].firenum   = ID_MON06_DATA[M_STAGE_NUM][p][4];	                
		COOR_MON06[p].firecount = COOR_MON06[p].firenum;
		COOR_MON06[p].ex		= COOR_MON06[p].sx + ID_MON06_XSIZE;
		COOR_MON06[p].ey		= COOR_MON06[p].sy + ID_MON06_YSIZE;
		COOR_MON06[p].sn		=	  						    0;		//   ٸ Ѵ.
		COOR_MON06[p].life		= 							 TRUE;
		COOR_MON06[p].move		=							FALSE;
		COOR_MON06[p].time		=								3;
		COOR_MON06[p].count		=			                    0;
	}


	////////////////////////  06(ĵ)  ĵ(̻^^;) ʱȭ 
	for(int b=0; b<ID_STAGE_DATA[M_STAGE_NUM][ID_MON06_NUM]; b++)	//  06   Ѵ
	{
		for(int bb=0; bb<COOR_MON06[b].firenum; bb++)               //  Ϳ     
		{
			switch(COOR_MON06[b].coor)
			{
			case ID_RIGHT:
				COOR_CANFIRE[b][bb].sx    = COOR_MON06[b].sx; // + ID_CANFIRE_XSIZE;
				COOR_CANFIRE[b][bb].sy    = COOR_MON06[b].sy + ID_MON06_YSIZE-ID_CANFIRE_YSIZE;
				COOR_CANFIRE[b][bb].att   = IDM06_LROLE_SPRNUM;
				COOR_CANFIRE[b][bb].step  = -2; //b+1;
				break;
			case ID_LEFT:
				COOR_CANFIRE[b][bb].sx    = COOR_MON06[b].sx + ID_MON06_XSIZE-ID_CANFIRE_XSIZE;
				COOR_CANFIRE[b][bb].sy    = COOR_MON06[b].sy + ID_MON06_YSIZE-ID_CANFIRE_YSIZE;
				COOR_CANFIRE[b][bb].att   = IDM06_RROLE_SPRNUM;
				COOR_CANFIRE[b][bb].step  = 2; //-(b+1);
				break;
			}
				COOR_CANFIRE[b][bb].ex	  = COOR_CANFIRE[b][bb].sx + ID_CANFIRE_XSIZE;
				COOR_CANFIRE[b][bb].ey	  = COOR_CANFIRE[b][bb].sy + ID_CANFIRE_YSIZE;
				COOR_CANFIRE[b][bb].life  = FALSE;
				COOR_CANFIRE[b][bb].coor  = COOR_MON06[b].coor;
				COOR_CANFIRE[b][bb].sn    = 0;
		}

	}


	/////////////////////////  ʱȭ 
	///////////////////////// ݶ
	COOR_COKE.sx    = ID_ITEMCOKE_DATA[M_STAGE_NUM][0];
	COOR_COKE.sy    = ID_ITEMCOKE_DATA[M_STAGE_NUM][1];
	COOR_COKE.life  = TRUE;
	COOR_COKE.ex    = COOR_COKE.sx + ID_COKE_XSIZE;
	COOR_COKE.ey    = COOR_COKE.sy + ID_COKE_YSIZE;
	COOR_COKE.sn    = 0;
	///////////////////////// 
	COOR_SKEY.sx    = ID_ITEMSKEY_DATA[M_STAGE_NUM][0];
	COOR_SKEY.sy    = ID_ITEMSKEY_DATA[M_STAGE_NUM][1];
	COOR_SKEY.life  = TRUE;
	COOR_SKEY.ex    = COOR_SKEY.sx + ID_SKEY_XSIZE;
	COOR_SKEY.ey    = COOR_SKEY.sy + ID_SKEY_YSIZE;
	COOR_SKEY.sn    = 4;
	///////////////////////// ݿ
	COOR_GKEY.sx    = ID_ITEMGKEY_DATA[M_STAGE_NUM][0];
	COOR_GKEY.sy    = ID_ITEMGKEY_DATA[M_STAGE_NUM][1];
	COOR_GKEY.life  = TRUE;
	COOR_GKEY.ex    = COOR_GKEY.sx + ID_GKEY_XSIZE;
	COOR_GKEY.ey    = COOR_GKEY.sy + ID_GKEY_YSIZE;
	COOR_GKEY.sn    = 8;


	//////////////////////////  ʱȭ 
	COOR_FINAL.sx		= ID_FINAL_COORDATA[M_STAGE_NUM][0];
	COOR_FINAL.sy		= ID_FINAL_COORDATA[M_STAGE_NUM][1];
	COOR_FINAL.ex		= COOR_FINAL.sx + ID_FINAL_XSIZE;
	COOR_FINAL.ey		= COOR_FINAL.sy + ID_FINAL_YSIZE;
	COOR_FINAL.att		= ID_UFINAL_SPRNUM;
	COOR_FINAL.sn		= 0;
	COOR_FINAL.life		= TRUE;


	///////////////////////// ̽Ȧ ̹ ʱȭ 
	for(int h=0; h<ID_MAX_STAGEHOLENUM[M_STAGE_NUM]; h++)
	{
		COOR_HOLE[h].sx   = ID_HOLEIMAGE_DATA[M_STAGE_NUM][h][0];
		COOR_HOLE[h].sy   = ID_HOLEIMAGE_DATA[M_STAGE_NUM][h][1];
		COOR_HOLE[h].ex   = COOR_HOLE[h].sx + ID_HOLE_XSIZE;
		COOR_HOLE[h].ey   = COOR_HOLE[h].sy + ID_HOLE_YSIZE;
		COOR_HOLE[h].att  = ID_SHOLE_SPRNUM;
		COOR_HOLE[h].sn   = h*2;
		COOR_HOLE[h].move = FALSE;

		for(int k=0; k<2; k++)
		{
			COOR_HOLE[h].next[k] = ID_HOLENEXT_DATA[M_STAGE_NUM][h][k];
		}
	}


	/////////////////////////  ٲ
	M_CHECK_MAINGMAE   = ID_STAGE_PLAY;
	/////////////////////////  Ŭ ʱȭ 
	M_STAGE_END     = FALSE;
	/////////////////////////    Ⱥ
	M_FINAL_VIEW    = FALSE;
	///////////////////////// ȭ  ʱȭ
	M_SCREEN_FADE   = ID_FADE_IN;
	/////////////////////////  ...   ̾  : TRUE,  ɰ : FALSE....
	M_GAME_STATE	= TRUE; 
	///////////////////////// Ȧ ö ġ  
	M_HOLE_OUTSW = FALSE;   
	///////////////////////// ð īƮ ʱȭ 
	M_CURRENT_TIMECOUNT = 0;
	M_CURRENT_MINUTE	= 0;
	M_CURRENT_SECOND	= 0;
	/////////////////////////  Ű ʱȭ 
	M_ENTER_KEY = FALSE;


	//////////////////////////   Ҹ
	MuteVolume(ID_WAV_VOLUME);
//	sndPlaySound(ID_SOUND_FILENAME[5], SND_ASYNC | SND_NODEFAULT);	
	MuteVolume(ID_WAV_VOLUME);
}




void Stage_CloseGame(void)
{
	FreeSpr(NOA,     noasprnum);

	FreeSpr(MON01, mon01sprnum);
	FreeSpr(MON02, mon02sprnum);
	FreeSpr(MON03, mon03sprnum);
	FreeSpr(MON04, mon04sprnum);
	FreeSpr(MON06, mon06sprnum);

	FreeSpr(BACK,   backsprnum);

	FreeSpr(FINAL,  finalsprnum);

	FreeSpr(FIRE,   firesprnum);

	FreeSpr(ITEM,   itemsprnum);

	FreeSpr(HOLE,   holesprnum);

	FreeSpr(NUMBER, numbersprnum);

	FreeSpr(NOADIE, noadiesprnum);


	//////////////////////   ... 
	switch(M_GAME_STATE)
	{
	case TRUE:
		if(COOR_NOA.life == TRUE) M_STAGE_NUM++;
		if(M_STAGE_NUM == ID_MAX_STAGENUM) M_STAGE_NUM = 0;       ///////////  ݺ κ////////////

		//  ʱȭ...
		if(M_STAGE_NUM < ID_MAX_STAGENUM) M_CHECK_MAINGMAE = ID_STAGE_INIT;
			else M_CHECK_MAINGMAE = ID_GAMEOVER;

		break;

	case FALSE:
		//  ...
		M_CHECK_MAINGMAE = ID_GAMEOVER;

		break;
	}

}





void Stage_DrawBack(void)
{	
	PutSpr(0, 0, &BACK[0], ID_BN);
}



//  ȭ鿡 ׸...
void Stage_DrawNoa(void)
{
	if(COOR_NOA.hole == FALSE)
	{
		switch(COOR_NOA.move)
		{
		case TRUE:
			PutSpr(COOR_NOA.sx, COOR_NOA.sy, &NOA[COOR_NOA.att + COOR_NOA.sn], ID_S);
			M_STOP_TIME = 0;
			break;

		case FALSE:
			// ư   δ...
			if(FrameSkip(10, 100)) M_STOP_TIME++;
			if(M_STOP_TIME > 5)   // ð  δ...
			{
				M_NOASPRNUM = 0;
				if(M_NOA_STOP == FALSE)	M_NOA_STOP = TRUE;
				M_STOP_TIME = 0;
			}

			PutSpr(COOR_NOA.sx, COOR_NOA.sy, &NOA[COOR_NOA.att + COOR_NOA.sn], ID_S);
			COOR_NOA.clipx = TRUE;
			break;
		}
	}

}



//  ̵ ˻... .
void Stage_CheckNoa(void)
{
	COOR_NOA.clipx = TRUE;
	COOR_NOA.clipy = TRUE;

	for(int i=0; i<backmapnum; i++)
	{
		if( (COOR_NOA.sx+12 < BACKMAP[i].ex) && (BACKMAP[i].sx < COOR_NOA.ex-12)
         && (COOR_NOA.sy+40 < BACKMAP[i].ey) && (BACKMAP[i].sy < COOR_NOA.ey) )
		{
			switch(BACKMAP[i].att)
			{
			case ID_MAP_WALL:			// ΰ?
				if(COOR_NOA.coor == ID_RIGHT) COOR_NOA.sx -= 2;
				if(COOR_NOA.coor ==  ID_LEFT) COOR_NOA.sx += 2;

				COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
		
				COOR_NOA.clipx = FALSE;
				break;

			case ID_MAP_LAND:			// ΰ?
				COOR_NOA.sy = BACKMAP[i].sy - ID_NOA_YSIZE;

				COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;

				COOR_NOA.clipy = FALSE;
				if(M_JUMP == FALSE) M_JUMPNUM = 0;
				break;

			case ID_MAP_START:
				break;
			case ID_MAP_FINAL:
				break;
			}
		}
	}

}





//////////////////////////  ̽Ȧ ˻ 
void Stage_CheckHole(void)
{
	for(int i=0; i<ID_MAX_STAGEHOLENUM[M_STAGE_NUM]; i++)
	{
		if( (COOR_NOA.sx+12 < COOR_HOLE[i].ex-18) && (COOR_HOLE[i].sx+18 < COOR_NOA.ex-12)
         && (COOR_NOA.sy+40 < COOR_HOLE[i].ey) && (COOR_HOLE[i].sy+50 < COOR_NOA.ey) )
		{
			sndPlaySound(ID_SOUND_FILENAME[2], SND_ASYNC | SND_NODEFAULT);	

			COOR_NOA.sx = 640;						// Ƹ 浹  ָ ´
			COOR_NOA.sy = 480;
			COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
			COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;
			COOR_NOA.newx = COOR_HOLE[i].next[0];	//   ǥ   д
			COOR_NOA.newy = COOR_HOLE[i].next[1];
			COOR_NOA.hole = TRUE;                   // Ȧ Ҵٴ ǥ...

			COOR_HOLE[i].move = TRUE;
			COOR_HOLE[i].sn   = 0;

		}
	}

}





//  ϶... ..
void Stage_CheckNoaMove(void)
{
	switch(M_KEYSW)
	{
	case ID_LEFT:
		// 浹˻簡   Ѵ.
		if(COOR_NOA.clipx == TRUE) COOR_NOA.sx-=COOR_NOA.step;
		COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
		COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;
		COOR_NOA.att = IDN_LWALK_SPRNUM;
		COOR_NOA.sn = M_NOASPRNUM;
		if(M_JUMP == FALSE) M_NOASPRNUM++;
		if(M_NOASPRNUM > 11) M_NOASPRNUM = 0;
		COOR_NOA.move = TRUE;
		break;
	
	case ID_RIGHT:
		if(COOR_NOA.clipx == TRUE) COOR_NOA.sx+=COOR_NOA.step;
		COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
		COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;
		COOR_NOA.att = IDN_RWALK_SPRNUM;
		COOR_NOA.sn = M_NOASPRNUM;
		if(M_JUMP == FALSE) M_NOASPRNUM++;
		if(M_NOASPRNUM > 11) M_NOASPRNUM = 0;
		COOR_NOA.move = TRUE;
		break;

	case ID_STOP:
		if(COOR_NOA.coor ==  ID_LEFT) COOR_NOA.att = IDN_LSTOP_SPRNUM;
		if(COOR_NOA.coor == ID_RIGHT) COOR_NOA.att = IDN_RSTOP_SPRNUM;
		if(M_JUMP == FALSE) COOR_NOA.sn = M_NOASPRNUM = 0;
		break;

	case ID_DIE:
/*   */		COOR_NOA.sx = ID_NOA_DATA[M_STAGE_NUM][0];
				COOR_NOA.sy = ID_NOA_DATA[M_STAGE_NUM][1];
				COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
				COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;
				M_KEYSW = ID_STOP;
		break;

	}

	
	switch(M_JUMP)
	{
	case TRUE:
		if(M_JUMPNUM < IDN_NOA_JUMPHEIGHT) 
		{
			if(M_NOASPRNUM == 0) 
				sndPlaySound(ID_SOUND_FILENAME[0], SND_ASYNC | SND_NODEFAULT);	

			COOR_NOA.sy -= 4;
			M_JUMPNUM++;

			if(COOR_NOA.coor ==  ID_LEFT) COOR_NOA.att = IDN_LJUMP_SPRNUM;
			if(COOR_NOA.coor == ID_RIGHT) COOR_NOA.att = IDN_RJUMP_SPRNUM;

			COOR_NOA.sn = M_NOASPRNUM;
			M_NOASPRNUM++; 
			if(M_NOASPRNUM > 11) M_NOASPRNUM = 0;     

		}
		else
		{
			M_JUMP = FALSE;
			M_STOP_TIME = 0;
		}

		COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
		COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;
		break;
	}




}




// ư Ȧ ö...
void Stage_HoleOut(void)
{
	if(COOR_NOA.coor ==  ID_LEFT) COOR_NOA.att = IDN_LOUT_SPRNUM;
	if(COOR_NOA.coor == ID_RIGHT) COOR_NOA.att = IDN_ROUT_SPRNUM;

	COOR_NOA.sn = M_NOASPRNUM;

	if(COOR_NOA.sn == 3) 
		sndPlaySound(ID_SOUND_FILENAME[3], SND_ASYNC | SND_NODEFAULT);	


	if(M_JUMP == FALSE && FrameSkip(89, 1200)) M_NOASPRNUM++;
	if(M_NOASPRNUM > 11) 
	{
		M_NOASPRNUM = 0;
		M_HOLE_OUTSW = FALSE;
		M_KEYSW = ID_STOP;
	}
	COOR_NOA.move = TRUE;

}





// ư ...
void Stage_DownNoa(void)
{
	// ư ٴڱ  ˻Ѵ.
	if(COOR_NOA.clipy == TRUE)
	{
		COOR_NOA.sy += 6;		 
		COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;

		M_JUMPNUM = IDN_NOA_JUMPHEIGHT;

		// Ȧ ö  ʴ´....
		if(M_HOLE_OUTSW == FALSE)
		{
			///////////  01  ˻ 
			for(int i=0; i<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; i++)
			{
				if(COOR_MON01[i].life == TRUE)
				{
					if( (COOR_NOA.sx+12 < COOR_MON01[i].ex-10) && (COOR_MON01[i].sx+10 < COOR_NOA.ex-12)
				     && (COOR_NOA.sy+40 < COOR_MON01[i].ey-27) && (COOR_MON01[i].sy+13 < COOR_NOA.ey) )
					{
						COOR_MON01[i].life  = FALSE;
						COOR_MON01[i].count = 0;
						COOR_MON01[i].sn	= 0;
	
						//   
						M_JUMPNUM   = 6;
						M_JUMP      = TRUE;
						M_NOASPRNUM = 0;
					}
				}
			}



			///////////  02  ˻ 
			for(int m=0; m<ID_STAGE_DATA[M_STAGE_NUM][ID_MON02_NUM]; m++)
			{
				if(COOR_MON02[m].life == TRUE)
				{
					if( (COOR_NOA.sx+12 < COOR_MON02[m].ex-17) && (COOR_MON02[m].sx+10 < COOR_NOA.ex-17)
				     && (COOR_NOA.sy+40 < COOR_MON02[m].ey-27) && (COOR_MON02[m].sy+3 < COOR_NOA.ey) )
					{
						COOR_MON02[m].life  = FALSE;
						COOR_MON02[m].count = 0;
						COOR_MON02[m].sn	= 0;
		
						//   
						M_JUMPNUM   = 6;
						M_JUMP      = TRUE;
						M_NOASPRNUM = 0;
					}
				}
			}	
	
	
	
			///////////  03  ˻ 
			for(int j=0; j<ID_STAGE_DATA[M_STAGE_NUM][ID_MON03_NUM]; j++)
			{
				if(COOR_MON03[j].life == TRUE)
				{
					if( (COOR_NOA.sx+12 < COOR_MON03[j].ex-10) && (COOR_MON03[j].sx+10 < COOR_NOA.ex-12)
				     && (COOR_NOA.sy+40 < COOR_MON03[j].ey-15) && (COOR_MON03[j].sy+10 < COOR_NOA.ey) )
					{
						COOR_MON03[j].life  = FALSE;
						COOR_MON03[j].count = 0;
						COOR_MON03[j].sn	= 0;
		
						//   
						M_JUMPNUM   = 6;
						M_JUMP      = TRUE;
						M_NOASPRNUM = 0;
					}
				}
			}
	
		

			///////////  04  ˻ 
			for(int k=0; k<ID_STAGE_DATA[M_STAGE_NUM][ID_MON04_NUM]; k++)
			{
				if(COOR_MON04[k].life == TRUE)
				{
					if( (COOR_NOA.sx+12 < COOR_MON04[k].ex-5) && (COOR_MON04[k].sx+5 < COOR_NOA.ex-12)
				     && (COOR_NOA.sy+40 < COOR_MON04[k].ey-13) && (COOR_MON04[k].sy+13 < COOR_NOA.ey) )
					{
						COOR_MON04[k].life  = FALSE;
						COOR_MON04[k].count = 0;
						COOR_MON04[k].sn	= 0;
		
						//   
						M_JUMPNUM   = 6;
						M_JUMP      = TRUE;
						M_NOASPRNUM = 0;
					}
				}
			}
		} // if(M_HOLE_OUTSW.... 
	
	}
}




// ư  ...
void Stage_StopNoaSpr(void)
{
	if(COOR_NOA.coor ==  ID_LEFT) COOR_NOA.att = IDN_LSTOP_SPRNUM;
	if(COOR_NOA.coor == ID_RIGHT) COOR_NOA.att = IDN_RSTOP_SPRNUM;

	COOR_NOA.sn = M_NOASPRNUM;

	if(FrameSkip(11, 2400)) M_NOASPRNUM++;
	if(M_NOASPRNUM > 11) 
	{
		M_NOA_STOP  = FALSE;
		M_NOASPRNUM = 0;
		COOR_NOA.sn = M_NOASPRNUM;
	}
}



////////////  ׸
void Stage_DrawMon(void)
{	
	/////////////  06(ĵ)  ׸
	for(int b=0; b<ID_STAGE_DATA[M_STAGE_NUM][ID_MON06_NUM]; b++)	//  06   Ѵ
	{
		for(int bb=0; bb<COOR_MON06[b].firenum; bb++)               //  Ϳ     
		{
			if(COOR_CANFIRE[b][bb].life == TRUE)
			{
				switch(COOR_CANFIRE[b][bb].coor)
				{
				case ID_RIGHT:
					COOR_CANFIRE[b][bb].att = IDM06_LROLE_SPRNUM;
					COOR_CANFIRE[b][bb].sn++;
					if(COOR_CANFIRE[b][bb].sn > 10) COOR_CANFIRE[b][bb].sn = 0;

					COOR_CANFIRE[b][bb].sx += COOR_CANFIRE[b][bb].step;
					COOR_CANFIRE[b][bb].ex  = COOR_CANFIRE[b][bb].sx + ID_CANFIRE_XSIZE;

					PutSpr(COOR_CANFIRE[b][bb].sx, COOR_CANFIRE[b][bb].sy, 
						&MON06[COOR_CANFIRE[b][bb].att + COOR_CANFIRE[b][bb].sn], ID_S);
					break;

				case ID_LEFT:
					COOR_CANFIRE[b][bb].att = IDM06_RROLE_SPRNUM;
					COOR_CANFIRE[b][bb].sn++;
					if(COOR_CANFIRE[b][bb].sn > 10) COOR_CANFIRE[b][bb].sn = 0;

					COOR_CANFIRE[b][bb].sx += COOR_CANFIRE[b][bb].step;
					COOR_CANFIRE[b][bb].ex  = COOR_CANFIRE[b][bb].sx + ID_CANFIRE_XSIZE;

					PutSpr(COOR_CANFIRE[b][bb].sx, COOR_CANFIRE[b][bb].sy, 
						&MON06[COOR_CANFIRE[b][bb].att - COOR_CANFIRE[b][bb].sn], ID_S);
					break;
				}
			}
		}
	}



	
	/////////////  01(巳)  ׸
	for(int a=0; a<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; a++)	//  01   Ѵ
	{
		for(int aa=0; aa<COOR_MON01[a].firenum; aa++)               //  Ϳ     
		{
			if(COOR_FIRE[a][aa].life == TRUE)
			{
				COOR_FIRE[a][aa].sn++;
				if(COOR_FIRE[a][aa].sn > 11) 
				{
					switch(COOR_FIRE[a][aa].coor)
					{
					case ID_RIGHT:
						COOR_FIRE[a][aa].att = IDM01_RFIRE1_SPRNUM;
						break;
					case ID_LEFT:
						COOR_FIRE[a][aa].att = IDM01_LFIRE1_SPRNUM;
						break;
					}
	
					COOR_FIRE[a][aa].sn  = 0;
				}

				COOR_FIRE[a][aa].sx += COOR_FIRE[a][aa].step;
				COOR_FIRE[a][aa].ex  = COOR_FIRE[a][aa].sx + ID_FIRE_XSIZE;

				PutSpr(COOR_FIRE[a][aa].sx, COOR_FIRE[a][aa].sy, &FIRE[COOR_FIRE[a][aa].att + COOR_FIRE[a][aa].sn], ID_S);
			}
		}
	}


	//  01 
	for(int i=0; i<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; i++)
	{
		PutSpr(COOR_MON01[i].sx, COOR_MON01[i].sy, &MON01[COOR_MON01[i].att + COOR_MON01[i].sn], ID_S);
	}

	//  02 
	for(int l=0; l<ID_STAGE_DATA[M_STAGE_NUM][ID_MON02_NUM]; l++)
	{
		PutSpr(COOR_MON02[l].sx, COOR_MON02[l].sy, &MON02[COOR_MON02[l].att + COOR_MON02[l].sn], ID_S);
	}

	//  03 
	for(int j=0; j<ID_STAGE_DATA[M_STAGE_NUM][ID_MON03_NUM]; j++)
	{
		PutSpr(COOR_MON03[j].sx, COOR_MON03[j].sy, &MON03[COOR_MON03[j].att + COOR_MON03[j].sn], ID_S);
	}

	//  04 
	for(int m=0; m<ID_STAGE_DATA[M_STAGE_NUM][ID_MON04_NUM]; m++)
	{
		PutSpr(COOR_MON04[m].sx, COOR_MON04[m].sy, &MON04[COOR_MON04[m].att + COOR_MON04[m].sn], ID_S);
	}


	//  06 
	for(int k=0; k<ID_STAGE_DATA[M_STAGE_NUM][ID_MON06_NUM]; k++)
	{
		PutSpr(COOR_MON06[k].sx, COOR_MON06[k].sy, &MON06[COOR_MON06[k].att + COOR_MON06[k].sn], ID_S);
	}

}




///////////   ˻ 
void Stage_CheckMonMove(void)
{
	/////////////  01
	for(int i=0; i<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; i++)
	{
		if(FrameSkip(20+i, 1200)) 
		{
			if( (COOR_MON01[i].att == IDM01_LFIRE_SPRNUM || COOR_MON01[i].att == IDM01_RFIRE_SPRNUM) && COOR_MON01[i].sn == 8)
			{
				if(COOR_MON01[i].firenum > 0 && COOR_MON01[i].firecount > 0)
				{
					for(int sh0=0; sh0<COOR_MON01[i].firenum; sh0++) //  ̻  迭 ã ʱȭ Ѵ.
					{
						if(COOR_FIRE[i][sh0].life == FALSE) 
						{
//							sndPlaySound(ID_SOUND_FILENAME[6], SND_ASYNC | SND_NODEFAULT);	

							COOR_FIRE[i][sh0].life = TRUE;
							goto next0;
						}
					}
					next0:
					;

					COOR_MON01[i].firecount--;       // ϳ ϳ  ...
					if(COOR_MON01[i].firecount <= 0) 
					{
						COOR_MON01[i].firecount = 0;
						COOR_MON01[i].sn		= 0;
					}
				}
			}

			COOR_MON01[i].sn++;
	
			//  .
			if(COOR_MON01[i].sn > 11) 
			{
				COOR_MON01[i].sn = 0;
				if(COOR_MON01[i].move != FALSE) COOR_MON01[i].move = FALSE;
			}

		}

		if(COOR_MON01[i].move == TRUE && COOR_MON01[i].life == TRUE) 
		{
			if(COOR_MON01[i].coor ==  ID_LEFT) COOR_MON01[i].att = IDM01_LFIRE_SPRNUM;
			if(COOR_MON01[i].coor == ID_RIGHT) COOR_MON01[i].att = IDM01_RFIRE_SPRNUM;
		}
		if(COOR_MON01[i].move == FALSE && COOR_MON01[i].life == TRUE)
		{
			if(COOR_MON01[i].coor ==  ID_LEFT) COOR_MON01[i].att = IDM01_LSTOP_SPRNUM;
			if(COOR_MON01[i].coor == ID_RIGHT) COOR_MON01[i].att = IDM01_RSTOP_SPRNUM;
		}
		if(COOR_MON01[i].life == FALSE)
		{
			if(COOR_MON01[i].coor ==  ID_LEFT) COOR_MON01[i].att = IDM01_LDIE_SPRNUM;
			if(COOR_MON01[i].coor == ID_RIGHT) COOR_MON01[i].att = IDM01_RDIE_SPRNUM;
		}
		
		// ٽ Ƴ ð...
		if(COOR_MON01[i].life == FALSE)
		{
			if(FrameSkip(25+i, 100)) COOR_MON01[i].count++;
			if(COOR_MON01[i].count == COOR_MON01[i].time)
			{
				COOR_MON01[i].move  = FALSE;
				COOR_MON01[i].sn	= 0;
				COOR_MON01[i].count = 0;
				COOR_MON01[i].life  = TRUE;
			}
		}

		// ҽ ð...
		if(COOR_MON01[i].life == TRUE && COOR_MON01[i].firenum > 0 && COOR_MON01[i].firecount > 0)
		{
			if(FrameSkip(30+i, 100)) COOR_MON01[i].count2++;
			if(COOR_MON01[i].count2 == COOR_MON01[i].time2)
			 {
				COOR_MON01[i].move   = TRUE;
				COOR_MON01[i].sn	 = 0;
				COOR_MON01[i].count2 = 0;
			}
		}


	}



	///////////////  02
	for(int l=0; l<ID_STAGE_DATA[M_STAGE_NUM][ID_MON02_NUM]; l++)
	{
		if(FrameSkip(35+l, 1200)) COOR_MON02[l].sn++;
		if(COOR_MON02[l].sn > 11)
		{
			if(COOR_MON02[l].move == TRUE && COOR_MON02[l].life == FALSE)
			{
				COOR_MON02[l].move  = FALSE;
				COOR_MON02[l].count = 0;
			}

			COOR_MON02[l].sn	= 0;
		}
		if(FrameSkip(40+l, 100)) COOR_MON02[l].count++;
		if(COOR_MON02[l].move == FALSE && COOR_MON02[l].count == COOR_MON02[l].time)
		{
			COOR_MON02[l].move  = TRUE;
			COOR_MON02[l].sn	= 0;
			COOR_MON02[l].count = 0;
			COOR_MON02[l].life  = TRUE;
		}
		if(COOR_MON02[l].move == TRUE && COOR_MON02[l].life == TRUE) 
		{
			if(COOR_MON02[l].coor ==  ID_LEFT) COOR_MON02[l].att = IDM02_LWALK_SPRNUM;
			if(COOR_MON02[l].coor == ID_RIGHT) COOR_MON02[l].att = IDM02_RWALK_SPRNUM;
		}
		if(COOR_MON02[l].move == TRUE && COOR_MON02[l].life == FALSE)
		{
			if(COOR_MON02[l].coor ==  ID_LEFT) COOR_MON02[l].att = IDM02_LDIE1_SPRNUM;
			if(COOR_MON02[l].coor == ID_RIGHT) COOR_MON02[l].att = IDM02_RDIE1_SPRNUM;
		}
		if(COOR_MON02[l].move == FALSE && COOR_MON02[l].life == FALSE)
		{
			if(COOR_MON02[l].coor ==  ID_LEFT) COOR_MON02[l].att = IDM02_LDIE2_SPRNUM;
			if(COOR_MON02[l].coor == ID_RIGHT) COOR_MON02[l].att = IDM02_RDIE2_SPRNUM;
		}
	}



	///////////////  03
	for(int j=0; j<ID_STAGE_DATA[M_STAGE_NUM][ID_MON03_NUM]; j++)
	{
		if(FrameSkip(45+j, 1200)) COOR_MON03[j].sn++;
		if(COOR_MON03[j].sn > 11)
		{
			if(COOR_MON03[j].move == TRUE && COOR_MON03[j].life == FALSE)
			{
				COOR_MON03[j].move  = FALSE;
				COOR_MON03[j].count = 0;
			}

			COOR_MON03[j].sn	= 0;
		}
		if(FrameSkip(50+j, 100)) COOR_MON03[j].count++;
		if(COOR_MON03[j].move == FALSE && COOR_MON03[j].count == COOR_MON03[j].time)
		{
			COOR_MON03[j].move  = TRUE;
			COOR_MON03[j].sn	= 0;
			COOR_MON03[j].count = 0;
			COOR_MON03[j].life  = TRUE;
		}
		if(COOR_MON03[j].move == TRUE && COOR_MON03[j].life == TRUE) 
		{
			if(COOR_MON03[j].coor ==  ID_LEFT) COOR_MON03[j].att = IDM03_LWALK_SPRNUM;
			if(COOR_MON03[j].coor == ID_RIGHT) COOR_MON03[j].att = IDM03_RWALK_SPRNUM;
		}
		if(COOR_MON03[j].move == TRUE && COOR_MON03[j].life == FALSE)
		{
			if(COOR_MON03[j].coor ==  ID_LEFT) COOR_MON03[j].att = IDM03_LDIE1_SPRNUM;
			if(COOR_MON03[j].coor == ID_RIGHT) COOR_MON03[j].att = IDM03_RDIE1_SPRNUM;
		}
		if(COOR_MON03[j].move == FALSE && COOR_MON03[j].life == FALSE)
		{
			if(COOR_MON03[j].coor ==  ID_LEFT) COOR_MON03[j].att = IDM03_LDIE2_SPRNUM;
			if(COOR_MON03[j].coor == ID_RIGHT) COOR_MON03[j].att = IDM03_RDIE2_SPRNUM;
		}
	}




	///////////////  04
	for(int m=0; m<ID_STAGE_DATA[M_STAGE_NUM][ID_MON04_NUM]; m++)
	{
		if(FrameSkip(55+m, 1200)) COOR_MON04[m].sn++;
		if(COOR_MON04[m].sn > 11)
		{
			if(COOR_MON04[m].move == TRUE && COOR_MON04[m].life == FALSE)
			{
				COOR_MON04[m].move  = FALSE;
				COOR_MON04[m].count = 0;
			}

			COOR_MON04[m].sn	= 0;
		}
		if(FrameSkip(60+m, 100)) COOR_MON04[m].count++;
		if(COOR_MON04[m].move == FALSE && COOR_MON04[m].count == COOR_MON04[m].time)
		{
			COOR_MON04[m].move  = TRUE;
			COOR_MON04[m].sn	= 0;
			COOR_MON04[m].count = 0;
			COOR_MON04[m].life  = TRUE;
		}
		if(COOR_MON04[m].move == TRUE && COOR_MON04[m].life == TRUE) 
		{
			if(COOR_MON04[m].coor ==  ID_LEFT) COOR_MON04[m].att = IDM04_LWALK_SPRNUM;
			if(COOR_MON04[m].coor == ID_RIGHT) COOR_MON04[m].att = IDM04_RWALK_SPRNUM;
		}
		if(COOR_MON04[m].move == TRUE && COOR_MON04[m].life == FALSE)
		{
			if(COOR_MON04[m].coor ==  ID_LEFT) COOR_MON04[m].att = IDM04_LDIE1_SPRNUM;
			if(COOR_MON04[m].coor == ID_RIGHT) COOR_MON04[m].att = IDM04_RDIE1_SPRNUM;
		}
		if(COOR_MON04[m].move == FALSE && COOR_MON04[m].life == FALSE)
		{
			if(COOR_MON04[m].coor ==  ID_LEFT) COOR_MON04[m].att = IDM04_LDIE2_SPRNUM;
			if(COOR_MON04[m].coor == ID_RIGHT) COOR_MON04[m].att = IDM04_RDIE2_SPRNUM;
		}
	}


	


	/////////////  06
	for(int k=0; k<ID_STAGE_DATA[M_STAGE_NUM][ID_MON06_NUM]; k++)
	{
		if(COOR_MON06[k].move == TRUE && COOR_MON06[k].firenum > 0 && COOR_MON06[k].firecount > 0)
		{
			if(COOR_MON06[k].coor ==  ID_LEFT) COOR_MON06[k].att = IDM06_LSTOP_SPRNUM;
			if(COOR_MON06[k].coor == ID_RIGHT) COOR_MON06[k].att = IDM06_RSTOP_SPRNUM;

			if(FrameSkip(65+k, 1600)) 
			{
				COOR_MON06[k].sn++;
	
				// ĵ .
				if(COOR_MON06[k].sn > 15) 
				{
					for(int sh1=0; sh1<COOR_MON06[k].firenum; sh1++) // ĵ ̻  迭 ã ʱȭ Ѵ.
					{
						if(COOR_CANFIRE[k][sh1].life == FALSE) 
						{
							COOR_CANFIRE[k][sh1].life = TRUE;
							goto next1;
						}
					}
					next1:
					;

					COOR_MON06[k].move	 = FALSE;
					COOR_MON06[k].sn	 =     0;

					COOR_MON06[k].firecount--;       // ϳ ϳ ĵ ...
					if(COOR_MON06[k].firecount <= 0) 
					{
						COOR_MON06[k].firecount = 0;
						COOR_MON06[k].sn		= 0;
					}
				}
			}

		}

		
		if(COOR_MON06[k].move == FALSE && COOR_MON06[k].firenum > 0 && COOR_MON06[k].firecount > 0)
		{
			if(FrameSkip(70+k, 50)) COOR_MON06[k].count++;
			if(COOR_MON06[k].count == COOR_MON06[k].time) 
			{
				COOR_MON06[k].move  = TRUE;
				COOR_MON06[k].sn	= 0;
				COOR_MON06[k].count = 0;
			}
		}

	}



}




//////////////////  ̵θ ˻Ѵ
void Stage_CheckMonLoad(void)
{
	//////////  02(ǳŰ) ˻ 
	for(int m=0; m<ID_STAGE_DATA[M_STAGE_NUM][ID_MON02_NUM]; m++)
	{
		if(COOR_MON02[m].life == TRUE)
		{
			if(COOR_MON02[m].coor == ID_RIGHT) COOR_MON02[m].sx += COOR_MON02[m].step;
			if(COOR_MON02[m].coor ==  ID_LEFT) COOR_MON02[m].sx -= COOR_MON02[m].step;

			COOR_MON02[m].ex = COOR_MON02[m].sx + ID_MON02_XSIZE;
		}

		for(int n=0; n<loadmapnum; n++)
		{
			if( (COOR_MON02[m].sx+17 < LOADMAP[n].ex) && (LOADMAP[n].sx < COOR_MON02[m].ex-17)
		     && (COOR_MON02[m].sy < LOADMAP[n].ey) && (LOADMAP[n].sy < COOR_MON02[m].ey) )
			{
				switch(LOADMAP[n].att)
				{
				case ID_MAP_WALL:
					if(COOR_MON02[m].coor == ID_LEFT)  
					{
						COOR_MON02[m].coor = ID_RIGHT;
						break;
					}

					if(COOR_MON02[m].coor == ID_RIGHT) 
					{
						COOR_MON02[m].coor = ID_LEFT;
						break;
					}
					break;
				}
			}
		}
	}



	//////////  03() ˻ 
	for(int j=0; j<ID_STAGE_DATA[M_STAGE_NUM][ID_MON03_NUM]; j++)
	{
		if(COOR_MON03[j].life == TRUE)
		{
			if(COOR_MON03[j].coor == ID_RIGHT) COOR_MON03[j].sx += COOR_MON03[j].step;
			if(COOR_MON03[j].coor ==  ID_LEFT) COOR_MON03[j].sx -= COOR_MON03[j].step;

			COOR_MON03[j].ex = COOR_MON03[j].sx + ID_MON03_XSIZE;
		}

		for(int i=0; i<loadmapnum; i++)
		{
			if( (COOR_MON03[j].sx < LOADMAP[i].ex) && (LOADMAP[i].sx < COOR_MON03[j].ex)
		     && (COOR_MON03[j].sy < LOADMAP[i].ey) && (LOADMAP[i].sy < COOR_MON03[j].ey) )
			{
				switch(LOADMAP[i].att)
				{
				case ID_MAP_WALL:
					if(COOR_MON03[j].coor == ID_LEFT)  
					{
						COOR_MON03[j].coor = ID_RIGHT;
						break;
					}

					if(COOR_MON03[j].coor == ID_RIGHT) 
					{
						COOR_MON03[j].coor = ID_LEFT;
						break;
					}
					break;
				}
			}
		}
	}




	//////////  04() ˻ 
	for(int k=0; k<ID_STAGE_DATA[M_STAGE_NUM][ID_MON04_NUM]; k++)
	{
		if(COOR_MON04[k].life == TRUE)
		{
			if(COOR_MON04[k].coor == ID_RIGHT) COOR_MON04[k].sx += COOR_MON04[k].step;
			if(COOR_MON04[k].coor ==  ID_LEFT) COOR_MON04[k].sx -= COOR_MON04[k].step;

			COOR_MON04[k].ex = COOR_MON04[k].sx + ID_MON04_XSIZE;
		}

		for(int kk=0; kk<loadmapnum; kk++)
		{
			if( (COOR_MON04[k].sx < LOADMAP[kk].ex) && (LOADMAP[kk].sx < COOR_MON04[k].ex)
		     && (COOR_MON04[k].sy < LOADMAP[kk].ey) && (LOADMAP[kk].sy < COOR_MON04[k].ey) )
			{
				switch(LOADMAP[kk].att)
				{
				case ID_MAP_WALL:
					if(COOR_MON04[k].coor == ID_LEFT)  
					{
						COOR_MON04[k].coor = ID_RIGHT;
						break;
					}

					if(COOR_MON04[k].coor == ID_RIGHT) 
					{
						COOR_MON04[k].coor = ID_LEFT;
						break;
					}
					break;
				}
			}
		}
	}



}




/////////// °  Ʈ 
void Stage_DrawFinal(void)
{
	if(M_FINAL_VIEW == TRUE)
	{
		if(FrameSkip(100, 1800)) COOR_FINAL.sn++;
		if(COOR_FINAL.sn > 35) 
		{
			COOR_FINAL.att = ID_SFINAL_SPRNUM;
			COOR_FINAL.sn = 0;
		}
	}

	PutSpr(COOR_FINAL.sx, COOR_FINAL.sy, &FINAL[COOR_FINAL.att + COOR_FINAL.sn], ID_S);
}





///////// ƿ  浹˻ 
void	Stage_Check_NoaToMon(void)
{
	/////////////  01 ˻  
	for(int i=0; i<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; i++)
	{
		if( (COOR_NOA.sx+12 < COOR_MON01[i].ex-6) && (COOR_MON01[i].sx+6 < COOR_NOA.ex-12)
	     && (COOR_NOA.sy+30 < COOR_MON01[i].ey) && (COOR_MON01[i].sy+30 < COOR_NOA.ey) )
		{
			if(COOR_MON01[i].life == TRUE)
			{
				COOR_NOA.life = FALSE;
			}
		}
	}



	///////////  02 ˻  
	for(int m=0; m<ID_STAGE_DATA[M_STAGE_NUM][ID_MON02_NUM]; m++)
	{
		if( (COOR_NOA.sx+12 < COOR_MON02[m].ex-17) && (COOR_MON02[m].sx+17 < COOR_NOA.ex-12)
	     && (COOR_NOA.sy+30 < COOR_MON02[m].ey) && (COOR_MON02[m].sy+30 < COOR_NOA.ey) )
		{
			if(COOR_MON02[m].life == TRUE)
			{
				COOR_NOA.life = FALSE;
			}
		}
	}


		

	///////////  03 ˻  
	for(int j=0; j<ID_STAGE_DATA[M_STAGE_NUM][ID_MON03_NUM]; j++)
	{
		if( (COOR_NOA.sx+12 < COOR_MON03[j].ex-6) && (COOR_MON03[j].sx+6 < COOR_NOA.ex-12)
	     && (COOR_NOA.sy+30 < COOR_MON03[j].ey) && (COOR_MON03[j].sy+30 < COOR_NOA.ey) )
		{
			if(COOR_MON03[j].life == TRUE)
			{
				COOR_NOA.life = FALSE;
			}
		}
	}



	///////////  04 ˻  
	for(int n=0; n<ID_STAGE_DATA[M_STAGE_NUM][ID_MON04_NUM]; n++)
	{
		if( (COOR_NOA.sx+12 < COOR_MON04[n].ex-7) && (COOR_MON04[n].sx+7 < COOR_NOA.ex-12)
	     && (COOR_NOA.sy+30 < COOR_MON04[n].ey) && (COOR_MON04[n].sy+20 < COOR_NOA.ey) )
		{
			if(COOR_MON04[n].life == TRUE)
			{
				COOR_NOA.life = FALSE;
			}
		}
	}



	/////////////  06 ˻  
	for(int k=0; k<ID_STAGE_DATA[M_STAGE_NUM][ID_MON06_NUM]; k++)
	{
		if( (COOR_NOA.sx+12 < COOR_MON06[k].ex) && (COOR_MON06[k].sx < COOR_NOA.ex-12)
	     && (COOR_NOA.sy+30 < COOR_MON06[k].ey) && (COOR_MON06[k].sy < COOR_NOA.ey) )
		{
			if(COOR_MON06[k].life == TRUE)
			{
				switch(COOR_NOA.coor)
				{
				case ID_RIGHT:
					COOR_NOA.sx = COOR_NOA.sx - 5;
					COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
					break;
				case ID_LEFT:
					COOR_NOA.sx = COOR_NOA.sx + 5;
					COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
					break;
				}
			}
		}
	}


}





///////////// Ҹ  
void Stage_SoundCheck(void)
{
	for(int i=0; i<soundmapnum; i++)
	{
		if( (M_XPOS < SOUNDMAP[i].ex) && (SOUNDMAP[i].sx < M_XPOS)
         && (M_YPOS < SOUNDMAP[i].ey) && (SOUNDMAP[i].sy < M_YPOS) )
		{
			if(M_MOUSE_LBUTTON == TRUE)
			{
				switch(SOUNDMAP[i].att)
				{
				case 0:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					PreCD();
					M_MOUSE_LBUTTON = FALSE;
					break;
				case 1:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					PlayCD();
					M_MOUSE_LBUTTON = FALSE;
					break;
				case 2:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					NextCD();
					M_MOUSE_LBUTTON = FALSE;
					break;
				case 3:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					StopCD();
					M_MOUSE_LBUTTON = FALSE;
					break;
				case 4:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					SetVolume(ID_CD_VOLUME, ID_ADD_VOLUME);
					M_MOUSE_LBUTTON = FALSE;
					break;
				case 5:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					SetVolume(ID_CD_VOLUME, ID_SUB_VOLUME);
					M_MOUSE_LBUTTON = FALSE;
					break;
				case 6:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					SetVolume(ID_WAV_VOLUME, ID_ADD_VOLUME);
					M_MOUSE_LBUTTON = FALSE;
					break;
				case 7:
					sndPlaySound(ID_SOUND_FILENAME[7], SND_ASYNC | SND_NODEFAULT);	
					SetVolume(ID_WAV_VOLUME, ID_SUB_VOLUME);
					M_MOUSE_LBUTTON = FALSE;
					break;
				}
			}
		}
	}

}





//////  ׸
void	Stage_DrawItem(void)
{
	// ݶ
	if(COOR_COKE.life == TRUE)
	{
		if(FrameSkip(12, 900)) COOR_COKE.sn++;
		if(COOR_COKE.sn > 11) COOR_COKE.sn = 0;
		PutSpr(COOR_COKE.sx, COOR_COKE.sy, &ITEM[ID_ITEMCOKE_SPRNUM + COOR_COKE.sn], ID_S);
	}

	// 
	if(COOR_SKEY.life == TRUE)
	{
		if(FrameSkip(13, 900)) COOR_SKEY.sn++;
		if(COOR_SKEY.sn > 11) COOR_SKEY.sn = 0;
		PutSpr(COOR_SKEY.sx, COOR_SKEY.sy, &ITEM[ID_ITEMSKEY_SPRNUM + COOR_SKEY.sn], ID_S);
	}

	// ݿ
	if(COOR_GKEY.life == TRUE)
	{
		if(FrameSkip(14, 900)) COOR_GKEY.sn++;
		if(COOR_GKEY.sn > 11) COOR_GKEY.sn = 0;
		PutSpr(COOR_GKEY.sx, COOR_GKEY.sy, &ITEM[ID_ITEMGKEY_SPRNUM + COOR_GKEY.sn], ID_S);
	}

	// Ƚ
	for(int i=0; i<5; i++)
	{
		int x, y;
		static int sn[5];

		x = ID_ITEMFIRE_DATA[M_STAGE_NUM][i][0];
		y = ID_ITEMFIRE_DATA[M_STAGE_NUM][i][1];

		sn[i]++;
		if(sn[i] > 22) sn[i] = 0;

		PutSpr(x, y, &ITEM[ID_ITEMFIRE_SPRNUM + sn[i]], ID_S);
	}

}





////////////// ,  ˻
void	Stage_Check_NoaToItem(void)
{
	//// ݶ ˻ 
	if(COOR_COKE.life == TRUE)
	{
		if( (COOR_NOA.sx+12 < COOR_COKE.ex) && (COOR_COKE.sx < COOR_NOA.ex-12)
		 && (COOR_NOA.sy+30 < COOR_COKE.ey) && (COOR_COKE.sy < COOR_NOA.ey) )
		{
			COOR_COKE.life = FALSE;
			M_ITEM01_COUNT++;
		}
	}

	////  ˻ 
	if(COOR_SKEY.life == TRUE)
	{
		if( (COOR_NOA.sx+12 < COOR_SKEY.ex) && (COOR_SKEY.sx < COOR_NOA.ex-12)
		 && (COOR_NOA.sy+30 < COOR_SKEY.ey) && (COOR_SKEY.sy < COOR_NOA.ey) )
		{
			COOR_SKEY.life = FALSE;
			M_ITEM02_COUNT++;
		}
	}

	////   ˻ 
	if(COOR_GKEY.life == TRUE)
	{
		if( (COOR_NOA.sx+12 < COOR_GKEY.ex) && (COOR_GKEY.sx < COOR_NOA.ex-12)
		 && (COOR_NOA.sy+30 < COOR_GKEY.ey) && (COOR_GKEY.sy < COOR_NOA.ey) )
		{
			sndPlaySound(ID_SOUND_FILENAME[5], SND_ASYNC | SND_NODEFAULT);	
	
			COOR_GKEY.life = FALSE;
			M_FINAL_VIEW   = TRUE;
		}
	}


	//// °() ˻ ( Ŭ κ....)
	if(M_FINAL_VIEW == TRUE && COOR_FINAL.life == TRUE)
	{
		if( (COOR_NOA.sx+12 < COOR_FINAL.ex-6) && (COOR_FINAL.sx+6 < COOR_NOA.ex-12)
	     && (COOR_NOA.sy+30 < COOR_FINAL.ey) && (COOR_FINAL.sy+20 < COOR_NOA.ey) )
		{
			M_SCREEN_FADE   = ID_FADE_OUT;
			M_GAME_STATE    = TRUE;
			COOR_FINAL.life = FALSE;
			M_STAGE_END     = TRUE;
		}
	}
		


}




/////////  ̵ ˻  Ұ  浹˻ 
void	Stage_CheckFire(void)
{
	///////  01   Ѵ
	for(int a=0; a<ID_STAGE_DATA[M_STAGE_NUM][ID_MON01_NUM]; a++)	//  01   Ѵ
	{
		for(int aa=0; aa<COOR_MON01[a].firenum; aa++)               //  Ϳ     
		{
			///////  ̵ ˻ 
			for(int i=0; i<backmapnum; i++)
			{
				switch(BACKMAP[i].att)     
				{
				case ID_MAP_WALL:			//  ̵ ˻翡  ˻Ѵ
					if( (COOR_FIRE[a][aa].sx < BACKMAP[i].ex) && (BACKMAP[i].sx < COOR_FIRE[a][aa].ex)
					&& (COOR_FIRE[a][aa].sy < BACKMAP[i].ey) && (BACKMAP[i].sy < COOR_FIRE[a][aa].ey) )
					{
						COOR_FIRE[a][aa].life = FALSE;
						COOR_MON01[a].firecount++;
						if(COOR_MON01[a].firecount > COOR_MON01[a].firenum) 
						{
							COOR_MON01[a].firecount = COOR_MON01[a].firenum;
						}

						switch(COOR_FIRE[a][aa].coor)
						{
						case ID_RIGHT:
							COOR_FIRE[a][aa].sx    = COOR_MON01[a].sx + ID_FIRE_XSIZE;
							COOR_FIRE[a][aa].sy    = COOR_MON01[a].sy + ID_MON01_YSIZE/2;
							COOR_FIRE[a][aa].att   = IDM01_RFIRE0_SPRNUM;
							break;
						case ID_LEFT:
							COOR_FIRE[a][aa].sx    = COOR_MON01[a].sx;
							COOR_FIRE[a][aa].sy    = COOR_MON01[a].sy + ID_MON01_YSIZE/2;
							COOR_FIRE[a][aa].att   = IDM01_LFIRE0_SPRNUM;
							break;
						}
					}
					break;
				}
			}
		


			///////   浹˻ (Ȧ ö  ʴ´...)
			if(COOR_FIRE[a][aa].life == TRUE && M_HOLE_OUTSW == FALSE)
			{
				if( (COOR_NOA.sx+12 < COOR_FIRE[a][aa].ex-3) && (COOR_FIRE[a][aa].sx+3 < COOR_NOA.ex-12)
			     && (COOR_NOA.sy+30 < COOR_FIRE[a][aa].ey-1) && (COOR_FIRE[a][aa].sy+1 < COOR_NOA.ey) )
				{
					COOR_FIRE[a][aa].life = FALSE;
					COOR_MON01[a].firecount++;
					if(COOR_MON01[a].firecount > COOR_MON01[a].firenum) 
					{
						COOR_MON01[a].firecount = COOR_MON01[a].firenum;
					}
	
					switch(COOR_FIRE[a][aa].coor)
					{
					case ID_RIGHT:
						COOR_FIRE[a][aa].sx    = COOR_MON01[a].sx + ID_FIRE_XSIZE;
						COOR_FIRE[a][aa].sy    = COOR_MON01[a].sy + ID_MON01_YSIZE/2;
						COOR_FIRE[a][aa].att   = IDM01_RFIRE0_SPRNUM;
						break;
					case ID_LEFT:
						COOR_FIRE[a][aa].sx    = COOR_MON01[a].sx;
						COOR_FIRE[a][aa].sy    = COOR_MON01[a].sy + ID_MON01_YSIZE/2;
						COOR_FIRE[a][aa].att   = IDM01_LFIRE0_SPRNUM;
						break;
					}
				
					COOR_NOA.life = FALSE;

				}
			}
		}
	}





	///////  06   Ѵ
	for(int b=0; b<ID_STAGE_DATA[M_STAGE_NUM][ID_MON06_NUM]; b++)	//  06   Ѵ
	{
		for(int bb=0; bb<COOR_MON06[b].firenum; bb++)               //  Ϳ     
		{
			/////// ĵ ̵ ˻ 
			for(int i=0; i<backmapnum; i++)
			{
				switch(BACKMAP[i].att)     
				{
				case ID_MAP_WALL:			// ĵ ̵ ˻翡  ˻Ѵ
					if( (COOR_CANFIRE[b][bb].sx < BACKMAP[i].ex) && (BACKMAP[i].sx < COOR_CANFIRE[b][bb].ex)
					&& (COOR_CANFIRE[b][bb].sy < BACKMAP[i].ey) && (BACKMAP[i].sy < COOR_CANFIRE[b][bb].ey) )
					{
						COOR_CANFIRE[b][bb].life = FALSE;
						COOR_MON06[b].firecount++;
						if(COOR_MON06[b].firecount > COOR_MON06[b].firenum) 
						{
							COOR_MON06[b].firecount = COOR_MON06[b].firenum;
						}
	
						switch(COOR_CANFIRE[b][bb].coor)
						{
						case ID_RIGHT:
							COOR_CANFIRE[b][bb].sx    = COOR_MON06[b].sx; 
							COOR_CANFIRE[b][bb].sy    = COOR_MON06[b].sy + ID_MON06_YSIZE-ID_CANFIRE_YSIZE;
							COOR_CANFIRE[b][bb].att   = IDM06_LROLE_SPRNUM;
							break;
						case ID_LEFT:
							COOR_CANFIRE[b][bb].sx    = COOR_MON06[b].sx + ID_MON06_XSIZE-ID_CANFIRE_XSIZE;
							COOR_CANFIRE[b][bb].sy    = COOR_MON06[b].sy + ID_MON06_YSIZE-ID_CANFIRE_YSIZE;
							COOR_CANFIRE[b][bb].att   = IDM06_RROLE_SPRNUM;
							break;
						}
					}
					break;
				}
			}
		


			/////// ĵ  浹˻ (Ȧ ö  ʴ´...)
			if(COOR_CANFIRE[b][bb].life == TRUE && M_HOLE_OUTSW == FALSE)
			{
				if( (COOR_NOA.sx+12 < COOR_CANFIRE[b][bb].ex-3) && (COOR_CANFIRE[b][bb].sx+3 < COOR_NOA.ex-12)
			     && (COOR_NOA.sy+30 < COOR_CANFIRE[b][bb].ey) && (COOR_CANFIRE[b][bb].sy+5 < COOR_NOA.ey) )
				{
					COOR_CANFIRE[b][bb].life = FALSE;
					COOR_MON06[b].firecount++;
					if(COOR_MON06[b].firecount > COOR_MON06[b].firenum) 
					{
						COOR_MON06[b].firecount = COOR_MON06[b].firenum;
					}
					switch(COOR_CANFIRE[b][bb].coor)
					{
					case ID_RIGHT:
						COOR_CANFIRE[b][bb].sx    = COOR_MON06[b].sx; 
						COOR_CANFIRE[b][bb].sy    = COOR_MON06[b].sy + ID_MON06_YSIZE-ID_CANFIRE_YSIZE;
						COOR_CANFIRE[b][bb].att   = IDM06_LROLE_SPRNUM;
						break;
					case ID_LEFT:
						COOR_CANFIRE[b][bb].sx    = COOR_MON06[b].sx + ID_MON06_XSIZE-ID_CANFIRE_XSIZE;
						COOR_CANFIRE[b][bb].sy    = COOR_MON06[b].sy + ID_MON06_YSIZE-ID_CANFIRE_YSIZE;
						COOR_CANFIRE[b][bb].att   = IDM06_RROLE_SPRNUM;
						break;
					}
				
/*   */			COOR_NOA.sx = ID_NOA_DATA[M_STAGE_NUM][0];
					COOR_NOA.sy = ID_NOA_DATA[M_STAGE_NUM][1];
					COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
					COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;
				}
			}
		}
	}





}




/////////// ̽ Ȧ ׸
void	Stage_DrawHole(void)
{
	for(int h=0; h<ID_MAX_STAGEHOLENUM[M_STAGE_NUM]; h++)
	{
		if(FrameSkip(90+h, 1600)) COOR_HOLE[h].sn++;
		if(COOR_HOLE[h].sn > 15) 
		{
			if(COOR_HOLE[h].move == TRUE)
			{
				COOR_HOLE[h].att  = ID_SHOLE_SPRNUM;
				COOR_HOLE[h].move = FALSE;

				COOR_NOA.sx = COOR_NOA.newx;            //   ǥ ű.
				COOR_NOA.sy = COOR_NOA.newy;
				COOR_NOA.ex = COOR_NOA.sx + ID_NOA_XSIZE;
				COOR_NOA.ey = COOR_NOA.sy + ID_NOA_YSIZE;
				COOR_NOA.hole = FALSE;

				M_HOLE_OUTSW = TRUE;   // Ȧ ö ġ  

			}

			COOR_HOLE[h].sn = 0;
		}


		if(COOR_HOLE[h].move == TRUE)
		{
			switch(COOR_NOA.coor)
			{
			case ID_RIGHT:
				COOR_HOLE[h].att = ID_RHOLE_SPRNUM;
				break;
			case ID_LEFT:
				COOR_HOLE[h].att = ID_LHOLE_SPRNUM;
				break;
			}
		}

		PutSpr(COOR_HOLE[h].sx, COOR_HOLE[h].sy, 
			&HOLE[COOR_HOLE[h].att + COOR_HOLE[h].sn], ID_N);
	}
}




//////// ð ˻ 
void Stage_TimeCheck(void)
{
	if(FrameSkip(1000, 100)) M_CURRENT_TIMECOUNT++;
}




////////////////  Ŭ ....
void Stage_Ending(void)
{
	int a, b;

	int x1 = 200, y1 = 100;		//  ð  ǥ
	int x2 = 200, y2 = 200;		// ְ ð  ǥ
	int dif = 100;				// а   Ÿ

	if(M_CURRENT_TIMECOUNT < M_BEST_TIMECOUNT) M_BEST_TIMECOUNT = M_CURRENT_TIMECOUNT;

	//  ð 
	M_CURRENT_MINUTE = M_CURRENT_TIMECOUNT/60;
	M_CURRENT_SECOND = M_CURRENT_TIMECOUNT%60;

	// ְ ð 
	M_BEST_MINUTE = M_BEST_TIMECOUNT/60;
	M_BEST_SECOND = M_BEST_TIMECOUNT%60;

	/////////////////////////////////
	ActivePage(page0);
	ClearPage(0);

	// ð ()
	a = M_CURRENT_MINUTE/10;
	b = M_CURRENT_MINUTE%10;
	
	PutSpr(x1,      y1, &NUMBER[a], ID_S);
	PutSpr(x1 + 32, y1, &NUMBER[b], ID_S);

	// ð ()
	a = M_CURRENT_SECOND/10;
	b = M_CURRENT_SECOND%10;
	
	PutSpr(x1 + dif,      y1, &NUMBER[a], ID_S);
	PutSpr(x1 + dif + 32, y1, &NUMBER[b], ID_S);

	// ְð ()
	a = M_BEST_MINUTE/10;
	b = M_BEST_MINUTE%10;
	
	PutSpr(x2,      y2, &NUMBER[a], ID_S);
	PutSpr(x2 + 32, y2, &NUMBER[b], ID_S);


	// ְð ()
	a = M_BEST_SECOND/10;
	b = M_BEST_SECOND%10;
	
	PutSpr(x2 + dif,      y2, &NUMBER[a], ID_S);
	PutSpr(x2 + dif + 32, y2, &NUMBER[b], ID_S);


	if(M_ENTER_KEY == TRUE) M_SCREEN_FADE = ID_FADE_OUT;

	switch(M_SCREEN_FADE)
	{
	case ID_FADE_OUT:			// ȭ ο
		if(ScreenFadeOut()) 
		{
			M_SCREEN_FADE = ID_FADE_NOR;

			M_CHECK_MAINGMAE = ID_STAGE_CLOSE;

			M_ENTER_KEY = FALSE;

			M_CHECK_MAINGMAE = ID_STAGE_CLOSE;
		}
		break;

	case ID_FADE_IN:			// ȭ 
		if(ScreenFadeIn()) 
		{
			M_SCREEN_FADE = ID_FADE_NOR;
		}
		break;
	}


	ViewScreen();
	//////////////////////////////////////////
}
		
	



/////  ...
void Stage_NoaDieScreen(void)
{
	static int count = 0;
	
	static BOOL sw = FALSE;

	/////////////////////////////////
	ActivePage(page0);
	ClearPage(0);
	

	PutSpr(0, 0, &NOADIE[0], ID_BN);

	if(M_SCREEN_FADE == ID_FADE_NOR && sw == FALSE) 
	{
		sndPlaySound(ID_SOUND_FILENAME[1], SND_ASYNC | SND_NODEFAULT);	
		sw = TRUE;
	}

	if(FrameSkip(900, 100) && M_SCREEN_FADE == ID_FADE_NOR) count++;

	if(count == 3)
	{
		count = 0;

		M_SCREEN_FADE = ID_FADE_OUT;
	}
	
	switch(M_SCREEN_FADE)
	{
	case ID_FADE_OUT:			// ȭ ο
		if(ScreenFadeOut()) 
		{
			M_SCREEN_FADE = ID_FADE_IN;

			M_CHECK_MAINGMAE = ID_STAGE_INIT;

			sw = FALSE;
		}
		break;

	case ID_FADE_IN:			// ȭ 
		if(ScreenFadeIn()) 
		{
			M_SCREEN_FADE = ID_FADE_NOR;
		}
		break;
	}



	ViewScreen();				
	///////////////////////////////////////
}





//////////////////////////////////////
//  ...
//////////////////////////////////////
void Stage_PlayGame( void )
{
	// ð ˻
	if(M_STAGE_END == FALSE) Stage_TimeCheck();


	/////////////////////////////////
	ActivePage(page0);
	ClearPage(0);

	/////////// ۾  ///////////
	//////  ׸
	Stage_DrawBack();

	////// ̽ Ȧ(̵ ) ׸ 
	Stage_DrawHole();
	
	
	////// °  Ʈ 
	Stage_DrawFinal();


	
	//////  ׸
	Stage_DrawItem();

	////// ,  浹 ˻ 
	Stage_Check_NoaToItem();


	
	
	//////  ̵ üũ 
	Stage_CheckMonLoad();

	//////   üũ 
	Stage_CheckMonMove();
	
    //////  ׸   ׸
	Stage_DrawMon();





	
	
	if(M_JUMP == FALSE) 
	{
		//  
		Stage_DownNoa();
	}
	

	//////  ̽Ȧ ˻  
	if(COOR_NOA.hole == FALSE) 
	{
		Stage_CheckHole();
	}

	if(M_NOA_STOP == TRUE && M_JUMP == FALSE) 
	{
		Stage_StopNoaSpr();
	}
	else 
	{
		switch(M_HOLE_OUTSW)     // Ȧ ö...
		{
		case TRUE:
			////// Ȧ ö  ˻ 
			if(M_STAGE_END == FALSE) Stage_HoleOut();
			break;

		case FALSE:
			//////   ˻
			if(M_STAGE_END == FALSE) Stage_CheckNoaMove();
			break;
		}
	}

	//////  ̵ ˻ 
	Stage_CheckNoa();




	/////  ̵  ˻  ƿ 浹˻ 
	if(M_STAGE_END == FALSE) Stage_CheckFire();

	////// ,  浹 ˻ (Ȧ ö  ʴ´...)
	if(M_HOLE_OUTSW == FALSE && M_STAGE_END == FALSE) Stage_Check_NoaToMon();

	//////  ׸
	if(COOR_NOA.life == TRUE) Stage_DrawNoa();




	/////////////////////////////////////// ׾...
	if(COOR_NOA.life == FALSE)
	{
		M_SCREEN_FADE = ID_FADE_OUT;
	}




	// ...............!!!!!!!!! ߿ ٲ...//////////////
	PutPixel(M_XPOS, M_YPOS, 15);			

	static int a, b;

	a = (M_STAGE_NUM+1)/10;
	b = (M_STAGE_NUM+1)%10;
	
	PutSpr(0,  0, &NUMBER[a], ID_S);
	PutSpr(32, 0, &NUMBER[b], ID_S);
	//////////////////////////////////////////////////////////// 





	switch(M_SCREEN_FADE)
	{
	case ID_FADE_OUT:			// ȭ ο
		if(ScreenFadeOut()) 
		{
			M_SCREEN_FADE = ID_FADE_IN;

			switch(COOR_NOA.life)
			{
			case TRUE:
				M_CHECK_MAINGMAE = ID_STAGE_ENDING;
				break;

			case FALSE:
				M_CHECK_MAINGMAE = ID_NOA_DIESCREEN;
				break;
			}
		}
		break;

	case ID_FADE_IN:			// ȭ 
		if(ScreenFadeIn()) 
		{
			M_SCREEN_FADE = ID_FADE_NOR;
		}
		break;
	}




	// ȭ 
	ViewScreen();
	/////////////////////////////////////////

	
	//  
	Stage_SoundCheck();

}





#endif

