///////////////////////////////////////////////////////////////////
// WINKGL.CPP ( TO LIBRARY )                      KYONGEUN
///////////////////////////////////////////////////////////////////

#include "winkgl.h"
//////////////////////////
// winkgl.cpp header file
//////////////////////////

LPSTR SpriteID  = "WinKGL Sprite Header. [ Ver 1.1 ]";   // .spr ȭ (33 byte)
LPSTR PaletteID = "WinKGL Palette Header. [ Ver 1.1 ]";  // .pal ȭ (34 byte)
LPSTR MapID     = "WinKGL Map Header. [ Ver 1.1 ]";      // .map ȭ (30 byte)


HWND			M_WINKHWND = NULL;
HDC				M_WINKHDC  = NULL;

PALETTEENTRY    *M_SCREENPAL;         //  ȷƮ
SCREENVIEW		M_CLIPWINDOW;         //  Ŭ ü
char			M_SAVEMESSAGE[80];    //  ޼  迭 
POINT			M_OLDIMMPOS;          // / ڰ  ִ ġ

LPBYTE			M_SCREENPAGE       = NULL;   //  ޸() 
BYTE			M_TRANSCOLOR       = 0;      // Ʈ   
int				M_OLDSCREENWIDTH   = 0;
int				M_OLDSCREENHEIGHT  = 0;

LPBYTE		    BBuffer			 = NULL;     // ⺻ ۷ Ѵ.
DWORD		    BBImage			 = NULL;     // Ÿ  ̹ ũ⸦ Ÿ. 
DWORD			BBDataSize 		 = 0;        // ü Ÿ ũ⸦ Ÿ.
HPALETTE		BBPalette		 = NULL;     // ⺻ ȷƮ ü ȴ. 

BOOL            M_FULLSCREEN	 = TRUE;

BYTE            M_WINKDEFAULTPAL[768];		 // ⺻ ȷƮ 迭 


/*********************************************************************************************/

void ViewScreen( HDC hdc )
{
	//  Ʈ ؽƮ ´.
	M_WINKHDC = hdc;

	HPALETTE hOldPalette;

	if( IsBBuff() == FALSE ) return;

//	if( BBPalette != NULL )      // 256 Į
//	{
		hOldPalette = SelectPalette( M_WINKHDC, BBPalette, FALSE);
		RealizePalette(M_WINKHDC);

		SetDIBitsToDevice( M_WINKHDC, 0,0,BBufferWidth(),BBufferHeight(), 
			0,BBufferHeight(),BBufferHeight(),BBufferHeight(), 
			BBPointer(), (BITMAPINFO*)BBuffer, DIB_RGB_COLORS );

		SelectPalette(M_WINKHDC, hOldPalette, FALSE);
		ReleaseDC(NULL, M_WINKHDC);
//	}

}






/*
void ViewScreen( HDC hdc )
{
	M_WINKHDC = hdc;

	HDC      hMemDC;
	HPALETTE hOldPalette;
	HANDLE   OldBitMap;
	HANDLE   hBBuffer;
	BITMAP   BitMap;

	if( IsBBuff() == FALSE ) return;

//	if( BBPalette != NULL )      // 256 Į
//	{
		hOldPalette = SelectPalette( M_WINKHDC, BBPalette, FALSE);
		RealizePalette(M_WINKHDC);

		hBBuffer = CreateDIBitmap(M_WINKHDC, (BITMAPINFOHEADER*)BBuffer, CBM_INIT, BBPointer(), 
			(BITMAPINFO*)BBuffer, DIB_RGB_COLORS);
			             		
		hMemDC = CreateCompatibleDC(M_WINKHDC);  
		GetObject(hBBuffer, sizeof(BITMAP), &BitMap);
		OldBitMap = SelectObject(hMemDC, hBBuffer);

		BitBlt(M_WINKHDC, 0, 0, BBufferWidth(), BBufferHeight(), hMemDC, 0, 0, SRCCOPY);

		SelectPalette(M_WINKHDC, hOldPalette, FALSE);
		ReleaseDC(NULL, M_WINKHDC);

		SelectObject(hMemDC, OldBitMap);

		DeleteObject(hBBuffer);
		DeleteDC(hMemDC);
		ReleaseDC(NULL, M_WINKHDC);
//	}

}

*/


void CloseWinKGL( void  )
{
	if( IsBBuff() )
	{
		GlobalFreePtr(BBuffer);

		if( BBPalette != NULL ) DeleteObject( BBPalette );
		
		BBPalette  = NULL;
		
		BBuffer    = NULL;
		BBImage    =    0;
		BBDataSize =    0;
	}		

	if(M_SCREENPAGE != NULL) M_SCREENPAGE = NULL;

	ChangeDispMode(M_OLDSCREENWIDTH, M_OLDSCREENHEIGHT);     // ص ȭ  ȯѴ.
	// ==> ChangeDispMode(0, 0);

	FreePalette();

	ShowImmBox();
}


BOOL InitWinKGL ( HWND hwnd )
{
	M_WINKHWND = hwnd;

	CloseWinKGL();        // ޸𸮸 Ѵ.

	GetRealDispMode();    //  ȭ 带  д.

	if(M_FULLSCREEN == TRUE)              // ȭ Full Screen  ̸...
	{
		ChangeDispMode(ID_WINKSIZEX, ID_WINKSIZEY);  // ȭ 带 Ѵ.
	}

	SetClip(0, 0, ID_WINKSIZEX, ID_WINKSIZEY);       // Ȱ ȭũ⸦ Ѵ. 

	
	// 256 color
	BBImage = 256L*sizeof(PALETTEENTRY)+sizeof(BITMAPINFOHEADER);  
	//  ̹  ȷƮ κ ũ⸦ Ѵ.

    BBDataSize = ID_WINKSIZEX * ID_WINKSIZEY + BBImage ;
	//  ̹ ũ⸦  ü Ÿ ũ⸦ Ѵ.
	
	BBuffer = (LPBYTE) GlobalAllocPtr(GHND, BBDataSize); 
	// Ÿ ũ⸸ŭ ޸𸮸 ȮѴ.
	
	if (BBuffer == NULL) return FALSE;

	memset(BBuffer, 0, BBDataSize);
	// ޸𸮸  0 ä.(Clear)

	((BITMAPINFOHEADER*) BBuffer)->biSize = sizeof(BITMAPINFOHEADER);
	((BITMAPINFOHEADER*) BBuffer)->biHeight = -ID_WINKSIZEY;   
	((BITMAPINFOHEADER*) BBuffer)->biWidth = ID_WINKSIZEX;
	((BITMAPINFOHEADER*) BBuffer)->biPlanes = 1;
	
    // 256 color
	((BITMAPINFOHEADER*) BBuffer)->biBitCount = 8;
	
	((BITMAPINFOHEADER*) BBuffer)->biCompression = BI_RGB;
	
    M_SCREENPAL = BBufferPalette();    //  ȷƮ ͸ Ѵ.

	HideImmBox();

	return TRUE;
}



///////////////////////////////
// ȭ 带 ٲ۴.
///////////////////////////////
BOOL ChangeDispMode(int ScreenWidth, int ScreenHeight)
{
	int BitsPerPel;      //  ϰִ ȼ Ʈ( )

	DEVMODE devmode;     // ġ  ü
	BOOL result;

	LONG value;

	//  ǰ ִ  ´.
	BitsPerPel = GetDeviceCaps(M_WINKHDC, BITSPIXEL); 
	
	// ġ  ü DEVMODE ʱⰪ о´.
	result = EnumDisplaySettings(NULL, 0, &devmode);

	if( result )
	{   
		// ȭ尪 ʱȭ Ѵ.
		devmode.dmPelsWidth  = ScreenWidth;
		devmode.dmPelsHeight = ScreenHeight;
		devmode.dmBitsPerPel = BitsPerPel;
		devmode.dmFields     = DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// ȭ ʱȭ  ٲ۴.
		value = ChangeDisplaySettings(&devmode, 0);
        	
        /*********************************************************************
		DISP_CHANGE_SUCCESSFUL : ׷  ÿ .
		DISP_CHANGE_RESTART    : ٲ 带 ϱؼ ǻ͸ 
		                           ؾ Ѵ.
		DISP_CHANGE_BADFLAGS   : 
		DISP_CHANGE_FAILED     : ׷   .
		DISP_CHANGE_BADMODE    : ׷ 带  ʴ´.
		DISP_CHANGE_NOTUPDATED : ׷ 带    .( NT )
        **********************************************************************/
		
		if(value != DISP_CHANGE_SUCCESSFUL)
		{
			sprintf(M_SAVEMESSAGE, "׷   ߽ϴ...^^;");
			return FALSE;
		}
		

		return TRUE;
	}
	else
	{
	  sprintf(M_SAVEMESSAGE, "׷ 带 ٲ  ϴ...^^;");
	  return FALSE;
	}

} 


///////////////////////////////////////////////////
//   ׷  ũ⸦ ´.
///////////////////////////////////////////////////
void GetRealDispMode(void)
{
  M_OLDSCREENWIDTH  = GetDeviceCaps(M_WINKHDC, HORZRES); 
  M_OLDSCREENHEIGHT = GetDeviceCaps(M_WINKHDC, VERTRES); 
}


/*********************************************************************************************/



void SetClip(int sx, int sy, int ex, int ey)
{
 M_CLIPWINDOW.sx = sx;          ///////////////////////////////////////
 M_CLIPWINDOW.sy = sy;          // Ŭ  ü  
 M_CLIPWINDOW.ex = ex-1;        // ʱȭ Ѵ.
 M_CLIPWINDOW.ey = ey-1;        ///////////////////////////////////////
}



void HideImmBox(void)
{
	HIMC himc = ImmGetContext(M_WINKHWND);      //   ڵ ´. 
	ImmGetStatusWindowPos(himc, &M_OLDIMMPOS);  // / ȯ   ġ Ѵ.
	POINT temppos = { -100, -100 };             // ų ġ ʱȭ Ѵ. 
	ImmSetStatusWindowPos(himc, &temppos);      // / ȯ  ġ ű.
}



void ShowImmBox(void)
{
	HIMC himc = ImmGetContext(M_WINKHWND);
	ImmSetStatusWindowPos(himc, &M_OLDIMMPOS);  // / ȯ  ġ Ѵ.
}


/********************************************************************************************/

////////////////////////////////////
// ۾  ޸𸮸 .
////////////////////////////////////
LPBYTE CreateMemory(int size)
{
 LPBYTE temppage;

 if((temppage=(LPBYTE)GlobalAllocPtr(GHND, size)) == NULL) 
 {
	 sprintf(M_SAVEMESSAGE, "޸𸮰 մϴ...^^;");
	 return FALSE;
 }

 return temppage;
}


//////////////////////////////////////
//  ޸𸮸 Ѵ.
//////////////////////////////////////
void FreeMemory(LPBYTE page)
{
	GlobalFreePtr(page);
}


/////////////////////////////////////
// ۾ ޸𸮷 Ȱȭ Ų.
/////////////////////////////////////
void ActivePage(LPBYTE page)
{
	page = BBPointer();
    M_SCREENPAGE = page;
}


/*********************************************************************************************/


BOOL LoadPcx(LPBYTE page, LPSTR filename, LPBYTE pal)
{
     FILE *fp;
     int num = 0, i = 0;
     int count = 0, offset = 0, bank = 1, imagesize = 0;
     BYTE color;
	 
     fp = fopen(filename, "rb");
     ////////////////////////////////////
     // б  ȭ о δ.
     ////////////////////////////////////

	 if(fp == NULL)
	 {
	   wsprintf(M_SAVEMESSAGE, "%s ȭ ϴ...^^;", filename);
	   return FALSE;
	 }

     if(fgetc(fp) != 0x0a)  {     // PCX ȭ ˻Ѵ.
       fclose(fp);                // ȭ ù° 1byte 0x0a̸ PCX ȭ̴. 
	   wsprintf(M_SAVEMESSAGE, "%s ȭ PCX ȭ ƴմϴ.", filename);
       return FALSE;              
     }                            

                                  /////////////////////////////////////////////////////
     fseek(fp, -768, SEEK_END);   // ȷƮ ġ ̵
		                 		  // SEEK_END : ȭ ͸  ű.
			                	  // -768     : ȭ ͸ -768 byteŭ ̵Ѵ.
				                  //            ( 768 = 256 * 3 )
                                  /////////////////////////////////////////////////////
     fread(pal, 768, 1, fp);

     fseek(fp, 128, SEEK_SET);
     ///////////////////////////////////////////////////////
     // SEEK_SET : file pointer ó ̵Ѵ.
     // 128      : file pointer 128 byteŭ ̵Ѵ.
     //            ( 128 byte : PCX file header part )
     ///////////////////////////////////////////////////////
                             
     imagesize = ID_WINKSIZEX * ID_WINKSIZEY;  // imagesize ʱȭ Ѵ.

     while(count < imagesize) {
     /////////////////////////////////
     // imagesizeŭ  .
     /////////////////////////////////

       num = fgetc(fp);
       /////////////////////////////////////////////////////////////////////////////////
       //  ȭ Ϳ 1byte о num  ִ´.
       // fgetc() ==>  file pointer 1byte а, pointer 1byte Ų.
       /////////////////////////////////////////////////////////////////////////////////

       /////////////////////////////////////////////////////////////////////////////////
       //  ִ ˻Ѵ.
       // о 1byte(8 bit)߿  2Ʈ  ν̰,  6Ʈ
       // Ÿ ݺ Ƚ ̴.
       /////////////////////////////////////////////////////////////////////////////////
       if((num & 0xc0) == 0xc0)     // num 8Ʈ  2Ʈ 11 ˻Ѵ.
	   {            			    // ( 2Ʈ 11̸  ִٴ ǹ.)
          	 num = num & 0x3f;      // num  6Ʈ maskؼ Ÿ ݺ Ƚ
				                    // Ѵ.
         	 color = fgetc(fp);     //  о color ִ´. 
	   }                            ////////////////////////////////////////////////////
       else
       {                            ////////////////////////////////////////////////////
	         color = num;           //   , num data color ְ, 
	         num = 1;               // Ѱ  ϱ num 1 Ѵ.
       }                            ////////////////////////////////////////////////////

                                    ////////////////////////////////////////////////
       for(i = 0; i < num; i++) {   // Ÿ ݺ Ƚŭ ݺѴ.
	    *(page + offset) = color;   // ۾  ݺ Ƚŭ 򰪿 
				                	// ׸.
        count++;                    //  ȼ(pixel) ̵Ѵ.
	    offset++;                   // ۾   ȼ ̵Ѵ.
                                    ////////////////////////////////////////////////
	    }
       }

     fclose(fp);
     return TRUE;
}



BOOL LoadBmp(LPBYTE page, LPSTR filename, LPBYTE pal)
{
	FILE *fp;

    LPBYTE tempbuffer;			        // page ͸ Ѱܹ ۾ 

	int colorsw;				        // 256 color True color Ȯϴ ġ  

	BITMAPFILEHEADER BmpHeader;			// BMP ȭ ⺻  
	BITMAPINFOHEADER BmpInfoHeader;     // BMP ȭ  

	PALETTEENTRY *Palette;              // ȷƮ 

	fp = fopen(filename, "rb");         // ȭ б  .
	if(fp == NULL) 
	{
		wsprintf(M_SAVEMESSAGE, "%s ȭ   ϴ...^^;", filename);
		return FALSE;        // ϸ returnѴ.
	}
		
	fread(&BmpHeader,     1, sizeof(BITMAPFILEHEADER), fp);  // ȭ ⺻  κ д´.
	fread(&BmpInfoHeader, 1, sizeof(BITMAPINFOHEADER), fp);  // ȭ   κ д´.

	if(BmpHeader.bfType != 0x4d42)   // BMP ȭ ´ ˻Ѵ.(0x4d42 = 'MB')     
	{
		wsprintf(M_SAVEMESSAGE, "%s ȭ BMPȭ ƴմϴ...^^;", filename);
		fclose(fp);
		return FALSE;    
	}

    if(BmpInfoHeader.biSize != sizeof(BITMAPINFOHEADER)) 
	{
    	wsprintf(M_SAVEMESSAGE, "%s ȭ  HEADER ũⰡ ٸϴ...^^;", filename);
		fclose(fp);
		return FALSE;
        // ȭ   κ Ȯ  ˻Ѵ.	
	}

	if(BmpInfoHeader.biBitCount == 8) colorsw = 1;
	   else colorsw = 0;
    // ȷƮ 256̸ colorsw 1, True color̸ colorsw 0 ִ´.

    if(colorsw == 1)   // 256̸...
	{
		Palette = (PALETTEENTRY *)GlobalAllocPtr(GHND, sizeof(PALETTEENTRY)*256);
		// ȷƮ  ޸𸮸 ȮѴ.
		if(Palette == NULL)  
		{
	    	sprintf(M_SAVEMESSAGE, "ȷƮ  ޸𸮰 մϴ...^^;");
			fclose(fp);
			return FALSE;
		}

		fread(Palette, sizeof(PALETTEENTRY), 256, fp);
		// ȷƮ д´.

	    for(int i = 0; i < 256; i++, pal+=3)   // ȷƮ 迭 ȯѴ.( ϰ...)
    	 {
			pal[0] = Palette[i].peBlue  ; 
			pal[1] = Palette[i].peGreen ; 
		 	pal[2] = Palette[i].peRed   ; 
         } 

		GlobalFreePtr(Palette);     // Ȯ ޸𸮸  Ѵ.
	}

	if(page == NULL) 
	{
    	sprintf(M_SAVEMESSAGE, "׸  ޸𸮰 ϴ...^^;");
		fclose(fp);
		return FALSE;  // page ޸𸮰 ٸ returnѴ. 
	}

    tempbuffer = page + BmpInfoHeader.biWidth * BmpInfoHeader.biHeight;
	// ۾ ۿ ͸ ϰ,  ͸  ̵Ѵ.
	// (̹ Ųٷ Ǿֱ ...)
	tempbuffer -=  BmpInfoHeader.biWidth;
	//  Ͱ  ù° ̵Ѵ.

	for(int i=0; i<BmpInfoHeader.biHeight; i++)
	{
		fread(tempbuffer, BmpInfoHeader.biWidth, 1, fp);
    	tempbuffer -=  BmpInfoHeader.biWidth;
	}
	// ̹ ʹ  (Line) ϰ, ۾  ʹ 
	//  ξ Ѵ.
	// (Ųٷε ̹ ٷ Ѵ.)
	
	fclose(fp);

	return TRUE;
	
}




/*********************************************************************************************/


int LoadSpr(SPRITE *spr, LPSTR filename, LPBYTE pal)
{
 FILE *fp;
 BYTE id[34];
 int sprnum;

 if((fp = fopen(filename, "rb")) == NULL) 
 {
	wsprintf(M_SAVEMESSAGE, "%s ȭ   ϴ...^^;", filename);
	return FALSE;				     // ϸ returnѴ.
 }

 fseek(fp, -4, SEEK_END);            // ȭ ͸ ȭ  -4Ʈŭ ̵Ѵ.
 fread(&sprnum, 4, 1, fp);           // sprnum  Ʈ  о´.

 fseek(fp, 0, SEEK_SET);             // ȭ ͸ ó ű.
 fread(id, 33, 1, fp);               // 33Ʈŭ SpriteID о´.
 id[33] = '\0';

 if(strcmp((LPSTR)id, SpriteID) != 0)       // Ʈ ȭ ´ ˻Ѵ.
 {
	wsprintf(M_SAVEMESSAGE, "%s ȭ Ʈ ȭ ƴմϴ...^^;", filename);
	fclose(fp);
	return FALSE;
 }

 fread(pal, 768, 1, fp);               // ȷƮ о´.

 for(int i=0; i<sprnum; i++)           // Ʈ ŭ Ÿ о´.
 {
	fread(&spr[i].num, 4, 1, fp);      // Ʈ ȣ 4Ʈ
	fread(&spr[i].xs, 4, 1, fp);       // Ʈ  ũ 4Ʈ
	fread(&spr[i].ys, 4, 1, fp);       // Ʈ  ũ 4Ʈ
	spr[i].img = CreateMemory(spr[i].xs*spr[i].ys);   // Ʈ ϱ ޸ Ȯ
	fread(spr[i].img, spr[i].xs*spr[i].ys, 1, fp);    // ũ⸸ŭ Ʈ о´.
 }

 fclose(fp);          // ȭ ݴ´.
 return sprnum;       //  Ʈ  ǵ.
}



void PutSpr(int x, int y, SPRITE *spr, int mode)
{
	PutImage(x, y, spr->xs, spr->ys, spr->img, mode);  // x, yġ Ʈ 
}


void FreeLoadSpr(int sn, int en, SPRITE *spr)
{
    for(int i=sn; i<en; i++) FreeMemory(spr[i].img);   // ʿ Ʈ ޸ 
}



void FreeSpr(SPRITE *spr, int num)
{
	FreeLoadSpr(0, num, spr);                          //  Ʈ ޸ 
}



/*********************************************************************************************/


BOOL LoadPal(LPBYTE pal, LPSTR filename)
{
	FILE *fp;
	BYTE id[35];

	if((fp = fopen(filename, "rb")) == NULL) 
	{
		wsprintf(M_SAVEMESSAGE, "%s ȭ   ϴ...^^;", filename);
		return FALSE;                         // ϸ returnѴ.
	}


	fread(id, 34, 1, fp);                     // 34Ʈŭ PaletteID о´.
	id[34] = '\0';

	if(strcmp((LPSTR)id, PaletteID) != 0)     // ȷƮ ȭ ´ ˻Ѵ.
	{
		wsprintf(M_SAVEMESSAGE, "%s ȭ ȷƮ ȭ ƴմϴ...^^;", filename);
		fclose(fp);
		return FALSE;
	 }

	fread(pal, 768, 1, fp);                   // ȷƮ о´.


	fclose(fp);

	return TRUE;
}




/*********************************************************************************************/

int LoadMap(MAP *map, LPSTR filename)
{
 FILE *fp;
 BYTE id[31];
 int mapnum;

 if((fp = fopen(filename, "rb")) == NULL) 
 {
	wsprintf(M_SAVEMESSAGE, "%s ȭ   ϴ...^^;", filename);
	return FALSE;        // ϸ returnѴ.
 }

 fseek(fp, -4, SEEK_END);            // ȭ ͸ ȭ  -4Ʈŭ ̵Ѵ.
 fread(&mapnum, 4, 1, fp);           // mapnum  Ʈ  о´.

 map[mapnum];

 fseek(fp, 0, SEEK_SET);             // ȭ ͸ ó ű.
 fread(id, 30, 1, fp);               // 30Ʈŭ MapID о´.
 id[30] = '\0';

 if(strcmp((LPSTR)id, MapID) != 0)   //  ȭ ´ ˻Ѵ.
 {
	wsprintf(M_SAVEMESSAGE, "%s ȭ  ȭ ƴմϴ...^^;", filename);
	fclose(fp);
	return FALSE;
 }

 for(int i=0; i<mapnum; i++)         //  ŭ Ÿ о´.
 {
	fread(&map[i].num, 4, 1, fp);    //  ȣ 4Ʈ
	fread(&map[i].sx,  4, 1, fp);    //  ,   ǥ ũ 4Ʈ
	fread(&map[i].sy,  4, 1, fp);  
	fread(&map[i].ex,  4, 1, fp);    //  ,   ǥ ũ 4Ʈ
	fread(&map[i].ey,  4, 1, fp);  
	fread(&map[i].att, 4, 1, fp);    //  Ӽ ũ 4Ʈ
 }

 fclose(fp);          // ȭ ݴ´.

 return mapnum;       //    ǵ.
}



/*********************************************************************************************/

//////////////////////
//   ׸
//////////////////////
void PutWLine(int x, int y, int w, BYTE color)
{
	for(int i=0; i<w; i++) 
	{
		PutPixel(x+i, y, color);
	}
}



//////////////////////
//   ׸
//////////////////////
void PutHLine(int x, int y, int h, BYTE color)
{
	for(int i=0; i<h; i++) 
	{
		PutPixel(x, y+i, color);
	}
}



///////////////////////
//  ׸
///////////////////////
void PutBox(int x, int y, int w, int h, BYTE color)
{
 PutWLine(x, y, w, color);
 PutHLine(x, y, h, color);

 PutWLine(x, y+h-1, w, color);
 PutHLine(x+w-1, y, h, color);
}




/////////////////////////////////////
// ۾  ̹ ׸.
/////////////////////////////////////
void PutImage(int x, int y, int w, int h, LPBYTE image, int mode)
{
    int off=0;
	int i, f;

	switch(mode)
	{
	case ID_S:
		for(i=y; i<(y + h); i++)             /////////////////////////////
		{                                    // ̹ .
			for(int j=x; j<(x + w); j++)     //
			{                                // ̹ .
											 /////////////////////////////
				if(*(image + off) != M_TRANSCOLOR)
		        if(ClipCheck(j, i)) PutPixel(j, i, *(image + off));
			    //////////////////////////////////////////////////////
				// ̹  óϿ Ʈ óѴ.
	            // M_TRANSCOLOR ó ʰ,   Ÿ
			    // Ѵ.
				//////////////////////////////////////////////////////
	  		    off++;
			}
		}
		break;

	case ID_RS:
		for(i=y, f=1; i<(y + h); i++, f++)   /////////////////////////////
		{                                    // ̹ .
			off = w * f - 1;                 // 
			for(int j=x; j<(x + w); j++)     // ̹ .
			{                                ///////////////////////////// 
											 
				if(*(image + off) != M_TRANSCOLOR)
		        if(ClipCheck(j, i)) PutPixel(j, i, *(image + off));
			    //////////////////////////////////////////////////////
				// ̹  óϿ Ʈ óѴ.
	            // M_TRANSCOLOR ó ʰ,   Ÿ
			    // Ѵ.
				//////////////////////////////////////////////////////
	  		    off--;
			}
		}
		break;

	case ID_N:
		if(ClipCheck(x, y)) 
	    {
		    for(int k=0; k<h; k++) 
					memcpy(M_SCREENPAGE+OffSet(x, y)+ID_WINKSIZEX*k, image+w*k, w);
	    }
        ///////////////////////////////////////////////////////////
        // ̹ ״ ϵ,  ī(Line Copy) ؼ
        // ӵ  .
        //  Ʈ ó ȵȴ.
        ///////////////////////////////////////////////////////////
		break;


	case ID_BN:
		memcpy(M_SCREENPAGE, image, ID_WINKSIZEX*ID_WINKSIZEY);
		break;

    }// switch...

}



////////////////////////////////////////
// ۾  ̹ ´.
////////////////////////////////////////
void GetImage(LPBYTE page, int x, int y, int w, int h, LPBYTE image)
{
     if(ClipCheck(x, y)) 
	 {
		 for(int i=0; i<h; i++) memcpy(image+w*i, page+OffSet(x, y)+ID_WINKSIZEX*i, w);
	 }
        //////////////////////////////////////////////////////
        // ̹ ȼ(Pixel)  ʰ,  
        // ´.
        //////////////////////////////////////////////////////
}



/*********************************************************************************************/

//////////////////////
// ȷƮ  Լ //
//////////////////////

BOOL SetPalette( LPRGBQUAD rq )
{
    return SetPalette( (PALETTEENTRY*)rq );
}



BOOL SetPalette( PALETTEENTRY* pe )
{
	if( M_SCREENPAL == NULL ) return FALSE;

	memcpy( (LPBYTE)M_SCREENPAL, (LPBYTE)pe, 256L*sizeof(PALETTEENTRY) );

	BBPalette = Create256Palette( M_SCREENPAL );

	return TRUE;
}



BOOL SetPalette( LPBYTE palette )
{
	if( M_SCREENPAL == NULL ) return FALSE;

	for(int k = 0; k<768; k++)
	{
		M_WINKDEFAULTPAL[k] = palette[k];
	}

	for(int i = 0; i < 256; i++, palette+=3) 
	{
		M_SCREENPAL[i].peBlue  = palette[0]; 
        M_SCREENPAL[i].peGreen = palette[1]; 
        M_SCREENPAL[i].peRed   = palette[2]; 
        M_SCREENPAL[i].peFlags = 0;
    }

	BBPalette = Create256Palette( M_SCREENPAL ); 

	return TRUE;
}



HPALETTE Create256Palette( PALETTEENTRY *Palentry )
{
	if( BBPalette != NULL ) DeleteObject( BBPalette );
		else BBPalette = NULL;

	struct {
		WORD PalVersion;
		WORD EntryNum;
		PALETTEENTRY PalEntry[256];
	} LogicalPalette = {0x300, 256 };

	memcpy( LogicalPalette.PalEntry, Palentry, 256*4 );

	return CreatePalette((LPLOGPALETTE)&LogicalPalette);
}


BOOL FreePalette(void)
{
	if(BBPalette == NULL) return FALSE;

	DeleteObject( BBPalette );

	BBPalette = NULL;

	return TRUE;
}



/*********************************************************************************************/
//////////////////////////////
// ȭ ⸦ Ѵ.
//////////////////////////////
BOOL ScreenBright(int per)
{
 PALETTEENTRY *temppal;
	
 if(per <   0) per =   0;
 if(per > 100) per = 100;

 SetPalette(M_WINKDEFAULTPAL);
 
 if( M_SCREENPAL == NULL ) return FALSE;

 temppal = M_SCREENPAL;

 for(int i = 0; i < 256; i++) 
 {
     M_SCREENPAL[i].peBlue  = temppal[i].peBlue*per/100; 
     M_SCREENPAL[i].peGreen = temppal[i].peGreen*per/100; 
     M_SCREENPAL[i].peRed   = temppal[i].peRed*per/100; 
     M_SCREENPAL[i].peFlags = 0;
 }

//  SetPalette(M_SCREENPAL);

  return TRUE;
}





//////////////////////////////////////
// ȭ  Ѵ.(ó)
//////////////////////////////////////
BOOL ScreenGray(int per)
{
 int gray;

 PALETTEENTRY* temppal;

 if(per <   0) per =   0;
 if(per > 100) per = 100;

 SetPalette(M_WINKDEFAULTPAL);

 if( M_SCREENPAL == NULL ) return FALSE;

 temppal = M_SCREENPAL;

 for(int i=0; i<256; i++) {
  gray = (int)(temppal[i].peBlue*3 + temppal[i].peGreen*5 + temppal[i].peRed*2);
  gray = (gray * per) / 1000;
  ///////////////////////////////////////////////
  // ȷƮ ׷ Ϸ  ˰.
  ///////////////////////////////////////////////

  M_SCREENPAL[i].peBlue  = gray; 
  M_SCREENPAL[i].peGreen = gray; 
  M_SCREENPAL[i].peRed   = gray; 
  M_SCREENPAL[i].peFlags = 0;
 }

//  SetPalette(M_SCREENPAL);

 return TRUE;
}



BOOL ScreenFadeIn(int step)
{
	static int FadeSW[1];

	FadeSW[0] = 0;

	if(M_FADEOUT == TRUE) M_FADEPER = 101;

	if(FadeSW[0] == 0)
	{
		if(step <  1) step =  1;
		if(step > 30) step = 30;

		if(M_FADEPER > 100) 
		{
			ScreenBright(100);
			FadeSW[0] = 1;
			M_FADEIN = FALSE;
			return TRUE;
		}

		ScreenBright(M_FADEPER);
		M_FADEPER+=step;
		M_FADEIN = TRUE;
		return FALSE;
	}

	return TRUE;	
}



BOOL ScreenFadeOut(int step)
{
	static int FadeSW[1];

	FadeSW[0] = 0;

	if(M_FADEIN == TRUE) M_FADEPER = -1;

	if(FadeSW[0] == 0)
	{
		if(step <  1) step =  1;
		if(step > 30) step = 30;

		if(M_FADEPER < 0) 
		{
			ScreenBright(0);
			FadeSW[0] = 1;
			M_FADEOUT = FALSE;
			return TRUE;
		}

		ScreenBright(M_FADEPER);
		M_FADEPER-=step;
		M_FADEOUT = TRUE;
		return FALSE;
	}

	return TRUE;	
}



/*********************************************************************************************/
//////////////////////
// Ÿ̸  Լ //
//////////////////////


long GetRealTime()
{
	LARGE_INTEGER time ;
	
	QueryPerformanceCounter( &time );		    // 64Ʈ  Ȯ ð ǵ.

	return (long)((DWORD)time.LowPart>>2);
}


BOOL FrameSkip(int tm, long frame)
{
	M_FRAMEPERSEC = 25000000L / frame;      // ʴ   Ѵ.

	M_THISTIME[tm] = GetRealTime();			//  ð Ѵ.
		
	if(M_THISTIME[tm] - M_OLDTIME[tm] > M_FRAMEPERSEC) 
	// M_FRAMEPERSEC  ŭ ð 귶 ˻Ѵ.
    {
		M_OLDTIME[tm] = M_THISTIME[tm];     //  ð Ѵ.
		return TRUE;
	}

	return FALSE;
}






/*********************************************************************************************/
////////////////////
// Ʈ  Լ //
////////////////////


BYTE H_FONT1[8][20][32];    // ʼ 8 Ʈ б  迭
BYTE H_FONT2[4][22][32];    // ߼ 4 Ʈ б  迭
BYTE H_FONT3[4][28][32];    //  4 Ʈ б  迭

BYTE E_FONT[256][16];       //  256 Ʈ б  迭

BYTE HangulImage[32];       // ѱ Ʈ ¿ 迭(Ʈ Ͽ )
BYTE EnglishImage[16];      //  Ʈ ¿ 迭(Ʈ Ͽ )



void LoadFont(LPSTR hname, LPSTR ename)  
{
    FILE *fp;

    if((fp = fopen(hname, "rb")) == NULL) {       // 16x16 ѱ Ʈ
        strupr(hname);
        puts("\nERROR : Hangul font file NOT found!\n");
        exit(0);
    }
                                    //              xxũ= հ
    fread(H_FONT1, 5120, 1, fp);    // ʼ 8 б (8 x 20 x 32 = 5120)
    fread(H_FONT2, 2816, 1, fp);    // ߼ 4 б (4 x 22 x 32 = 2816)
    fread(H_FONT3, 3584, 1, fp);    //  4 б (4 x 28 x 32 = 3584)

    fclose(fp); // ѱ Ʈ ȭ ݴ´

    if((fp = fopen(ename,"rb")) == NULL) {       // 8x8  Ʈ
        strupr(ename);
        puts("\nERROR : English font file NOT found!\n");
        exit(0);
    }
    fread(E_FONT, 4096, 1, fp);     //  Ʈ ϱ (256 x 16 = 4096)
    fclose(fp); //  Ʈ ȭ ݴ´
}




void ORImage(BYTE *src, BYTE *dest, int size)    // ̹ (or )
{
    for (int i = 0; i < size; i++)          // *src  sizeŭ
        dest[i] |= src[i];              // *dest orϿ 
}



void OutlineFont(BYTE *dest, int size)        // ܰ Ʈ .
{
    BYTE temp1[32], temp2[32];
    int i;

    memcpy(temp1, dest, size);
    memcpy(temp2, dest, size);

    if (size == 16){                        //  Ʈ  ˻
        for (i = 0; i < 16; i++){
            temp1[i] |= temp2[i] >> 1;
            temp1[i] |= temp2[i] << 1;
        }
        for (i = 0; i < 15; i++)
            temp1[i + 1] |= temp2[i];
        for (i = 1; i < 16; i++)
            temp1[i - 1] |= temp2[i];
        for (i = 0; i < 15; i++)
            temp1[i    ] ^= temp2[i];
    } else {                                // ѱ Ʈ 
        for (i = 0; i < 32; i++){
            temp1[i] |= temp2[i] >> 1;
            temp1[i] |= temp2[i] << 1;
        }
        for (i = 0; i < 32; i++)
            temp1[i + 2] |= temp2[i];
        for (i = 2; i < 32; i++)
            temp1[i - 2] |= temp2[i];
        for (i = 0; i < 32; i++)
            temp1[i    ] ^= temp2[i];
    }
    memcpy(dest, temp1, size);
}



void ConvertFont(BYTE *dest, int size)     //  
{
    for (int i = 0; i != size; i++)
        dest[i] = ~dest[i];
}



void ShadowFont(BYTE *dest, int size)      // ׸ 
{
    BYTE temp[32];
    int i;

    memcpy(temp, dest, size);

    if (size == 16){      // ̸
        for (i = 0; i < 16; i++)
            dest[i    ] |= temp[i] >> 1;
        for (i = 0; i < 15; i++)
            dest[i + 1] |= temp[i];
        for (i = 0; i < 16; i++)
            dest[i    ] ^= temp[i];
    } else {              // ѱ̸
        for (i = 0; i < 32; i++)
            dest[i    ] |= temp[i] >> 1;
        for (i = 0; i < 30; i++)
            dest[i + 2] |= temp[i];
        for (i = 0; i < 32; i++)
            dest[i    ] ^= temp[i];
    }
}



void PutFontPixel(int x, int y, BYTE *fnt, int color, int size)
{                                                      // 
    int i, k, m = 0, n = 0;
    BYTE dat = 0x80;

    for (i = y; i < y + 16; i++)
    {
        for (k = x; k < x + size; k++)
        {
            if ((fnt[m] & (dat >> n)) == (dat >> n))
               PutPixel(k, i, color);

            if ((++n) == 8)
            {
                n = 0;
                m ++;
            }
        }
    }
}



// ȭ鿡 ۾ Ѵ.
void PutFont(int x, int y, LPSTR str, int color, int mode)
{
    BYTE data1, data2;
    BYTE first, mid, last;
    int b1, b2, b3;

    int i;

    for (i = 0; i < (int)strlen(str); i++){
        data1 = *(str + i);             // str  ڿ ù Ʈ

        memset(HangulImage, 0, 32);
        memset(EnglishImage, 0, 16);

        if (data1 > 127) {              // ѱΰ?
            data2 = *(str + (++i));     // ѱ  Ʈ б

            first = (data1 & 124) >> 2; // ʼ 5Ʈ -> Ʈ...
            mid   = (data1 & 3) * 8 + (data2 >> 5); //߼5Ʈ -> Ʈ...
            last  = (data2 & 31);       //  5Ʈ -> Ʈ...

            first = TABLE[0][first];    // ʼ ڵ忡  Ʈ ȣ ã
            mid   = TABLE[1][mid  ];    // ߼ ڵ忡  Ʈ ȣ ã
            last  = TABLE[2][last ];    //  ڵ忡  Ʈ ȣ ã

            b3 = MIDDLE_TABLE[0][mid];      // ߼   Ʈ 

            if (!last){                 //  
                b2 = FIRST_TABLE[0][first];
                b1 = MIDDLE_TABLE[1][mid];
            } else {
                b2 = FIRST_TABLE[1][first];
                b1 = MIDDLE_TABLE[2][mid];
            }
            if (first)                  // ʼ 
                ORImage(H_FONT1[b1][first], HangulImage, 32);
            if (mid)                    // ߼ 
                ORImage(H_FONT2[b2][mid  ], HangulImage, 32);
            if (last)                   //  
                ORImage(H_FONT3[b3][last ], HangulImage, 32);


            switch (mode){
                case SHL :                // ܰ  
                    OutlineFont(HangulImage, 32);
                    PutFontPixel(x, y, HangulImage, color, 16);
                    break;
                case CON :                //  
                    ConvertFont(HangulImage, 32);
                    PutFontPixel(x, y, HangulImage, color, 16);
                    break;
                case SDW :                // ׸  
                    ShadowFont(HangulImage, 32);
                    PutFontPixel(x, y, HangulImage, color, 16);
                    break;
                default :               // 빮 
                    PutFontPixel(x, y, HangulImage, color, 16);
            }

            x += 16;                    // ѱ ũ⸸ŭ Xǥ ̵
        }

        else {            //  Ʈ 
            memmove(&EnglishImage, &E_FONT[data1], 16);

            switch (mode){
                case SHL :                // ܰ  
                    OutlineFont(EnglishImage, 16);
                    PutFontPixel(x, y, EnglishImage, color, 8);
                    break;
                case CON :                //   
                    ConvertFont(EnglishImage, 16);
                    PutFontPixel(x, y, EnglishImage, color, 8);
                    break;
                case SDW :                // ׸  
                    ShadowFont(EnglishImage, 16);
                    PutFontPixel(x, y, EnglishImage, color, 8);
                    break;
                default :               // 빮 
                    PutFontPixel(x, y, EnglishImage, color, 8);
            }

            x += 8;                     //  ũ⸸ŭ Xǥ ̵
        }

    }
}




