// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"

XGLLINK void XGLCALL grSstOrigin(uint32 origin) {
	vlog("Called grSstOrigin");

	if (origin == XGLORIGIN_OTHER) 
		Voodoo.origin = XGLORIGIN_UL;
	else
		Voodoo.origin = origin;

	SetVconv();
}


XGLLINK void XGLCALL grCullMode(uint32 mode) {
	vlog("Called grCullMode: mode=" << mode);
	int dwCull;

	_exebuffer->Flush();

	switch(mode) {
	case XGLCULL_NONE:
		dwCull = D3DCULL_NONE;
		break;
	case XGLCULL_CCW:
		dwCull = D3DCULL_CCW;
		break;
	case XGLCULL_CW:
		dwCull = D3DCULL_CW;
		break;
	default:
		dwCull = XGLCULL_NONE;
  }
  if(DX.D3DD->SetRenderState(D3DRENDERSTATE_CULLMODE, dwCull) != D3D_OK) log("  Error in grCullMode\n");

}


XGLLINK uint32 XGLCALL gu3dfGetInfo(char *filename, XGL3dfInfo *info) {
	vlog("Called gu3dfGetInfo: filename=" << filename);

	ifstream f;
	int i, smalllod=1, largelod=1, w_aspect=1, h_aspect=1;
	char s[256], fmt[8];

	f.open(filename);
	if(!f.is_open()) {
		log("  Could not open " << filename);
		return XGLFALSE;
	}

	for (i=0; i<11; i++) {
		f >> s;
		switch (i) {
		case 2:		strcpy(fmt, s);			break;
		case 5:		smalllod = atoi(s);		break;
		case 6:		largelod = atoi(s);		break;
		case 9:		w_aspect = atoi(s);		break;
		case 10:	h_aspect = atoi(s);		break;
		}
	}
	f.close();

	int slod, llod;

	switch (largelod) {
	case 256:	llod = XGLLOD_256;	break;
	case 128:	llod = XGLLOD_128;	break;
	case 64:	llod = XGLLOD_64;	break;
	case 32:	llod = XGLLOD_32;	break;
	case 16:	llod = XGLLOD_16;	break;
	case 8:		llod = XGLLOD_8;	break;
	case 4:		llod = XGLLOD_4;	break;
	case 2:		llod = XGLLOD_2;	break;
	case 1:		llod = XGLLOD_1;	break;
	default:	llod = XGLLOD_1;
	}

	switch (smalllod) {
	case 256:	slod = XGLLOD_256;	break;
	case 128:	slod = XGLLOD_128;	break;
	case 64:	slod = XGLLOD_64;	break;
	case 32:	slod = XGLLOD_32;	break;
	case 16:	slod = XGLLOD_16;	break;
	case 8:		slod = XGLLOD_8;	break;
	case 4:		slod = XGLLOD_4;	break;
	case 2:		slod = XGLLOD_2;	break;
	case 1:		slod = XGLLOD_1;	break;
	default:	slod = XGLLOD_1;
	}

	int width = largelod, height = largelod;

	info->aspect = getAspectRatio(w_aspect, h_aspect);
	switch (info->aspect) {
	case XGLASPECT_8x1:		height >>= 3;	break;
	case XGLASPECT_4x1:		height >>= 2;	break;
	case XGLASPECT_2x1:		height >>= 1;	break;
	case XGLASPECT_1x1:		break;
	case XGLASPECT_1x2:		width >>= 1;	break;
	case XGLASPECT_1x4:		width >>= 2;	break;
	case XGLASPECT_1x8:		width >>= 3;	break;
	}


	info->width =  width;
	info->height = height;
	info->smalllod = slod;
	info->largelod = llod;
	info->format = getTextureFormat(fmt);

//	info->palette

	info->data = 0;

	info->mem = getMemRequired(info, smalllod, largelod, w_aspect, h_aspect);


	vlog("  smalllod=" << smalllod);
	vlog("  largelod=" << largelod);
	vlog("  w_aspect=" << w_aspect);
	vlog("  h_aspect=" << h_aspect);
	vlog("  width=" << info->width);
	vlog("  height=" << info->height);
	vlog("  mem=" << info->mem);


	return XGLTRUE;
}


XGLLINK uint32 XGLCALL gu3dfLoad(char *filename, XGL3dfInfo *info) {
	vlog("Called gu3dfLoad");

	return XGLTRUE;
}


XGLLINK void XGLCALL grDepthBiasLevel(uint32 level) {
	vlog("Called grDepthBiasLevel: level=" << level);

//	_exebuffer->Flush();

//	log("  Error, unsupported function grDepthBiasLevel");

//	DX.D3DD->SetRenderState(D3DRENDERSTATE_ZBIAS, level);
}


XGLLINK void XGLCALL grDepthMask(uint32 mask) {
	vlog("Called grDepthMask: mask=" << mask);

	_exebuffer->Flush();

	if (mask) 
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, TRUE);
	else
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, FALSE);
		
}

uint32 getTextureFormat(char *format) {
	if (strcmp(format, "yiq") == 0)			return XGLTEX_YIQ422;
	if (strcmp(format, "rgb565") == 0)		return XGLTEX_RGB565;
	if (strcmp(format, "a8") == 0)			return XGLTEX_A8;
	if (strcmp(format, "rgb332") == 0)		return XGLTEX_RGB332;
	if (strcmp(format, "p8") == 0)			return XGLTEX_P8;
	if (strcmp(format, "ayiq8422") == 0)	return XGLTEX_AYIQ8422;
	if (strcmp(format, "argb8332") == 0)	return XGLTEX_ARGB8332;
	if (strcmp(format, "argb4444") == 0)	return XGLTEX_ARGB4444;
	if (strcmp(format, "argb1555") == 0)	return XGLTEX_ARGB1555;
	if (strcmp(format, "ap88") == 0)		return XGLTEX_AP88;

	return 0;
}

uint32 getAspectRatio(uint32 w, uint32 h) {
	if (w == 1) {
		if (h == 1) return XGLASPECT_1x1;
		if (h == 2) return XGLASPECT_1x2;
		if (h == 4) return XGLASPECT_1x4;
		if (h == 8) return XGLASPECT_1x8;
	}
	if (w == 2) return XGLASPECT_2x1;
	if (w == 4) return XGLASPECT_4x1;
	if (w == 8) return XGLASPECT_8x1;

	return XGLASPECT_1x1;
}

uint32 getMemRequired(XGL3dfInfo *info, uint32 smalllod, uint32 largelod, uint32 xaspect, uint32 yaspect) {
	uint32 pixels = 0;
	uint32 i;

	log(smalllod << " - " << largelod << " - " << xaspect << " - " << yaspect);

	for (i=smalllod; i<=largelod; i *= 2)
		pixels += i * i / (xaspect * yaspect);

	return (pixels * getBytesPerPixel(info->format));
}

uint32 getBytesPerPixel(uint32 fmt) {
	switch (fmt) {
	case XGLTEX_RGB332:		return 1;
	case XGLTEX_YIQ422:		return 1;
	case XGLTEX_A8:			return 1;
	case XGLTEX_L8:			return 1;
	case XGLTEX_AL44:		return 1;
	case XGLTEX_P8:			return 1;
	case XGLTEX_ARGB8332:	return 2;			// Same as GR_TEXFMT_16BIT
	case XGLTEX_AYIQ8422:	return 2;
	case XGLTEX_RGB565:		return 2;
	case XGLTEX_ARGB1555:	return 2;
	case XGLTEX_ARGB4444:	return 2;
	case XGLTEX_AL88:		return 2;
	case XGLTEX_AP88:		return 2;
	}

	return 2;
}

uint32 getLfbBytesPerPixel(uint32 fmt) {
	switch (fmt) {
	case XGLLFB_FMT_RGB565:				return 2;        
	case XGLLFB_FMT_RGB555:				return 2;
	case XGLLFB_FMT_ARGB1555:			return 2;
	case XGLLFB_FMT_RGB888:				return 3;
	case XGLLFB_FMT_ARGB8888:			return 4;
	case XGLLFB_FMT_RGB565_D16:			return 4;
	case XGLLFB_FMT_RGB555_D16:			return 4;
	case XGLLFB_FMT_ARGB1555_D16:		return 4;
	case XGLLFB_FMT_D16:				return 2;
	case XGLLFB_FMT_ANY:				return 2;
	default:							return 2;
	}
}