// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


Tex::Tex(const uint32 address, const XGLTexture &tex) {
	DDSURFACEDESC2 DDSDesc;
	int width, height;

	vlog("Called Tex::Tex");

	vlog("  Texture:");
	vlog("    smalllod=" << tex.smalllod);
	vlog("    largelod=" << tex.largelod);
	vlog("    aspect=" << tex.aspect);
	vlog("    format=" << tex.format);


	_palhash = -1;
	_base = address;
	_aspect = tex.aspect;
	_format = tex.format;


	switch (tex.largelod) {
	case XGLLOD_256:	width=256;	height=256;	break;
	case XGLLOD_128:	width=128;	height=128;	break;
	case XGLLOD_64:		width=64;	height=64;	break;
	case XGLLOD_32:		width=32;	height=32;	break;
	case XGLLOD_16:		width=16;	height=16;	break;
	case XGLLOD_8:		width=8;	height=8;	break;
	case XGLLOD_4:		width=4;	height=4;	break;
	case XGLLOD_2:		width=2;	height=2;	break;
	case XGLLOD_1:		width=1;	height=1;	break;
	default:
		log("  Error in large LOD Tex::Tex: " << tex.largelod);
		width=1; height=1;
		break;
	}

	switch(tex.aspect)	{
	case XGLASPECT_8x1:		height >>= 3; 	break;
	case XGLASPECT_4x1:		height >>= 2; 	break;
	case XGLASPECT_2x1:		height >>= 1; 	break;
	case XGLASPECT_1x1:		break;
	case XGLASPECT_1x2:		width >>= 1; 	break;
	case XGLASPECT_1x4:		width >>= 2; 	break;
	case XGLASPECT_1x8:		width >>= 3; 	break;
	default:
		log("  Error in aspect ratio in Tex::Tex: " << _aspect);
		_aspect = XGLASPECT_1x1;
		break;
	}

	memset(&DDSDesc, 0, sizeof(DDSURFACEDESC2));
	DDSDesc.ddpfPixelFormat.dwSize = sizeof(DDPIXELFORMAT);



	
	DDSDesc.ddpfPixelFormat = xglpixelformats[tex.format].pf;
	_texcc = xglpixelformats[tex.format].texcc;
	_ckcc = xglpixelformats[tex.format].ckcc;
	_sbpp = xglpixelformats[tex.format].sbpp;
	_bpp = xglpixelformats[tex.format].bpp;
	_paletted = xglpixelformats[tex.format].paletted;
	_palemu = xglpixelformats[tex.format].palemu;




	DDSDesc.dwSize = sizeof(DDSURFACEDESC2);
	DDSDesc.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT;
//	DDSDesc.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT | DDSD_PIXELFORMAT | DDSD_MIPMAPCOUNT;
//	DDSDesc.dwMipMapCount = 5; 
	DDSDesc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_TEXTURE;
//	DDSDesc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_TEXTURE | DDSCAPS_VIDEOMEMORY;
//	DDSDesc.ddsCaps.dwCaps = DDSCAPS_3DDEVICE | DDSCAPS_TEXTURE | DDSCAPS_MIPMAP | DDSCAPS_COMPLEX;
	DDSDesc.ddsCaps.dwCaps2 = DDSCAPS2_TEXTUREMANAGE;
	DDSDesc.dwWidth = _width = width;
	DDSDesc.dwHeight = _height = height;
	DDSDesc.dwTextureStage = 0;
//	DDSDesc.lPitch = width * _bpp;
//	DDSDesc.dwMipMapCount = tex.largelod - tex.smalllod + 1;
//	DDSDesc.dwMipMapCount = 1;

	HRESULT href;

	if ((href = DX.DD->CreateSurface(&DDSDesc, &_texDDS, 0)) != DD_OK) {
		_texDDS = 0;
		log("Error code " << (href&0xFF) << " in Tex::Tex on CreateSurface, line " << __LINE__ << ", file " << __FILE__);
		return;
	}


	copytexture(tex);


	if (_paletted && !_palemu) createpalette();

	setcolorkey();

	if (_texDDS->QueryInterface(IID_IDirect3DTexture2, (void**)&_tex) != D3D_OK) {
		_tex = 0;
		log("Error querying interface");
	}


}


void Tex::copytexture(const XGLTexture &tex) {
	// Ok, now we copy the texture to the surface
	DDSURFACEDESC2 DDSD;
	RECT r = {0, 0, _width, _height};

	DDSD.dwSize = sizeof(DDSURFACEDESC2);

	if (_texDDS->Lock(&r, &DDSD, DDLOCK_WAIT, 0) == DD_OK) {

		vlog("   width=" << DDSD.dwWidth);
		vlog("   height=" << DDSD.dwHeight);
		vlog("   pitch=" << DDSD.lPitch);

		if (_texcc) {
			// If theres a texture conversion funcion defined, use that to convert the texture
			for (uint32 i=0; i<DDSD.dwHeight; i++) {
				for (uint32 j=0; j<DDSD.dwWidth; j++) {
					_texcc((uchar *)DDSD.lpSurface+(i*DDSD.lPitch)+j*_bpp, (uchar *)tex.data+((i*DDSD.dwWidth+j)*_sbpp));
				}
			}

		} else {
			// Otherwise, a straight copy
			for (uint32 i=0; i<DDSD.dwHeight; i++) {
				memcpy((char *)DDSD.lpSurface+(i*DDSD.lPitch), (char *)tex.data+(i*DDSD.dwWidth*_bpp), DDSD.dwWidth*_bpp);
			}
		}
		
		if (_texDDS->Unlock(&r) != DD_OK) log("Could not unlock surface on line " << __LINE__ << ", file " << __FILE__);

	} else {
		_tex = 0;
		log("Could not lock texture surface on line " << __LINE__);
		return;
	}
}


void Tex::createpalette() {
	LPDIRECTDRAWPALETTE DDP;

	if (DX.DD->CreatePalette(DDPCAPS_8BIT | DDPCAPS_ALLOW256 | DDPCAPS_INITIALIZE , Voodoo.palette, &DDP, 0) != DD_OK) {
		_tex = 0;
		log("Error creating palette");
		return;
	}
	if (_texDDS->SetPalette(DDP) != DD_OK) {
		_tex = 0;
		log("Error setting palette");
		return;
	}
	DDP->Release();
}

void Tex::setcolorkey() {
	DDCOLORKEY colorKey;
	DWORD c = 0;

	if (_ckcc)
		_ckcc((uchar *)&c, (uchar *)&Voodoo.colorKey);
	else
		c = Voodoo.colorKey;
	
	colorKey.dwColorSpaceLowValue = c;
	colorKey.dwColorSpaceHighValue = c;

	_texDDS->SetColorKey(DDCKEY_SRCBLT, &colorKey);
}


Tex::~Tex() {
	vlog("Called Tex::~Tex");
	if (_tex) _tex->Release();
	if (_texDDS) _texDDS->Release();
}


#define d3dassert(func) if (FAILED(func)) log("  Could not perform: " #func)

void Tex::setpalette() {

	if (Voodoo.palhash != _palhash) {
		if (!_palemu) {
			LPDIRECTDRAWPALETTE DDP;

			if (_texDDS->GetPalette(&DDP) != DD_OK) log("Error getting palette");
			if (DDP->SetEntries(0, 0, 256, Voodoo.palette) != DD_OK) log("Error setting palette");
			DDP->Release();
			_palhash = Voodoo.palhash;
		} else {
/*
			uint32 i, j;

			DDSURFACEDESC2 DDSD;
			DDSD.dwSize = sizeof(DDSURFACEDESC2);

			RECT r = {0, 0, _width, _height};

			d3dassert(_texDDS->Lock(&r, &DDSD, DDLOCK_WAIT, 0));

			log("Doing paletted texture conversion");
/*
			uchar *ds = (uchar *)DDSD.lpSurface;
			uint32 dpitch = DDSD.lPitch;
			uint32 spitch = width;

			if (!_data) return;

			for (i=0; i<_height; i++) {
				for (j=0; j<_width; j++) {
					_texcc(ds+(i*dpitch + j*_bpp), _data+(i*spitch + j));
				}
			}
*/
/*
			d3dassert(_texDDS->Unlock(&r));

//			log("  Todo: perform paletted texture conversion");
			// Todo: perform paletted texture conversion
*/
		}
	}
}


