// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"

XGLLINK void XGLCALL grHints(uint32 type, uint32 hintMask) {
	log("Called grHints:");
	log("  type=" << type);
	log("  hintmask=" << hintMask);

}


XGLLINK void XGLCALL grGammaCorrectionValue(float value) {
	vlog("Called grGammaCorrectionValue: value=" << value);

}


XGLLINK void XGLCALL grErrorSetCallback(void *func) {
	log("Called grErrorSetCallback");

}


XGLLINK void XGLCALL grDitherMode(uint32 mode) {
	vlog("Called grDitherMode: mode=" << mode);

	_exebuffer->Flush();

	switch(mode) {
	case XGLDITHER_DISABLE:
		DX.D3DD->SetRenderState(D3DRENDERSTATE_DITHERENABLE, FALSE);
		break;
	case XGLDITHER_2x2:
	case XGLDITHER_4x4:
		DX.D3DD->SetRenderState(D3DRENDERSTATE_DITHERENABLE, TRUE);
		break;
	}

}


XGLLINK void XGLCALL grDisableAllEffects() {
	vlog("Called grDisableAllEffects");

	grAlphaBlendFunction(XGLBLEND_ONE, XGLBLEND_ZERO, XGLBLEND_ONE, XGLBLEND_ZERO);
	grAlphaTestFunction(XGLCMP_ALWAYS);
	grChromakeyMode(XGLCK_DISABLE);
	grDepthBufferMode(XGLDB_DISABLE);
	grFogMode(XGLFOG_DISABLE);

}



D3DCOLOR colorconv(uint32 c) {
	vlog("  Called colorconv");

	switch (Voodoo.colorFormat) {
	case XGLCOLORFORMAT_RGBA: 
		return ((c << 24) | (c >> 8));
	case XGLCOLORFORMAT_ARGB:
		return c;
	case XGLCOLORFORMAT_BGRA:
		return ((c << 24) | ((c << 8) & 0x00FF0000) | ((c >> 8) & 0x0000FF00) | (c >> 24));
	case XGLCOLORFORMAT_ABGR:
		return ((c & 0xFF000000) | ((c << 16) & 0x00FF0000) | (c & 0x0000FF00) | ((c >> 16) & 0x000000FF));
	default:
		return 0xFFFFFFFF;
	}
}


D3DCOLOR iterated(const XGLVertex & v) {
	return D3DCOLOR((uchar(v.a) << 24) | (uchar(v.r) << 16) | (uchar(v.g) << 8) | (uchar(v.b)));
}

D3DCOLOR iterated2(const XGLVertex & v) {
	return D3DCOLOR((uchar(v.a) << 24) | (uchar(v.r) << 16) | (uchar(v.g) << 8) | (uchar(v.b)));
}

D3DCOLOR iterconst(const XGLVertex & v) {
	return D3DCOLOR((uchar(v.a) << 24) | (uchar(v.r) << 16) | (uchar(v.g) << 8) | (uchar(v.b)));

//	return D3DCOLOR(
//		((int(v.a*Voodoo.CCA)&0xFF) << 24) + 
//		((int(v.r*Voodoo.CCR)&0xFF) << 16) + 
//		((int(v.g*Voodoo.CCG)&0xFF) << 8) + 
//		(int(v.b*Voodoo.CCB)&0xFF));
}

D3DCOLOR constant(const XGLVertex & v) {
	return Voodoo.constantColor;
}

D3DCOLOR constant2(const XGLVertex & v) {
	return Voodoo.constantColor;
}

D3DCOLOR white(const XGLVertex & v) {
	return 0xFFFFFFFF;
}

D3DCOLOR black(const XGLVertex & v) {
	return 0x00000000;
}



/*
	if( v.x > 2048 ) { \
		vc.sx = v.x - (FLOAT)(((DWORD)v.x) & 0xfffff000) - 0.5001f; \
		vc.sy = v.y - (FLOAT)(((DWORD)v.y) & 0xfffff000) - 0.5001f; \
	} else { \
		vc.sx = v.x - 0.5001f; \
		vc.sy = v.y - 0.5001f; \
	} \

	if( v.x > 2048 ) { \
		vc.sx = v.x - (FLOAT)(((DWORD)v.x) & 0xfffff000); \
		vc.sy = v.y - (FLOAT)(((DWORD)v.y) & 0xfffff000); \
	} else { \
		vc.sx = v.x; \
		vc.sy = v.y; \
	} \

	vc.sx = v.x; \
	vc.sy = v.y; \


		vc.sx = v.x - (FLOAT)(((DWORD)v.x) & 0xfffff000); \
		vc.sy = v.y - (FLOAT)(((DWORD)v.y) & 0xfffff000); \

*/

//
// A template for the vertex conversion function.
// As long as the compiler does even the slightest bit
// of optimization, almost all the if statements collapse
// down to nothing, leaving a very branch-free function.
//

#define vconv_arb(name, depth_test, depth_bits, w_buf, w_fake, lower_left, textured) \
void name (const XGLVertex &v, D3DTLVERTEX &vc) { \
	vvlog("  Called " #name ); \
	vvlog("x=" << v.x << "  y=" << v.y << "  z=" << v.z << "  w=" << 1.0/v.oow << "  name=" << #name); \
\
	if( v.x > 2048 ) { \
		vc.sx = v.x - (3 << 18); \
		vc.sy = v.y - (3 << 18); \
	} else { \
		vc.sx = v.x; \
		vc.sy = v.y; \
	} \
\
	float w = 1.0f / v.oow; \
\
	if (depth_test) { \
		if (w_buf) { \
			if (w_fake) { \
				if (depth_bits == 16) { \
					vc.sz = float(((*(DWORD *)&w >> 11) & 0xFFFFF) - (127 << 12)) / 65536.0f;\
				} else { \
					vc.sz = 1 - v.oow; \
				} \
			} else { \
					vc.sz = w / 65536.0f; \
			} \
		} else { \
			vc.sz = v.ooz / 65536.0f; \
		} \
	} \
\
	vc.color = getcolor(v); \
\
	if (textured) { \
		int aspect = Voodoo.curtex->aspect(); \
\
		vc.tu = v.tmuvertex[0].sow*w*smul[aspect]; \
		vc.tv = v.tmuvertex[0].tow*w*tmul[aspect]; \
\
		vc.rhw = v.oow; \
	} else { \
		vc.rhw = 1.0f; \
	} \
\
	if (lower_left) vc.sy = Voodoo.height - vc.sy; \
}


vconv_arb(vconv_D_UL_T,			0, 0,  0, 0, 0, 1)
vconv_arb(vconv_W_UL_T,			1, 16, 1, 0, 0, 1)
vconv_arb(vconv_W_Z16_UL_T,		1, 16, 1, 1, 0, 1)
vconv_arb(vconv_W_Z24_UL_T,		1, 24, 1, 1, 0, 1)
vconv_arb(vconv_W_Z32_UL_T,		1, 32, 1, 1, 0, 1)
vconv_arb(vconv_Z_UL_T,			1, 16, 0, 0, 0, 1)

vconv_arb(vconv_D_LL_T,			0, 0,  0, 0, 1, 1)
vconv_arb(vconv_W_LL_T,			1, 16, 1, 0, 1, 1)
vconv_arb(vconv_W_Z16_LL_T,		1, 16, 1, 1, 1, 1)
vconv_arb(vconv_W_Z24_LL_T,		1, 24, 1, 1, 1, 1)
vconv_arb(vconv_W_Z32_LL_T,		1, 32, 1, 1, 1, 1)
vconv_arb(vconv_Z_LL_T,			1, 16, 0, 0, 1, 1)

vconv_arb(vconv_D_UL_NT,		0, 0,  0, 0, 0, 0)
vconv_arb(vconv_W_UL_NT,		1, 16, 1, 0, 0, 0)
vconv_arb(vconv_W_Z16_UL_NT,	1, 16, 1, 1, 0, 0)
vconv_arb(vconv_W_Z24_UL_NT,	1, 24, 1, 1, 0, 0)
vconv_arb(vconv_W_Z32_UL_NT,	1, 32, 1, 1, 0, 0)
vconv_arb(vconv_Z_UL_NT,		1, 16, 0, 0, 0, 0)

vconv_arb(vconv_D_LL_NT,		0, 0,  0, 0, 1, 0)
vconv_arb(vconv_W_LL_NT,		1, 16, 1, 0, 1, 0)
vconv_arb(vconv_W_Z16_LL_NT,	1, 16, 1, 1, 1, 0)
vconv_arb(vconv_W_Z24_LL_NT,	1, 24, 1, 1, 1, 0)
vconv_arb(vconv_W_Z32_LL_NT,	1, 32, 1, 1, 1, 0)
vconv_arb(vconv_Z_LL_NT,		1, 16, 0, 0, 1, 0)
