// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"

HRESULT CALLBACK EnumTextureCallback(LPDDPIXELFORMAT lpDDPixFmt, LPVOID lpUserArg) {
	log("    Texture pixel format:");
	log("      dwFlags=           0x" << hex << setw(8) << setfill('0') << lpDDPixFmt->dwFlags);
	log("      dwFourCC=          " << lpDDPixFmt->dwFourCC);
	log("      dwRGBBitCount=     " << dec << lpDDPixFmt->dwRGBBitCount);
	log("      dwRGBAlphaBitMask= 0x" << hex << setw(8) << setfill('0') << lpDDPixFmt->dwRGBAlphaBitMask);
	log("      dwRBitMask=        0x" << setw(8) << setfill('0') << lpDDPixFmt->dwRBitMask);
	log("      dwGBitMask=        0x" << setw(8) << setfill('0') << lpDDPixFmt->dwGBitMask);
	log("      dwBBitMask=        0x" << setw(8) << setfill('0') << lpDDPixFmt->dwBBitMask << dec);

	return 1;
}

BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM lparam) {
	char s[257];

	GetWindowText(hwnd, s, 257);
//	log(s);

	s[8] = 0;
	// Move UltraHLE window to corner of screen so it doesn't flash in the background
	if (strcmp(s, "UltraHLE") == 0) {
		RECT r;
		
		GetWindowRect(hwnd, &r);
		MoveWindow(hwnd, r.left, r.top+100, (r.right-r.left), (r.bottom-r.top), 0);
	}

	return 1;
}

XGLLINK uint32 XGLCALL grSstStatus() {

	return 1;
}


XGLLINK void XGLCALL grSstIdle() {
	
}

XGLLINK uint32 XGLCALL grSstIsBusy() {

	return 0;
}


BOOL WINAPI DDEnumCallbackEx(GUID FAR *pGUID, LPSTR pDriverDescription, LPSTR pDriverName, LPVOID pContext, HMONITOR hm) {

	if(pGUID) memcpy(pContext, pGUID, sizeof(GUID));

	return D3DENUMRET_OK;
}




XGLLINK uint32 XGLCALL grSstWinOpen(uint32 hwnd,
									 uint32 res,
									 uint32 refresh,
									 uint32 colorformat,
									 uint32 origin,
									 uint32 buffers,
									 uint32 temp) {
	log("Called grSstWinOpen");
	log("  hWnd=" << hwnd);
	log("  res=" << res);
	log("  refresh=" << refresh);
	log("  color format=" << colorformat);
	log("  origin=" << origin);
	log("  # buffers=" << buffers);

	if (Voodoo.openwindow) grSstWinClose();

//	res = XGLRES_1024x768;

	switch (res) {
	case XGLRES_320x240:	Voodoo.width=320;	Voodoo.height=240;	break;
	case XGLRES_400x300:	Voodoo.width=400;	Voodoo.height=300;	break;
	case XGLRES_512x384:	Voodoo.width=512;	Voodoo.height=384;	break;
	case XGLRES_640x480:	Voodoo.width=640;	Voodoo.height=480;	break;
	case XGLRES_800x600:	Voodoo.width=800;	Voodoo.height=600;	break;
	case XGLRES_1024x768:	Voodoo.width=1024;	Voodoo.height=768;	break;
	case XGLRES_1280x1024:	Voodoo.width=1280;	Voodoo.height=1024;	break;
	case XGLRES_1600x1200:	Voodoo.width=1600;	Voodoo.height=1200;	break;
	default:
		Voodoo.width=640;
		Voodoo.height=480;
		log("Error: invalid resolution, defaulting to 640x480.\n");
	}

	
	
	DX.hWnd = (HWND)hwnd;
//	_hWnd = 0;
	Voodoo.colorFormat = colorformat;

	Voodoo.origin = origin;
	if (Voodoo.origin == XGLORIGIN_OTHER) Voodoo.origin = XGLORIGIN_UL;


	Voodoo.dbmode = XGLDB_DISABLE;


	Voodoo.texture = NO_TEXTURE;
	Voodoo.curtex = 0;

//	SetVconv();
	vconv = vconv_D_UL_T;


	WNDCLASS wndClass = { CS_HREDRAW | CS_VREDRAW, DefWindowProc, 0, 0, _hInstance, 0, 0, 0, 0, TEXT("XGl200") };


	if(!DX.hWnd) {
		DX.hWnd = GetActiveWindow();

		char wndName[256];

		GetWindowText(DX.hWnd, wndName, sizeof(wndName));
		log("  Used window name='" << wndName << "'");
	}

	if (!DX.hWnd) {
		if (!RegisterClass( &wndClass )) {
			log("  Could not register window class");
			return XGLFALSE;
		}

		if (!(DX.hWnd = CreateWindow("XGl200", "XGl200", WS_OVERLAPPEDWINDOW, 0, 0, Voodoo.width, Voodoo.height, 0, 0, _hInstance, 0 ))) {
			log("  Could not create window");
			return XGLFALSE;
		}
		ShowWindow(DX.hWnd, SW_SHOWNORMAL);
		UpdateWindow(DX.hWnd);
	}

	// If DirectDrawCreate fails, user must not have DX 6 installed
	LPDIRECTDRAW DD;

	if (DirectDrawCreate(0, &DD, 0)) { 
		log("  Error: DirectDrawCreate(); failed\n");
		MessageBox(NULL, "Warning: This program requires DirectX 6.0.", "Error", MB_OK); 
		return XGLFALSE; 
	}

	if (DD->QueryInterface(IID_IDirectDraw4, (LPVOID *)&DX.DD)) {
		log("  Error in QueryInterface");
		return XGLFALSE;
	}

	if (DX.DD->SetCooperativeLevel(DX.hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_FPUSETUP)) {
		log("  Error in SetCooperativeLevel");
		return XGLFALSE;
	}
	if (DX.DD->QueryInterface( IID_IDirect3D3, (VOID**)&DX.D3D)) {
		log("  Error in QueryInterface");
		return XGLFALSE;
	}
	if (DX.DD->SetDisplayMode(Voodoo.width, Voodoo.height, 16, 0, 0)) {
		log("  Error in SetDisplayMode");
		return XGLFALSE;
	}


	EnumWindows(EnumWindowsProc, 0);

	DDPIXELFORMAT ddpfZBuffer;
	if (getzbuffer(ddpfZBuffer) != XGLTRUE) return XGLFALSE;


	DDSURFACEDESC2 ddsd;
    DDSCAPS2 ddscaps;

	memset(&ddsd, 0, sizeof(DDSURFACEDESC2));
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE;
	ddsd.dwBackBufferCount = Settings.backbuffers;

	if (DX.DD->CreateSurface(&ddsd, &DX.DDSPrimary, NULL)) {
		log("  Error in CreateSurface");
		return XGLFALSE;
	}

    // Get a pointer to the back buffer
	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
	if (DX.DDSPrimary->GetAttachedSurface(&ddscaps, &DX.DDSRender)) {
		log("  Error in GetAttachedSurface");
		return XGLFALSE;
	}



	if (getcaps() == XGLFALSE) return XGLFALSE;



	memset(&ddsd, 0, sizeof(DDSURFACEDESC2));
	ddsd.dwSize = sizeof(DDSURFACEDESC2);
	ddsd.dwFlags        = DDSD_CAPS|DDSD_WIDTH|DDSD_HEIGHT|DDSD_PIXELFORMAT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_ZBUFFER | DDSCAPS_VIDEOMEMORY;
	ddsd.dwWidth        = Voodoo.width;
	ddsd.dwHeight       = Voodoo.height;
	memcpy( &ddsd.ddpfPixelFormat, &ddpfZBuffer, sizeof(DDPIXELFORMAT) ); 

	if(DX.DD->CreateSurface(&ddsd, &DX.DDSZBuffer, NULL)) {
		log(" Error in CreateSurface ");
		return XGLFALSE;
	}

	if(DX.DDSRender->AddAttachedSurface(DX.DDSZBuffer)) {
		log("  Error in AddAttachedSurface");
		return XGLFALSE;
	}

	if (DX.D3D->CreateDevice(IID_IDirect3DHALDevice, DX.DDSRender, &DX.D3DD, NULL)) {
		log("  Error in CreateDevice");
		return XGLFALSE;
	}


	Voodoo.viewport.dwSize = sizeof(D3DVIEWPORT2);
	Voodoo.viewport.dwX = 0;
	Voodoo.viewport.dwY = 0;
	Voodoo.viewport.dwWidth = Voodoo.width;
	Voodoo.viewport.dwHeight = Voodoo.height;
	Voodoo.viewport.dvClipX = 0;
	Voodoo.viewport.dvClipY = 0;
	Voodoo.viewport.dvClipWidth = float(Voodoo.width);
	Voodoo.viewport.dvClipHeight = float(Voodoo.height);
	Voodoo.viewport.dvMinZ = 0;
	Voodoo.viewport.dvMaxZ = 1;

	if (DX.D3D->CreateViewport(&DX.D3DViewport, NULL)) {
		log("  Error in CreateViewport");
		return XGLFALSE;
	}
	if (DX.D3DD->AddViewport(DX.D3DViewport)) {
		log("  Error in AddViewport");
		return XGLFALSE;
	}
	if (DX.D3DViewport->SetViewport2(&Voodoo.viewport)) {
		log("  Error in SetViewport2 in grSstWinOpen");
		return XGLFALSE;
	}
	if (DX.D3DD->SetCurrentViewport(DX.D3DViewport)) {
		log("  Error in SetCurrentViewport");
		return XGLFALSE;
	}



	switch (Settings.aa) {
	case 1:
		DX.D3DD->SetRenderState(D3DRENDERSTATE_EDGEANTIALIAS, TRUE);
		break;
	case 2:
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ANTIALIAS, D3DANTIALIAS_SORTINDEPENDENT);
		break;
	case 3:
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ANTIALIAS, D3DANTIALIAS_SORTDEPENDENT);
		break;
	}


	// 3 clears in case triple-buffering is enabled
	grBufferClear(0, 0, 0);
	grBufferSwap(0);
	grBufferClear(0, 0, 0);
	grBufferSwap(0);
	grBufferClear(0, 0, 0);
	grBufferSwap(0);



	DX.D3DD->EnumTextureFormats(EnumTextureCallback, 0);


	getcolor = iterated;

	table_init();



//	D3DRENDERSTATETYPE
	DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREPERSPECTIVE, TRUE);
//	DX.D3DD->SetRenderState(D3DRENDERSTATE_WRAPU, TRUE);
//	DX.D3DD->SetRenderState(D3DRENDERSTATE_WRAPV, TRUE);
//	DX.D3DD->SetRenderState(D3DRENDERSTATE_ZENABLE, D3DZB_TRUE);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_ALPHABLENDENABLE, TRUE);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_CULLMODE, D3DCULL_NONE);
//	DX.D3DD->SetRenderState();
//	DX.D3DD->SetRenderState(D3DRENDERSTATE_DITHERENABLE, TRUE);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREMIN, D3DFILTER_LINEAR);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREMAG, D3DFILTER_LINEAR);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_FOGCOLOR, 0x00000000);
//	DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREMAPBLEND, D3DTBLEND_DECAL);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_SHADEMODE, D3DSHADE_GOURAUD);
	DX.D3DD->SetRenderState(D3DRENDERSTATE_SUBPIXEL, TRUE);


//	DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREMIN, D3DFILTER_MIPLINEAR);
//	DX.D3DD->SetRenderState(D3DRENDERSTATE_TEXTUREMAG, D3DFILTER_MIPLINEAR);

	DX.D3DD->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTFG_POINT);
	DX.D3DD->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTFG_POINT);
//	DX.D3DD->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTFP_LINEAR);
//	DX.D3DD->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTFP_POINT);

//	DX.D3DD->SetRenderState(D3DRENDERSTATE_SRCBLEND, D3DPBLENDCAPS_ONE);
//	DX.D3DD->SetRenderState(D3DRENDERSTATE_DESTBLEND, D3DPBLENDCAPS_ZERO);

	DX.D3DD->SetRenderState(D3DRENDERSTATE_ALPHATESTENABLE, TRUE);


//	grColorMask(TRUE, TRUE);					// ?
	grDitherMode(XGLDITHER_4x4);
	grDepthBufferFunction(XGLCMP_LESSEQUAL);
	grDepthBufferMode(XGLDB_DISABLE);
	grColorCombine(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_GOURAUD, 0);
	grTexClampMode(0, XGLTADDRESS_WRAP, XGLTADDRESS_WRAP);
	grConstantColorValue(0xFFFFFFFF);


//	Voodoo.lastpolytype = D3DPT_TRIANGLELIST;
//	_lpD3DD->Begin(D3DPT_TRIANGLELIST, D3DFVF_TLVERTEX, D3DDP_DONOTLIGHT | D3DDP_WAIT);

//	ShowCursor(FALSE);

	// Move cursor to corner of screen
	SetCursorPos(3600, 2400);

	log("  Finished grSstWinOpen successfully");

	Voodoo.openwindow = 1;



	return XGLTRUE;
}


XGLLINK void XGLCALL grSstWinClose() {
	log("Called grSstWinClose");

	if (Voodoo.openwindow) {
		unlockall();

		_texlist->ReleaseAll();

		DX.D3DD->EndScene();

		DX.D3DViewport->Release();
		DX.D3DD->Release();
		DX.DDSPrimary->Release();

		DX.DD->RestoreDisplayMode();

		DX.D3D->Release();

		DX.DD->SetCooperativeLevel(DX.hWnd, DDSCL_NORMAL);
		DX.DD->Release();

		Voodoo.openwindow = 0;
	}

}



XGLLINK void XGLCALL grSstSelect(uint32 sst) {
	log("Called grSstSelect: sst=" << sst);

	if (sst != 0)
		log("Invalid board selected"); // Error if board 0 is not selected.
}


XGLLINK uint32 XGLCALL grSstScreenHeight() {
	log("Called grSstScreenHeight");

	return Voodoo.height;
}


XGLLINK uint32 XGLCALL grSstScreenWidth() {
	log("Called grSstScreenWidth");

	return Voodoo.width;
}

XGLLINK uint32 XGLCALL grSstQueryHardware(XGLBoardConfig *config ) {
	log("Called grSstQueryHardware");

	Voodoo.openwindow = 0;

	config->num = 1; // One subsystem...
	config->type = XGLCARD_VOODOO; // ...of Voodoo type

	config->mem = 4; // This many megs for the frame buffer
	config->revision = 1; // Revision number... not sure what this should be.
	config->numtmu = 1; // 1 virtual TexelFX chip installed
	config->sli = XGLFALSE; // Not SLI

	config->tmu[0].revision = 1; // Revision number... not sure what this should be. 
//	config->tmu[0].mem = Voodoo.tmumem; // This many megs for the texture unit
	config->tmu[0].mem = MAX_TEXTURES>>10; // This many megs for the texture unit

	return XGLTRUE;
}


XGLLINK uint32 XGLCALL grSstQueryBoards(XGLBoardConfig *config) {
	log("Called grSstQueryBoards");

	memset(config, 0, sizeof(XGLBoardConfig)); // Added 2/2/99
	config->num = 1; // We have one virtual board installed

	return XGLTRUE;
}



XGLLINK uint32 XGLCALL grSstControl(uint32 i) {
	vlog("Called grSstControl: value=" << i);

	return XGLTRUE;
}


XGLLINK uint32 XGLCALL grSstVRetraceOn() {
	BOOL status;

	DX.DD->GetVerticalBlankStatus(&status);

	return (status) ? XGLTRUE : XGLFALSE;
}

XGLLINK uint32 XGLCALL grSstVideoLine() {
	DWORD scanline;

	DX.DD->GetScanLine(&scanline);

	return scanline;
}