#define XGLVER "0.04"

// Data types
#define int8 char
#define int16 short
#define int32 long
#define uint8 unsigned char
#define uint16 unsigned short
#define uint32 unsigned long
#define uchar unsigned char


#define XGLLINK __declspec(dllexport)
#define XGLCALL __stdcall

// Misc
#define MAX_TEXTURES 2048
#define XGLNUM_TMU 1

// General comparison functions
#define XGLCMP_NEVER		0
#define XGLCMP_LESS			1
#define XGLCMP_EQUAL		2
#define XGLCMP_LESSEQUAL	3
#define XGLCMP_GREATER		4
#define XGLCMP_NOTEQUAL		5
#define XGLCMP_GREATEREQUAL	6
#define XGLCMP_ALWAYS		7
#define XGLCMP_MAX			8


// Depth buffer functions
#define XGLDB_DISABLE	0
#define XGLDB_ZBUF		1
#define XGLDB_WBUF		2
#define XGLDB_ZBUF2		3
#define XGLDB_WBUF2		4
#define XGLDB_MAX		5


// Blend functions
#define XGLBLEND_ZERO				0
#define XGLBLEND_SRCALPHA			1
#define XGLBLEND_SRCCOLOR			2
#define XGLBLEND_DESTCOLOR			2
#define XGLBLEND_DESTALPHA			3 
#define XGLBLEND_ONE				4
#define XGLBLEND_INVSRCALPHA		5
#define XGLBLEND_INVSRCCOLOR		6
#define XGLBLEND_INVDESTCOLOR		6
#define XGLBLEND_INVDESTALPHA		7
#define XGLBLEND_SRCALPHASAT		15

// guColorCombineFunction
#define XGLCC_CONSTANT					1
#define XGLCC_GOURAUD					2
#define XGLCC_TEXTURE					4
#define XGLCC_MODULATE_TEXTURE_CONSTANT	5
#define XGLCC_MODULATE					6
#define XGLCC_ADD						11

// Color combine functions
#define XGLCOMBINEFUNC_LOCAL       								1
#define XGLCOMBINEFUNC_SCALE_OTHER 								3
#define XGLCOMBINEFUNC_BLEND_OTHER 								3
#define XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL 					4
#define XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL_ALPHA 				5 
#define XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL		7
#define XGLCOMBINEFUNC_MAX										8


// Color combine factors
#define XGLCOMBINEFACTOR_ZERO						0
#define XGLCOMBINEFACTOR_LOCAL						1
#define XGLCOMBINEFACTOR_LOCAL_ALPHA				3
#define XGLCOMBINEFACTOR_TEXTURE_ALPHA				4
#define XGLCOMBINEFACTOR_TEXTURE_RGB				5
#define XGLCOMBINEFACTOR_ONE						8
#define XGLCOMBINEFACTOR_MAX						9


// Local function
#define XGLLOCAL_GOURAUD		0
#define XGLLOCAL_CONSTANT		1
#define XGLLOCAL_NONE			1
#define XGLLOCAL_DEPTH			2
#define XGLLOCAL_MAX			3

// Other function
#define XGLOTHER_GOURAUD	0
#define XGLOTHER_TEXTURE	1
#define XGLOTHER_CONSTANT	2
#define XGLOTHER_NONE		2
#define XGLOTHER_MAX		3

// Alpha source
#define XGLALPHA_CONSTANT			0
#define XGLALPHA_GOURAUD			1
#define XGLALPHA_TEXTURE			2
#define XGLALPHA_GOURAUD_TEXTURE	3

// Booleans
#define XGLFALSE	0
#define XGLTRUE		1

// Fog table types
#define XGLFOG_DISABLE				0
#define XGLFOG_TYPE1				1
#define XGLFOG_TYPE2				2
#define XGLFOG_TYPE3				3
#define XGLFOG_TYPE4				256
#define XGLFOG_TYPE5				512



// Aspect ratios
#define XGLASPECT_8x1	0
#define XGLASPECT_4x1	1
#define XGLASPECT_2x1	2
#define XGLASPECT_1x1	3
#define XGLASPECT_1x2	4
#define XGLASPECT_1x4	5
#define XGLASPECT_1x8	6
#define XGLASPECT_MAX	7

// LOD Constants
#define XGLLOD_256	0
#define XGLLOD_128	1
#define XGLLOD_64	2
#define XGLLOD_32	3
#define XGLLOD_16	4
#define XGLLOD_8	5
#define XGLLOD_4	6
#define XGLLOD_2	7
#define XGLLOD_1	8


// Origin positions
#define XGLORIGIN_UL	0
#define XGLORIGIN_LL	1
#define XGLORIGIN_MAX	2
#define XGLORIGIN_OTHER	255


// Culling
#define XGLCULL_NONE	0
#define XGLCULL_CCW		1
#define XGLCULL_CW		2

// Texture formats
#define XGLTEX_RGB332		0
#define XGLTEX_YIQ422		1
#define XGLTEX_A8			2
#define XGLTEX_L8			3
#define XGLTEX_AL44			4
#define XGLTEX_P8			5
#define XGLTEX_ARGB8332		8
#define XGLTEX_AYIQ8422		9
#define XGLTEX_RGB565		10
#define XGLTEX_ARGB1555		11
#define XGLTEX_ARGB4444		12
#define XGLTEX_AL88			13
#define XGLTEX_AP88			14

#define XGLTEX_ARGB8888		28
#define XGLTEX_P4			29
#define XGLTEX_RGB888		30
#define XGLTEX_RGB555		31
#define XGLTEX_MAX			32


// Frame buffer modes
#define XGLLFB_FMT_RGB565			0
#define XGLLFB_FMT_RGB555			1
#define XGLLFB_FMT_ARGB1555			2
#define XGLLFB_FMT_RGB888			4
#define XGLLFB_FMT_ARGB8888			5
#define XGLLFB_FMT_RGB565_D16		12
#define XGLLFB_FMT_RGB555_D16		13
#define XGLLFB_FMT_ARGB1555_D16		14
#define XGLLFB_FMT_D16				15
#define XGLLFB_FMT_RLE16			128
#define XGLLFB_FMT_ANY				255


#define XGLLOCK_READONLY	0
#define XGLLOCK_WRITEONLY	1
#define XGLLOCK_MAX			2


// Buffers
#define XGLBUF_FRONT	0
#define XGLBUF_BACK		1
#define XGLBUF_AUX		2
#define XGLBUF_DEPTH	3
#define XGLBUF_ALPHA	4
#define XGLBUF_TRIPLE	5
#define XGLBUF_MAX		6

// Resolution
#define XGLRES_320x240		1
#define XGLRES_400x300		15
#define XGLRES_512x384		3
#define XGLRES_640x480		7
#define XGLRES_800x600		8
#define XGLRES_1024x768		12
#define XGLRES_1280x1024	13
#define XGLRES_1600x1200	14
#define XGLRES_NONE			255


#define XGLDITHER_DISABLE	0
#define XGLDITHER_2x2		1
#define XGLDITHER_4x4		2

// Texture addressing
#define XGLTADDRESS_WRAP	0
#define XGLTADDRESS_CLAMP	1


#define XGLCARD_VOODOO		0
#define XGLCARD_VOODOO2		3

// Palette tables
#define XGLTEXTABLE_NCC0		0
#define XGLTEXTABLE_NCC1		1
#define XGLTEXTABLE_PALETTE		2


// Texture filters
#define XGLFILTER_NEAREST			0
#define XGLFILTER_LINEAR			1


// Functions for guTexCombineFunction
#define XGLTEXCOMBINE_DECAL			1


#define XGLCK_DISABLE		0
#define XGLCK_ENABLE		1


#define XGLCOLORFORMAT_ARGB		0
#define XGLCOLORFORMAT_ABGR		1
#define XGLCOLORFORMAT_RGBA		2
#define XGLCOLORFORMAT_BGRA		3

// Origin
#define XGL_ORIGIN_UL	0
#define XGL_ORIGIN_LL	1
#define XGL_ORIGIN		2


