//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdx.h,v $
// $Author: MICHAELR $
//
// $Log: cdx.h,v $
// Revision 2.7  1999/05/21 14:20:31  MICHAELR
// Changed DI and DS versions to 0x0500
//
// Revision 2.6  1999/05/20 15:29:02  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.5  1999/05/19 14:02:54  bsimser
// Removed includes of other base classes.
//
// Revision 2.4  1999/05/11 18:55:34  MICHAELR
// Renamed macro DELETE to SAFEDELETE to resolve a duplication problem with WINNT.H
//
// Revision 2.3  1999/05/11 04:13:48  bsimser
// Added the DELETE macro (similar to RELEASE) for objects that don't have
// a release method.
//
// Revision 2.2  1999/05/03 20:40:33  MICHAELR
// The CDX_* defines where not 'defined'
// DIRECTDRAW_VERSION was incorrectly called DIRECTDRAWVERSION
// The *_VERSION were all wrong, they were all missing a 0x0XXX, e.g. 0x300 should have been 0x0300
// DX3 compatible DDCreateSurface(...) was using IDirectDraw4
//
// Revision 2.1  1999/05/02 23:18:20  pietro
// added CDXFile class as file operation wrapper.
// the error handling is not yet working wery well - we need to create some
// general error handling routines.
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.7 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDX_H
#define CDX_H

// If you want to support DX running under NT 4.0 (currently only 
// supporting DX3) then define NTDX3 in your program
#ifdef NTDX3

#define DIRECTDRAW_VERSION	0x0300
#define DIRECTINPUT_VERSION	0x0300
#define DIRECTSOUND_VERSION	0x0300

#else

// CDX currently supports DX6
#define DIRECTDRAW_VERSION	0x0600
#define DIRECTINPUT_VERSION	0x0500
#define DIRECTSOUND_VERSION	0x0500

#endif

// CDX Currently support DirectX 6
#define CDX_DDVER		0x0600
#define CDX_DIVER		0x0500
#define CDX_DSVER		0x0500


// System includes
#include <windows.h>
#include <windowsx.h>
#include <mmsystem.h>
#include <stdio.h>

// DirectX includes
#include <ddraw.h>
#include <dinput.h>
#include <dsound.h>
#include <dplay.h>
#include <dplobby.h>

typedef struct
{
    RGBQUAD depth;		// How many bits of precision per channel
    RGBQUAD Position;	// At what bit position does the color start
	UINT bpp;
} RGBFORMAT;

//////////////////////////////////////////////////////////////////////////////////
// Globals
//////////////////////////////////////////////////////////////////////////////////
extern "C"
{
	// CDX Functions
	extern void Clip(int *DestX, int *DestY, RECT *SrcRect, RECT *DestRect);

	// DDUTILS Functions
#if DIRECTDRAW_VERSION >= CDX_DDVER
	extern IDirectDrawPalette* DDLoadPalette(IDirectDraw4 *pdd, LPCSTR szBitmap);
	extern IDirectDrawSurface4* DDLoadBitmap(IDirectDraw4 *pdd, LPCSTR szBitmap, int dx, int dy, BOOL memoryType);
	extern IDirectDrawSurface4* DDLoadSizeBitmap(IDirectDraw4 *pdd, LPCSTR szBitmap, int *dx, int *dy, BOOL memoryType);
	IDirectDrawSurface4 *DDCreateSurface(IDirectDraw4 *pdd, DWORD width, DWORD height, DDSURFACEDESC2 *ddsd);
	extern HRESULT             DDReLoadBitmap(IDirectDrawSurface4 *pdds, LPCSTR szBitmap);
	extern HRESULT             DDCopyBitmap(IDirectDrawSurface4 *pdds, HBITMAP hbm, int x, int y, int dx, int dy);
	extern DWORD               DDColorMatch(IDirectDrawSurface4 *pdds, COLORREF rgb);
	extern HRESULT             DDSetColorKey(IDirectDrawSurface4 *pdds, COLORREF rgb);
    extern BOOL                GetRGBFormat(IDirectDrawSurface4* Surface, RGBFORMAT* rgb);
#else
	extern IDirectDrawPalette* DDLoadPalette(IDirectDraw *pdd, LPCSTR szBitmap);
	extern IDirectDrawSurface* DDLoadBitmap(IDirectDraw *pdd, LPCSTR szBitmap, int dx, int dy, BOOL memoryType);
	extern IDirectDrawSurface* DDLoadSizeBitmap(IDirectDraw *pdd, LPCSTR szBitmap, int *dx, int *dy, BOOL memoryType);
	IDirectDrawSurface *DDCreateSurface(IDirectDraw *pdd, DWORD width, DWORD height, DDSURFACEDESC *ddsd);
	extern HRESULT             DDReLoadBitmap(IDirectDrawSurface *pdds, LPCSTR szBitmap);
	extern HRESULT             DDCopyBitmap(IDirectDrawSurface *pdds, HBITMAP hbm, int x, int y, int dx, int dy);
	extern DWORD               DDColorMatch(IDirectDrawSurface *pdds, COLORREF rgb);
	extern HRESULT             DDSetColorKey(IDirectDrawSurface *pdds, COLORREF rgb);
    extern BOOL                GetRGBFormat(IDirectDrawSurface* Surface, RGBFORMAT* rgb);
#endif

	extern BOOL __cdecl        IsMMX(void);

	// DirectX Errors
	extern void DDError(HRESULT hErr, void* hWnd, LPCSTR szFile, int iLine);
	extern void DSError(HRESULT hErr, void* hWnd);
}

//////////////////////////////////////////////////////////////////////////////////
// For those lazy coders, #define CDXINCLUDEALL and all cdx headers will get 
// included. Otherwise, you need to #include all header files you will need 
// (depending on modules you are going to use)
//////////////////////////////////////////////////////////////////////////////////
#ifdef CDXINCLUDEALL
	#include "cdxfile.h"
	#include "cdxscreen.h"
	#include "cdxsurface.h"
	#include "cdxlayer.h"
	#include "cdxtile.h"
	#include "cdxmap.h"
	#include "cdxsprite.h"
	#include "cdxsound.h"
	#include "cdxmusic.h"
	#include "cdxinput.h"
	#include "cdxlink.h"
	#include "cdxresource.h"
#endif


//////////////////////////////////////////////////////////////////////////////////
// MACROS
//////////////////////////////////////////////////////////////////////////////////
#define SAFEDELETE(x) if(x != NULL) { delete x; x = NULL; }
#define RELEASE(x) if(x != NULL) { x->Release(); x = NULL; }
#define ODS(a) OutputDebugString(a)

#endif
