//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxfile.cpp,v $
// $Author: pietro $
//
// $Log: cdxfile.cpp,v $
// Revision 2.3  1999/05/23 04:02:27  pietro
// format change
//
// Revision 2.2  1999/05/20 15:29:02  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.1  1999/05/02 23:18:20  pietro
// added CDXFile class as file operation wrapper.
// the error handling is not yet working wery well - we need to create some
// general error handling routines.
//
//
// $Revision: 2.3 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid[] = "@(#) $Id: cdxfile.cpp,v 2.3 1999/05/23 04:02:27 pietro Exp $";
#endif

#include "CDX.h"
#include "cdxfile.h"

//////////////////////////////////////////////////////////////////////////////////
// Default constructor.
//////////////////////////////////////////////////////////////////////////////////
CDXFile::CDXFile()
{
	FileOpen=false;
}


//////////////////////////////////////////////////////////////////////////////////
// Default destructor.
//////////////////////////////////////////////////////////////////////////////////
CDXFile::~CDXFile()
{
	
}

//////////////////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////////////////

int CDXFile::OpenRead(LPSTR FileName)
{
	Close();
	fh=fopen(FileName,"rb");
	CurrentPos=0;
	
	if(fh==NULL)
		return -1;
	FileOpen=true;

	return 0;
}

int CDXFile::Close()
{
	if (FileOpen==false)
		return 0;
	if(FileOpen)fclose(fh);
	FileOpen=false;
	return 0;
}

int CDXFile::Read(UINT howmuch, UCHAR *whence)
{
	if (howmuch != (fread(&whence,sizeof(UCHAR),howmuch,fh)))
		return -1;
	else
		return 0;
}

UCHAR CDXFile::ReadUCHAR()
{
	UCHAR whence;

	if (1 != (fread(&whence,sizeof(UCHAR),1,fh)))
		//raise error!
		return -1;
	else
		return whence;
}
USHORT CDXFile::ReadUSHORT()
{

	USHORT whence;

	if (1 != (fread(&whence,sizeof(USHORT),1,fh)))
		//raise error!!
		return -1;
	else
		return whence;
}

UINT CDXFile::ReadUINT()
{

	UINT whence;

	if (1 != (fread(&whence,sizeof(UINT),1,fh)))
		//raise error!
		return -1;
	else
		return whence;
}

