//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxinput.h,v $
// $Author: bsimser $
//
// $Log: cdxinput.h,v $
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.0 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXINPUT_H
#define CDXINPUT_H

// CDX Input Types. Applies to keyboard keys, mouse & joystick buttons.
#define CDXKEY_NONE				0
#define CDXKEY_RELEASE			1
#define CDXKEY_PRESS			2
#define CDXKEY_REPEAT			3

// CDXInput Key constants
enum
{
	CDXKEY_NULL				= 0x00000000,
    CDXKEY_BACKSPACE		= 0x00000008,
    CDXKEY_TAB				= 0x00000009,
    CDXKEY_ENTER			= 0x0000000D,
    CDXKEY_ESCAPE			= 0x0000001B,
    CDXKEY_SPACE			= 0x00000020,

	// Printable characters
	CDXKEY_BANG,
	CDXKEY_DQUOTE,
	CDXKEY_POUND,
	CDXKEY_DOLLAR,
	CDXKEY_PERCENT,
	CDXKEY_AMPERSAND,
	CDXKEY_APOSTROPHE,
	CDXKEY_LBRACE,
	CDXKEY_RBRACE,
	CDXKEY_ASTERISC,
	CDXKEY_PLUS,
	CDXKEY_COMMA,
	CDXKEY_DASH,
	CDXKEY_PERIOD,
	CDXKEY_SLASH,
    CDXKEY_0,
	CDXKEY_1,
	CDXKEY_2,
	CDXKEY_3,
	CDXKEY_4,
	CDXKEY_5,
	CDXKEY_6,
	CDXKEY_7,
	CDXKEY_8,
	CDXKEY_9,
	CDXKEY_COLON,
	CDXKEY_SEMICOLON,
	CDXKEY_LESSTHEN,
	CDXKEY_EQUALS,
	CDXKEY_GREATERTHEN,
	CDXKEY_QMARK,
	CDXKEY_AT,
	CDXKEY_CA,
	CDXKEY_CB,
	CDXKEY_CC,
	CDXKEY_CD,
	CDXKEY_CE,
	CDXKEY_CF,
	CDXKEY_CG,
	CDXKEY_CH,
	CDXKEY_CI,
	CDXKEY_CJ,
	CDXKEY_CK,
	CDXKEY_CL,
	CDXKEY_CM,
	CDXKEY_CN,
	CDXKEY_CO,
	CDXKEY_CP,
	CDXKEY_CQ,
	CDXKEY_CR,
	CDXKEY_CS,
	CDXKEY_CT,
	CDXKEY_CU,
	CDXKEY_CV,
	CDXKEY_CW,
	CDXKEY_CX,
	CDXKEY_CY,
	CDXKEY_CZ,
	CDXKEY_LBRACKET,
	CDXKEY_BACKSLASH,
	CDXKEY_RBRACKET,
	CDXKEY_CARETE,
	CDXKEY_UNDERSCORE,
	CDXKEY_GRAVE,
	CDXKEY_A,
	CDXKEY_B,
	CDXKEY_C,
	CDXKEY_D,
	CDXKEY_E,
	CDXKEY_F,
	CDXKEY_G,
	CDXKEY_H,
	CDXKEY_I,
	CDXKEY_J,
	CDXKEY_K,
	CDXKEY_L,
	CDXKEY_M,
	CDXKEY_N,
	CDXKEY_O,
	CDXKEY_P,
	CDXKEY_Q,
	CDXKEY_R,
	CDXKEY_S,
	CDXKEY_T,
	CDXKEY_U,
	CDXKEY_V,
	CDXKEY_W,
	CDXKEY_X,
	CDXKEY_Y,
	CDXKEY_Z,
	CDXKEY_LCURLY,
	CDXKEY_PIPE,
	CDXKEY_RCURLY,
	CDXKEY_TILDA,
	CDXKEY_DELETE,

	// modifier keys
    CDXKEY_LEFTSHIFT		= 0x00000080,
    CDXKEY_RIGHTSHIFT,
	CDXKEY_LEFTCTRL,
	CDXKEY_RIGHTCTRL,
    CDXKEY_LEFTALT,
    CDXKEY_RIGHTALT,
	
	// arrow keys
	CDXKEY_LEFTARROW,
    CDXKEY_RIGHTARROW,
    CDXKEY_UPARROW,
    CDXKEY_DOWNARROW,
    
	// function keys
	CDXKEY_F1,
    CDXKEY_F2,
    CDXKEY_F3,
    CDXKEY_F4,
    CDXKEY_F5,
    CDXKEY_F6,
    CDXKEY_F7,
    CDXKEY_F8,
    CDXKEY_F9,
    CDXKEY_F10,
    CDXKEY_F11,
    CDXKEY_F12,

	// cursor control keys
    CDXKEY_INS,
    CDXKEY_DEL,
    CDXKEY_HOME,
    CDXKEY_END,
    CDXKEY_PGUP,
    CDXKEY_PGDN,
	
	// numeric keypad
    CDXKEY_NUMSLASH,
    CDXKEY_NUMSTAR,
    CDXKEY_NUMMINUS,
    CDXKEY_NUMPLUS,
    CDXKEY_NUMENTER,
    CDXKEY_NUMPERIOD,
    CDXKEY_NUM0,
    CDXKEY_NUM1,
    CDXKEY_NUM2,
    CDXKEY_NUM3,
    CDXKEY_NUM4,
    CDXKEY_NUM5,
    CDXKEY_NUM6,
    CDXKEY_NUM7,
    CDXKEY_NUM8,
    CDXKEY_NUM9,
    
	// locks and misc keys
	CDXKEY_NUMLOCK,
    CDXKEY_CAPSLOCK,
    CDXKEY_SCROLLLOCK,
    CDXKEY_PRINTSCRN,
    CDXKEY_PAUSE,
	
	// windows keys deliberately not listed

	// characters 256 and up used for mouse and joystick buttons etc.
	CDXKEY_MOUSELEFT		= 0x00000100,
	CDXKEY_MOUSERIGHT,
	CDXKEY_MOUSEMIDDLE,
	CDXKEY_MOUSEBUTN4,
	CDXKEY_JOYBUTN0,
	CDXKEY_JOYBUTN1,
	CDXKEY_JOYBUTN2,
	CDXKEY_JOYBUTN3,
	CDXKEY_JOYBUTN4,
	CDXKEY_JOYBUTN5,
	CDXKEY_JOYBUTN6,
	CDXKEY_JOYBUTN7,
	CDXKEY_JOYBUTN8,
	CDXKEY_JOYBUTN9,

	// last keytype defined
	CDXKEY_NUMKEYS
};

#define NUMDIKEYS 256

//////////////////////////////////////////////////////////////////////////////////
// CDXInput is a class wrapper for DirectInput and contains functions to receive 
// data from the mouse, keyboard and joystick.
//////////////////////////////////////////////////////////////////////////////////
class CDXInput
{
public:
	CDXInput(void);
	~CDXInput(void);

	BOOL Create(void *hInst, void *hWnd);

	void Update(void);
	void FlushKeyboardData();
	void RunMouseControlPanel(void *hWnd = NULL);
	void RunJoystickControlPanel(void *hWnd = NULL);

	//HRESULT SetMouseCooperative(DWORD inFlags);
	//void SetMouseExclusive(BOOL exclusive);
	void SetJoystickLimits(LONG x1, LONG y1, LONG x2, LONG y2);
	void SetMouseLimits(LONG x1, LONG y1, LONG x2, LONG y2);
	void SetMouseSensitivity(float factor);
	void SetActiveDevices(BOOL bMouse, BOOL bKeyboard, BOOL bJoystick);
	void SetMouseAbs(void);
	void SetJoystickAbs(void);
	void SetMousePos(LONG x, LONG y);
	void SetMouseFreePos(LONG x, LONG y);
	void SetJoystickPos(LONG x, LONG y);
	void SetJoystickFreePos(LONG x, LONG y);

	BYTE GetShiftedKeyState(BYTE key);
	BYTE GetKeyState(BYTE key);
	BYTE GetKeyRaw(BYTE key);
	void GetMousePos(LONG* x, LONG* y);
	void GetMouseFreePos(LONG* x, LONG* y);
	void GetMouseDeltas(LONG* x, LONG* y);
	void GetJoystickPos(LONG* x, LONG* y);
	void GetJoystickFreePos(LONG* x, LONG* y);
	void GetJoystickDeltas(LONG* x, LONG* y);
	float GetMouseSensitivity();

private:
	void InitDIKToCDXKEY();
	void AcquireMouse();
	void UnacquireMouse();
	void AcquireKeyboard();
	void UnacquireKeyboard();
	void AcquireJoystick();
	void UnacquireJoystick();
	void CheckKeyEvents(DWORD key, BOOL isPressed);
	void InitShiftedKeys();

public:
	//BYTE Keys[NUMDIKEYS];

private:
	LPDIRECTINPUT        m_lpDI;
	LPDIRECTINPUTDEVICE  m_lpDIDKeyboard;
	LPDIRECTINPUTDEVICE  m_lpDIDMouse;

#if DIRECTINPUT_VERSION >= CDX_DIVER
	LPDIRECTINPUTDEVICE2 m_lpDIDJoystick;
#endif

	BOOL m_bMouse;
	BOOL m_bKeyboard;
	BOOL m_bJoystick;

	float m_mouseSensitivity;
	LONG m_mouseMinX;
	LONG m_mouseMinY;
	LONG m_mouseMaxX;
	LONG m_mouseMaxY;

	LONG m_joystickMinX;
	LONG m_joystickMinY;
	LONG m_joystickMaxX;
	LONG m_joystickMaxY;

	LONG m_mouseX, m_mouseY;
	LONG m_mouseFreeX, m_mouseFreeY;
	LONG m_mouseDeltaX, m_mouseDeltaY;

	LONG m_joystickX, m_joystickY;
	LONG m_joystickFreeX, m_joystickFreeY;
	LONG m_joystickDeltaX, m_joystickDeltaY;

	BYTE  m_keyStates[CDXKEY_NUMKEYS];
	BYTE  m_keyRaw[NUMDIKEYS];
	DWORD m_keyPressTimes[CDXKEY_NUMKEYS];
	DWORD m_keyDragStartPositions[CDXKEY_NUMKEYS][2];

	BYTE  m_shiftedKeyStates[CDXKEY_NUMKEYS];
	DWORD m_DIKToCDXKEY[NUMDIKEYS];
};

#endif
