//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxlayer.cpp,v $
// $Author: janni $
//
// $Log: cdxlayer.cpp,v $
// Revision 2.2  1999/05/23 05:23:05  janni
// changed constructor, it now calls its father constructor and then inits itself
//
// Revision 2.1  1999/05/20 15:29:02  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.2 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid[] = "@(#) $Id: cdxlayer.cpp,v 2.2 1999/05/23 05:23:05 janni Exp $";
#endif

#include "CDX.h"
#include "cdxlayer.h"

//////////////////////////////////////////////////////////////////////////////////
// Creates a DirectDrawSurface object holding the bitmap pointed to by szFilename.
//////////////////////////////////////////////////////////////////////////////////
CDXLayer::CDXLayer(CDXScreen *pScreen, char *szFilename, BOOL memoryType) 
: CDXSurface( pScreen , szFilename , memoryType )
{	
	m_XOffset = 0;
	m_YOffset = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// Scroll the bitmap up by the number of pixels indicated by offset.
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollUp(int Offset)
{
  m_YOffset += Offset;
	if(m_YOffset > m_PixelHeight) m_YOffset -= m_PixelHeight;
}

//////////////////////////////////////////////////////////////////////////////////
// Scroll the bitmap down by the number of pixels indicated by offset.
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollDown(int Offset)
{
  m_YOffset -= Offset;
	if(m_YOffset < 0) m_YOffset = m_PixelHeight + m_YOffset;
}

//////////////////////////////////////////////////////////////////////////////////
// Scroll the bitmap left by the number of pixels indicated by offset.
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollLeft(int Offset)
{
  m_XOffset += Offset;
	if(m_XOffset > m_PixelWidth) m_XOffset -= m_PixelWidth;
}

//////////////////////////////////////////////////////////////////////////////////
// Scroll the bitmap right by the number of pixels indicated by offset.
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::ScrollRight(int Offset)
{
  m_XOffset -= Offset;
	if(m_XOffset < 0) m_XOffset = m_PixelWidth + m_XOffset;
}

//////////////////////////////////////////////////////////////////////////////////
// Sets the position in the bitmap.
//////////////////////////////////////////////////////////////////////////////////
void CDXLayer::MoveTo(int XOffset, int YOffset)
{
  m_XOffset = XOffset;
	m_YOffset = YOffset;
}

//////////////////////////////////////////////////////////////////////////////////
// Copies the bitmap from the source surface to the surface pointed to by lpDDS.  
// Uses the DestRect structure to position the bitmap. The bitmap automatically 
// wraps around the screen.
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXLayer::Draw(CDXSurface* lpDDS)
{
	HRESULT rval;

	SetSrc(m_PixelHeight - m_YOffset, m_PixelWidth - m_XOffset, m_PixelHeight, m_PixelWidth);
	lpDDS->m_lpDDS->BltFast(0, 0, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);

	SetSrc(m_PixelHeight - m_YOffset, 0, m_PixelHeight, m_PixelWidth - m_XOffset);
	lpDDS->m_lpDDS->BltFast(m_XOffset, 0, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);

	SetSrc(0, m_PixelWidth - m_XOffset, m_PixelHeight - m_YOffset, m_PixelWidth);
	lpDDS->m_lpDDS->BltFast(0, m_YOffset, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);

	SetSrc(0, 0, m_PixelHeight - m_YOffset, m_PixelWidth - m_XOffset);
	rval=lpDDS->m_lpDDS->BltFast(m_XOffset, m_YOffset, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);
	if(rval == DDERR_SURFACELOST) {
		m_lpDDS->Restore();
		rval=DDReLoadBitmap(m_lpDDS, m_pFilename);
	}

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// Draw the layer at the given X, Y location to the surface lpDDS.
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXLayer::Draw(int X,int Y,CDXSurface* lpDDS)
{
	HRESULT rval;

	SetSrc(m_PixelHeight - m_YOffset, m_PixelWidth - m_XOffset, m_PixelHeight, m_PixelWidth);
	lpDDS->m_lpDDS->BltFast(0, 0, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);

	SetSrc(m_PixelHeight - m_YOffset, 0, m_PixelHeight, m_PixelWidth - m_XOffset);
	lpDDS->m_lpDDS->BltFast(m_XOffset+X, 0, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);

	SetSrc(0, m_PixelWidth - m_XOffset, m_PixelHeight - m_YOffset, m_PixelWidth);
	lpDDS->m_lpDDS->BltFast(0, m_YOffset+Y, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);

	SetSrc(0, 0, m_PixelHeight - m_YOffset, m_PixelWidth - m_XOffset);
	rval=lpDDS->m_lpDDS->BltFast(m_XOffset, m_YOffset, m_lpDDS, &SrcRect, DDBLTFAST_WAIT);
	if(rval == DDERR_SURFACELOST) {
		m_lpDDS->Restore();
		rval=DDReLoadBitmap(m_lpDDS, m_pFilename);
	}

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// Draw the layer using the transparent color at the given X, Y location to 
// the surface lpDDS.
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXLayer::DrawTrans(int X,int Y,CDXSurface* lpDDS)
{
	HRESULT rval;

	SetSrc(m_PixelHeight - m_YOffset, m_PixelWidth - m_XOffset, m_PixelHeight, m_PixelWidth);
	lpDDS->m_lpDDS->BltFast(0, 0, m_lpDDS, &SrcRect, DDBLTFAST_WAIT  | DDBLTFAST_SRCCOLORKEY);

	SetSrc(m_PixelHeight - m_YOffset, 0, m_PixelHeight, m_PixelWidth - m_XOffset);
	lpDDS->m_lpDDS->BltFast(m_XOffset+X, 0, m_lpDDS, &SrcRect, DDBLTFAST_WAIT  | DDBLTFAST_SRCCOLORKEY);

	SetSrc(0, m_PixelWidth - m_XOffset, m_PixelHeight - m_YOffset, m_PixelWidth);
	lpDDS->m_lpDDS->BltFast(0, m_YOffset+Y, m_lpDDS, &SrcRect, DDBLTFAST_WAIT  | DDBLTFAST_SRCCOLORKEY);

	SetSrc(0, 0, m_PixelHeight - m_YOffset, m_PixelWidth - m_XOffset);
	rval=lpDDS->m_lpDDS->BltFast(m_XOffset, m_YOffset, m_lpDDS, &SrcRect, DDBLTFAST_WAIT | DDBLTFAST_SRCCOLORKEY);
	if(rval == DDERR_SURFACELOST) {
		m_lpDDS->Restore();
		rval=DDReLoadBitmap(m_lpDDS, m_pFilename);
	}

	return rval;
}