//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxlayer.h,v $
// $Author: pietro $
//
// $Log: cdxlayer.h,v $
// Revision 2.2  1999/05/20 15:29:02  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.1  1999/05/07 20:24:30  janni
// fixed constructor, changed parameter memoryType to have as
// default value CDXMEM_VIDTHENSYS
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.2 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXLAYER_H
#define CDXLAYER_H

#include "cdxsurface.h"

//////////////////////////////////////////////////////////////////////////////////
// CDXLayer is derived from CDXSurface and is very similar in most respects. 
// However, a CDXLayer has the added ability to smoothly scroll the surface in 
// all directions. This effect is often seen in platform games where the background 
// is a scrolling bitmap and the foreground a scrolling tile map, giving a good 
// feeling of depth. A CDXLayer would also be perfect for a pinball game since 
// DirectX places no restrictions on the height of bitmaps in video memory.
//////////////////////////////////////////////////////////////////////////////////
class CDXLayer : public CDXSurface
{
public:
	CDXLayer(CDXScreen *pScreen, char *szFilename, BOOL memoryType=CDXMEM_VIDTHENSYS );

	void ScrollUp(int Offset);
	void ScrollDown(int Offset);
	void ScrollLeft(int Offset);
	void ScrollRight(int Offset);
	void MoveTo(int XOffset, int YOffset);
	virtual HRESULT Draw(CDXSurface* lpDDS);
	virtual HRESULT Draw(int X, int Y, CDXSurface* lpDDS);
	virtual HRESULT DrawTrans(int X, int Y, CDXSurface* lpDDS);

public:
	int m_XOffset;	// The current X position in pixels
	int m_YOffset;	// The current Y position in pixels
};

#endif
