//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxmap.h,v $
// $Author: pietro $
//
// $Log: cdxmap.h,v $
// Revision 2.1  1999/05/20 15:29:03  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXMAP_H
#define CDXMAP_H

#include "cdxtile.h"

//////////////////////////////////////////////////////////////////////////////////
// The CDXMapCell is a helper class for all CDXMap classes. It allows you to 
// define override a custom class to define your data for each map tile. This 
// way you can create your own CDXMapCell class and store as much information
// as you want and save it the way you want.
//////////////////////////////////////////////////////////////////////////////////
class CDXMapCell
{
public:
	CDXMapCell();
	~CDXMapCell();
	void Save(FILE *fp);
	void Load(FILE *fp);
	virtual int GetTile();
	virtual void SetTile(int Tile);
private:
	int TileNum;
};

//////////////////////////////////////////////////////////////////////////////////
// This is the main object which controls tile based scrolling in CDX. Screen, 
// tile and map information all come together in this class to produce a scrolling 
// output.  Map information is stored (using the default CDXMapCell class) in 
// binary files in the simplest possible form:
//
// Map width (4 bytes)
// Map height (4 bytes)
// Map data (Map width * Map height * 4 bytes)
//////////////////////////////////////////////////////////////////////////////////
class CDXMap
{
public:
	CDXMap();
	CDXMap(CDXTile *pTiles, CDXScreen *pScreen);
	~CDXMap();

	void Create(int Width, int Height, int Fill);
	BOOL Load(const char *szFilename);
	BOOL Save(const char *szFilename);
	void Clear(void);
	void Fill(int TileNum);
	void BltTile(CDXSurface* lpDDS, int xdest, int ydest, int w, int h, int xoff, int yoff);
	void BltTileTrans(CDXSurface* lpDDS, int xdest, int ydest, int w, int h, int xoff, int yoff);
	void Draw(CDXSurface* lpDDS);
	void DrawTrans(CDXSurface* lpDDS);
	void DrawClipped(CDXSurface* lpDDS, LPRECT ClipRect);
	void MoveTo(int PosX, int PosY);
	void ScrollUp(int Offset);
	void ScrollDown(int Offset);
	void ScrollLeft(int Offset);
	void ScrollRight(int Offset);
	void WrapScrollUp(int Offset);
	void WrapScrollDown(int Offset);
	void WrapScrollLeft(int Offset);
	void WrapScrollRight(int Offset);
	void ScreenTileSize(int Width, int Height);
	int  GetTile(int MapX, int MapY);
	CDXMapCell *GetCell(int MapX, int MapY);
	void SetTile(int MapX, int MapY, int Tile);
	void LoadTiles(CDXTile *pTiles);
	virtual void InitData(int iSIZE, int iFill);

public:
	int m_PosX;			// The current map X position in pixels
	int m_PosY;			// The current map Y position in pixels
	int m_Width;		// The map width in map units
	int m_Height;		// The map height in map units
	int m_TileWidth;	// Tile width in pixels, from the CDXTile pointer
	int m_TileHeight;	// Tile height in pixels, from the CDXTile pointer
	int m_PixelWidth;	// The width of the map in pixels
	int m_PixelHeight;	// The height of the map in pixels
	int SCREEN_TW;		// Number of tiles wide on screen
	int SCREEN_TH;		// Number of tiles high on screen
	int SCREEN_W;		// Screen pixel width, from CDXScreen pointer
	int SCREEN_H;		// Screen pixel height, from CDXScreen pointer
	int SIZE;			// Map size, width * height

	CDXMapCell *DATA;	// Pointer to the CDXMapCell object for tiles
	CDXScreen *Screen;	// Pointer to the CDXScreen object
	CDXTile *Tiles;		// Pointer to the CDXTile object
};

//////////////////////////////////////////////////////////////////////////////////
// This is the main object which controls tile based ISO scrolling in CDX. Screen, 
// tile and map information all come together in this class to produce a scrolling 
// output.
//////////////////////////////////////////////////////////////////////////////////
class CDXIsoMap : public CDXMap
{
public:
	CDXIsoMap(CDXTile *pTiles, CDXScreen *pScreen):CDXMap(pTiles, pScreen) {};
    virtual void ScrollUp(int);
    virtual void ScrollDown(int);
    virtual void ScrollLeft(int);
    virtual void ScrollRight(int);
    virtual void BltTileTrans(CDXSurface*, int, int, int, int, int, int, int, int);
    virtual void DrawTrans(CDXSurface*);
	POINT ProcessClicks(int, int);
};

#endif
