//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxmusic.h,v $
// $Author: bsimser $
//
// $Log: cdxmusic.h,v $
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.0 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXMUSIC_H
#define CDXMUSIC_H

//////////////////////////////////////////////////////////////////////////////////
// CDXMusic allows you to load and play MIDI files for the music in your game. 
// CDXMusic currently uses the Windows MCI functions and in terms of performance 
// is quite demanding.
//////////////////////////////////////////////////////////////////////////////////
class CDXMusic
{
public:
	CDXMusic(void *hWnd);

	BOOL Play(const char *Filename);
	BOOL Stop(void);
	BOOL Pause(void);
	BOOL Resume(void);
	BOOL Restart(void);

public:
	HWND m_hWnd;				// Window handle
};

//////////////////////////////////////////////////////////////////////////////////
// CDXMusicCd allows you to load and play audio CD files for the music in your game. 
// CDXMusicCd currently uses the Windows MCI functions and in terms of performance 
// is quite demanding.
//////////////////////////////////////////////////////////////////////////////////
class CDXMusicCd
{
public:
	CDXMusicCd(void);
	~CDXMusicCd(void);

	short	Read(void);
	short	GetNumberOfTracks(void)	{ return m_nNumberOfTracks; }
	void  SetNumberOfTracks(short nTracks) { m_nNumberOfTracks = nTracks; }
	short	GetTrackLength(short nTrack);
	void  SetTrackLength(short nTrack, short nNewLength);
	short	GetTotalLength(void);
	void  Play(short nTrack);
	void  Stop(void);

private:
	short	m_nNumberOfTracks;
	short	m_nTrackLength[100];
	MCI_STATUS_PARMS m_MCIStatus;
	MCI_OPEN_PARMS m_MCIOpen;
};

#endif
