//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxresource.h,v $
// $Author: pietro $
//
// $Log: cdxresource.h,v $
// Revision 2.6  1999/05/19 04:30:57  pietro
// modified CreateFromBMPi so that the sizeis last one parameter.
//
// Revision 2.5  1999/05/19 04:07:20  pietro
// removed LoadBMP from CDX Resource. Now every object handles his own loading
// via his own interfaces. in cdx surface, use create.
//
// Revision 2.4  1999/05/18 18:27:11  pietro
// seek returns now FILE* handle of RF for subsequent read operations
//
// Revision 2.3  1999/05/17 21:24:42  pietro
// Added comments
//
// Revision 2.2  1999/05/17 21:10:31  pietro
// Added CDXResWorldObject handling
//
// Revision 2.1  1999/05/17 00:14:10  pietro
// new CDXResource, backward compatibility is maintained.
// For CDXResourceCompiler see Tools.
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.6 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXRESOURCE_H
#define CDXRESOURCE_H

//////////////////////////////////////////////////////////////////////////////////
// Structure used for each file entry in a resource file.
//////////////////////////////////////////////////////////////////////////////////
typedef struct
{
	long offset;
	char name[13];
} FILEENTRY, *LPFILEENTRY;

//////////////////////////////////////////////////////////////////////////////////
//version 2 resource files
//////////////////////////////////////////////////////////////////////////////////

typedef struct
{
	UINT	Signature;			//signature of the resource file, 'CDXR'
	UINT	Version;			//currently version 2
	UINT	NumOfEntries;		//number of resource file entries
} CDXRESOURCEFILEHEADER;

typedef UINT RESHANDLE;

class CDXResDirEntry
{
public:
	CDXResDirEntry()	{pos=0; size=0; type=0; id=0;}		//constructor - so new will be cleared

	UINT		pos;					//position in RF of particular file
	UINT		size;					//size of particular file
	UCHAR		type;					//are 256 different types enough?
	UINT		id;						//id of the file, see IDHFILE keyword of ResourceCompiler
};



//////////////////////////////////////////////////////////////////////////////////
// The CDXResource class allows you to clump all types of files together for 
// your game. Files can be retrieved at runtime with the GetFile() method. There 
// is very little implied structure with the file so any type of file can be
// used as a resource.
//////////////////////////////////////////////////////////////////////////////////
class CDXResource
{
public:
	CDXResource(void);
	~CDXResource(void);

	BOOL Open(const char *Filename);
	BOOL OpenV1(const char *Filename);
	void Close(void);
	char* GetFile(const char *Filename);

public:
	LPFILEENTRY m_pFE;			// file entry structure for each file in a resource file
	int m_Infile;				// handle to the resource file
	int m_Outfile;				// handle to the output file
	int m_nFiles;				// number of files in a resource file

//version 2 resource files
	char	*fName;							//name of Resource File
	FILE	*fHandle;						//handle of Resource File
	UINT	version;						//version of resource file
	UINT	NumOfEntries;
	UINT	fSize;							//Resource File Size
	CDXResDirEntry	*Directory;

	FILE*	GetfHandle();
	RESHANDLE GetHandle(UINT id);
	FILE*	Seek(RESHANDLE i);
	UINT GetPos(RESHANDLE i);
	UINT GetSize(RESHANDLE i);
	UCHAR GetType(RESHANDLE i);
};

#endif
