//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxscreen.cpp,v $
// $Author: janni $
//
// $Log: cdxscreen.cpp,v $
// Revision 2.11  1999/05/21 06:59:00  janni
// took back the changes from revision 2.10
// removed AdjustWinStyle
// only SetVideoMode is in cdxscreen now
//
// Revision 2.10  1999/05/20 22:25:52  janni
// added SetVideoMode which is a shell for CreateWindowed/CreateFullScreen
// added AdjustWinStyle, moved from CDX App Wizard code to CDXScreen, it is called automatically now when you set a videomode
// changed CreateWindowed/CreateFullScreen, they call AdjustWinStyle
// changed CreateWindowed, it now first calls GetDD->RestoreDisplayMode, moved from CDX App Wizard code to here
//
// Revision 2.9  1999/05/20 15:29:03  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.8  1999/05/15 07:56:55  janni
// Flip without VSync in fullscreen DIrectX3 did not work, so I replaced it with a vsynced version, this means that you always get vsync in fullscreen DirectX3
//
// Revision 2.7  1999/05/15 07:26:16  janni
// fixed problem of flipping fullscreen without vsync, problems was that directx does not knowthe
// DDFLIP_NOVSYNC flag so I changed this by flipping the complete backbuffer into the frontbuffer instead
//
// Revision 2.6  1999/05/14 16:31:14  janni
// fixed BOOL in definition of CDXScreen::Flip into bool to provide Visual C 5 compatibility
//
// Revision 2.5  1999/05/14 08:50:35  janni
// added VSync parameter to CDXScreen:Flip , default = true
// true means flip with vsync, flase means flip without vsync
// this works in windowed and fullscreen modes!
//
// Revision 2.4  1999/05/11 21:44:56  janni
// changed DELETE macro to SAFEDELETE to get NT compatibility
//
// Revision 2.3  1999/05/07 20:27:17  janni
// added SetTripleBuffering and GetTripleBuffering
// added WaitForVerticalBlank
// SetTripleBuffering must be called before CreateFullScreen, works not in windowed mode!
// changed Flip - in windowed mode now the flip is vsynced
//
// Revision 2.2  1999/05/06 14:13:27  janni
// Janni: added
//    GetNumberOfVideoModes
//    GetVideoModeInformation
//    CheckIfVideoModeExists(
//
//    changed all 3 constructors to allow mode switching without destroying and recreating CDXScreen object
//    changed destructor
//    added InitCDXScreen, called from all constructors
//
// Revision 2.1  1999/05/03 20:54:41  MICHAELR
// DIRECTDRAW_VERSION incorrectly called DIRECTDRAWVERSION
// CDXScreen::CDXScreen didn't #ifdef out the m_ZBuffer init if using DX3
// CDXScreen::~CDXScreen() didn't #ifdef out the m_ZBuffer release if using DX3
// CDXScreen::CreateFullScreen() on init or DirectDraw object, had two lines referencing lpDD that were not needed for DX3 implementation
// CDXScreen::CreateFullScreen() and CDXScreen::CreateWindowed() were init'ing m_ZBuffer, but didn't handld DX3
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.11 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid[] = "@(#) $Id: cdxscreen.cpp,v 2.11 1999/05/21 06:59:00 janni Exp $";
#endif

#include "CDX.h"
#include "cdxscreen.h"
#include "cdxsurface.h"

//////////////////////////////////////////////////////////////////////////////////
// Initializes all member variables an enumerates video modes
// is called from all constructors! // janni
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::InitCDXScreen()
{
	HRESULT   rval;

	// initialize member variables
	m_lpDD = NULL;
	m_lpDDSFront = NULL;
	m_lpDDSBack = NULL;
	m_lpDDPalette = NULL;
	m_lpClipper = NULL;
#if DIRECTDRAW_VERSION >= CDX_DDVER
	m_ZBuffer = NULL;
#endif

	// create direct draw object
#if DIRECTDRAW_VERSION >= CDX_DDVER
	LPDIRECTDRAW lpDD;

	rval = DirectDrawCreate(NULL, &lpDD, NULL);
	if(rval != DD_OK) DDError(rval, NULL, __FILE__, __LINE__);

	rval = lpDD->QueryInterface(IID_IDirectDraw4, (LPVOID*)&m_lpDD);
	if(rval != DD_OK) DDError(rval, NULL, __FILE__, __LINE__);

	RELEASE(lpDD);
#else
	rval = DirectDrawCreate(NULL, &m_lpDD, NULL);
	if(rval != DD_OK) DDError(rval, NULL, __FILE__, __LINE__);
#endif

    // get all video modes
    m_NumberOfVideoModes = 0;
    m_VideoModes = new CDX_VIDEOMODESSTRUCT;
    m_VideoModes->Width     = 0;
    m_VideoModes->Height    = 0;
    m_VideoModes->BPP       = 0;
    m_VideoModes->NextMode  = NULL;

    m_lpDD->EnumDisplayModes( DDEDM_STANDARDVGAMODES ,
                              NULL , (LPVOID)m_VideoModes , EnumDisplayModesCallback );

    CDX_VIDEOMODESSTRUCT * Modes = ( CDX_VIDEOMODESSTRUCT * )m_VideoModes;

    while( Modes->NextMode != NULL )
    {
        Modes = ( CDX_VIDEOMODESSTRUCT * )Modes->NextMode;
        ++ m_NumberOfVideoModes;
    }   
}


//////////////////////////////////////////////////////////////////////////////////
// Default constructor
//////////////////////////////////////////////////////////////////////////////////
CDXScreen::CDXScreen()
{
	InitCDXScreen();
}

//////////////////////////////////////////////////////////////////////////////////
// Creates the DirectDraw object, sets the screen resolution and creates and 
// attaches the front and back buffer. (this constructor is no different from 
// CreateFullScreen)
//////////////////////////////////////////////////////////////////////////////////
CDXScreen::CDXScreen(void *hWnd, DWORD Width, DWORD Height, DWORD BPP, BOOL bVGA)
{
	InitCDXScreen();
	CreateFullScreen(hWnd, Width, Height, BPP, bVGA);
}

//////////////////////////////////////////////////////////////////////////////////
// Creates the DirectDraw object, initializes DirectDraw for a Windowed mode 
// application. (this constructor is no different from CreateWindowed)
//////////////////////////////////////////////////////////////////////////////////
CDXScreen::CDXScreen(void *hWnd, int Width, int Height)
{
	InitCDXScreen();
	CreateWindowed(hWnd, Width, Height);
}


//////////////////////////////////////////////////////////////////////////////////
// Destroys the DirectDraw object and returns control to Windows.
//////////////////////////////////////////////////////////////////////////////////
CDXScreen::~CDXScreen(void)
{
    CDX_VIDEOMODESSTRUCT * Modes , * Modes2;

	// detstroy linked list with video modes informations
    Modes = m_VideoModes;
    do
    {
        Modes2 = Modes;
        Modes = ( CDX_VIDEOMODESSTRUCT *)Modes->NextMode;
		if( Modes2 != NULL )
			delete Modes2;
    }
    while( Modes != NULL );

	if(m_lpDD != NULL) 
		m_lpDD->RestoreDisplayMode();

	if( m_lpDDSBack != NULL )
		SAFEDELETE( m_lpDDSBack );

	if( m_lpDDSFront != NULL )
		SAFEDELETE(  m_lpDDSFront );

#if DIRECTDRAW_VERSION >= CDX_DDVER
	RELEASE(m_ZBuffer);
#endif
	RELEASE(m_lpClipper);

	RELEASE(m_lpDDPalette);

	RELEASE(m_lpDD);
}



//////////////////////////////////////////////////////////////////////////////////
// Creates the DirectDraw object, initialises CDX for a windowed mode application.  
// The Width and Height are used to create the back buffer size, not the window size.
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXScreen::CreateWindowed(void *hWnd, int Width, int Height)
{
	HRESULT rval;
	DWORD dwFlags;
	HDC hDC;

#if DIRECTDRAW_VERSION >= CDX_DDVER
	DDSURFACEDESC2 ddsd;
#else
	DDSURFACEDESC ddsd;
#endif

	m_lpDD->RestoreDisplayMode();
	// first release everything that has been allocated
	if( m_lpDDSBack != NULL )
		SAFEDELETE( m_lpDDSBack );

	if( m_lpDDSFront != NULL )
		SAFEDELETE(  m_lpDDSFront );

#if DIRECTDRAW_VERSION >= CDX_DDVER
	RELEASE(m_ZBuffer);
#endif
	RELEASE(m_lpClipper);

	RELEASE(m_lpDDPalette);

	m_bFullScreen = FALSE;
	m_lpDDPalette = NULL;
	m_dwPixelWidth = Width;
	m_dwPixelHeight = Height;
	m_hWnd = hWnd;

	hDC = GetDC(NULL);
	m_BPP = GetDeviceCaps(hDC, PLANES) * GetDeviceCaps(hDC, BITSPIXEL);
	ReleaseDC(NULL, hDC);

	dwFlags = DDSCL_NORMAL;

	rval = m_lpDD->SetCooperativeLevel((HWND)hWnd, dwFlags);
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;

	m_lpDDSFront = new CDXSurface();
	m_lpDDSBack = new CDXSurface();

	rval = m_lpDD->CreateSurface(&ddsd, &m_lpDDSFront->m_lpDDS, NULL);
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	m_lpDD->AddRef();

	ddsd.dwFlags = DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;    
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
	ddsd.dwWidth = Width;
	ddsd.dwHeight = Height;

	rval = m_lpDD->CreateSurface( &ddsd, &m_lpDDSBack->m_lpDDS, NULL );
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	m_lpDD->AddRef();

	rval = m_lpDD->CreateClipper(0, &m_lpClipper, NULL);
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	rval = m_lpClipper->SetHWnd(0, (HWND)hWnd);
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	rval = m_lpDDSFront->m_lpDDS->SetClipper(m_lpClipper);
	if(rval != DD_OK) DDError(rval, (HWND)hWnd, __FILE__, __LINE__);

	m_lpDDSFront->m_PixelWidth		= m_dwPixelWidth;
	m_lpDDSFront->m_PixelHeight		= m_dwPixelHeight;
	m_lpDDSFront->DestRect.top		= 0;
	m_lpDDSFront->DestRect.left		= 0;
	m_lpDDSFront->DestRect.bottom	= m_dwPixelHeight;
	m_lpDDSFront->DestRect.right	= m_dwPixelWidth;
	m_lpDDSFront->SrcRect.top		= 0;
	m_lpDDSFront->SrcRect.left		= 0;
	m_lpDDSFront->SrcRect.bottom	= m_dwPixelHeight;
	m_lpDDSFront->SrcRect.right		= m_dwPixelWidth;
	m_lpDDSFront->Screen			= this;
	m_lpDDSFront->SetClipRect(&(m_lpDDSFront->SrcRect));
	GetRGBFormat(m_lpDDSFront->m_lpDDS,&(m_lpDDSFront->m_RGB));

	m_lpDDSBack->m_PixelWidth		= m_dwPixelWidth;
	m_lpDDSBack->m_PixelHeight		= m_dwPixelHeight;
	m_lpDDSBack->DestRect.top		= 0;
	m_lpDDSBack->DestRect.left		= 0;
	m_lpDDSBack->DestRect.bottom	= m_dwPixelHeight;
	m_lpDDSBack->DestRect.right		= m_dwPixelWidth;
	m_lpDDSBack->SrcRect.top		= 0;
	m_lpDDSBack->SrcRect.left		= 0;
	m_lpDDSBack->SrcRect.bottom		= m_dwPixelHeight;
	m_lpDDSBack->SrcRect.right		= m_dwPixelWidth;
	m_lpDDSBack->Screen				= this;
	m_lpDDSBack->SetClipRect(&(m_lpDDSBack->SrcRect));
	GetRGBFormat(m_lpDDSBack->m_lpDDS,&(m_lpDDSBack->m_RGB));

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// Creates the DirectDraw object, sets the screen resolution and creates and 
// attaches the front and back buffer.
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXScreen::CreateFullScreen(void *hWnd, DWORD Width, DWORD Height, DWORD BPP, BOOL bVGA)
{
	HRESULT rval;
	DWORD dwFlags;

#if DIRECTDRAW_VERSION >= CDX_DDVER
	DDSURFACEDESC2 ddsd;
	DDSCAPS2 ddscaps;
#else
	DDSURFACEDESC ddsd;
	DDSCAPS ddscaps;
#endif

	// first release everything that has been allocated
	if( m_lpDDSBack != NULL )
		SAFEDELETE( m_lpDDSBack );

	if( m_lpDDSFront != NULL )
		SAFEDELETE(  m_lpDDSFront );

#if DIRECTDRAW_VERSION >= CDX_DDVER
	RELEASE(m_ZBuffer);
#endif
	RELEASE(m_lpClipper);

	RELEASE(m_lpDDPalette);

	m_bFullScreen = TRUE;
	m_lpDDPalette = NULL;
	m_dwPixelWidth = Width;
	m_dwPixelHeight = Height;
	m_BPP = BPP;
	m_hWnd = hWnd;

	dwFlags = DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT | DDSCL_ALLOWMODEX;

	rval = m_lpDD->SetCooperativeLevel((HWND)hWnd, dwFlags);
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

#if DIRECTDRAW_VERSION >= CDX_DDVER
	if(bVGA) rval = m_lpDD->SetDisplayMode(m_dwPixelWidth, m_dwPixelHeight, m_BPP, 0, DDSDM_STANDARDVGAMODE);
	else rval = m_lpDD->SetDisplayMode(m_dwPixelWidth, m_dwPixelHeight, m_BPP, 0, 0);
#else
	rval = m_lpDD->SetDisplayMode(m_dwPixelWidth, m_dwPixelHeight, m_BPP);
#endif

	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	// when triple buffering is set try to allocate 2 back buffers
	// when an error occurs then the system is unable to create 2 backbuffers
	// and i try to create only one!
	// I use gotos here because it makes things much easier for me :-  (janni)
	if( GetTripleBuffering( )  == true )
	{
		ZeroMemory(&ddsd, sizeof(ddsd));
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
		ddsd.dwBackBufferCount = 2;

		m_lpDDSFront = new CDXSurface;
		m_lpDDSBack = new CDXSurface;

		rval = m_lpDD->CreateSurface(&ddsd, &m_lpDDSFront->m_lpDDS, NULL);
		if(rval != DD_OK) goto Create1Backbuffer;

		m_lpDD->AddRef();

		ddscaps.dwCaps = DDSCAPS_BACKBUFFER;

		rval = m_lpDDSFront->m_lpDDS->GetAttachedSurface(&ddscaps, &m_lpDDSBack->m_lpDDS);
		if(rval != DD_OK) goto Create1Backbuffer;

		m_lpDD->AddRef();
		goto SkipCreationOf1Backbuffer;
	}

Create1Backbuffer :

	m_TripleBuffering = false;
	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
	ddsd.dwBackBufferCount = 1;

	m_lpDDSFront = new CDXSurface;
	m_lpDDSBack = new CDXSurface;

	rval = m_lpDD->CreateSurface(&ddsd, &m_lpDDSFront->m_lpDDS, NULL);
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	m_lpDD->AddRef();

	ddscaps.dwCaps = DDSCAPS_BACKBUFFER;

	rval = m_lpDDSFront->m_lpDDS->GetAttachedSurface(&ddscaps, &m_lpDDSBack->m_lpDDS);
	if(rval != DD_OK) DDError(rval, hWnd, __FILE__, __LINE__);

	m_lpDD->AddRef();

SkipCreationOf1Backbuffer:

	m_lpDDSFront->m_PixelWidth		= m_dwPixelWidth;
	m_lpDDSFront->m_PixelHeight		= m_dwPixelHeight;
	m_lpDDSFront->DestRect.top		= 0;
	m_lpDDSFront->DestRect.left		= 0;
	m_lpDDSFront->DestRect.bottom	= m_dwPixelHeight;
	m_lpDDSFront->DestRect.right	= m_dwPixelWidth;
	m_lpDDSFront->SrcRect.top		= 0;
	m_lpDDSFront->SrcRect.left		= 0;
	m_lpDDSFront->SrcRect.bottom	= m_dwPixelHeight;
	m_lpDDSFront->SrcRect.right		= m_dwPixelWidth;
	m_lpDDSFront->Screen			= this;
	m_lpDDSFront->SetClipRect(&(m_lpDDSFront->SrcRect));
	GetRGBFormat(m_lpDDSFront->m_lpDDS,&(m_lpDDSFront->m_RGB));

	m_lpDDSBack->m_PixelWidth		= m_dwPixelWidth;
	m_lpDDSBack->m_PixelHeight		= m_dwPixelHeight;
	m_lpDDSBack->DestRect.top		= 0;
	m_lpDDSBack->DestRect.left		= 0;
	m_lpDDSBack->DestRect.bottom	= m_dwPixelHeight;
	m_lpDDSBack->DestRect.right		= m_dwPixelWidth;
	m_lpDDSBack->SrcRect.top		= 0;
	m_lpDDSBack->SrcRect.left		= 0;
	m_lpDDSBack->SrcRect.bottom		= m_dwPixelHeight;
	m_lpDDSBack->SrcRect.right		= m_dwPixelWidth;
	m_lpDDSBack->Screen				= this;
	m_lpDDSBack->SetClipRect(&(m_lpDDSBack->SrcRect));
	GetRGBFormat(m_lpDDSBack->m_lpDDS,&(m_lpDDSBack->m_RGB));

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// Displays the contents of the back buffer on screen.  
// If in a windowed mode, Flip will stretch the back buffer to fit into the window.
// Default parameter VSync = true = wait for vsync
// when VSync = false, then the flip is done without vsync!
// CAUTION: In DirectX 3 the fullscreen flip always is vsynced!
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXScreen::Flip(BOOL VSync)
{
	HRESULT rval;

	if(m_bFullScreen)
	{
		if( VSync == TRUE )
			rval = m_lpDDSFront->m_lpDDS->Flip(NULL, DDFLIP_WAIT);
		else
#if DIRECTDRAW_VERSION >= CDX_DDVER
			rval = m_lpDDSFront->m_lpDDS->Flip(NULL, DDFLIP_NOVSYNC);
#else
		// In DirectX 3 I tried to blit the backbuffer to the frontbuffer
		// because the DDFLIP_NOVSYNC flag is not know there but it did not work!
		// so I made DirectX 3 flip without vsync flip with vsync!
			//rval = m_lpDDSFront->m_lpDDS->BltFast( 0 , 0 , m_lpDDSBack->m_lpDDS, NULL, DDBLT_WAIT );
		rval = m_lpDDSFront->m_lpDDS->Flip(NULL, DDFLIP_WAIT);
#endif
		if(rval == DDERR_SURFACELOST) Restore();
	}
	else
	{
		RECT Window;
		POINT pt;

		GetClientRect((HWND)m_hWnd, &Window);
		pt.x = pt.y = 0;
		ClientToScreen((HWND)m_hWnd, &pt);
		OffsetRect(&Window, pt.x, pt.y);

		if( VSync == TRUE )
			WaitForVerticalBlank( );

		rval = m_lpDDSFront->m_lpDDS->Blt(&Window, m_lpDDSBack->m_lpDDS, NULL, DDBLT_WAIT, NULL);
		if(rval == DDERR_SURFACELOST) Restore();
	}

	return rval;
}

//////////////////////////////////////////////////////////////////////////////////
// Fills the back buffer with the specified colour.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::Fill(DWORD FillColor)
{
	DDBLTFX ddBltFx;

	ddBltFx.dwSize = sizeof(DDBLTFX);
	ddBltFx.dwFillColor = FillColor;
	m_lpDDSBack->m_lpDDS->Blt(NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddBltFx);
}

//////////////////////////////////////////////////////////////////////////////////
// Loads a .BMP file straight onto the back buffer.
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXScreen::LoadBitmap(const char* szFilename)
{
	if(szFilename == NULL) return FALSE;
	if(DDReLoadBitmap(m_lpDDSBack->m_lpDDS, szFilename) != DD_OK) return FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// Loads the palette from a .BMP file.  Should be called before other bitmap operations.
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXScreen::LoadPalette(const char* szFilename)
{
	if(szFilename == NULL) return FALSE;
	m_lpDDPalette = DDLoadPalette(m_lpDD, szFilename);
	if(m_lpDDPalette == NULL) return FALSE;
	m_lpDDSFront->m_lpDDS->SetPalette(m_lpDDPalette);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// Restores the DirectDraw object if lost.  Called internally if a flip fails.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::Restore(void)
{
	if(m_lpDDSFront->m_lpDDS != NULL && m_lpDDSFront->m_lpDDS->IsLost() != DD_OK)
	{
		m_lpDDSFront->m_lpDDS->Restore();
	}
}

//////////////////////////////////////////////////////////////////////////////////
// Sets the red, green and blue values of a single colour in the current palette.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::SetColor(int col, int r, int g, int b)
{
	PALETTEENTRY pe[1];

	m_lpDDPalette->GetEntries(0, col, 1, pe);
	pe[0].peRed = r;
	pe[0].peGreen = g;
	pe[0].peBlue = b;
	m_lpDDPalette->SetEntries(0, col, 1, pe);
}

//////////////////////////////////////////////////////////////////////////////////
// Returns the red, green and blue values of a single colour in the current palette.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::GetColor(int col, int *r, int *g, int *b)
{
	PALETTEENTRY pe[1];

	m_lpDDPalette->GetEntries(0, col, 1, pe);
	*r = pe[0].peRed;
	*g = pe[0].peGreen;
	*b = pe[0].peBlue;
}

//////////////////////////////////////////////////////////////////////////////////
// Sets the palette pointed to by lpPE.  Start indicates the first entry to be set 
// and Count is the number of palette entries to be changed.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::SetPalette(int Start, int Count, LPPALETTEENTRY lpPE)
{
	m_lpDDPalette->SetEntries(0, Start, Count, lpPE);
}

//////////////////////////////////////////////////////////////////////////////////
// Fills lpPE with values from the current palette.  Start indicates the first 
// entry to be set and Count is the number of palette entries to be changed.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::GetPalette(int Start, int Count, LPPALETTEENTRY lpPE)
{
	m_lpDDPalette->GetEntries(0, Start, Count, lpPE);
}

//////////////////////////////////////////////////////////////////////////////////
// Sets all the palette entries to a single colour.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::FillPalette(int r, int g, int b)
{
	PALETTEENTRY pe[256];

	m_lpDDPalette->GetEntries(0, 0, 256, pe);

	for(int i = 1; i < 256; i++)
	{
		pe[i].peRed = r;
		pe[i].peGreen = g;
		pe[i].peBlue = b;
	}
	m_lpDDPalette->SetEntries(0, 0, 256, pe);
}

//////////////////////////////////////////////////////////////////////////////////
// Converts the current palette into a monochrome palette.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::GreyScale(void)
{
	PALETTEENTRY pe[256];
	int total, grey;

	m_lpDDPalette->GetEntries(0, 0, 256, pe);

	for(int i = 1; i < 256; i++)
	{
		total = pe[i].peRed + pe[i].peGreen + pe[i].peBlue;
		grey = total / 3;

		pe[i].peRed = grey;
		pe[i].peGreen = grey;
		pe[i].peBlue = grey;
	}
	m_lpDDPalette->SetEntries(0, 0, 256, pe);
}

//////////////////////////////////////////////////////////////////////////////////
// Smoothly fades the current palette into the palette pointed to by lpPE.  It 
// takes 3 steps to operate a fade in function.  First you should get the current 
// palette using GetPalette, then you should set the current palette to the colour 
// you wish to start from, lastly you call FadeIn with the palette you grabbed in 
// the first step.
//
// For example:
//
// CDXScreen Screen;
// PALETTEENTRY pe[256];
// Screen->GetPalette(0, 256, pe);
// Screen->FillPalette(255, 0, 0);
// Screen->FadeIn(6, pe);
//
// This code would make the screen flash red then return to how it started, just 
// like a rocket hit in Quake!
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::FadeIn(int delay, LPPALETTEENTRY lpPE)
{
	PALETTEENTRY pe[256];

	m_lpDDPalette->GetEntries(0, 0, 256, pe);

	for(int j = 1; j < 84; j++)
	{
		for(int i = 1; i < 256; i++)
		{
			// Red
			if(pe[i].peRed > (lpPE[i].peRed+5)) pe[i].peRed -= 3;
			else if(pe[i].peRed < (lpPE[i].peRed-5)) pe[i].peRed += 3;
			else pe[i].peRed = lpPE[i].peRed;

			// Green
			if(pe[i].peGreen > (lpPE[i].peGreen+5)) pe[i].peGreen -= 3;
			else if(pe[i].peGreen < (lpPE[i].peGreen-5)) pe[i].peGreen += 3;
			else pe[i].peGreen = lpPE[i].peGreen;

			// Blue
			if(pe[i].peBlue > (lpPE[i].peBlue+5)) pe[i].peBlue -= 3;
			else if(pe[i].peBlue < (lpPE[i].peBlue-5)) pe[i].peBlue += 3;
			else pe[i].peBlue = lpPE[i].peBlue;

			// Add a delay here for slower fades
			for(long d = 0; d < delay*100; d++) ;
		}
		m_lpDDPalette->SetEntries(0, 0, 256, pe);
	}
}

//////////////////////////////////////////////////////////////////////////////////
// Smoothly fades the current palette to black.  A delay of 0 to 10 seems about 
// right (0 - fast, 10 - slow).
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::FadeOut(int delay)
{
	PALETTEENTRY pe[256];

	m_lpDDPalette->GetEntries(0, 0, 256, pe);

	for(int j = 1; j < 84; j++)
	{
		for(int i = 1; i < 256; i++)
		{
			// Red
			if(pe[i].peRed > 5) pe[i].peRed -= 3;
			else pe[i].peRed = 0;

			// Green
			if(pe[i].peGreen > 5) pe[i].peGreen -= 3;
			else pe[i].peGreen = 0;

			// Blue
			if(pe[i].peBlue > 5) pe[i].peBlue -= 3;
			else pe[i].peBlue = 0;

			// Add a delay here for slower fades
			for(long d = 0; d < delay*100; d++) ;
		}
		m_lpDDPalette->SetEntries(0, 0, 256, pe);
	}
}

//////////////////////////////////////////////////////////////////////////////////
// Smoothly fades the current palette to the specified colour.
//////////////////////////////////////////////////////////////////////////////////
void CDXScreen::FadeTo(int r, int g, int b, int delay)
{
	PALETTEENTRY pe[256];

	m_lpDDPalette->GetEntries(0, 0, 256, pe);

	for(int j = 1; j < 84; j++)
	{
		for(int i = 1; i < 256; i++)
		{
			// Red
			if(pe[i].peRed > r+5) pe[i].peRed -= 3;
			else if(pe[i].peRed < r-5) pe[i].peRed += 3;
			else pe[i].peRed = r;

			// Green
			if(pe[i].peGreen > g+5) pe[i].peGreen -= 3;
			else if(pe[i].peGreen < g-5) pe[i].peGreen += 3;
			else pe[i].peGreen = g;

			// Blue
			if(pe[i].peBlue > b+5) pe[i].peBlue -= 3;
			else if(pe[i].peBlue < b-5) pe[i].peBlue += 3;
			else pe[i].peBlue = b;

			// Add a delay here for slower fades
			for(long d = 0; d < delay*100; d++) ;
		}
		m_lpDDPalette->SetEntries(0, 0, 256, pe);
	}
}



//////////////////////////////////////////////////////////////////////////////////
// gets the numer of video modes the card supports
// this function is needed if you need a list of all videomodes to know
// how much modes there are and to get them via GetVideoModeInformation
//////////////////////////////////////////////////////////////////////////////////
DWORD CDXScreen::GetNumberOfVideoModes( void )
{
    return m_NumberOfVideoModes;
}



//////////////////////////////////////////////////////////////////////////////////
// Gets information about Videomode Index, Index is a number from 0 to GetNumberOfVideoModes
// if an invalid mode index is given, the return value is false, else true
//////////////////////////////////////////////////////////////////////////////////
bool CDXScreen::GetVideoModeInformation( DWORD Index  , DWORD * Width , DWORD * Height , DWORD * BPP )
{
    CDX_VIDEOMODESSTRUCT * Modes;

    Modes = m_VideoModes;

    if( Index < m_NumberOfVideoModes )
    {
        while( Index > 0 )
        {
            -- Index;
            Modes = ( CDX_VIDEOMODESSTRUCT * )Modes->NextMode;
        }
        *Width   = Modes->Width;
        *Height  = Modes->Height;
        *BPP     = Modes->BPP;

        return true;
    }
    else
        return false;
}


//////////////////////////////////////////////////////////////////////////////////
// checks if the desired video mode exists, if yes return = true , else return = false
//////////////////////////////////////////////////////////////////////////////////
bool CDXScreen::CheckIfVideoModeExists( DWORD Width , DWORD Height , DWORD BPP )
{
    bool                    found;
    CDX_VIDEOMODESSTRUCT *  Modes;

    Modes = m_VideoModes;
    found = false;

    while( Modes->NextMode != NULL )
    {
        if( ( Modes->Width  == Width  ) &&
            ( Modes->Height == Height ) &&
            ( Modes->BPP    == BPP    ) )
        {
            found = true;
            break;
        }
        Modes = ( CDX_VIDEOMODESSTRUCT * )Modes->NextMode;
    }

    return found;
}


//////////////////////////////////////////////////////////////////////////////////
// waits until the vertical blank phase starts
//////////////////////////////////////////////////////////////////////////////////
HRESULT CDXScreen::WaitForVerticalBlank( void )
{
	return m_lpDD->WaitForVerticalBlank(  DDWAITVB_BLOCKBEGIN , 0 );
}



// --------------------------------------------------------------------------------
// Sets the current video mode, if BPP = 0 then a windowed mode is set
// --------------------------------------------------------------------------------
BOOL CDXScreen::SetVideoMode( void * hWnd , int Width , int Height , int BPP )
{
	if( BPP == 0 )
		return CreateWindowed( hWnd , Width , Height );
	else
		return CreateFullScreen( hWnd , Width , Height , BPP );
}