//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxscreen.h,v $
// $Author: janni $
//
// $Log: cdxscreen.h,v $
// Revision 2.8  1999/05/21 06:59:47  janni
// took back the changes from revision 2.7
// removed AdjustWinStyle
// only SetVideoMode is in cdxscreen now
//
// Revision 2.7  1999/05/20 22:24:27  janni
// added SetVideoMode which is a shell for CreateWindowed/CreateFullScreen
// added AdjustWinStyle, moved from CDX App Wizard code to CDXScreen, it is called automatically now when you set a videomode
//
// Revision 2.6  1999/05/14 16:30:56  janni
// fixed BOOL in definition of CDXScreen::Flip into bool to provide Visual C 5 compatibility
//
// Revision 2.5  1999/05/14 08:50:01  janni
// added VSync parameter to CDXScreen:Flip , default = true
// true means flip with vsync, flase means flip without vsync
// this works in windowed and fullscreen modes!
//
// Revision 2.4  1999/05/07 20:25:55  janni
// added SetTripleBuffering and GetTripleBuffering
// added WaitForVerticalBlank
//
// Revision 2.3  1999/05/06 14:11:21  janni
// Janni: added
//    members:
//     CDX_VIDEOMODESSTRUCT;
//     m_NumberOfVideoModes;
//     m_VideoModes;
//
//     functions:
//     EnumDisplayModesCallback
//     GetNumberOfVideoModes
//     GetVideoModeInformation
//     CheckIfVideoModeExists
//
// Revision 2.2  1999/05/03 21:08:56  MICHAELR
// fixed a place i missed where DIRECTDRAW_VERSION was incorrectly called DIRECTDRAWVERSION
//
// Revision 2.1  1999/05/03 20:46:03  MICHAELR
// DIRECTDRAW_VERSION was incorrectly called DIRECTDRAWVERSION
// CDXScreen::m_lpDD didn't support DX3 compaible LPDIRECTDRAW
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.8 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXSCREEN_H
#define CDXSCREEN_H


// structure for videomodes
// Janni
typedef struct 
{
    DWORD					Width;
    DWORD					Height;
    DWORD					BPP;
    void				*   NextMode;
} CDX_VIDEOMODESSTRUCT;

// callback function for video mode enumeration, implemented in ddutils.cpp
#if DIRECTDRAW_VERSION >= CDX_DDVER
HRESULT CALLBACK EnumDisplayModesCallback( LPDDSURFACEDESC2 lpDDSurfaceDesc,  
                                           LPVOID lpContext  );
#else
HRESULT CALLBACK EnumDisplayModesCallback( LPDDSURFACEDESC lpDDSurfaceDesc,  
                                           LPVOID lpContext  );
#endif

// Janni


// Forward declaration needed for the CDXScreen class
class CDXSurface;

//////////////////////////////////////////////////////////////////////////////////
// CDXScreen is the primary object of the library and every program that
// uses CDX must include a CDXScreen object.  As the name implies CDXScreen
// contains all the functions necessary to control the video display,
// currently this also includes functions to control the palette.
//////////////////////////////////////////////////////////////////////////////////
class CDXScreen
{
public:
	CDXScreen();
	CDXScreen(void *hWnd, DWORD Width, DWORD Height, DWORD BPP, BOOL bVGA = FALSE);
	CDXScreen(void *hWnd, int Width, int Height);
	~CDXScreen();

	BOOL CreateFullScreen(void *hWnd, DWORD Width, DWORD Height, DWORD BPP, BOOL bVGA = FALSE);
	BOOL CreateWindowed(void *hWnd, int Width, int Height);
	BOOL LoadBitmap(const char* szFilename);
	BOOL LoadPalette(const char* szFilename);
	void Fill(DWORD FillColor);
	void Restore(void);
	HRESULT Flip( BOOL VSync=TRUE);

	void SetColor(int col, int r, int g, int b);
	void GetColor(int col, int *r, int *g, int *b);
	void SetPalette(int Start, int Count, LPPALETTEENTRY lpPE);
	void GetPalette(int Start, int Count, LPPALETTEENTRY lpPE);
	void FillPalette(int r, int g, int b);
	void GreyScale(void);
	void FadeIn(int delay, LPPALETTEENTRY lpPE);
	void FadeOut(int delay);
	void FadeTo(int r, int g, int b, int delay);

	int GetWidth(void) { return m_dwPixelWidth; }
	int GetHeight(void) { return m_dwPixelHeight; }
	int GetBPP(void) { return m_BPP; }

#if DIRECTDRAW_VERSION >= CDX_DDVER
	LPDIRECTDRAW4 GetDD(void) { return m_lpDD; }
#else
	LPDIRECTDRAW GetDD(void) { return m_lpDD; }
#endif

	CDXSurface* GetFront(void) { return m_lpDDSFront; }
	CDXSurface* GetBack(void) { return m_lpDDSBack; }
	LPDIRECTDRAWPALETTE GetPalette(void) { return m_lpDDPalette; }
// Janni
    DWORD GetNumberOfVideoModes( void );
    bool  GetVideoModeInformation( DWORD Index  , DWORD * Width , DWORD * Height , DWORD * BPP );
    bool  CheckIfVideoModeExists( DWORD Width , DWORD Height , DWORD BPP );
	HRESULT WaitForVerticalBlank( void );
	void InitCDXScreen();
	void SetTripleBuffering( bool Flag ) { m_TripleBuffering = Flag; }
	bool GetTripleBuffering( void ) { return m_TripleBuffering; }
	BOOL SetVideoMode( void * hWnd , int Width , int Height , int BPP = 0 );
// Janni

public:

#if DIRECTDRAW_VERSION >= CDX_DDVER
	LPDIRECTDRAW4 m_lpDD;						 // the DirectDraw object
#else
	LPDIRECTDRAW m_lpDD;						 // the DirectDraw object
#endif

	CDXSurface* m_lpDDSFront;					 // a CDXSurface object for the front buffer
	CDXSurface* m_lpDDSBack;					 // a CDXSurface object for the back buffer

#if DIRECTDRAW_VERSION >= CDX_DDVER
	LPDIRECTDRAWSURFACE4 m_ZBuffer;		
#endif

	LPDIRECTDRAWPALETTE m_lpDDPalette;			 // the DirectDraw palette object
	LPDIRECTDRAWCLIPPER m_lpClipper;			 // the DirectDraw clipper, used for window mode only

	DWORD m_dwPixelWidth;						 // the screen width, in pixels
	DWORD m_dwPixelHeight;						 // the screen height, in pixels
	DWORD m_BPP;								 // bits per pixel (colour depth)
	void* m_hWnd;								 // pointer to the HWND handle of the window

	BOOL m_bFullScreen;							 // is the program running in fullscreen mode?
// Janni
    DWORD                   m_NumberOfVideoModes; // number of video modes the video adapter supports
    CDX_VIDEOMODESSTRUCT *  m_VideoModes;		// linked list with all video modes informations
	bool					m_TripleBuffering;	// is triple buffering enabled ?
// Janni

};

#endif
