//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxsound.cpp,v $
// $Author: pietro $
//
// $Log: cdxsound.cpp,v $
// Revision 2.1  1999/05/20 15:29:03  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.0  1999/05/01 13:51:16  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid[] = "@(#) $Id: cdxsound.cpp,v 2.1 1999/05/20 15:29:03 pietro Exp $";
#endif

#include "CDX.h"
#include "cdxsound.h"

//////////////////////////////////////////////////////////////////////////////////
// Default constructor.
//////////////////////////////////////////////////////////////////////////////////
CDXSound::CDXSound()
{
	m_lpDS = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// Default destructor.
//////////////////////////////////////////////////////////////////////////////////
CDXSound::~CDXSound()
{
	if(m_lpDS) m_lpDS->Release();
}

//////////////////////////////////////////////////////////////////////////////////
// Initializes the DirectSound object. The return value contains either the 
// return value of the failed SetCooperativeLevel call, or DS_OK if the 
// function succeeds.
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSound::Create(void *hWnd)
{
	HRESULT rval;

	rval = DirectSoundCreate(NULL, &m_lpDS, NULL);
	if(rval != DS_OK) DSError(rval, hWnd);

	rval = m_lpDS->SetCooperativeLevel((HWND)hWnd, DSSCL_NORMAL);
	if(rval != DS_OK) DSError(rval, hWnd);

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// Gets the current sound capabilities. The return value contains the result 
// of the GetCaps call if the call fails. DS_OK is returned is call succeeds.
//////////////////////////////////////////////////////////////////////////////////
BOOL CDXSound::GetCaps(void)
{
	HRESULT rval;

	rval = m_lpDS->GetCaps(&m_DSCaps);
	if(rval != DS_OK) return FALSE;

	return TRUE;
}
