//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxsound.h,v $
// $Author: bsimser $
//
// $Log: cdxsound.h,v $
// Revision 2.0  1999/05/01 13:51:17  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.0 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXSOUND_H
#define CDXSOUND_H

//////////////////////////////////////////////////////////////////////////////////
// CDXSound is a simple wrapper for a DirectSound object. It is necessary to 
// create a CDXSound object before you can load and play sound using the 
// CDXSoundBuffer object.
//////////////////////////////////////////////////////////////////////////////////
class CDXSound
{
public:
	CDXSound(void);
	~CDXSound(void);

	BOOL Create(void *hWnd);
	BOOL GetCaps(void);

public:
	LPDIRECTSOUND m_lpDS;					// The DirectSound Object
	DSCAPS m_DSCaps;						// Direct sound capabilities
};

//////////////////////////////////////////////////////////////////////////////////
// A simple wrapper for a DirectSoundBuffer object. It is used to load and play 
// WAVE files for the sound effects in your game.
//////////////////////////////////////////////////////////////////////////////////
class CDXSoundBuffer
{
public:
	CDXSoundBuffer(void);
	~CDXSoundBuffer(void);

	BOOL Load(CDXSound* pDS, const char* Filename, int Num = 1);
	BOOL Play(int Pan = 0, DWORD dwFlags = 0);
	BOOL Stop(void);
	void SetVolume(LONG Volume);

	BOOL LoadFromFile(void);
	BOOL CreateSoundBuffer(DWORD dwBufSize, DWORD dwFreq, DWORD dwBitsPerSample,
												 DWORD dwBlkAlign, BOOL bStereo);
	BOOL ReadData(FILE* fp, DWORD dwSize, DWORD dwPos);
	LPDIRECTSOUNDBUFFER GetFreeBuffer(void);

public:
	int m_nBuffers;							// The number of sound buffers created
	int m_Current;							// The currently selected buffer
	const char* m_Filename;					// The name of the WAVE file
	CDXSound* m_pDS;						// Contains a pointer to the CDXSound object
	LPDIRECTSOUNDBUFFER m_lpDSB[1];			// The IDirectSoundBuffer object
};

#endif
