//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxsprite.h,v $
// $Author: pietro $
//
// $Log: cdxsprite.h,v $
// Revision 2.1  1999/05/20 15:29:03  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.0  1999/05/01 13:51:17  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXSPRITE_H
#define CDXSPRITE_H

#include "cdxtile.h"
#include "cdxmap.h"

// CDXSprite BLT types
#define CDXBLT_BLK				0
#define CDXBLT_BLKALPHA			1
#define CDXBLT_BLKALPHAFAST		2
#define CDXBLT_BLKSCALED		3
#define CDXBLT_BLKSHADOW		4
#define CDXBLT_BLKSHADOWFAST	5
#define CDXBLT_BLKROTATED		6
#define CDXBLT_BLKROTOZOOM		7
#define CDXBLT_BLKHFLIP			8
#define CDXBLT_BLKVFLIP			9

#define CDXBLT_TRANS			100
#define CDXBLT_TRANSALPHA		101
#define CDXBLT_TRANSALPHAFAST	102
#define CDXBLT_TRANSSCALED		103
#define CDXBLT_TRANSSHADOW		104
#define CDXBLT_TRANSSHADOWFAST	105
#define CDXBLT_TRANSROTATED		106
#define CDXBLT_TRANSROTOZOOM	107
#define CDXBLT_TRANSHFLIP		108
#define CDXBLT_TRANSVFLIP		109

#define CDXBLT_TRANSALPHALUT	110
#define CDXBLT_TRANSALPHAORIG	111
#define CDXBLT_TRANSALPHAMASK	112

//////////////////////////////////////////////////////////////////////////////////
// This class contains the data and functions required to display animated sprites.
// A CDXSprite object is created from a pointer to a CDXTile object which is used 
// to store the bitmap data for the sprite. All the sprite's frames must be the 
// same width and height and stored in the same bitmap file.
//////////////////////////////////////////////////////////////////////////////////
class CDXSprite
{
public:
	CDXSprite(void) {}
	CDXSprite(CDXTile* pTile);

	CDXSprite(CDXScreen *pScreen, const char* Filename, int w, int h, int num, BOOL memoryType);
	virtual ~CDXSprite(void);

	BOOL Create(CDXTile* pTile);
	BOOL Create(CDXScreen *pScreen, const char* Filename, int w, int h, int num, BOOL memoryType);

	void SetPos(int pX, int pY) { m_PosX = pX; m_PosY = pY; }
	void SetVel(int vX, int vY) { m_VelX = vX; m_VelY = vY; }
	void SetFrame(int Frame) { m_Frame = Frame; }
	void SetDelay(int Delay) { m_Delay = Delay; }
	void SetState(int State) { m_State = State; }
	void SetType(int Type) { m_Type = Type; }

	void Lock(void) { m_Tile->Lock(); }
	void UnLock(void) { m_Tile->UnLock(); }
	
	void SetShadowOffset(LONG dx, LONG dy);
	void SetShadowValue(WORD Shade) { m_ShadowValue = Shade; }
	void SetAlphaValue(WORD Shade) { m_AlphaValue = Shade; }
	void SetColorKey(DWORD Col) { m_Tile->SetColorKey(Col); }
	void SetColorKey(void) { m_Tile->SetColorKey(); }
	
	BOOL SpriteHit(CDXSprite* pSprite);
	BOOL TileHit(CDXMap* pMap, int Tile);

	void Draw(CDXSurface* lpCDXS, DWORD ScrnWorldX, DWORD ScrnWorldY, WORD BltType);
	HRESULT BlkBlt(CDXSurface* lpDDSDest, RECT SrcRect, RECT DestRect);
	HRESULT TransBlt(CDXSurface* lpDDS, RECT SrcRect, RECT DestRect);
	HRESULT TransHFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect);
	HRESULT BlkHFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect);
	HRESULT TransVFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect);
	HRESULT BlkVFlip(CDXSurface* lpCDXSDest, RECT SrcRect, RECT DestRect);
	HRESULT BlkAlpha(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT BlkAlphaFast(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT BlkShadow(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT BlkShadowFast(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT TransAlpha(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT TransAlphaFast(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT TransShadow(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT TransShadowFast(CDXSurface* dest, RECT srcRect, RECT destRect);
	HRESULT TransAlphaMask(CDXSurface* dest, RECT srcRect, RECT destRect);

public:
	int m_PosX;				// The sprite's X position
	int m_PosY;				// The sprite's Y position
	int m_PosZ;
	int m_VelX;				// The sprite's X velocity
	int m_VelY;				// The sprite's Y velocity
	int m_Frame;			// The current frame
	int m_Delay;			// Used for game timing, the time till the next frame
	int m_State;			// User defined state.  Walking, jumping, etc
	int m_Type;				// User defined type.  Health, weapon, etc
	int m_Angle;			// The sprite's angle of rotation
	BOOL m_Flipped;			// Is the sprite flipped?

	LONG m_ShadowOffsetX;
	LONG m_ShadowOffsetY;
	WORD m_ShadowValue;
	WORD m_AlphaValue;
	BOOL m_TileCreated;

	CDXTile* m_Tile;		// A CDXTile pointer to the sprite's bitmap data
	CDXSprite* m_Next;		// A CDXSprite pointer to the next sprite in a CDXSpriteList
	CDXSprite* m_Prev;		// A CDXSprite pointer to the previous sprite in a CDXSpriteList
};

//////////////////////////////////////////////////////////////////////////////////
// Sprite lists are used to store sprites in a dynamic fashion. A CDXSpriteList 
// is a linked list of CDXSprite objects, which can be added and removed at run-time.
//
// LOOPING THE LIST: When using a sprite list you will often need to loop through 
// the list and perform operations on each of the sprites in the list, such as 
// updating their positions.  The code below shows how to loop through a CDXSpriteList:
//
// CDXSpriteList SpriteList;
// CDXSprite* Node;
//
// CDXSprite* Save;
//
// for(Node = SpriteList.Next(); Node != SpriteList.List(); Node = Save)
// {
//     Save = Node->m_Next;
//     Add code to update sprite here
// }
// 
// Notice that if you intend to remove sprites from the list as you update them you 
// must save a pointer to the next sprite in the list to prevent the loop becoming lost.
//////////////////////////////////////////////////////////////////////////////////
class CDXSpriteList
{
public:
	CDXSpriteList(void);
	~CDXSpriteList(void);

	CDXSprite *AddSprite(CDXTile* pTile, int Type=0, int PosX=0, int PosY=0,
		int VelX=0, int VelY=0, int State=0, int Frame=0, int Delay=0);
	void DelSprite(CDXSprite* pNode);

	CDXSprite* Next(void) { return m_List.m_Next; }
	CDXSprite* Prev(void) { return m_List.m_Prev; }
	CDXSprite* List(void) { return &m_List; }

	void Draw(CDXSurface* lpCDXS, DWORD ScrnWorldX, DWORD ScrnWorldY, WORD BltType);

public:
	CDXSprite m_List;			// The top of the list
	int m_nSprites;				// The number of sprites in the list
};

#endif
