//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxspritelist.cpp,v $
// $Author: pietro $
//
// $Log: cdxspritelist.cpp,v $
// Revision 2.1  1999/05/20 15:29:03  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.0  1999/05/01 13:51:17  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.1 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid[] = "@(#) $Id: cdxspritelist.cpp,v 2.1 1999/05/20 15:29:03 pietro Exp $";
#endif

#include "CDX.h"
#include "cdxsprite.h"

//////////////////////////////////////////////////////////////////////////////////
// Default constructor.
//////////////////////////////////////////////////////////////////////////////////
CDXSpriteList::CDXSpriteList(void)
{
	m_List.m_Next = m_List.m_Prev = &m_List;
	m_List.SetPos(0,0);
	m_List.SetVel(0,0);

	m_nSprites = 0;
}

//////////////////////////////////////////////////////////////////////////////////
// Default contructor.
//////////////////////////////////////////////////////////////////////////////////
CDXSpriteList::~CDXSpriteList(void)
{
}

//////////////////////////////////////////////////////////////////////////////////
// Adds a sprite to the sprite list. Only a pointer to a CDXTile object 
// is required, however you can also set up the sprite as required.
//////////////////////////////////////////////////////////////////////////////////
CDXSprite *CDXSpriteList::AddSprite(CDXTile* pTile, int Type, int PosX, int PosY, 
							  int VelX, int VelY, int State, int Frame, int Delay)
{
	CDXSprite* Node;

	// Create a new sprite
	Node = new CDXSprite(pTile);
	if(Node == NULL) 
		return Node;

	// Setup sprite
	Node->SetType(Type);
	Node->SetPos(PosX, PosY);
	Node->SetVel(VelX, VelY);
	Node->SetState(State);
	Node->SetFrame(Frame);
	Node->SetDelay(Delay);

	// Add sprite too list
	Node->m_Next = m_List.m_Next;
	Node->m_Prev = &m_List;
	m_List.m_Next->m_Prev = Node;
	m_List.m_Next = Node;

	m_nSprites++;

	return Node;
}

//////////////////////////////////////////////////////////////////////////////////
// Removes a sprite from the list.
//////////////////////////////////////////////////////////////////////////////////
void CDXSpriteList::DelSprite(CDXSprite* pNode)
{
	if(m_List.m_Next == &m_List) 
		return;

	m_nSprites--;

	pNode->m_Next->m_Prev = pNode->m_Prev;
	pNode->m_Prev->m_Next = pNode->m_Next;

	delete pNode;
}

//////////////////////////////////////////////////////////////////////////////////
// Draws all the sprites in the list to the surface pointed to by lpDDS.
//////////////////////////////////////////////////////////////////////////////////
void CDXSpriteList::Draw(CDXSurface* lpCDXS, DWORD ScrnWorldX, DWORD ScrnWorldY, WORD BltType)
{
	CDXSprite* Node;

	// Loop the list and draw the objects
	for(Node = m_List.m_Next; Node != &m_List; Node = Node->m_Next)
	{
		Node->Draw(lpCDXS, ScrnWorldX, ScrnWorldY, BltType);
	}
}
