//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxsurface.h,v $
// $Author: pietro $
//
// $Log: cdxsurface.h,v $
// Revision 2.9  1999/05/20 15:29:03  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.8  1999/05/19 04:30:57  pietro
// modified CreateFromBMPi so that the sizeis last one parameter.
//
// Revision 2.7  1999/05/19 04:07:21  pietro
// removed LoadBMP from CDX Resource. Now every object handles his own loading
// via his own interfaces. in cdx surface, use create.
//
// Revision 2.6  1999/05/19 02:28:00  rbt
// Added a copy constructor.
//
// Revision 2.5  1999/05/16 17:45:21  pietro
// Added CDXSurface::CreateFromBMPi.
// Creates a CDXSurface from a 24BPP BMP file.
// The file must be already opened and the position set. (fpos).
// The file will be left opened, but the position will change.
// With this function, you can have many bmp files in one large file.
//
// Revision 2.4  1999/05/11 18:53:22  janni
// added InitCDXSurface function, is called from all  3 constructors to init member variables and fix access violation problems
// added RELEASE( m_lpDDS ) in both Create functions to release allocated surfaces before creating new ones
//
// Revision 2.3  1999/05/05 20:46:00  janni
// Janni: added 4 functions :
//     GetWidth,
//     GetHeight,
//     GetPitch,
//     GetSurfaceBytesPointer,
//     GetlpDDS
//
// Revision 2.1  1999/05/03 21:11:07  MICHAELR
// DIRECTDRAW_VERSION was incorrectly called DIRECTDRAWVERSION
//
// Revision 2.0  1999/05/01 13:51:17  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.9 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXSURFACE_H
#define CDXSURFACE_H

#include <cdxscreen.h>
#include <cdxresource.h>

// CDX memory types
#define CDXMEM_VIDEOONLY		0
#define CDXMEM_SYSTEMONLY		1
#define CDXMEM_VIDTHENSYS		2

//class CDXResource;
//////////////////////////////////////////////////////////////////////////////////
// This is basically a straight wrapper for a IDirectDrawSurface object, it holds 
// bitmap information for later copying to the screen.  As you will see CDXSurface 
// is used as a base class for several other classes in CDX.  Remember that with 
// DirectX you can't create surfaces wider than the width of the screen unless you
// create them in system memory (slow!)
//////////////////////////////////////////////////////////////////////////////////
class CDXSurface
{
public:
	void InitCDXSurface( void );
	CDXSurface();
	CDXSurface(CDXSurface& aSurface);
	CDXSurface(CDXScreen *pScreen, int Width, int Height, BOOL memoryType = CDXMEM_VIDTHENSYS);
	CDXSurface(CDXScreen *pScreen, const char *szFilename, BOOL memoryType = CDXMEM_VIDTHENSYS);
	virtual ~CDXSurface();

	BOOL Create(CDXScreen *pScreen, int Width, int Height, BOOL memoryType = CDXMEM_VIDTHENSYS);
	BOOL Create(CDXScreen *pScreen, const char *szFilename, BOOL memoryType = CDXMEM_VIDTHENSYS);
	BOOL Create(CDXScreen *pScreen, FILE *fh, UINT size, BYTE memoryType);
	BOOL Create(CDXScreen *pScreen, CDXResource *r, RESHANDLE i, BYTE memoryType);

	BOOL CreateFromBMPi(CDXScreen *pScreen, FILE *fh, BYTE memoryType, UINT size=0);

	BOOL CreateFromPSD(CDXScreen *pScreen, const char *szFilename, BYTE memoryType);
	BOOL LoadAlphaMask(const char *szFilename);
	unsigned short Read16(FILE* fh);
	unsigned int Read32(FILE* fh);
	void UnPackPSD(FILE* fh, BYTE* pixels, WORD channelCnt, WORD compression);
	
	void SetDest(int t, int l, int b, int r);
 	void SetSrc(int t, int l, int b, int r);

	void SetColorKey(DWORD col);
	void SetColorKey(void);

	void Restore(void);
	void Fill(DWORD FillColor);

	void ChangeFont(const char* FontName, int Width, int Height, int Attributes = FW_NORMAL);
	void SetFont(void);
	HRESULT Lock(void);
	HRESULT UnLock(void);
	void GetDC();
	void ReleaseDC();

	void TextXY(int X, int Y, COLORREF Col, LPCTSTR pString);
	void DrawText(LPCSTR pString, COLORREF col, LPRECT pRect);

	void PutPixel(int X, int Y, DWORD Col);
	DWORD GetPixel(int X, int Y);
	void Rect(int X1,int Y1,int X2,int Y2,DWORD Col);
	void FillRect(int X1, int Y1, int X2, int Y2, DWORD Col);
	void Line(int X1, int Y1, int X2, int Y2, DWORD Col);
	void VLine(int Y1, int Y2, int X, DWORD Col);
	void HLine(int X1, int X2, int Y, DWORD Col);
	void Circle(int X, int Y, int Radius, DWORD Col);
	void FillCircle(int X, int Y, int Radius, DWORD Col);

	virtual HRESULT Draw(CDXSurface* lpDDS);
	virtual HRESULT DrawFast(int X, int Y, CDXSurface* lpDDS);
	virtual HRESULT DrawTrans(int X, int Y, CDXSurface* lpDDS);
	virtual HRESULT DrawClipped(int X, int Y, CDXSurface* lpDDS, LPRECT ClipRect);
	virtual HRESULT DrawWindowed(CDXSurface* lpDDS);
	virtual HRESULT DrawScaled(int X, int Y, float Factor, CDXSurface* lpDDS);
	virtual HRESULT DrawScaled(int X, int Y, int Width, int Height, CDXSurface* lpDDS);
	virtual HRESULT DrawHFlip(int X, int Y, CDXSurface* lpDDS);
	virtual HRESULT DrawVFlip(int X, int Y, CDXSurface* lpDDS);
	virtual void DrawRotated(int X, int Y, double Angle, CDXSurface* lpDDS);

	BOOL ValidateBlt(CDXSurface* lpCDXS, LONG *lDestX, LONG *lDestY, RECT *srcRect);
	BOOL ClipRect(RECT *Rect);
	void GetClipRect(RECT *clipRect);
	void SetClipRect(RECT *clipRect);

	HRESULT CDXBLT_Blk(CDXSurface* lpCDXS, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_Trans(CDXSurface* lpCDXS, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_BlkHFlip(CDXSurface* lpCDXS, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_TransHFlip(CDXSurface* lpCDXS, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_BlkVFlip(CDXSurface* lpCDXS, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_TransVFlip(CDXSurface* lpCDXS, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_BlkAlphaFast(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_TransAlphaFast(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_BlkAlpha(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect, WORD ALPHA);
	HRESULT CDXBLT_TransAlpha(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect, WORD ALPHA);
	HRESULT CDXBLT_BlkShadow(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect, WORD SHADOW);
	HRESULT CDXBLT_TransShadow(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect, WORD SHADOW);
	HRESULT CDXBLT_BlkShadowFast(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_TransShadowFast(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect);
	HRESULT CDXBLT_TransAlphaMask(CDXSurface* dest, LONG lDestX, LONG lDestY, RECT srcRect);

// Janni
    DWORD GetWidth( void )  { return m_PixelWidth;  }
    DWORD GetHeight( void ) { return m_PixelHeight; };
    DWORD GetPitch( void ) { return m_DDSD.lPitch; }
    void * GetSurfaceBytesPointer( void ) { return m_DDSD.lpSurface; }
#if DIRECTDRAW_VERSION >= CDX_DDVER
    LPDIRECTDRAWSURFACE4 GetlpDDS( void ) { return m_lpDDS; }
#else
	LPDIRECTDRAWSURFACE GetlpDDS( void ) { return m_lpDDS; }
#endif
// Janni

public:
	int m_PixelWidth;					// The surface width in pixels
	int m_PixelHeight;					// The surface height in pixels
	const char* m_pFilename;			// The name of the bitmap file loaded, used in Restore

	HDC m_DC;							// A HDC object, used for drawing text to the surface
	DWORD m_ColorKey;					// The specified color key for this surface
	RECT SrcRect;						// A RECT structure holding the surface source
	RECT DestRect;						// A RECT structure holding the surface destination
	HFONT m_Font;						// A HFONT object describing the currently selected font

#if DIRECTDRAW_VERSION >= CDX_DDVER
	DDSURFACEDESC2 m_DDSD;				// A DDSURFACEDESC object, stores surface information
	LPDIRECTDRAWSURFACE4 m_lpDDS;		// The LPDIRECTDRAWSURFACE object
#else
	DDSURFACEDESC m_DDSD;				// A DDSURFACEDESC object, stores surface information
	LPDIRECTDRAWSURFACE m_lpDDS;		// The LPDIRECTDRAWSURFACE object
#endif

	CDXScreen *Screen;					// A pointer to a CDXScreen object

	BOOL m_MMX;
	RECT m_ClipRect;
	RGBFORMAT m_RGB;
	char *m_FontName;
	BOOL m_FontLoaded;
	BYTE *m_alphaMask;
};

#endif
