//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx/cdxtile.h,v $
// $Author: janni $
//
// $Log: cdxtile.h,v $
// Revision 2.3  1999/05/23 05:23:40  janni
// added memoryType to CreateFromTLE
//
// Revision 2.2  1999/05/20 15:29:03  pietro
// Multiple changes:
// * fixed #include bugs in all .cpp and various .h files
// * fixed all rcsid[] bugs
// * added conditional compile variable CDXINCLUDEALL - when defined,
//   all #include files are included in cdx.h to keep backward compatibility
// * All the libraries are created in ..\..\lib\vc\ directory, library names are
//   cdx.lib/cdxd.lib/cdxdx3.lib/cdxdx3d.lib/cdxadx3.lib/cdxadx3d.lib
//
// Revision 2.1  1999/05/05 04:47:01  MICHAELR
// Added default value for memoryType in constructors to be consistent with CDXSurface
//
// Revision 2.0  1999/05/01 13:51:17  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.3 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDXTILE_H
#define CDXTILE_H

#include "cdxsurface.h"

//////////////////////////////////////////////////////////////////////////////////
// This class name is somewhat deceptive given that a CDXTile object holds the 
// bitmap information for all the tiles of a given map or sprite, rather than just 
// one tile. CDXTile is derived from CDXSurface.
//
// IMPORTANT NOTES: The bitmap file containing the tiles should have an empty tile 
// at the start, this is because CDX treats the first tile to be transparent. Tiles 
// should be stored from left to right down the bitmap and should fit exactly into 
// the width of the bitmap, have a look at the tiles from one of the examples if 
// this is unclear. Remember to set the colour key for the surface if you intend to 
// draw the tiles transparently.
//////////////////////////////////////////////////////////////////////////////////
class CDXTile : public CDXSurface
{
public:
	CDXTile();
	CDXTile(CDXScreen *pScreen, const char* szFilename, int w, int h, int num, BOOL memoryType = CDXMEM_VIDTHENSYS);

	BOOL Create(CDXScreen *pScreen, const char* szFilename, int w, int h, int num, BOOL memoryType = CDXMEM_VIDTHENSYS);
	BOOL CreateFromTLE(CDXScreen *pScreen, const char* szFilename , BOOL memoryType = CDXMEM_VIDTHENSYS );

public:
	int m_BlockWidth;				// The width of one tile, in pixels
	int m_BlockHeight;				// The height of one tile, in pixels
	int m_BlockNum;					// The number of tiles in the bitmap file
};

#endif
