//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx3d/camera.cpp,v $
// $Author: bsimser $
//
// $Log: camera.cpp,v $
// Revision 2.0  1999/05/01 13:51:18  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.0 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid = "@(#) $Id: camera.cpp,v 2.0 1999/05/01 13:51:18 bsimser Exp $";
#endif

#include "CDX3D.h"

//////////////////////////////////////////////////////////////////////////////////
// CRMCamera Constructor
//////////////////////////////////////////////////////////////////////////////////
CRMCamera::CRMCamera(CRMEngine* pEngine)
{
	m_Engine = pEngine;
	m_Frame = NULL;
	m_View = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMCamera Destructor
//////////////////////////////////////////////////////////////////////////////////
CRMCamera::~CRMCamera(void)
{
	RELEASE(m_View);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMCamera Create
//////////////////////////////////////////////////////////////////////////////////
BOOL CRMCamera::Create(CRMScene* pScene)
{
	m_Engine->CreateFrame(pScene->m_Frame, &m_Frame);
	m_Frame->SetPosition(pScene->m_Frame, D3DVAL(0.0), D3DVAL(0.0), D3DVAL(-10.0));

	m_Engine->GetD3DRM()->CreateViewport(m_Engine->m_RMDevice, m_Frame, 0, 0,
	                                     m_Engine->m_Screen->GetWidth(),
	                                     m_Engine->m_Screen->GetHeight(), &m_View);

	m_View->SetBack(D3DVAL(5000.0));

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMCamera Clear
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMCamera::Clear(void)
{
	return m_View->Clear();
}

//////////////////////////////////////////////////////////////////////////////////
// CRMCamera Render
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMCamera::Render(CRMScene* pScene)
{
	return m_View->Render(pScene->m_Frame);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMCamera ForceUpdate
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMCamera::ForceUpdate(DWORD X1, DWORD Y1, DWORD X2, DWORD Y2)
{
	return m_View->ForceUpdate(X1, Y1, X2, Y2);
}
