//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx3d/cdx3dengine.h,v $
// $Author: bsimser $
//
// $Log: cdx3dengine.h,v $
// Revision 2.0  1999/05/01 13:51:18  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.0 $
//////////////////////////////////////////////////////////////////////////////////
#ifndef CDX3DENGINE_H
#define CDX3DENGINE_H

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine Class
//////////////////////////////////////////////////////////////////////////////////
class CRMEngine
{
public:
        CRMEngine(void);
        ~CRMEngine(void);

        HRESULT CreateFullScreen(CDXScreen* pScreen, void *hWnd, int Width, int Height, int BPP);
        HRESULT CreateWindowed(CDXScreen* pScreen, void *hWnd, int Width, int Height);

		LPGUID FindDevice(int BPP);
		void SetDefaults(void);

        HRESULT CreateFrame(LPDIRECT3DRMFRAME pParent, LPDIRECT3DRMFRAME* pFrame);
        HRESULT CreateLight(D3DRMLIGHTTYPE type, double r, double g, double b,
                            LPDIRECT3DRMLIGHT* pLight);
        HRESULT CreateMeshBuilder(LPDIRECT3DRMMESHBUILDER* pMeshBld);

        HRESULT Update(void);
        HRESULT Tick(double Tick);
        HRESULT SetDither(BOOL Dither);
        HRESULT SetQuality(D3DRMRENDERQUALITY Quality);
        HRESULT SetShades(DWORD Shades);
        HRESULT SetTextureQuality(D3DRMTEXTUREQUALITY TextureQuality);

        LPDIRECT3D2 GetD3D(void) { return m_Direct3D; }
        LPDIRECT3DRM GetD3DRM(void) { return m_Direct3DRM; }

public:
        LPDIRECT3D2 m_Direct3D;
        LPDIRECT3DRM m_Direct3DRM;
        LPDIRECT3DDEVICE2 m_IMDevice;
        LPDIRECT3DRMDEVICE m_RMDevice;
		LPDIRECTDRAWCLIPPER m_lpDDClipper;
        CDXScreen* m_Screen;

private:
		DWORD bppToDbd(int bpp);
};

#endif
