//////////////////////////////////////////////////////////////////////////////////
// $Source: /usr/cvsroot/cdx/src/cdx3d/engine.cpp,v $
// $Author: bsimser $
//
// $Log: engine.cpp,v $
// Revision 2.0  1999/05/01 13:51:18  bsimser
// Updated revision number to 2.0
//
// Revision 1.1.1.1  1999/05/01 04:10:56  bsimser
// Initial revision to cvs
//
// $Revision: 2.0 $
//////////////////////////////////////////////////////////////////////////////////
#ifdef SAVE_RCSID
static char rcsid = "@(#) $Id: engine.cpp,v 2.0 1999/05/01 13:51:18 bsimser Exp $";
#endif

#include "CDX3D.h"

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine Constructor
//////////////////////////////////////////////////////////////////////////////////
CRMEngine::CRMEngine(void)
{
	m_Direct3D = NULL;
	m_IMDevice = NULL;
	m_RMDevice = NULL;

	m_Direct3DRM = NULL;
	m_lpDDClipper = NULL;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine Destructor
//////////////////////////////////////////////////////////////////////////////////
CRMEngine::~CRMEngine(void)
{
	RELEASE(m_Direct3D);
	RELEASE(m_IMDevice);
	RELEASE(m_RMDevice);

	RELEASE(m_Direct3DRM);
	RELEASE(m_lpDDClipper);
}

DWORD CRMEngine::bppToDbd(int bpp)
{
	switch(bpp) {
	case 1:
		return DDBD_1;
	case 2:
		return DDBD_2;
	case 4:
		return DDBD_4;
	case 8:
		return DDBD_8;
	case 16:
		return DDBD_16;
	case 24:
		return DDBD_24;
	case 32:
		return DDBD_32;
	}

	return 0;
}

LPGUID CRMEngine::FindDevice(int BPP)
{
	LPDIRECTDRAW lpDD;
	LPDIRECT3D lpD3D;
	D3DFINDDEVICESEARCH devSearch;
	static D3DFINDDEVICERESULT devResult;
	HRESULT error;

	if(DirectDrawCreate(NULL, &lpDD, NULL))
		return NULL;

	if(lpDD->QueryInterface(IID_IDirect3D, (void**)&lpD3D)) {
		lpDD->Release();
		return NULL;
	}

	ZeroMemory(&devSearch, sizeof(devSearch));
	devSearch.dwSize = sizeof(devSearch);
	devSearch.dwFlags = D3DFDS_COLORMODEL;
	devSearch.dcmColorModel = D3DCOLOR_RGB;

	ZeroMemory(&devResult, sizeof(devResult));
	devResult.dwSize = sizeof(devResult);

	error = lpD3D->FindDevice(&devSearch, &devResult);
	if(error == DD_OK) {
		if(devResult.ddHwDesc.dwFlags && 
			!(devResult.ddHwDesc.dwDeviceRenderBitDepth & bppToDbd(BPP))) {
			devSearch.dwFlags |= D3DFDS_HARDWARE;
			devSearch.bHardware = FALSE;
			ZeroMemory(&devResult, sizeof(devResult));
			devResult.dwSize = sizeof(devResult);
			// do a software search now
			error = lpD3D->FindDevice(&devSearch, &devResult);
		}
	}

	lpD3D->Release();
	lpDD->Release();

	if(error)
		return NULL;
	else
		return(&devResult.guid);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine CreateFullScreen - creates a full screen application
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::CreateFullScreen(CDXScreen* pScreen, void *hWnd,
                                    int Width, int Height, int BPP)
{
	return D3DRM_OK;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine CreateWindowed - creates a windowed application
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::CreateWindowed(CDXScreen* pScreen, void *hWnd,
                                  int Width, int Height)
{
	HRESULT rval;

	// create the CDXScreen object
	m_Screen = pScreen;
	if(!m_Screen->CreateWindowed(hWnd, Width, Height)) {
		return D3DRMERR_NOTDONEYET;
	}
	
	// create the main d3drm object
	rval = Direct3DRMCreate(&m_Direct3DRM);
	if(rval != D3DRM_OK) {
		return D3DRMERR_NOTDONEYET;
	}

	// create the dd clipper object
	if(FAILED(DirectDrawCreateClipper(0, &m_lpDDClipper, NULL))) {
		return D3DRMERR_NOTDONEYET;
	}

	// set the clipper objects hWnd
	if(FAILED(m_lpDDClipper->SetHWnd(0, (HWND)hWnd))) {
		RELEASE(m_lpDDClipper);
		return D3DRMERR_NOTDONEYET;
	}

	// create the d3d device
	if(FAILED(m_Direct3DRM->CreateDeviceFromClipper(m_lpDDClipper,
		FindDevice(m_Screen->GetBPP()), Width, Height, &m_RMDevice))) {
		return D3DRMERR_NOTDONEYET;
	}

	// start our engine with default values based on color depth
	SetDefaults();
	
	return D3DRM_OK;
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine Update
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::Update(void)
{
	return m_RMDevice->Update();
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine CreateFrame
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::CreateFrame(LPDIRECT3DRMFRAME pParent, LPDIRECT3DRMFRAME* pFrame)
{
	return m_Direct3DRM->CreateFrame(pParent, pFrame);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine CreateLight
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::CreateLight(D3DRMLIGHTTYPE type, double r, double g, double b,
                               LPDIRECT3DRMLIGHT* pLight)
{
	return m_Direct3DRM->CreateLightRGB(type, D3DVAL(r), D3DVAL(g), D3DVAL(b), pLight);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine CreateMeshBuilder
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::CreateMeshBuilder(LPDIRECT3DRMMESHBUILDER* pMeshBld)
{
	return m_Direct3DRM->CreateMeshBuilder(pMeshBld);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine SetDither
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::SetDither(BOOL Dither)
{
	return m_RMDevice->SetDither(Dither);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine SetQuality
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::SetQuality(D3DRMRENDERQUALITY Quality)
{
	return m_RMDevice->SetQuality(Quality);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine SetShades
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::SetShades(DWORD Shades)
{
	return m_RMDevice->SetShades(Shades);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine SetTextureQuality
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::SetTextureQuality(D3DRMTEXTUREQUALITY TextureQuality)
{
	return m_RMDevice->SetTextureQuality(TextureQuality);
}

//////////////////////////////////////////////////////////////////////////////////
// CRMEngine Tick
//////////////////////////////////////////////////////////////////////////////////
HRESULT CRMEngine::Tick(double Tick)
{
	return m_Direct3DRM->Tick(Tick);
}

//////////////////////////////////////////////////////////////////////////////////
// Sets some default values for the engine based on the current bit depth.
//////////////////////////////////////////////////////////////////////////////////
void CRMEngine::SetDefaults(void)
{
	int bpp;

	bpp = m_Screen->GetBPP();
	
	switch(bpp) {
	case 1:
		SetShades(4);
		break;

	case 16:
		SetShades(32);
		SetDither(FALSE);
		break;

	case 24:
	case 32:
		SetShades(256);
		SetDither(FALSE);
		break;

	default:
		SetDither(FALSE);
	}
}