/******************************************
GLUTRAD
Copyright, 1998, Colbeck Desktop Solutions Ltd
contact: colbeck@cix.co.uk
******************************************/
#include "objects.h"
#include <math.h>
#include <fstream.h>

#define PI 3.1415927

int BoundingBox=0;

extern int dis;
extern int zoom;

// TObject #####################################################################
TObject::TObject()
{
	VertexCount=0; TriCount=0;
	memset(HashTable, 0, sizeof(HashTable));
}

TObject::~TObject()
{
	for(int i=0; i<VertexCount; i++)
		delete V[i];
	for(i=0; i<TriCount; i++)
		delete T[i];
	delete[] T;
	delete[] V;
	KillHashTable();
}

void TObject::CalculateVertexNormals()
{
	for(int i=0; i<VertexCount; i++)
	{
		V[i]->d = TVector(0, 0, 0);
		V[i]->count=0;
	}
	TTriangle* tri;
	for(int p=0; p<TriCount; p++)
	{
		tri=T[p];
		tri->GetNormal();
		for(i=0; i<3; i++)
		{
			tri->V[i]->d.x+=tri->N.x;
			tri->V[i]->d.y+=tri->N.y;
			tri->V[i]->d.z+=tri->N.z;
			tri->V[i]->count++;
		}
	}
	for(i=0; i<VertexCount; i++)
	{
		V[i]->d /= V[i]->count;
		V[i]->d.Normalise();
	}
}

void TObject::CalculateVertexEnergy()
{
	for(int i=0; i<VertexCount; i++)
	{
		V[i]->energy.Set(0.0, 0.0, 0.0);
		V[i]->count=0;
	}
	TTriangle* tri;
	for(int p=0; p<TriCount; p++)
	{
		tri=T[p];
		for(i=0; i<3; i++)
		{
			tri->V[i]->energy.r+=tri->energy.r;
			tri->V[i]->energy.g+=tri->energy.g;
			tri->V[i]->energy.b+=tri->energy.b;
			tri->V[i]->count++;
		}
	}
	for(i=0; i<VertexCount; i++)
	{
		V[i]->energy.r /= V[i]->count;
		V[i]->energy.g /= V[i]->count;
		V[i]->energy.b /= V[i]->count;
	}
}

BOOL TObject::FileOpenRaw(const char* fname)
{
	TTriangle *tri;	// this is what is repeatedly copied into the array of squares in ol
	ifstream f(fname);
	if(f.fail())
		return FALSE;
	double x1, y1, z1, x2, y2, z2, x3, y3, z3;
	int a, b, c;
	f.getline(name, 128); // read object's name
	while(TRUE)
	{
		f >> x1 >> y1 >> z1 >> x2 >> y2 >> z2 >> x3 >> y3 >> z3 >> ws;
		if(f.fail())
			break;
		
		tri=new TTriangle;
		a=AddVertexHash(x1, y1, z1, tri);
		b=AddVertexHash(x2, y2, z2, tri);
		c=AddVertexHash(x3, y3, z3, tri);
		tri->Set(V[a], V[b], V[c], a, b, c);
		tri->GetNormal();
		tri->CalcArea();
		tri->CalcCentre();
		T[TriCount++]=tri;	// square is copied into the list
	}
	CalculateVertexNormals();
	KillHashTable();
	return TRUE;
}

#define SMALL 0.001

unsigned long TObject::AddVertexHash(double x, double y, double z, TTriangle* tri)
{
	TVertex* vertex;
	unsigned hash= (unsigned(1000.0*x) ^ unsigned(1000.0*y) ^ unsigned(1000.0*z))%1000;

	if(HashTable[hash]==0) // this is a new vertex...
	{
		HashTable[hash]=new THashItem;
		vertex=new TVertex(TVector(x, y, z), TVector(0, 0, 0));
		V[VertexCount]=vertex;
		vertex->AddUser(tri);
		HashTable[hash]->v=vertex;
		HashTable[hash]->index=VertexCount;
		HashTable[hash]->next=0;
		return VertexCount++;
	}
	else // this hash value is not unique
	{
		THashItem *item, *current=HashTable[hash];
		while(current)
		{
			if(fabs(current->v->v.x-x)<SMALL && fabs(current->v->v.y-y)<SMALL && fabs(current->v->v.z-z)<SMALL) // found the vertex in this hash item's list
			{
				current->v->AddUser(tri);
				return current->index; // return it's index
			}
			item=current;
			current=current->next;
		}
		// item has not been found, so add new hash item
		item->next=new THashItem;
		current=item->next;
		vertex=new TVertex(TVector(x, y, z), TVector(0, 0, 0));
		V[VertexCount]=vertex;
		vertex->AddUser(tri);
		current->v=vertex;
		current->index=VertexCount;
		current->next=0;
		return VertexCount++;
	}
}

void TObject::KillHashTable()
{
	THashItem *item, *next;
	for(int i=0; i<1000; i++)
	{
		if(HashTable[i])
		{
			item=HashTable[i];
			while(item)
			{
				next=item->next;
				delete item;
				item=next;
			}
		}
		HashTable[i]=0;
	}
}
	
void TObject::Save6d()
{
	char s[128];
	wsprintf(s, "%s.6d", name);
	ofstream f(s);
	f << VertexCount << '\n';
	for(int i=0; i<VertexCount; i++)
		f << V[i]->v.x << ' ' << V[i]->v.y << ' ' << V[i]->v.z << '\n';

	f << TriCount << '\n';
	for(i=0; i<TriCount; i++)
	{
		f << T[i]->index[0] << ' ' << T[i]->index[1] << ' ' << T[i]->index[2] << ' ';
		f << T[i]->energy.r << ' ' << T[i]->energy.g << ' ' << T[i]->energy.b << '\n';
	}
}