/******************************************
GLUTRAD
Copyright, 1998, Colbeck Desktop Solutions Ltd
contact: colbeck@cix.co.uk
******************************************/
#ifndef _OBJECTS_H
	#define _OBJECTS_H

#include <gl\gl.h>
#include <gl\glu.h>

#include "vector.h"

enum TProjection {TOP=1, FRONT=2, SIDE=4, ISO=8};

class TObject
{
	struct THashItem
	{
		TVertex* v;
		int index;
		THashItem* next;
	};
	THashItem* HashTable[1000];
public:
	char name[128];
	int tri_index; // where the triangles are in the scheme of things
	int TriCount;
	TTriangle** T;
	int VertexCount;
	TVertex** V;

	TColour reflectance, emission;
	
	TObject();
	~TObject();
	
	BOOL FileOpen(const char* name);
	unsigned long AddVertexHash(double x, double y, double z, TTriangle* tri);
	void KillHashTable();
	void Save6d();

	void CalculateVertexNormals();
	void CalculateVertexEnergy();
	BOOL FileOpenRaw(const char* fname);
};

#endif
