//This code is taken from the OpenGL red book:
/*
 * (c) Copyright 1993, Silicon Graphics, Inc.
 *               1993-1995 Microsoft Corporation
 *
 * ALL RIGHTS RESERVED
 */
#include "jitter.h"
#include "vector.h"

extern GLfloat viewanglex;
extern GLfloat viewanglez;
extern double camera_fov;
extern double near_plane;
extern double far_plane;
extern TVector camera_pos;
extern TVector camera_lookat;
extern TVector camera_up;

#define ACSIZE 8
#define PI_ 3.14159265358979323846

/*  accFrustum()
 *  The first 6 arguments are identical to the glFrustum() call.
 *  
 *  pixdx and pixdy are anti-alias jitter in pixels. 
 *  Set both equal to 0.0 for no anti-alias jitter.
 *  eyedx and eyedy are depth-of field jitter in pixels. 
 *  Set both equal to 0.0 for no depth of field effects.
 *
 *  focus is distance from eye to plane in focus. 
 *  focus must be greater than, but not equal to 0.0.
 *
 *  Note that accFrustum() calls glTranslatef().  You will 
 *  probably want to insure that your ModelView matrix has been 
 *  initialized to identity before calling accFrustum().
 */
void accFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top,
    GLdouble znear, GLdouble zfar, GLdouble pixdx, GLdouble pixdy, 
    GLdouble eyedx, GLdouble eyedy, GLdouble focus)
{
    GLdouble xwsize, ywsize; 
    GLdouble dx, dy;
    GLint viewport[4];

    glGetIntegerv (GL_VIEWPORT, viewport);
    
    xwsize = right - left;
    ywsize = top - bottom;
    
    dx = -(pixdx*xwsize/(GLdouble) viewport[2] + eyedx*znear/focus);
    dy = -(pixdy*ywsize/(GLdouble) viewport[3] + eyedy*znear/focus);
    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    glFrustum (left + dx, right + dx, bottom + dy, top + dy, znear, zfar);
    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(camera_pos.x, camera_pos.y, camera_pos.z,  /* eye position */
			  camera_lookat.x, camera_lookat.y, camera_lookat.z,	 /* centre position */
			  camera_up.x, camera_up.y, camera_up.z); /* up is in postivie Y direction */
}

/*  accPerspective()
 * 
 *  The first 4 arguments are identical to the gluPerspective() call.
 *  pixdx and pixdy are anti-alias jitter in pixels. 
 *  Set both equal to 0.0 for no anti-alias jitter.
 *  eyedx and eyedy are depth-of field jitter in pixels. 
 *  Set both equal to 0.0 for no depth of field effects.
 *
 *  focus is distance from eye to plane in focus. 
 *  focus must be greater than, but not equal to 0.0.
 *
 *  Note that accPerspective() calls accFrustum().
 */
void accPerspective(GLdouble fovy, GLdouble aspect, 
    GLdouble znear, GLdouble zfar, GLdouble pixdx, GLdouble pixdy, 
    GLdouble eyedx, GLdouble eyedy, GLdouble focus)
{
    GLdouble fov2,left,right,bottom,top;

    fov2 = ((fovy*PI_) / 180.0) / 2.0;

    top = znear / (cos(fov2) / sin(fov2));
    bottom = -top;

    right = top * aspect;
    left = -right;

    accFrustum (left, right, bottom, top, znear, zfar,
			pixdx, pixdy, eyedx, eyedy, focus);
}


void AliasPerspective(int model)
{
    glClear(GL_ACCUM_BUFFER_BIT);
	GLint viewport[4];
	glGetIntegerv (GL_VIEWPORT, viewport);
	for(int jitter=0; jitter<ACSIZE; jitter++)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		accPerspective (camera_fov, 1, near_plane, far_plane, j8[jitter].x, j8[jitter].y, 0.0, 0.0, 1.0);

		glMatrixMode( GL_MODELVIEW ); // the model stack is now current
		glPushMatrix();
			glRotatef(viewanglex, 1.f, 0.f, 0.f);
			glRotatef(viewanglez, 0.f, 0.f, 1.f);
			glCallList(model);
		glPopMatrix();
		glAccum(GL_ACCUM, 1.0f/ACSIZE);
	}
    glAccum (GL_RETURN, 1.0f);
    glFlush();
}
