(*==========================================================================;
 *
 *  Copyright (C) 1995-1997 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       dsetup.h
 *  Content:    DirectXSetup, error codes and flags
 *
 *  DirectX 6 Delphi adaptation by Erik Unger
 *
 *  Modyfied: 22.Mar.99
 *
 *  Download: http://www.bigfoot.com/~ungerik/
 *  E-Mail: ungerik@bigfoot.com
 *
 ***************************************************************************)

unit DSetup;

{$INCLUDE COMSWITCH.INC}
{$INCLUDE STRINGSWITCH.INC}

interface

uses
{$IFDEF D2COM}
  OLE2,
{$ENDIF}
  Windows;

var
  DSetupDLL : HMODULE;
  
function ErrorString(Value: HResult) : string;

type
{$IFDEF UNICODE}
  PCharAW = PWideChar;
{$ELSE}
  PCharAW = PAnsiChar;
{$ENDIF}
  
// DSETUP Error Codes, must remain compatible with previous setup.
const
  DSETUPERR_SUCCESS_RESTART     = HResult(1);
  DSETUPERR_SUCCESS             = HResult(0);
  DSETUPERR_BADWINDOWSVERSION   = HResult(-1);
  DSETUPERR_SOURCEFILENOTFOUND  = HResult(-2);
  DSETUPERR_BADSOURCESIZE       = HResult(-3);
  DSETUPERR_BADSOURCETIME       = HResult(-4);
  DSETUPERR_NOCOPY              = HResult(-5);
  DSETUPERR_OUTOFDISKSPACE      = HResult(-6);
  DSETUPERR_CANTFINDINF         = HResult(-7);
  DSETUPERR_CANTFINDDIR         = HResult(-8);
  DSETUPERR_INTERNAL            = HResult(-9);
  DSETUPERR_NTWITHNO3D          = HResult(-10);  // REM: obsolete, you'll never see this
  DSETUPERR_UNKNOWNOS           = HResult(-11);
  DSETUPERR_USERHITCANCEL       = HResult(-12);
  DSETUPERR_NOTPREINSTALLEDONNT = HResult(-13);

// DSETUP flags. DirectX 5.0 apps should use these flags only.
  DSETUP_DDRAWDRV     = $00000008;   (* install DirectDraw Drivers           *)
  DSETUP_DSOUNDDRV    = $00000010;   (* install DirectSound Drivers          *)
  DSETUP_DXCORE       = $00010000;   (* install DirectX runtime              *)
  DSETUP_DIRECTX = DSETUP_DXCORE or DSETUP_DDRAWDRV or DSETUP_DSOUNDDRV;
  DSETUP_TESTINSTALL  = $00020000;   (* just test install, don't do anything *)

// These OBSOLETE flags are here for compatibility with pre-DX5 apps only.
// They are present to allow DX3 apps to be recompiled with DX5 and still work.
// DO NOT USE THEM for DX5. They will go away in future DX releases.

  DSETUP_DDRAW         = $00000001; (* OBSOLETE. install DirectDraw           *)
  DSETUP_DSOUND        = $00000002; (* OBSOLETE. install DirectSound          *)
  DSETUP_DPLAY         = $00000004; (* OBSOLETE. install DirectPlay           *)
  DSETUP_DPLAYSP       = $00000020; (* OBSOLETE. install DirectPlay Providers *)
  DSETUP_DVIDEO        = $00000040; (* OBSOLETE. install DirectVideo          *)
  DSETUP_D3D           = $00000200; (* OBSOLETE. install Direct3D             *)
  DSETUP_DINPUT        = $00000800; (* OBSOLETE. install DirectInput          *)
  DSETUP_DIRECTXSETUP  = $00001000; (* OBSOLETE. install DirectXSetup DLL's   *)
  DSETUP_NOUI          = $00002000; (* OBSOLETE. install DirectX with NO UI   *)
  DSETUP_PROMPTFORDRIVERS = $10000000; (* OBSOLETE. prompt when replacing display/audio drivers *)
  DSETUP_RESTOREDRIVERS = $20000000;(* OBSOLETE. restore display/audio drivers *)

//******************************************************************
// DirectX Setup Callback mechanism
//******************************************************************

// DSETUP Message Info Codes, passed to callback as Reason parameter.
  DSETUP_CB_MSG_NOMESSAGE                 = 0;
  DSETUP_CB_MSG_CANTINSTALL_UNKNOWNOS     = 1;
  DSETUP_CB_MSG_CANTINSTALL_NT            = 2;
  DSETUP_CB_MSG_CANTINSTALL_BETA          = 3;
  DSETUP_CB_MSG_CANTINSTALL_NOTWIN32      = 4;
  DSETUP_CB_MSG_CANTINSTALL_WRONGLANGUAGE = 5;
  DSETUP_CB_MSG_CANTINSTALL_WRONGPLATFORM = 6;
  DSETUP_CB_MSG_PREINSTALL_NT             = 7;
  DSETUP_CB_MSG_NOTPREINSTALLEDONNT       = 8;
  DSETUP_CB_MSG_SETUP_INIT_FAILED         = 9;
  DSETUP_CB_MSG_INTERNAL_ERROR            = 10;
  DSETUP_CB_MSG_CHECK_DRIVER_UPGRADE      = 11;
  DSETUP_CB_MSG_OUTOFDISKSPACE            = 12;
  DSETUP_CB_MSG_BEGIN_INSTALL             = 13;
  DSETUP_CB_MSG_BEGIN_INSTALL_RUNTIME     = 14;
  DSETUP_CB_MSG_BEGIN_INSTALL_DRIVERS     = 15;
  DSETUP_CB_MSG_BEGIN_RESTORE_DRIVERS     = 16;
  DSETUP_CB_MSG_FILECOPYERROR             = 17;


  DSETUP_CB_UPGRADE_TYPE_MASK      = $000F;
  DSETUP_CB_UPGRADE_KEEP           = $0001;
  DSETUP_CB_UPGRADE_SAFE           = $0002;
  DSETUP_CB_UPGRADE_FORCE          = $0004;
  DSETUP_CB_UPGRADE_UNKNOWN        = $0008;

  DSETUP_CB_UPGRADE_HASWARNINGS    = $0100;
  DSETUP_CB_UPGRADE_CANTBACKUP     = $0200;

  DSETUP_CB_UPGRADE_DEVICE_ACTIVE  = $0800;

  DSETUP_CB_UPGRADE_DEVICE_DISPLAY = $1000;
  DSETUP_CB_UPGRADE_DEVICE_MEDIA   = $2000;


type
  PDSetup_CB_UpgradeInfo = ^TDSetup_CB_UpgradeInfo;
  TDSetup_CB_UpgradeInfo = record
    UpgradeFlags: DWORD;
  end;

  PDSetup_CB_FileCopyError = ^TDSetup_CB_FileCopyError;
  TDSetup_CB_FileCopyError = record
    dwError: DWORD;
  end;

//
// Data Structures
//
  PDirectXRegisterAppA = ^TDirectXRegisterAppA;
  TDirectXRegisterAppA = record
    dwSize: DWORD;
    dwFlags: DWORD;
    lpszApplicationName: PAnsiChar;
    lpGUID: PGUID;
    lpszFilename: PAnsiChar;
    lpszCommandLine: PAnsiChar;
    lpszPath: PAnsiChar;
    lpszCurrentDirectory: PAnsiChar;
  end;

  PDirectXRegisterAppW = ^TDirectXRegisterAppW;
  TDirectXRegisterAppW = record
    dwSize: DWORD;
    dwFlags: DWORD;
    lpszApplicationName: PWideChar;
    lpGUID: PGUID;
    lpszFilename: PWideChar;
    lpszCommandLine: PWideChar;
    lpszPath: PWideChar;
    lpszCurrentDirectory: PWideChar;
  end;


  PDirectXRegisterApp = ^TDirectXRegisterApp;
{$IFDEF UNICODE}
  TDirectXRegisterApp = TDirectXRegisterAppW;
{$ELSE}
  TDirectXRegisterApp = TDirectXRegisterAppA;
{$ENDIF}

//
// API
//
var
  DirectXSetupW : function (hWnd: HWND; lpszRootPath: PWideChar; dwFlags: DWORD)
      : Integer; stdcall;
  DirectXSetupA : function (hWnd: HWND; lpszRootPath: PAnsiChar; dwFlags: DWORD)
      : Integer; stdcall;
  DirectXSetup : function (hWnd: HWND; lpszRootPath: PCharAW; dwFlags: DWORD)
      : Integer; stdcall;

  DirectXDeviceDriverSetupW : function (hWnd: HWND; lpszDriverClass: PWideChar;
     lpszDriverPath: PWideChar; dwFlags: DWORD) : Integer; stdcall;
  DirectXDeviceDriverSetupA : function (hWnd: HWND; lpszDriverClass: PAnsiChar;
     lpszDriverPath: PAnsiChar; dwFlags: DWORD) : Integer; stdcall;
  DirectXDeviceDriverSetup : function (hWnd: HWND; lpszDriverClass: PCharAW;
     lpszDriverPath: PCharAW; dwFlags: DWORD) : Integer; stdcall;

  DirectXRegisterApplicationW : function
     (hWnd: HWND; var lpDXRegApp: TDirectXRegisterAppW) : Integer; stdcall;
  DirectXRegisterApplicationA : function
     (hWnd: HWND; var lpDXRegApp: TDirectXRegisterAppA) : Integer; stdcall;
  DirectXRegisterApplication : function
     (hWnd: HWND; var lpDXRegApp: TDirectXRegisterApp) : Integer; stdcall;

  DirectXUnRegisterApplication : function
     (hWnd: HWND; var lpGUID: TGUID) : Integer; stdcall;

type
  TDSetup_Callback = function (Reason: DWORD; MsgType: DWORD; // Same as flags to MessageBox
      szMessage: PChar; szName: PChar; pInfo: Pointer) : DWORD; stdcall;

var
  DirectXSetupSetCallback : function (Callback: TDSetup_Callback) : Integer;
      stdcall;

  DirectXSetupGetVersion : function (var lpdwVersion: DWORD;
      var lpdwMinorVersion: DWORD) : Integer; stdcall;

implementation

uses
  DXCommon;
  
function ErrorString(Value: HResult) : string;
begin
  case Value of
    DSETUPERR_SUCCESS: Result := 'Setup was successful and no restart is required.';
    DSETUPERR_SUCCESS_RESTART: Result := 'Setup was successful and a restart is required.';
    DSETUPERR_BADSOURCESIZE: Result := 'A files size could not be verified or was incorrect.';
    DSETUPERR_BADSOURCETIME: Result := 'A files date and time could not be verified or were incorrect.';
    DSETUPERR_BADWINDOWSVERSION: Result := 'DirectX does not support the Windows version on the system.';
    DSETUPERR_CANTFINDDIR: Result := 'The setup program could not find the working directory.';
    DSETUPERR_CANTFINDINF: Result := 'A required .inf file could not be found.';
    DSETUPERR_INTERNAL: Result := 'An internal error occurred.';
    DSETUPERR_NOCOPY: Result := 'A files version could not be verified or was incorrect.';
    DSETUPERR_NOTPREINSTALLEDONNT: Result := 'The version of Windows NT on the system does not contain the current version of DirectX. An older version of DirectX may be present, or DirectX may be absent altogether.';
    DSETUPERR_OUTOFDISKSPACE: Result := 'The setup program ran out of disk space during installation.';
    DSETUPERR_SOURCEFILENOTFOUND: Result := 'One of the required source files could not be found.';
    DSETUPERR_UNKNOWNOS: Result := 'The operating system on your system is not currently supported.';
    DSETUPERR_USERHITCANCEL: Result := 'The Cancel button was pressed before the application was fully installed.';
    else Result := 'Unrecognized Error';
  end;
end;

function GetDSetupDLLPath : string;
begin
   Result := RegGetStringValue(HKEY_LOCAL_MACHINE,
                               'Software\Microsoft\Windows\CurrentVersion\Uninstall\DirectXDrivers',
                               'UninstallString');
   if Result <> '' then
     Result := Copy(Result,1,Length(Result)-Length('dxsetup.exe')) + 'DSetup.dll';
end;

initialization
begin
  if not IsNTandDelphiRunning then
  begin
    DSetupDLL := LoadLibrary(PChar(GetDSetupDLLPath));

    DirectXSetupA := GetProcAddress(DSetupDLL,'DirectXSetupA');
    DirectXSetupW := GetProcAddress(DSetupDLL,'DirectXSetupW');
  {$IFDEF UNICODE}
    DirectXSetup := DirectXSetupW;
  {$ELSE}
    DirectXSetup := DirectXSetupA;
  {$ENDIF}

    DirectXDeviceDriverSetupA :=
        GetProcAddress(DSetupDLL,'DirectXDeviceDriverSetupA');
    DirectXDeviceDriverSetupW :=
        GetProcAddress(DSetupDLL,'DirectXDeviceDriverSetupW');
  {$IFDEF UNICODE}
    DirectXDeviceDriverSetup := DirectXDeviceDriverSetupW;
  {$ELSE}
    DirectXDeviceDriverSetup := DirectXDeviceDriverSetupA;
  {$ENDIF}

    DirectXRegisterApplicationA :=
         GetProcAddress(DSetupDLL,'DirectXRegisterApplicationA');
    DirectXRegisterApplicationW :=
         GetProcAddress(DSetupDLL,'DirectXRegisterApplicationW');
  {$IFDEF UNICODE}
    DirectXRegisterApplication := DirectXRegisterApplicationW;
  {$ELSE}
    DirectXRegisterApplication := DirectXRegisterApplicationA;
  {$ENDIF}

    DirectXUnRegisterApplication :=
        GetProcAddress(DSetupDLL,'DirectXUnRegisterApplication');

    DirectXSetupSetCallback :=
        GetProcAddress(DSetupDLL,'DirectXSetupSetCallback');

    DirectXSetupGetVersion := GetProcAddress(DSetupDLL,'DirectXSetupGetVersion');
  end;
end;


finalization
begin
  FreeLibrary(DSetupDLL);
end;



end.
