// SMgal... 99/7/10 

unit Unit1;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   DMusicYK, StdCtrls, ExtCtrls, ActiveX, ComCtrls;

type
   TForm1 = class(TForm)

      Timer1    : TTimer;
      Button1   : TButton;
      Button2   : TButton;
      Bevel1    : TBevel;
      StatusBar : TStatusBar;

      procedure FormShow(Sender: TObject);
      procedure FormClose(Sender: TObject; var Action: TCloseAction);
      procedure Timer1Timer(Sender: TObject);
      procedure Button1Click(Sender: TObject);
      procedure Button2Click(Sender: TObject);

   private
      Initialized : boolean;

   public
      DirectMusic : IDirectMusic;
      MIDIPerf    : IDirectMusicPerformance;
      MIDILoader  : IDirectMusicLoader;
      MIDISegment : IDirectMusicSegment;
      MIDISegStat : IDirectMusicSegmentState;

      function  InitializeDMusic : boolean;
      procedure FinalizeDMusic;
      function  OpenMIDI(FileName : string) : boolean;
      function  PlayMIDI : boolean;
      procedure CloseMIDI;
   end;

var
  Form1 : TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormShow(Sender: TObject);
begin
   Initialized := InitializeDMusic;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if Initialized then FinalizeDMusic;
end;

function MULTI_TO_WIDE(x : PWideChar; y : PChar) : integer;
begin
   MULTI_TO_WIDE := MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,y,-1,x,MAX_PATH);
end;

function LoadMIDISegment(MIDIPerf    : IDirectMusicPerformance;
                         MIDILoader  : IDirectMusicLoader;
                         FileName    : String)           : IDirectMusicSegment;
var
   ObjDesc     : TDMUS_OBJECTDESC;
   MIDISegment : IDirectMusicSegment;
   sPath       : string;
   Path        : array [0..DMUS_MAX_FILENAME-1] of CHAR;
   wPath       : array [0..DMUS_MAX_FILENAME-1] of WCHAR;
   wFileName   : array [0..DMUS_MAX_FILENAME-1] of WCHAR;
   HR          : HResult;
begin
   LoadMIDISegment := nil;

   sPath := ExtractFilePath(FileName);
   sPath := Copy(sPath,1,Length(sPath)-1);

   StrCopy(Path,PChar(sPath));
   MULTI_TO_WIDE(wPath,Path);

   HR := MIDILoader.SetSearchDirectory(GUID_DirectMusicAllTypes,wPath,FALSE);
   if HR <> S_OK then exit;

   FillChar(ObjDesc,Sizeof(TDMUS_OBJECTDESC),0);
   ObjDesc.dwSize      := sizeof(TDMUS_OBJECTDESC);
   ObjDesc.dwValidData := DMUS_OBJ_CLASS or DMUS_OBJ_FILENAME;
   ObjDesc.guidClass   := CLSID_DirectMusicSegment;
   MULTI_TO_WIDE(wFileName,PChar(ExtractFileName(FileName)));
   Move(wFileName,ObjDesc.wszFileName,Sizeof(wFileName));

   MIDISegment := nil;
   HR := MIDILoader.GetObject(ObjDesc,IID_IDirectMusicSegment,MIDISegment);
   if HR <> S_OK then exit;

   if Assigned(MIDISegment) then begin
      HR := MIDISegment.SetParam(GUID_StandardMIDIFile,$FFFFFFFF,0,0,Pointer(MIDIPerf));
      if HR <> S_OK then exit;
      HR := MIDISegment.SetParam(GUID_Download,$FFFFFFFF,0,0,Pointer(MIDIPerf));
      if HR <> S_OK then exit;
   end;

   LoadMIDISegment     := MIDISegment;
end;

function  TForm1.OpenMIDI(FileName : string) : boolean;
begin
   if Assigned(MIDISegment) then CloseMIDI;

   MIDISegment := LoadMIDISegment(MIDIPerf,MIDILoader,FileName);
   if not Assigned(MIDISegment) then exit;
end;

function  TForm1.PlayMIDI : boolean;
begin
   if Assigned(MIDISegment) then begin
      if MIDIPerf.PlaySegment(MIDISegment,0,ZERO_INT64,MIDISegStat) <> S_OK then ShowMessage('!!');
      Timer1.Enabled := TRUE;
   end;
end;

procedure TForm1.CloseMIDI;
begin
   if Assigned(MIDISegment) then begin
      if Assigned(MIDIPerf)    then MIDIPerf.Stop(nil,nil,0,0);
      if Assigned(MIDISegment) then MIDISegment.SetParam(GUID_Unload,$FFFFFFFF,0,0,Pointer(MIDIPerf));
      if Assigned(MIDISegment) then MIDISegment._Release;
      MIDISegment := nil;
   end;
end;

function  TForm1.InitializeDMusic : boolean;
var
   GUID      : TGUID;
begin
   InitializeDMusic := FALSE;

   DirectMusic := nil;

   if CoInitialize(nil) <> S_OK then exit;
   if CoCreateInstance(CLSID_DirectMusicPerformance,nil,CLSCTX_INPROC,IID_IDirectMusicPerformance,MIDIPerf) <> S_OK then exit;
   if MIDIPerf.Init(DirectMusic,nil,Handle) <> S_OK then exit;
   if MIDIPerf.AddPort(nil) <> S_OK then exit;

   GUID := GUID_NOTIFICATION_SEGMENT;
   MIDIPerf.AddNotificationType(GUID);

   if CoCreateInstance(CLSID_DirectMusicLoader,nil,CLSCTX_INPROC,IID_IDirectMusicLoader,MIDILoader) <> S_OK then exit;
   if not Assigned(MIDILoader) then exit;

   InitializeDMusic := TRUE;
end;

procedure TForm1.FinalizeDMusic;
begin
   Timer1.Enabled := FALSE;

   if Assigned(MIDIPerf)    then MIDIPerf.Stop(nil,nil,0,0);
   if Assigned(MIDISegment) then MIDISegment.SetParam(GUID_Unload,$FFFFFFFF,0,0,Pointer(MIDIPerf));
   if Assigned(MIDIPerf)    then MIDIPerf.CloseDown;
{
   if Assigned(MIDISegStat) then MIDISegStat._Release;
   if Assigned(MIDISegment) then MIDISegment._Release;
   if Assigned(MIDILoader)  then MIDILoader._Release;
   if Assigned(MIDIPerf)    then MIDIPerf._Release;
   if Assigned(DirectMusic) then DirectMusic._Release;
   MIDISegStat := nil;
   MIDISegment := nil;
   MIDILoader  := nil;
   MIDIPerf    := nil;
   DirectMusic := nil;

   CoUninitialize;
}
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
   pMsg  : PDMus_Notification_PMsg;
begin
   if Assigned(MIDIPerf) then begin
      while (MIDIPerf.GetNotificationPMsg(PDMus_Notification_PMsg(pMsg)) = S_OK) do begin
         case pMsg.dwNotificationOption of
            DMUS_NOTIFICATION_SEGSTART :
            begin
               StatusBar.Panels[1].Text := ' MIDI ';
            end;
            DMUS_NOTIFICATION_SEGEND   :
            begin
               MIDIPerf.PlaySegment(MIDISegment,0,ZERO_INT64,MIDISegStat);
               StatusBar.Panels[1].Text := ' MIDI ֳ';
               Timer1.Enabled := FALSE;
            end;
         end;
         MIDIPerf.FreePMsg(PDMus_PMsg(pMsg));
      end;
   end;

end;

procedure TForm1.Button1Click(Sender: TObject);
var
   FileName : string;
begin
   FileName := ExtractFilePath(Application.ExeName) + 'Test.Mid';
   if OpenMIDI(FileName) then PlayMIDI;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   Close;
end;

end.
