//-----------------------------------------------------------------------------
//
//  $Logfile:: /Quake 2 Engine/Sin/code/game/ctf.cpp                          $
// $Revision:: 3                                                              $
//   $Author:: Jimdose                                                        $
//     $Date:: 10/10/98 3:37a                                                 $
//
// Copyright (C) 1998 by Ritual Entertainment, Inc.
// All rights reserved.
//
// This source may not be distributed and/or modified without
// expressly written permission by Ritual Entertainment, Inc.
//
// $Log:: /Quake 2 Engine/Sin/code/game/ctf.cpp                               $
// 
// 3     10/10/98 3:37a Jimdose
// Began converting to Sin
// 
// 2     10/10/98 3:03a Jimdose
// Created file
// 
// 1     10/10/98 3:02a Jimdose
//
// DESCRIPTION:
// Game code for Threewave Capture the Flag.
//
// The original source for this code was graciously provided by Zoid and
// Id Software.  Many thanks!
//
// Original credits:
//
// Programming             - Dave 'Zoid' Kirsch
// Original CTF Art Design - Brian 'Whaleboy' Cozzens
// 

#include "g_local.h"
#include "ctf.h"
#include "ctf_player.h"

cvar_t *ctf;
cvar_t *ctf_forcejoin;

typedef struct ctfgame_s
   {
	int   team1, team2;
	int   total1, total2; // these are only set when going into intermission!
	float last_flag_capture;
	int   last_capture_team;
   } ctfgame_t;

ctfgame_t ctfgame;

qboolean techspawn = false;

void CTFInit
   (
   void
   )

   {
	ctf            = gi.cvar("ctf", "1", CVAR_SERVERINFO);
	ctf_forcejoin  = gi.cvar("ctf_forcejoin", "", 0);

   memset( &ctfgame, 0, sizeof( ctfgame ) );
	techspawn = false;
   }
