#include "CLAX.H"
#include "MATERIAL.H"

#include <stdio.h>

// current active scene
extern c_SCENE  *clax_scene;


void CalcFaceMatGroup( c_OBJECT *lpObject )
{
	LPFACEMATGROUP		Group = lpObject->lpFaceMatGroup;

	// Face Material ׷  ʴٸ default Ѵ.
	if ( !Group ) {

		Group = (LPFACEMATGROUP) malloc( sizeof(FACEMATGROUP) );
		strcpy( Group->szName, "DEFAULT" );

		Group->NumTriangles = lpObject->numfaces;
		//Group->lpTriangles = new WORD [ group->NumTriangles ];
		Group->lpTriangles = (LPWORD) malloc( Group->NumTriangles * sizeof(WORD) );

		for ( int i = 0; i < Group->NumTriangles; i++ )
			Group->lpTriangles[i] = i;
	}

	//  face material Ѵ.
	while ( Group ) {
		Group->lpMaterial = FindMaterial( clax_scene->world, Group->szName );
		Group = Group->lpNext;
	}
}


// =====================================
//  vertex normal vector Ѵ.
// =====================================
void CalcVertexNormals( c_OBJECT *lpObject )
{
	D3DVECTOR u, v, n;
	//lpObject->lpD3DVertex = new D3DVERTEX [ lpObject->numverts ];
	lpObject->lpD3DVertex = (LPD3DVERTEX) malloc( sizeof(D3DVERTEX) * lpObject->numverts );

	LPD3DVERTEX lpD3DVertex = lpObject->lpD3DVertex;

	for ( int i = 0; i < lpObject->numverts; i++ ) {

		lpD3DVertex[i].x = lpObject->vertices[i].vert.x;
		lpD3DVertex[i].y = lpObject->vertices[i].vert.y;
		lpD3DVertex[i].z = lpObject->vertices[i].vert.z;

		lpD3DVertex[i].tu = lpObject->vertices[i].u;
		lpD3DVertex[i].tv = lpObject->vertices[i].v;

		lpD3DVertex[i].nx = 0;
		lpD3DVertex[i].ny = 0;
		lpD3DVertex[i].nz = 0;

	}

	c_FACE	*lpTriangles = lpObject->faces;

	for ( i = 0; i < lpObject->numfaces; i++ ) {

		u.x = lpD3DVertex[ lpTriangles[i].a ].x - lpD3DVertex[ lpTriangles[i].b ].x;
		u.y = lpD3DVertex[ lpTriangles[i].a ].y - lpD3DVertex[ lpTriangles[i].b ].y;
		u.z = lpD3DVertex[ lpTriangles[i].a ].z - lpD3DVertex[ lpTriangles[i].b ].z;

		v.x = lpD3DVertex[ lpTriangles[i].a ].x - lpD3DVertex[ lpTriangles[i].c ].x;
		v.y = lpD3DVertex[ lpTriangles[i].a ].y - lpD3DVertex[ lpTriangles[i].c ].y;
		v.z = lpD3DVertex[ lpTriangles[i].a ].z - lpD3DVertex[ lpTriangles[i].c ].z;

		n = Normalize( CrossProduct( u, v ) );

		// face ؽ normal vector Ѵ.
		lpD3DVertex[ lpTriangles[i].a ].nx += n.x;
		lpD3DVertex[ lpTriangles[i].a ].ny += n.y;
		lpD3DVertex[ lpTriangles[i].a ].nz += n.z;

		lpD3DVertex[ lpTriangles[i].b ].nx += n.x;
		lpD3DVertex[ lpTriangles[i].b ].ny += n.y;
		lpD3DVertex[ lpTriangles[i].b ].nz += n.z;

		lpD3DVertex[ lpTriangles[i].c ].nx += n.x;
		lpD3DVertex[ lpTriangles[i].c ].ny += n.y;
		lpD3DVertex[ lpTriangles[i].c ].nz += n.z;
	}

	for ( i = 0; i < lpObject->numverts; i++ ) {

		n.x = lpD3DVertex[i].nx;
		n.y = lpD3DVertex[i].ny;
		n.z = lpD3DVertex[i].nz;

		n = Normalize( n );

		lpObject->vertices[i].norm.x = lpD3DVertex[i].nx = n.x;
		lpObject->vertices[i].norm.y = lpD3DVertex[i].ny = n.y;
		lpObject->vertices[i].norm.z = lpD3DVertex[i].nz = n.z;

	}
}



void CalcObject( c_OBJECT *lpObject )
{
	/*
	if ( !lpObject->lpTVertices )
	{
		lpObject->lpTVertices = new TVERTEX [ lpObject->NumVertices ];
		ZeroMemory( lpObject->lpTVertices, sizeof(TVERTEX) * lpObject->NumVertices );
	}
	*/

	//  face material  ش.
	CalcFaceMatGroup( lpObject );

	// normal vector Ѵ.
	CalcVertexNormals( lpObject );
}
