/*CAMERA.C********************************************************************

   Clax: Portable keyframing library
         see inclosed LICENSE.TXT for licensing terms.

         for documentation, refer to CLAX.TXT

   author           : Adept
   file created     : 16/04/97
   file description : camera math

   revision history :
     v0.10 (16/04/97) Adept: Initial version.
           (17/06/97) Borzom: Added lens to fov conversion.
           (20/06/97: Borzom: Camera pivot inside matrix.

   notes            :

*****************************************************************************/

#include <stdio.h>
#include "clax.h"
#include "claxi.h"
#include "D3DUtil.h"
#include "D3DMATH.H"

#include "MATRIX.H"


extern D3DMATRIX	matWorld, matView, matProj;

// converts 3dstudio lens to fov.
void cam_lens_fov (float lens, float *fov)
{
	int16  i;

	// ̸ غ ī޶  Ʈ
	struct {

		float lens, fov;

	} lens_table[] = {

		{ 15.0f,  115.0f    }, 
		{ 20.0f,  94.28571f }, 
		{ 24.0f,  84.0f     }, 
		{ 28.0f,  76.36364f },
		{ 35.0f,  63.0f	 },  
		{ 50.0f,  46.0f	 },     
		{ 85.0f,  28.0f	 }, 
		{ 135.0f, 18.0f	 },
		{ 200.0f, 12.0f	 }

	};

	// Ʈ  ġϸ   fov Ѵ.
	for (i = 0; i < 9; i++) {

		if (lens == lens_table[i].lens) {
			*fov = lens_table[i].fov;
			return;
		}

	}

	// hello adept :)
	//    fov Ѵ.
	*fov = 15.0f / lens * 160.0f; 
}


/*
  cam_update: updates the camera matrix.
*/
/*
void cam_update (c_CAMERA *cam)
{
	D3DVECTOR c, pivot;
	D3DMATRIX mat;
	float    tanfov, focus;
	float    ax, ay, az;
	float    sinx, siny, sinz,
			 cosx, cosy, cosz;

	mat_identity (mat);
	vec_negate (&cam->pos, &pivot);
	vec_sub (&cam->target, &cam->pos, &c);
	focus = vec_length (&c);
	tanfov = (float)tan ((cam->fov / 2.0f) / 180.0f * M_PI);
	cam->perspX = cam->sizeX / 2 / tanfov;
	cam->perspY = cam->sizeY / 2 / cam->aspectratio / tanfov;

	ax = (float)-atan2 (c.x, c.z);
	ay = (float)asin (c.y / focus);
	az = -cam->roll * M_PI / 180;

	sinx = (float)sin (ax); 
	cosx = (float)cos (ax); 
	siny = (float)sin (ay);

	cosy = (float)cos (ay); 
	sinz = (float)sin (az); 
	cosz = (float)cos (az);

	mat[X][X] =  sinx * siny * sinz + cosx * cosz;
	mat[X][Y] =  cosy * sinz;
	mat[X][Z] =  sinx * cosz - cosx * siny * sinz;

	mat[Y][X] =  sinx * siny * cosz - cosx * sinz;
	mat[Y][Y] =  cosy * cosz;
	mat[Y][Z] = -cosx * siny * cosz - sinx * sinz;

	mat[Z][X] = -sinx * cosy;
	mat[Z][Y] =  siny;
	mat[Z][Z] =  cosx * cosy;

	mat_pretrans (&pivot, mat, cam->matrix);
}
*/


//	Direct3D Camera Func
void SetCamera( LPDIRECT3DDEVICE3 lpDev, w_NODE *World )
{
	c_CAMERA	*lpCamera;

	while( World ) {

		if(World->type == clax_obj_camera) {

			lpCamera = (c_CAMERA *)World->object;
			
			D3DVECTOR position( lpCamera->pos.x, 
								lpCamera->pos.y, 
								lpCamera->pos.z );

			D3DVECTOR direction( lpCamera->target.x, 
								 lpCamera->target.y, 
								 lpCamera->target.z );

			//  ġ ٶ󺸴 ǥ   ͸ .
			//D3DVECTOR up = CrossProduct( position, direction );
			D3DVECTOR up(0.0f, 1.0f, 0.0f);

			D3DUtil_SetViewMatrix( matView, position, direction, up );
			
			// Set roll
			if (lpCamera->roll != 0.0f)
				D3DMath_MatrixMultiply( matView, RotateZMatrix( -lpCamera->roll ), matView );

			D3DUtil_SetProjectionMatrix( matProj, lpCamera->Lens * 3.141592f / 180, 1.0f, 
										 1.0f, 100000.0f );

			lpDev->SetTransform( D3DTRANSFORMSTATE_VIEW, &matView );
			lpDev->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );
			break;
		}
		
		World = World->next;
	}
}
