#define STRICT
#include <windows.h>

#define D3D_OVERLOADS

#include "D3DEnum.h"
#include "D3DFrame.h"
#include "D3DUtil.h"
#include "D3DMATH.H"

#include "MATERIAL.H"
#include "CLAX.H"
#include "MATRIX.H"

#include <stdio.h>


#define isKeyDOWN( key )      HIBYTE( GetAsyncKeyState( key ) )


CD3DFramework*  g_pFramework		= NULL;
c_SCENE			*scene;

// Direct3D ֿ Ʈ
LPDIRECT3D3			g_pD3D			= NULL;
LPDIRECT3DDEVICE3	g_pD3Ddevice	= NULL;
LPDIRECT3DVIEWPORT3	g_pD3DViewPort  = NULL;

// ׹ ٸ Ʈ
LPDIRECT3DLIGHT     g_pLight		= NULL;
LPDIRECT3DMATERIAL3 g_pmtrlObjectMtrl  = NULL;

D3DMATRIX	matWorld, matView, matProj;

D3DEnum_DriverInfo* pDriverInfo;
D3DEnum_DeviceInfo* pDeviceInfo;


HWND	hMainWnd;
BOOL	bIsActive;


float rot_x2 = 0.0f;
float rot_y2 = 0.0f;


float		StartFrame, frames;
float		frame;


long PASCAL WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
BOOL		InitWindow( HINSTANCE hInstance, int nCmdShow );
HRESULT		Initialize3DEnvironment( HWND hWnd );
HRESULT		ConfirmDevice( DDCAPS* pddDriverCaps, D3DDEVICEDESC* pd3dDeviceDesc );
int WINAPI  WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine,
					  int nCmdShow );



//  â Ѵ.
BOOL InitWindow( HINSTANCE hInstance, int nCmdShow )
{
    //  
    WNDCLASS wc;

    wc.style            = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc      = WindowProc;
    wc.cbClsExtra       = 0;
    wc.cbWndExtra       = 0;
    wc.hInstance        = hInstance;
    wc.hIcon            = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor          = LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground	= (HBRUSH)GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName     = NULL;
    wc.lpszClassName    = "3DKeyFrame";
    if ( !RegisterClass( &wc ) )
        return FALSE;


    //  
    hMainWnd = CreateWindowEx( WS_EX_TOPMOST,
                               "3DKeyFrame",
                               "Direct3D 3DS FILE Key-Animation",
                               //WS_POPUP,
							   WS_OVERLAPPEDWINDOW,
                               0,
                               0,
                               GetSystemMetrics(SM_CXSCREEN),
                               GetSystemMetrics(SM_CYSCREEN),
                               NULL,
                               NULL,
                               hInstance,
                               NULL );
    if ( !hMainWnd )
        return FALSE;

    ShowWindow( hMainWnd, nCmdShow );
    UpdateWindow( hMainWnd );

	return TRUE;
}



long PASCAL WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
    switch ( message )
    {
        case WM_ACTIVATEAPP:
            bIsActive = wParam;
            break;

        case WM_CREATE:
            break;

        // Ŀ ߱
        case WM_SETCURSOR:
            SetCursor( NULL );
            return TRUE;

        case WM_KEYDOWN:
            switch ( wParam )
            {
                // ESC Ű  
                case VK_ESCAPE:
                    PostMessage( hWnd, WM_DESTROY, 0, 0 );
                    break;
            }
            break;

        case WM_DESTROY:
			bIsActive = FALSE;

			//   Ʈ Ѵ.
			SAFE_RELEASE( g_pLight );
			// ⺻ material Ʈ Ѵ.
			SAFE_RELEASE( g_pmtrlObjectMtrl );

			// ݵ Frame Ŭ Ұ ȣѴ.
			clax_free_scene( scene );

			// 3dȯ  Ѵ.
			SAFE_DELETE( g_pFramework );
            PostQuitMessage(0);
            break;
    }

    return DefWindowProc( hWnd, message, wParam, lParam );
}



HRESULT ConfirmDevice( DDCAPS* pddDriverCaps, D3DDEVICEDESC* pd3dDeviceDesc )
{
    // Get Triangle Caps
	/*
    LPD3DPRIMCAPS pdpcTriCaps = &pd3dDeviceDesc->dpcTriCaps;

    // Check Texture modes for MIPLINEAR MipMapping
    if( !( pdpcTriCaps->dwTextureFilterCaps & D3DPTFILTERCAPS_LINEARMIPLINEAR ) )
        return E_FAIL;
	*/

    return S_OK;
}



//----------------------------------------
//	    3dȯ Ѵ.
//----------------------------------------
HRESULT Initialize3DEnvironment( HWND hWnd )
{
	HRESULT hr;
	DWORD	dwFrameworkFlags = 0L;

    if( ( g_pFramework = new CD3DFramework() ) == NULL )
		return E_OUTOFMEMORY;

	dwFrameworkFlags = D3DFW_FULLSCREEN | D3DFW_BACKBUFFER | D3DFW_ZBUFFER;

	// Initialize the D3D framework
    if( SUCCEEDED( hr = g_pFramework->Initialize( hWnd, 
												  &pDriverInfo->guid,
												  &pDeviceInfo->guid, 
												  &pDeviceInfo->pCurrentMode->ddsd, 
												  dwFrameworkFlags ) ) ) {
		g_pD3D = g_pFramework->GetDirect3D();
		g_pD3Ddevice = g_pFramework->GetD3DDevice();
		g_pD3DViewPort = g_pFramework->GetViewport();

		return S_OK;
	}

	return hr;
}



BOOL InitRender(void)
{
	HRESULT		hr;
	

    // Check parameters
    if( g_pD3Ddevice == NULL || g_pD3DViewPort == NULL )
        return FALSE;

    // Create and set up the object material
	//  Ʈ Ѵ.
    g_pD3D->CreateMaterial( &g_pmtrlObjectMtrl, NULL );

    D3DMATERIAL       mtrl;
    D3DMATERIALHANDLE hmtrl;

	//  ü  ⺻ Ͼ ʱȭѴ.
    D3DUtil_InitMaterial( mtrl, 1.0f, 1.0f, 1.0f );       // Ͼ

	//  Ʈ ʱȭ  ü Ѵ.
    g_pmtrlObjectMtrl->SetMaterial( &mtrl );
	// 3d ġ   Ʈκ ڵ ´.
    g_pmtrlObjectMtrl->GetHandle( g_pD3Ddevice, &hmtrl );
    g_pD3Ddevice->SetLightState( D3DLIGHTSTATE_MATERIAL, hmtrl );


    // Set the transform matrices
	D3DVECTOR vEyePt    = D3DVECTOR( 0.0f, 0.0f, -30.0f );	//  
	D3DVECTOR vLookatPt = D3DVECTOR( 0.0f, 0.0f, 1.0f );	//   ִ...
    D3DVECTOR vUpVec    = D3DVECTOR( 0, 1, 0 );

	// matWorld  ʱȭ Ų.
    D3DUtil_SetIdentityMatrix( matWorld );

	//  (, ǥ, Ϻ) ͷ ä.
    D3DUtil_SetViewMatrix( matView, vEyePt, vLookatPt, vUpVec );

	//   ʱȭ Ѵ.
	//D3DUtil_SetProjectionMatrix( matProj, 3.141592f / 4, 1.0f, 1.0f, 10000.0f );
	D3DUtil_SetProjectionMatrix( matProj, 61.75f * 3.141592f / 180, 1.0f, 1.0f, 100000.0f );

	// 3d ġ  ࿭ Ѵ.
    g_pD3Ddevice->SetTransform( D3DTRANSFORMSTATE_WORLD,      &matWorld );
    g_pD3Ddevice->SetTransform( D3DTRANSFORMSTATE_VIEW,       &matView );
    g_pD3Ddevice->SetTransform( D3DTRANSFORMSTATE_PROJECTION, &matProj );

    // Set up the light
    if( FAILED( hr = g_pD3D->CreateLight( &g_pLight, NULL ) ) )
        return FALSE;

    D3DLIGHT light;
	// point   ġ ش.
    D3DUtil_InitLight( light, D3DLIGHT_POINT, 0.0, 3.0, 0.0 );

    light.dcvColor.r = D3DVAL(0.8);
    light.dcvColor.g = D3DVAL(0.8);
    light.dcvColor.b = D3DVAL(0.8);

	// light  Ѵ.
    light.dvAttenuation0 = 1.0f;
	//  g_pLight Ʈ light ü Ѵ.
    g_pLight->SetLight( &light );

	// Ʈ  ߰Ѵ. (Ʈ...)
    g_pD3DViewPort->AddLight( g_pLight );

	// Turn on Z-buffering
	g_pD3Ddevice->SetRenderState( D3DRENDERSTATE_ZENABLE, D3DZB_TRUE );
	//g_pD3Ddevice->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE, D3DZB_TRUE );

	//   ϰ Ѵ.
    //g_pD3Ddevice->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	//g_pD3Ddevice->SetRenderState( D3DRENDERSTATE_DESTBLEND, D3DBLEND_INVSRCALPHA );

	//  ϰ Ѵ.
	//g_pD3Ddevice->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE );

	//g_pD3Ddevice->SetRenderState( D3DRENDERSTATE_SPECULARENABLE, FALSE );

	//pd3dDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTFN_LINEAR );
	//pd3dDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTFG_LINEAR );

	g_pD3Ddevice->SetLightState( D3DLIGHTSTATE_AMBIENT, RGBA_MAKE(150, 150, 150, 100) );
	
    return TRUE;
}



//  Լ
void Rendering()
{
	w_NODE				*node;
	c_OBJECT			*obj;
	//c_FACE				*Face;
	LPFACEMATGROUP		FaceGroup;
	static WORD			i, FaceList[10000];

	//   Ѵ.
	clax_setframe(frame);
	//     óѴ.
	clax_update();

	if(frame >= frames)
		frame = StartFrame;
	else
		frame++;

	if ( isKeyDOWN( VK_UP ) )
	    rot_x2-= 0.025f;

    if ( isKeyDOWN( VK_DOWN ) )
	    rot_x2 += 0.025f;

    if ( isKeyDOWN( VK_LEFT ) )
	    rot_y2 -= 0.025f;

    if ( isKeyDOWN( VK_RIGHT ) )
	    rot_y2 += 0.025f;


	D3DMath_MatrixMultiply( scene->Matrix, RotateXMatrix( rot_x2 ),
										   RotateYMatrix( rot_y2 ) );

	//scene->Matrix._43 = 200.0f;

	g_pD3DViewPort->Clear2( 1UL, (D3DRECT *)g_pFramework->GetViewportRect(), 
							D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, 0x000000ff, 1.0f, 0L );

    g_pD3Ddevice->BeginScene();

	g_pD3Ddevice->SetTransform( D3DTRANSFORMSTATE_WORLD, &scene->Matrix );


	// Ʈ Ѵ.
	for (node = scene->world; node; node = node->next) {

		if (node->type == clax_obj_object) {

			obj = (c_OBJECT *)node->object;

			//Face = obj->faces;
			FaceGroup = obj->lpFaceMatGroup;

			while ( FaceGroup ) {
				SetCurrentMaterial( g_pD3Ddevice, FaceGroup->lpMaterial );

				for(i = 0; i < FaceGroup->NumTriangles; i ++ ) {
					FaceList[ i * 3 + 0 ] = obj->faces[ FaceGroup->lpTriangles[ i ] ].a;
					FaceList[ i * 3 + 1 ] = obj->faces[ FaceGroup->lpTriangles[ i ] ].b;
					FaceList[ i * 3 + 2 ] = obj->faces[ FaceGroup->lpTriangles[ i ] ].c;
				}

				/*
				for(int i = 0; i<obj->numfaces * 3; i += 3) {

					FaceList[ i + 0 ] = Face->a;
					FaceList[ i + 1 ] = Face->b;
					FaceList[ i + 2 ] = Face->c;

					Face++;
				}*/

				g_pD3Ddevice->DrawIndexedPrimitive( D3DPT_TRIANGLELIST, 
													D3DFVF_VERTEX,
													(LPVOID)obj->lpD3DVertex, 
													obj->numverts,
													(LPWORD)FaceList,
													// obj->numfaces * 3,
													FaceGroup->NumTriangles * 3,
													//D3DDP_WAIT,
													NULL);

				FaceGroup = FaceGroup->lpNext;
			}

		}
	}

	g_pD3Ddevice->EndScene();

	g_pFramework->GetFrontBuffer()->Flip( NULL, DDFLIP_WAIT );
}



int WINAPI WinMain ( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine,
					 int nCmdShow )
{
	int			err;
	HRESULT		hr;
	MSG			msg;
	

	InitWindow( hInstance, nCmdShow );

	//   3dġ ˻Ѵ.
	if( FAILED( hr = D3DEnum_EnumerateDevices( ConfirmDevice ) ) )
	{
		MessageBox( NULL, "Enumerate 3D-Device fail!", "Error", MB_ICONERROR | MB_OK );
        return FALSE;
	}

    D3DEnum_GetSelectedDriver( &pDriverInfo, &pDeviceInfo );
	
	/*
	char	Str[512];
	wsprintf( Str, "Use Driver: %s\n     Device: %s", pDriverInfo->strDesc, 
													 pDeviceInfo->strName );
	MessageBox( hMainWnd, Str, "Find Accelator", MB_OK );
	*/

	Initialize3DEnvironment( hMainWnd );

	InitRender();

	clax_init (clax_transform | clax_hierarchy | clax_domorph);

	err = clax_alloc_scene ( &scene );
	if(err != clax_err_ok) {
		MessageBox( hMainWnd, clax_geterror(err), "Error", MB_ICONERROR | MB_OK );
	    return FALSE;
	}


	// mesh data о object Ѵ.
	err = clax_load_world ( "SAMPLE.3DS", scene );

	if (err != clax_err_ok) {
		MessageBox( hMainWnd, clax_geterror(err), "Error", MB_ICONERROR | MB_OK );
		return FALSE;
	}

	//  Ʈ Ʈ  ؽƮ ȭϷ Ѵ.
	//clax_print_world();

	SetupMaterial( g_pD3D, g_pD3Ddevice, scene->world );

	SetCamera( g_pD3Ddevice, scene->world );

	// motion data о´.
	err = clax_load_motion ( "SAMPLE.3DS", scene);

	if (err != clax_err_ok) {
		MessageBox( hMainWnd, clax_geterror(err), "Error", MB_ICONERROR | MB_OK );
		return FALSE;
	}

	clax_setactive_scene (scene);

	//clax_print_keyframer();


	// Ű ó  ´.
	clax_getframes(&StartFrame, &frames);
	frame = StartFrame;


	while ( 1 ) {

		if ( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) ) {

			if ( !GetMessage( &msg, NULL, 0, 0 ) ) 
				break;

			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}
		else if ( bIsActive ) {
			Rendering();
		}
		else 
			WaitMessage();
	}

	return msg.wParam;
}
