#include "MATERIAL.H"

#include <stdio.h>


// Material List
///////////////////////////////////////////////////////////////////////////////
c_MATERIAL* FindMaterial( w_NODE *World, char* lpszName )
{
	c_MATERIAL *lpMaterial;

	while ( World ) {

		if( World->type == clax_obj_material ) {

			lpMaterial = (c_MATERIAL*)World->object;

			// ã material name ִٸ  ּҸ  ش.
			if ( !strcmp( lpszName, lpMaterial->name ) )
				 return lpMaterial;

		}
		
		World = World->next;
	}

	return NULL;
}



void SetupMaterial( LPDIRECT3D3 lpD3D, LPDIRECT3DDEVICE3 lpD3Ddevice, w_NODE *World )
{
	c_MATERIAL		*ObjMat;

	while( World ) {

		if( World->type == clax_obj_material ) {
			ObjMat = (c_MATERIAL*)World->object;

			lpD3D->CreateMaterial( &ObjMat->lpD3DMaterial, NULL );
			ObjMat->lpD3DMaterial->SetMaterial( &ObjMat->Material );
			ObjMat->lpD3DMaterial->GetHandle( lpD3Ddevice, &ObjMat->Handle );
		}

		World = World->next;
	}
}



HRESULT SetCurrentMaterial( LPDIRECT3DDEVICE3 lpDev, c_MATERIAL *lpMaterial )
{
	HRESULT hResult = lpDev->SetLightState( D3DLIGHTSTATE_MATERIAL, lpMaterial->Handle );

	//if ( hResult != D3D_OK )
	//	return hResult;

	return hResult;
	//return lpDev->SetRenderState( D3DRENDERSTATE_TEXTUREHANDLE, 
	//							  lpMaterial->Material.hTexture );
}
